/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.components;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.bookmarks.BookmarksManager;
import gaiasky.gui.bookmarks.NewBookmarkFolderDialog;
import gaiasky.gui.components.GuiComponent;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.scene2d.ContextMenu;
import gaiasky.util.scene2d.MenuItem;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextField;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class BookmarksComponent
extends GuiComponent
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(BookmarksComponent.class);
    private static final Vector2 tmpCoords = new Vector2();
    private final Drawable folderIcon;
    private final Drawable bookmarkIcon;
    private final Set<ContextMenu> contextMenus;
    protected Scene scene;
    protected FocusView view;
    protected Tree<TreeNode, String> bookmarksTree;
    protected TextField searchBox;
    protected OwnScrollPane bookmarksScrollPane;
    protected VerticalGroup infoTable;
    protected OwnLabel infoMessage1;
    protected OwnLabel infoMessage2;
    private boolean events = true;
    private boolean updateSelection = true;

    public BookmarksComponent(Skin skin, Stage stage) {
        super(skin, stage);
        this.folderIcon = skin.getDrawable("iconic-folder-small");
        this.bookmarkIcon = skin.getDrawable("iconic-bookmark-small");
        this.contextMenus = new HashSet<ContextMenu>();
        this.view = new FocusView();
        EventManager.instance.subscribe((IObserver)this, Event.FOCUS_CHANGED, Event.BOOKMARKS_ADD, Event.BOOKMARKS_REMOVE, Event.BOOKMARKS_REMOVE_ALL);
    }

    @Override
    public void initialize(float componentWidth) {
        this.searchBox = new OwnTextField("", this.skin);
        this.searchBox.setName("search box");
        this.searchBox.setWidth(componentWidth);
        this.searchBox.setMessageText(I18n.msg("gui.objects.search"));
        this.searchBox.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent ie = (InputEvent)event;
                if (ie.getType() == InputEvent.Type.keyUp && !this.searchBox.getText().isEmpty()) {
                    String text = this.searchBox.getText().toLowerCase(Locale.ROOT).trim();
                    if (this.scene.index().containsEntity(text)) {
                        Entity node = this.scene.getEntity(text);
                        if (Mapper.focus.has(node)) {
                            this.view.setEntity(node);
                            FocusView focus = this.view;
                            boolean timeOverflow = focus.isCoordinatesTimeOverflow();
                            boolean ctOn = GaiaSky.instance.isOn(focus.getCt());
                            if (!timeOverflow && ctOn) {
                                GaiaSky.postRunnable(() -> {
                                    EventManager.publish(Event.CAMERA_MODE_CMD, this.searchBox, new Object[]{CameraManager.CameraMode.FOCUS_MODE, true});
                                    EventManager.publish(Event.FOCUS_CHANGE_CMD, this.searchBox, focus, true);
                                });
                            } else if (timeOverflow) {
                                this.info(I18n.msg("gui.objects.search.timerange.1", text), I18n.msg("gui.objects.search.timerange.2"));
                            } else {
                                this.info(I18n.msg("gui.objects.search.invisible.1", text), I18n.msg("gui.objects.search.invisible.2", focus.getCt().toString()));
                            }
                        }
                    } else {
                        this.info(null, null);
                    }
                    if (ie.getKeyCode() == 111) {
                        this.stage.setKeyboardFocus(null);
                    }
                } else if (ie.getType() == InputEvent.Type.keyDown && (ie.getKeyCode() == 129 || ie.getKeyCode() == 130)) {
                    this.stage.setKeyboardFocus(null);
                }
                return true;
            }
            return false;
        });
        this.infoTable = new VerticalGroup();
        this.infoMessage1 = new OwnLabel((CharSequence)"", this.skin, "default-blue");
        this.infoMessage2 = new OwnLabel((CharSequence)"", this.skin, "default-blue");
        this.bookmarksTree = new Tree(this.skin);
        this.bookmarksTree.setName("bookmarks tree");
        this.reloadBookmarksTree();
        this.bookmarksTree.addListener(event -> {
            if (this.events) {
                if (event instanceof ChangeListener.ChangeEvent) {
                    ChangeListener.ChangeEvent ce = (ChangeListener.ChangeEvent)event;
                    Actor actor = ce.getTarget();
                    TreeNode selected = (TreeNode)((Tree)actor).getSelectedNode();
                    if (selected != null && !selected.hasChildren()) {
                        if (selected.node.position == null && selected.node.direction == null && selected.node.up == null && selected.node.time == null && selected.node.uuid == null) {
                            String name = selected.node.name;
                            if (this.scene.index().containsEntity(name)) {
                                Entity node = this.scene.getEntity(name);
                                if (Mapper.focus.has(node)) {
                                    this.view.setEntity(node);
                                    this.view.getFocus(name);
                                    FocusView focus = this.view;
                                    boolean timeOverflow = focus.isCoordinatesTimeOverflow();
                                    boolean ctOn = GaiaSky.instance.isOn(focus.getCt());
                                    if (!timeOverflow && ctOn) {
                                        GaiaSky.postRunnable(() -> {
                                            EventManager.publish(Event.CAMERA_MODE_CMD, this.bookmarksTree, new Object[]{CameraManager.CameraMode.FOCUS_MODE, true});
                                            EventManager.publish(Event.FOCUS_CHANGE_CMD, this.bookmarksTree, focus, true);
                                        });
                                        this.info(null, null);
                                    } else if (timeOverflow) {
                                        this.info(I18n.msg("gui.objects.search.timerange.1", name), I18n.msg("gui.objects.search.timerange.2"));
                                    } else {
                                        this.info(I18n.msg("gui.objects.search.invisible.1", name), I18n.msg("gui.objects.search.invisible.2", focus.getCt().toString()));
                                    }
                                }
                            } else {
                                this.info(null, null);
                            }
                        } else {
                            GaiaSky.postRunnable(() -> {
                                Settings settings;
                                Vector3D p = selected.node.position;
                                Vector3D d = selected.node.direction;
                                Vector3D u = selected.node.up;
                                String f = selected.node.focus;
                                Instant t = selected.node.time;
                                if (selected.node.time != null) {
                                    EventManager.publish(Event.TIME_CHANGE_CMD, this.bookmarksTree, t);
                                }
                                if (selected.node.uuid != null && (settings = selected.node.loadSettingsFromFile()) != null) {
                                    Settings.VersionSettings version = Settings.settings.version.clone();
                                    if (SettingsManager.setSettingsInstance(settings)) {
                                        Settings.settings.setupListeners();
                                        Settings.settings.version = version;
                                        Settings.settings.apply();
                                    }
                                }
                                GaiaSky.postRunnable(() -> {
                                    if (p != null) {
                                        EventManager.publish(Event.CAMERA_POS_CMD, this.bookmarksTree, new Object[]{new double[]{p.x, p.y, p.z}});
                                    }
                                    if (f == null) {
                                        EventManager.publish(Event.CAMERA_MODE_CMD, this.bookmarksTree, new Object[]{CameraManager.CameraMode.FREE_MODE, true});
                                    } else {
                                        this.updateSelection = false;
                                        EventManager.publish(Event.CAMERA_MODE_CMD, this.bookmarksTree, new Object[]{CameraManager.CameraMode.FREE_MODE, true});
                                        EventManager.publish(Event.FOCUS_CHANGE_CMD, this.bookmarksTree, f, true);
                                        EventManager.publish(Event.CAMERA_MODE_CMD, this.bookmarksTree, new Object[]{CameraManager.CameraMode.FOCUS_MODE, true});
                                        EventManager.publish(Event.CAMERA_CENTER_FOCUS_CMD, this.bookmarksTree, false);
                                        this.updateSelection = true;
                                    }
                                    if (d != null) {
                                        EventManager.publish(Event.CAMERA_DIR_CMD, this.bookmarksTree, new Object[]{new double[]{d.x, d.y, d.z}});
                                    }
                                    if (u != null) {
                                        EventManager.publish(Event.CAMERA_UP_CMD, this.bookmarksTree, new Object[]{new double[]{u.x, u.y, u.z}});
                                    }
                                });
                            });
                        }
                    }
                    return true;
                }
                if (event instanceof InputEvent) {
                    InputEvent ie = (InputEvent)event;
                    ie.toCoordinates(event.getListenerActor(), tmpCoords);
                    if (ie.getType() == InputEvent.Type.touchDown && ie.getButton() == 1) {
                        TreeNode target = (TreeNode)this.bookmarksTree.getNodeAt(BookmarksComponent.tmpCoords.y);
                        if (target != null) {
                            GaiaSky.postRunnable(() -> {
                                ContextMenu cm = new ContextMenu(this.skin, "default");
                                MenuItem info = new MenuItem(I18n.msg("gui.bookmark.context.info", target.getValue()), this.skin, this.skin.getDrawable("iconic-info"));
                                info.addListener(evt -> {
                                    if (evt instanceof ChangeListener.ChangeEvent) {
                                        EventManager.publish(Event.SHOW_BOOKMARK_INFO_ACTION, (Object)info, target.node);
                                        return true;
                                    }
                                    return false;
                                });
                                cm.addItem(info);
                                cm.addSeparator();
                                BookmarksManager.BookmarkNode parent = target.node.getFirstFolderAncestor();
                                String parentName = "/" + (parent == null ? "" : parent.path.toString());
                                MenuItem newDirectory = new MenuItem(I18n.msg("gui.bookmark.context.newfolder", parentName), this.skin, this.skin.getDrawable("iconic-folder"));
                                newDirectory.addListener(evt -> {
                                    if (evt instanceof ChangeListener.ChangeEvent) {
                                        NewBookmarkFolderDialog newBookmarkFolderDialog = new NewBookmarkFolderDialog(parent != null ? parent.path.toString() : "/", this.skin, this.stage);
                                        newBookmarkFolderDialog.setAcceptListener(() -> {
                                            String folderName = newBookmarkFolderDialog.input.getText();
                                            EventManager.publish(Event.BOOKMARKS_ADD, (Object)newDirectory, parent != null ? parent.path.resolve(folderName).toString() : folderName, true);
                                            this.reloadBookmarksTree();
                                        });
                                        newBookmarkFolderDialog.show(this.stage);
                                        return true;
                                    }
                                    return false;
                                });
                                cm.addItem(newDirectory);
                                MenuItem delete = new MenuItem(I18n.msg("gui.bookmark.context.delete", target.getValue()), this.skin, this.skin.getDrawable("iconic-delete"));
                                delete.addListener(evt -> {
                                    if (evt instanceof ChangeListener.ChangeEvent) {
                                        EventManager.publish(Event.BOOKMARKS_REMOVE, (Object)delete, target.node.path.toString());
                                        this.reloadBookmarksTree();
                                        return true;
                                    }
                                    return false;
                                });
                                cm.addItem(delete);
                                cm.addSeparator();
                                MenuItem moveUp = new MenuItem(I18n.msg("gui.bookmark.context.move.up"), this.skin, this.skin.getDrawable("iconic-arrow-top"));
                                moveUp.addListener(evt -> {
                                    if (evt instanceof ChangeListener.ChangeEvent) {
                                        EventManager.publish(Event.BOOKMARKS_MOVE_UP, (Object)moveUp, target.node);
                                        this.reloadBookmarksTree();
                                        return true;
                                    }
                                    return false;
                                });
                                cm.addItem(moveUp);
                                MenuItem moveDown = new MenuItem(I18n.msg("gui.bookmark.context.move.down"), this.skin, this.skin.getDrawable("iconic-arrow-bottom"));
                                moveDown.addListener(evt -> {
                                    if (evt instanceof ChangeListener.ChangeEvent) {
                                        EventManager.publish(Event.BOOKMARKS_MOVE_DOWN, (Object)moveDown, target.node);
                                        this.reloadBookmarksTree();
                                        return true;
                                    }
                                    return false;
                                });
                                cm.addItem(moveDown);
                                if (target.node.parent != null) {
                                    MenuItem move = new MenuItem(I18n.msg("gui.bookmark.context.move", target.getValue(), "/"), this.skin, this.skin.getDrawable("iconic-move"));
                                    move.addListener(evt -> {
                                        if (evt instanceof ChangeListener.ChangeEvent) {
                                            EventManager.publish(Event.BOOKMARKS_MOVE, (Object)move, target.node, null);
                                            this.reloadBookmarksTree();
                                            return true;
                                        }
                                        return false;
                                    });
                                    cm.addItem(move);
                                }
                                List<BookmarksManager.BookmarkNode> folders = GaiaSky.instance.getBookmarksManager().getFolders();
                                for (BookmarksManager.BookmarkNode folder : folders) {
                                    if (target.node.isDescendantOf(folder)) continue;
                                    MenuItem mv = new MenuItem(I18n.msg("gui.bookmark.context.move", target.getValue(), "/" + folder.path.toString()), this.skin, this.skin.getDrawable("iconic-move"));
                                    mv.addListener(evt -> {
                                        if (evt instanceof ChangeListener.ChangeEvent) {
                                            EventManager.publish(Event.BOOKMARKS_MOVE, (Object)mv, target.node, folder);
                                            this.reloadBookmarksTree();
                                            return true;
                                        }
                                        return false;
                                    });
                                    cm.addItem(mv);
                                }
                                this.newMenu(cm);
                                cm.showMenu(this.stage, ie.getStageX(), ie.getStageY());
                            });
                        } else {
                            GaiaSky.postRunnable(() -> {
                                ContextMenu cm = new ContextMenu(this.skin, "default");
                                String parentName = "/";
                                MenuItem newDirectory = new MenuItem(I18n.msg("gui.bookmark.context.newfolder", parentName), this.skin, this.skin.getDrawable("iconic-folder"));
                                newDirectory.addListener(evt -> {
                                    if (evt instanceof ChangeListener.ChangeEvent) {
                                        NewBookmarkFolderDialog nbfd = new NewBookmarkFolderDialog("/", this.skin, this.stage);
                                        nbfd.setAcceptListener(() -> {
                                            String folderName = nbfd.input.getText();
                                            EventManager.publish(Event.BOOKMARKS_ADD, (Object)newDirectory, folderName, true);
                                            this.reloadBookmarksTree();
                                        });
                                        nbfd.show(this.stage);
                                        return true;
                                    }
                                    return false;
                                });
                                cm.addItem(newDirectory);
                                this.newMenu(cm);
                                cm.showMenu(this.stage, ie.getStageX(), ie.getStageY());
                            });
                        }
                    }
                    event.setBubbles(false);
                    return true;
                }
            }
            return false;
        });
        this.bookmarksScrollPane = new OwnScrollPane((Actor)this.bookmarksTree, this.skin, "minimalist-nobg");
        this.bookmarksScrollPane.setName("bookmarks scroll");
        this.bookmarksScrollPane.setFadeScrollBars(false);
        this.bookmarksScrollPane.setScrollingDisabled(true, false);
        this.bookmarksScrollPane.setHeight(400.0f);
        this.bookmarksScrollPane.setWidth(componentWidth);
        VerticalGroup objectsGroup = new VerticalGroup().align(8).columnAlign(8).space(this.pad12);
        objectsGroup.addActor((Actor)this.searchBox);
        if (this.bookmarksScrollPane != null) {
            objectsGroup.addActor((Actor)this.bookmarksScrollPane);
        }
        objectsGroup.addActor((Actor)this.infoTable);
        this.component = objectsGroup;
    }

    private void newMenu(ContextMenu cm) {
        for (ContextMenu menu : this.contextMenus) {
            menu.remove();
        }
        this.contextMenus.add(cm);
    }

    public void reloadBookmarksTree() {
        List<BookmarksManager.BookmarkNode> bookmarks = GaiaSky.instance.getBookmarksManager().getBookmarks();
        this.bookmarksTree.clearChildren();
        for (BookmarksManager.BookmarkNode bookmark : bookmarks) {
            TreeNode node = new TreeNode(bookmark, this.skin);
            if (bookmark.isTypeFolder()) {
                node.setIcon(this.folderIcon);
            } else {
                node.setIcon(this.bookmarkIcon);
            }
            this.bookmarksTree.add((Tree.Node)node);
            this.genSubtree(node, bookmark);
        }
        this.bookmarksTree.pack();
    }

    private void genSubtree(TreeNode parent, BookmarksManager.BookmarkNode bookmark) {
        if (bookmark.children != null && !bookmark.children.isEmpty()) {
            for (BookmarksManager.BookmarkNode child : bookmark.children) {
                TreeNode tn = new TreeNode(child, this.skin);
                if (child.isTypeFolder()) {
                    tn.setIcon(this.folderIcon);
                } else {
                    tn.setIcon(this.bookmarkIcon);
                }
                parent.add(tn);
                this.genSubtree(tn, child);
            }
        }
    }

    public void selectBookmark(String bookmark, boolean fire) {
        if (bookmark == null) {
            this.bookmarksTree.getSelectedValue();
        }
        boolean backup = this.events;
        this.events = fire;
        TreeNode node = (TreeNode)this.bookmarksTree.findNode((Object)bookmark);
        if (node != null) {
            this.bookmarksTree.getSelection().set((Object)node);
            node.expandTo();
            this.scrollTo(node);
        }
        this.events = backup;
    }

    private void scrollTo(TreeNode node) {
        float y = this.getYPosition((Array<TreeNode>)this.bookmarksTree.getRootNodes(), node);
        this.bookmarksScrollPane.setScrollY(y);
    }

    private float getYPosition(Array<TreeNode> nodes, TreeNode node) {
        if (nodes == null || nodes.isEmpty()) {
            return 0.0f;
        }
        float yPos = 0.0f;
        for (TreeNode n : nodes) {
            if (n != node) {
                yPos += n.getHeight() + this.bookmarksTree.getYSpacing();
                if (n.isExpanded()) {
                    yPos += this.getYPosition((Array<TreeNode>)n.getChildren(), node);
                }
            } else {
                return yPos;
            }
            if (!n.isAscendantOf(node)) continue;
            break;
        }
        return yPos;
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    private void info(String info1, String info2) {
        if (info1 == null) {
            this.infoMessage1.setText("");
            this.infoMessage2.setText("");
            this.info(false);
        } else {
            this.infoMessage1.setText(info1);
            this.infoMessage2.setText(info2);
            this.info(true);
        }
        this.infoTable.pack();
    }

    private void info(boolean visible) {
        this.infoTable.clear();
        if (visible) {
            this.infoTable.addActor((Actor)this.infoMessage1);
            this.infoTable.addActor((Actor)this.infoMessage2);
        }
        this.infoTable.pack();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case FOCUS_CHANGED: {
                if (!this.updateSelection) break;
                FocusView focus = null;
                if (data[0] instanceof String) {
                    this.view.setEntity(this.scene.getEntity((String)data[0]));
                    focus = this.view;
                } else if (data[0] instanceof FocusView) {
                    focus = (FocusView)data[0];
                }
                if (focus == null) break;
                this.selectBookmark(focus.getName(), false);
                break;
            }
            case BOOKMARKS_ADD: {
                Object d0 = data[0];
                String name = d0 instanceof String ? (String)d0 : (String)data[6];
                this.reloadBookmarksTree();
                this.selectBookmark(name, false);
                break;
            }
            case BOOKMARKS_REMOVE: 
            case BOOKMARKS_REMOVE_ALL: {
                this.reloadBookmarksTree();
                break;
            }
        }
    }

    @Override
    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    public static class TreeNode
    extends Tree.Node<TreeNode, String, OwnLabel> {
        public BookmarksManager.BookmarkNode node;

        public TreeNode(BookmarksManager.BookmarkNode node, Skin skin) {
            super((Actor)new OwnLabel((CharSequence)node.name, skin));
            ((OwnLabel)this.getActor()).setName(node.name);
            this.node = node;
            this.setValue(node.name);
        }
    }
}

