/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.components;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.beans.CameraComboBoxBean;
import gaiasky.gui.components.GuiComponent;
import gaiasky.gui.main.KeyBindings;
import gaiasky.render.postprocess.effects.CubmeapProjectionEffect;
import gaiasky.scene.camera.CameraManager;
import gaiasky.util.Settings;
import gaiasky.util.SlaveManager;
import gaiasky.util.TextUtils;
import gaiasky.util.camera.rec.Camcorder;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import java.util.Objects;

public class CameraComponent
extends GuiComponent
implements IObserver {
    protected OwnLabel date;
    protected SelectBox<String> cameraSpeedLimit;
    protected SelectBox<CameraComboBoxBean> cameraMode;
    protected OwnSliderPlus fieldOfView;
    protected OwnSliderPlus cameraSpeed;
    protected OwnSliderPlus turnSpeed;
    protected OwnSliderPlus rotateSpeed;
    protected CheckBox focusLock;
    protected CheckBox orientationLock;
    protected CheckBox cinematic;
    protected OwnTextIconButton button3d;
    protected OwnTextIconButton buttonDome;
    protected OwnTextIconButton buttonCubemap;
    protected OwnTextIconButton buttonOrthosphere;
    protected OwnTextIconButton buttonMaster;
    protected OwnImageButton recCamera;
    protected OwnImageButton recKeyframeCamera;
    protected OwnImageButton playCamera;
    protected boolean fovFlag = true;
    private boolean fieldLock = false;

    public CameraComponent(Skin skin, Stage stage) {
        super(skin, stage);
    }

    @Override
    public void initialize(float componentWidth) {
        this.recCamera = new OwnImageButton(this.skin, "rec");
        this.recCamera.setName("recCam");
        this.recCamera.setChecked(Settings.settings.runtime.recordCamera);
        this.recCamera.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.recCamera.isChecked() && Camcorder.instance.isPlaying()) {
                    this.recCamera.setCheckedNoFire(false);
                    return false;
                }
                if (!this.recCamera.isChecked() && !Camcorder.instance.isRecording()) {
                    this.recCamera.setCheckedNoFire(false);
                    return false;
                }
                EventManager.publish(Event.RECORD_CAMERA_CMD, (Object)this.recCamera, this.recCamera.isChecked(), null);
                return true;
            }
            return false;
        });
        this.recCamera.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.reccamera"), this.skin));
        this.recKeyframeCamera = new OwnImageButton(this.skin, "rec-key");
        this.recKeyframeCamera.setName("recKeyframeCamera");
        this.recKeyframeCamera.setChecked(Settings.settings.runtime.recordKeyframeCamera);
        this.recKeyframeCamera.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_KEYFRAMES_WINDOW_ACTION, (Object)this.recKeyframeCamera, new Object[0]);
                return true;
            }
            return false;
        });
        this.recKeyframeCamera.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.reccamerakeyframe"), this.skin));
        this.playCamera = new OwnImageButton(this.skin, "play");
        this.playCamera.setName("playCam");
        this.playCamera.setChecked(false);
        this.playCamera.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (Camcorder.instance.isRecording()) {
                    return false;
                }
                EventManager.publish(Event.SHOW_PLAYCAMERA_CMD, (Object)this.playCamera, new Object[0]);
                return true;
            }
            return false;
        });
        this.playCamera.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.playcamera"), this.skin));
        Table cameraPathGroup = new Table(this.skin);
        cameraPathGroup.setWidth(componentWidth);
        cameraPathGroup.add((Actor)new Separator(this.skin, "gray")).center().growX().padRight(this.pad8);
        cameraPathGroup.add((Actor)this.recCamera).center().padRight(this.pad4);
        cameraPathGroup.add((Actor)this.recKeyframeCamera).center().padRight(this.pad4);
        cameraPathGroup.add((Actor)this.playCamera).center().padRight(this.pad8);
        cameraPathGroup.add((Actor)new Separator(this.skin, "gray")).center().growX();
        this.cinematic = new OwnCheckBox(I18n.msg("gui.camera.cinematic"), this.skin, this.pad8);
        this.cinematic.setName("cinematic camera");
        this.cinematic.setChecked(Settings.settings.scene.camera.cinematic);
        String[] hkc = KeyBindings.instance.getStringKeys("action.toggle/camera.cinematic", true);
        this.cinematic.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("gui.camera.cinematic")), hkc, this.skin));
        this.cinematic.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.CAMERA_CINEMATIC_CMD, this.cinematic, this.cinematic.isChecked());
                return true;
            }
            return false;
        });
        Label modeLabel = new Label((CharSequence)I18n.msg("gui.camera.mode"), this.skin, "default");
        int cameraModes = CameraManager.CameraMode.values().length;
        Object[] cameraOptions = new CameraComboBoxBean[cameraModes];
        for (int i = 0; i < cameraModes; ++i) {
            cameraOptions[i] = new CameraComboBoxBean(Objects.requireNonNull(CameraManager.CameraMode.getMode(i)).toStringI18n(), CameraManager.CameraMode.getMode(i));
        }
        this.cameraMode = new OwnSelectBox<CameraComboBoxBean>(this.skin);
        this.cameraMode.setName("camera mode");
        this.cameraMode.setWidth(componentWidth);
        this.cameraMode.setItems(cameraOptions);
        this.cameraMode.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                CameraComboBoxBean selection = (CameraComboBoxBean)this.cameraMode.getSelected();
                CameraManager.CameraMode mode = selection.mode;
                EventManager.publish(Event.CAMERA_MODE_CMD, this.cameraMode, new Object[]{mode});
                return true;
            }
            return false;
        });
        if (!Settings.settings.runtime.openXr) {
            float buttonSize = 55.0f;
            Image icon3d = new Image(this.skin.getDrawable("3d-icon"));
            this.button3d = new OwnTextIconButton("", 1, icon3d, this.skin, "toggle");
            this.button3d.setChecked(Settings.settings.program.modeStereo.active);
            String[] hk3d = KeyBindings.instance.getStringKeys("action.toggle/element.stereomode", true);
            this.button3d.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.stereomode")), hk3d, this.skin));
            this.button3d.setName("3d");
            this.button3d.setSize(buttonSize, buttonSize);
            this.button3d.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.button3d.isChecked()) {
                        this.buttonCubemap.setProgrammaticChangeEvents(true);
                        this.buttonCubemap.setChecked(false);
                        this.buttonDome.setProgrammaticChangeEvents(true);
                        this.buttonDome.setChecked(false);
                        this.buttonOrthosphere.setProgrammaticChangeEvents(true);
                        this.buttonOrthosphere.setChecked(false);
                    }
                    EventManager.publish(Event.STEREOSCOPIC_CMD, (Object)this.button3d, this.button3d.isChecked());
                    return true;
                }
                return false;
            });
            Image iconDome = new Image(this.skin.getDrawable("dome-icon"));
            this.buttonDome = new OwnTextIconButton("", 1, iconDome, this.skin, "toggle");
            this.buttonDome.setChecked(Settings.settings.program.modeCubemap.active && Settings.settings.program.modeCubemap.isPlanetariumOn());
            String[] hkDome = KeyBindings.instance.getStringKeys("action.toggle/element.planetarium", true);
            this.buttonDome.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.planetarium")), hkDome, this.skin));
            this.buttonDome.setName("dome");
            this.buttonDome.setSize(buttonSize, buttonSize);
            this.buttonDome.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.buttonDome.isChecked()) {
                        this.buttonCubemap.setProgrammaticChangeEvents(true);
                        this.buttonCubemap.setChecked(false);
                        this.button3d.setProgrammaticChangeEvents(true);
                        this.button3d.setChecked(false);
                        this.buttonOrthosphere.setProgrammaticChangeEvents(true);
                        this.buttonOrthosphere.setChecked(false);
                    }
                    EventManager.publish(Event.CUBEMAP_CMD, (Object)this.buttonDome, new Object[]{this.buttonDome.isChecked(), CubmeapProjectionEffect.CubemapProjection.AZIMUTHAL_EQUIDISTANT});
                    this.fieldOfView.setDisabled(this.buttonDome.isChecked());
                    return true;
                }
                return false;
            });
            Image iconCubemap = new Image(this.skin.getDrawable("cubemap-icon"));
            this.buttonCubemap = new OwnTextIconButton("", 1, iconCubemap, this.skin, "toggle");
            this.buttonCubemap.setProgrammaticChangeEvents(false);
            this.buttonCubemap.setChecked(Settings.settings.program.modeCubemap.active && Settings.settings.program.modeCubemap.isPanoramaOn());
            String[] hkCubemap = KeyBindings.instance.getStringKeys("action.toggle/element.360", true);
            this.buttonCubemap.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.360")), hkCubemap, this.skin));
            this.buttonCubemap.setName("cubemap");
            this.buttonCubemap.setSize(buttonSize, buttonSize);
            this.buttonCubemap.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.buttonCubemap.isChecked()) {
                        this.buttonDome.setProgrammaticChangeEvents(true);
                        this.buttonDome.setChecked(false);
                        this.button3d.setProgrammaticChangeEvents(true);
                        this.button3d.setChecked(false);
                        this.buttonOrthosphere.setProgrammaticChangeEvents(true);
                        this.buttonOrthosphere.setChecked(false);
                    }
                    EventManager.publish(Event.CUBEMAP_CMD, (Object)this.buttonCubemap, new Object[]{this.buttonCubemap.isChecked(), CubmeapProjectionEffect.CubemapProjection.EQUIRECTANGULAR});
                    this.fieldOfView.setDisabled(this.buttonCubemap.isChecked());
                    return true;
                }
                return false;
            });
            Image iconOrthosphere = new Image(this.skin.getDrawable("orthosphere-icon"));
            this.buttonOrthosphere = new OwnTextIconButton("", 1, iconOrthosphere, this.skin, "toggle");
            this.buttonOrthosphere.setProgrammaticChangeEvents(false);
            this.buttonOrthosphere.setChecked(Settings.settings.program.modeCubemap.active && Settings.settings.program.modeCubemap.isOrthosphereOn());
            String[] hkOrthosphere = KeyBindings.instance.getStringKeys("action.toggle/element.orthosphere", true);
            this.buttonOrthosphere.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.orthosphere")), hkOrthosphere, this.skin));
            this.buttonOrthosphere.setName("orthosphere");
            this.buttonOrthosphere.setSize(buttonSize, buttonSize);
            this.buttonOrthosphere.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.buttonOrthosphere.isChecked()) {
                        this.buttonCubemap.setProgrammaticChangeEvents(true);
                        this.buttonCubemap.setChecked(false);
                        this.buttonDome.setProgrammaticChangeEvents(true);
                        this.buttonDome.setChecked(false);
                        this.button3d.setProgrammaticChangeEvents(true);
                        this.button3d.setChecked(false);
                    }
                    EventManager.publish(Event.CUBEMAP_CMD, (Object)this.buttonOrthosphere, new Object[]{this.buttonOrthosphere.isChecked(), CubmeapProjectionEffect.CubemapProjection.ORTHOSPHERE});
                    this.fieldOfView.setDisabled(this.buttonOrthosphere.isChecked());
                    return true;
                }
                return false;
            });
            if (Settings.settings.program.net.isMasterInstance()) {
                Image iconMaster = new Image(this.skin.getDrawable("iconic-link-intact"));
                this.buttonMaster = new OwnTextIconButton("", 1, iconMaster, this.skin, "default");
                this.buttonMaster.setProgrammaticChangeEvents(false);
                this.buttonMaster.setSize(28.0f, 29.6f);
                String[] hkmaster = KeyBindings.instance.getStringKeys("action.slave.configure", true);
                this.buttonMaster.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.slave.config")), hkmaster, this.skin));
                this.buttonMaster.setName("master");
                this.buttonMaster.setSize(buttonSize, buttonSize);
                this.buttonMaster.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        EventManager.publish(Event.SHOW_SLAVE_CONFIG_ACTION, (Object)this.buttonMaster, new Object[0]);
                        return true;
                    }
                    return false;
                });
            }
        }
        this.fieldOfView = new OwnSliderPlus(I18n.msg("gui.camera.fov"), 1.0f, 150.0f, 0.01f, false, this.skin);
        this.fieldOfView.setValueSuffix("\u00b0");
        this.fieldOfView.setName("field of view");
        this.fieldOfView.setWidth(componentWidth);
        this.fieldOfView.setValue(Settings.settings.scene.camera.fov);
        this.fieldOfView.setDisabled(Settings.settings.program.modeCubemap.isFixedFov());
        this.fieldOfView.addListener(event -> {
            if (this.fovFlag && event instanceof ChangeListener.ChangeEvent && !SlaveManager.projectionActive() && !Settings.settings.program.modeCubemap.isFixedFov()) {
                float value = this.fieldOfView.getMappedValue();
                EventManager.publish(Event.FOV_CHANGED_CMD, (Object)this.fieldOfView, Float.valueOf(value));
                return true;
            }
            return false;
        });
        Object[] speedLimits = new String[]{I18n.msg("gui.camera.speedlimit.kmh", "1"), I18n.msg("gui.camera.speedlimit.kmh", "10"), I18n.msg("gui.camera.speedlimit.kmh", "100"), I18n.msg("gui.camera.speedlimit.kmh", "1000"), I18n.msg("gui.camera.speedlimit.kms", "1"), I18n.msg("gui.camera.speedlimit.kms", "10"), I18n.msg("gui.camera.speedlimit.kms", "100"), I18n.msg("gui.camera.speedlimit.kms", "1000"), I18n.msg("gui.camera.speedlimit.cfactor", "0.01"), I18n.msg("gui.camera.speedlimit.cfactor", "0.1"), I18n.msg("gui.camera.speedlimit.cfactor", "0.5"), I18n.msg("gui.camera.speedlimit.cfactor", "0.8"), I18n.msg("gui.camera.speedlimit.cfactor", "0.9"), I18n.msg("gui.camera.speedlimit.cfactor", "0.99"), I18n.msg("gui.camera.speedlimit.cfactor", "0.99999"), I18n.msg("gui.camera.speedlimit.c"), I18n.msg("gui.camera.speedlimit.cfactor", 2), I18n.msg("gui.camera.speedlimit.cfactor", 10), I18n.msg("gui.camera.speedlimit.cfactor", 1000), I18n.msg("gui.camera.speedlimit.aus", 1), I18n.msg("gui.camera.speedlimit.aus", 10), I18n.msg("gui.camera.speedlimit.aus", 1000), I18n.msg("gui.camera.speedlimit.aus", 10000), I18n.msg("gui.camera.speedlimit.pcs", 1), I18n.msg("gui.camera.speedlimit.pcs", 2), I18n.msg("gui.camera.speedlimit.pcs", 10), I18n.msg("gui.camera.speedlimit.pcs", 1000), I18n.msg("gui.camera.speedlimit.nolimit")};
        this.cameraSpeedLimit = new OwnSelectBox<String>(this.skin);
        this.cameraSpeedLimit.setName("camera speed limit");
        this.cameraSpeedLimit.setWidth(componentWidth);
        this.cameraSpeedLimit.setItems(speedLimits);
        this.cameraSpeedLimit.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                int idx = this.cameraSpeedLimit.getSelectedIndex();
                EventManager.publish(Event.SPEED_LIMIT_CMD, this.cameraSpeedLimit, idx);
                return true;
            }
            return false;
        });
        this.cameraSpeedLimit.setSelectedIndex(Settings.settings.scene.camera.speedLimitIndex);
        this.cameraSpeed = new OwnSliderPlus(I18n.msg("gui.camera.speed"), 0.0f, 100.0f, 1.0f, 0.1f, 15.0f, this.skin);
        this.cameraSpeed.setName("camera speed");
        this.cameraSpeed.setWidth(componentWidth);
        this.cameraSpeed.setMappedValue(Settings.settings.scene.camera.speed);
        this.cameraSpeed.addListener(event -> {
            if (!this.fieldLock && event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.CAMERA_SPEED_CMD, (Object)this.cameraSpeed, Float.valueOf(this.cameraSpeed.getMappedValue()));
                return true;
            }
            return false;
        });
        this.rotateSpeed = new OwnSliderPlus(I18n.msg("gui.rotation.speed"), 0.0f, 100.0f, 1.0f, 200.0f, 10000.0f, this.skin);
        this.rotateSpeed.setName("rotate speed");
        this.rotateSpeed.setWidth(componentWidth);
        this.rotateSpeed.setMappedValue(Settings.settings.scene.camera.rotate);
        this.rotateSpeed.addListener(event -> {
            if (!this.fieldLock && event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.ROTATION_SPEED_CMD, (Object)this.rotateSpeed, Float.valueOf(this.rotateSpeed.getMappedValue()));
                return true;
            }
            return false;
        });
        this.turnSpeed = new OwnSliderPlus(I18n.msg("gui.turn.speed"), 0.0f, 100.0f, 1.0f, 200.0f, 3000.0f, this.skin);
        this.turnSpeed.setName("turn speed");
        this.turnSpeed.setWidth(componentWidth);
        this.turnSpeed.setMappedValue(Settings.settings.scene.camera.turn);
        this.turnSpeed.addListener(event -> {
            if (!this.fieldLock && event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.TURNING_SPEED_CMD, (Object)this.turnSpeed, Float.valueOf(this.turnSpeed.getMappedValue()), true);
                return true;
            }
            return false;
        });
        this.focusLock = new CheckBox(" " + I18n.msg("gui.camera.lock"), this.skin);
        this.focusLock.setName("focus lock");
        this.focusLock.setChecked(Settings.settings.scene.camera.focusLock.position);
        this.focusLock.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.FOCUS_LOCK_CMD, this.focusLock, this.focusLock.isChecked());
                this.orientationLock.setVisible(this.focusLock.isChecked());
                return true;
            }
            return false;
        });
        this.orientationLock = new CheckBox(" " + I18n.msg("gui.camera.lock.orientation"), this.skin);
        this.orientationLock.setName("orientation lock");
        this.orientationLock.setChecked(Settings.settings.scene.camera.focusLock.orientation);
        this.orientationLock.setVisible(Settings.settings.scene.camera.focusLock.position);
        this.orientationLock.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.ORIENTATION_LOCK_CMD, this.orientationLock, this.orientationLock.isChecked());
                return true;
            }
            return false;
        });
        HorizontalGroup buttonGroup = null;
        if (!Settings.settings.runtime.openXr) {
            buttonGroup = new HorizontalGroup();
            buttonGroup.space(this.pad4);
            buttonGroup.addActor((Actor)this.button3d);
            buttonGroup.addActor((Actor)this.buttonDome);
            buttonGroup.addActor((Actor)this.buttonCubemap);
            buttonGroup.addActor((Actor)this.buttonOrthosphere);
            if (Settings.settings.program.net.isMasterInstance()) {
                buttonGroup.addActor((Actor)this.buttonMaster);
            }
        }
        Table cameraGroup = new Table(this.skin);
        cameraGroup.align(8);
        cameraGroup.add((Actor)cameraPathGroup).center().growX().padBottom(this.pad9).row();
        cameraGroup.add((Actor)this.group((Actor)modeLabel, (Actor)this.cameraMode, this.pad3)).top().left().padBottom(this.pad9).row();
        cameraGroup.add((Actor)this.group((Actor)new Label((CharSequence)I18n.msg("gui.camera.speedlimit"), this.skin, "default"), (Actor)this.cameraSpeedLimit, this.pad3)).top().left().padBottom(this.pad20).row();
        cameraGroup.add((Actor)this.fieldOfView).top().left().padBottom(this.pad9).row();
        cameraGroup.add((Actor)this.cameraSpeed).top().left().padBottom(this.pad9).row();
        cameraGroup.add((Actor)this.rotateSpeed).top().left().padBottom(this.pad9).row();
        cameraGroup.add((Actor)this.turnSpeed).top().left().padBottom(this.pad20).row();
        cameraGroup.add((Actor)this.cinematic).top().left().padBottom(this.pad9).row();
        cameraGroup.add((Actor)this.focusLock).top().left().padBottom(this.pad9).row();
        cameraGroup.add((Actor)this.orientationLock).top().left().row();
        if (!Settings.settings.runtime.openXr) {
            cameraGroup.add((Actor)this.group((Actor)new Label((CharSequence)"", this.skin), (Actor)buttonGroup, this.pad3)).top().center();
        }
        this.component = cameraGroup;
        cameraGroup.pack();
        EventManager.instance.subscribe((IObserver)this, Event.CAMERA_MODE_CMD, Event.ROTATION_SPEED_CMD, Event.TURNING_SPEED_CMD, Event.CAMERA_SPEED_CMD, Event.SPEED_LIMIT_CMD, Event.STEREOSCOPIC_CMD, Event.FOV_CHANGED_CMD, Event.CUBEMAP_CMD, Event.CAMERA_CINEMATIC_CMD, Event.ORIENTATION_LOCK_CMD, Event.RECORD_CAMERA_CMD);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case CAMERA_CINEMATIC_CMD: {
                boolean gui;
                boolean bl = gui = source == this.cinematic;
                if (gui) break;
                this.cinematic.setProgrammaticChangeEvents(false);
                this.cinematic.setChecked(((Boolean)data[0]).booleanValue());
                this.cinematic.setProgrammaticChangeEvents(true);
                break;
            }
            case CAMERA_MODE_CMD: {
                if (source == this.cameraMode) break;
                CameraManager.CameraMode mode = (CameraManager.CameraMode)((Object)data[0]);
                Array cModes = this.cameraMode.getItems();
                CameraComboBoxBean selected = null;
                for (CameraComboBoxBean cameraModeBean : cModes) {
                    if (cameraModeBean.mode != mode) continue;
                    selected = cameraModeBean;
                    break;
                }
                if (selected == null) break;
                this.cameraMode.getSelection().setProgrammaticChangeEvents(false);
                this.cameraMode.setSelected((Object)selected);
                this.cameraMode.getSelection().setProgrammaticChangeEvents(true);
                break;
            }
            case ROTATION_SPEED_CMD: {
                if (source == this.rotateSpeed) break;
                float value = ((Float)data[0]).floatValue();
                this.fieldLock = true;
                this.rotateSpeed.setMappedValue(value);
                this.fieldLock = false;
                break;
            }
            case CAMERA_SPEED_CMD: {
                if (source == this.cameraSpeed) break;
                float value = ((Float)data[0]).floatValue();
                this.fieldLock = true;
                this.cameraSpeed.setMappedValue(value);
                this.fieldLock = false;
                break;
            }
            case TURNING_SPEED_CMD: {
                if (source == this.turnSpeed) break;
                float value = ((Float)data[0]).floatValue();
                this.fieldLock = true;
                this.turnSpeed.setMappedValue(value);
                this.fieldLock = false;
                break;
            }
            case SPEED_LIMIT_CMD: {
                if (source == this.cameraSpeedLimit) break;
                int value = (Integer)data[0];
                this.cameraSpeedLimit.getSelection().setProgrammaticChangeEvents(false);
                this.cameraSpeedLimit.setSelectedIndex(value);
                this.cameraSpeedLimit.getSelection().setProgrammaticChangeEvents(true);
                break;
            }
            case ORIENTATION_LOCK_CMD: {
                if (source == this.orientationLock) break;
                boolean lock = (Boolean)data[0];
                this.orientationLock.setProgrammaticChangeEvents(false);
                this.orientationLock.setChecked(lock);
                this.orientationLock.setProgrammaticChangeEvents(true);
                break;
            }
            case FOV_CHANGED_CMD: {
                if (source == this.fieldOfView) break;
                this.fovFlag = false;
                this.fieldOfView.setValue(((Float)data[0]).floatValue());
                this.fovFlag = true;
                break;
            }
            case STEREOSCOPIC_CMD: {
                if (source == this.button3d || Settings.settings.runtime.openXr) break;
                this.button3d.setProgrammaticChangeEvents(false);
                this.button3d.setChecked((Boolean)data[0]);
                this.button3d.setProgrammaticChangeEvents(true);
                break;
            }
            case CUBEMAP_CMD: {
                if (Settings.settings.runtime.openXr) break;
                CubmeapProjectionEffect.CubemapProjection proj = (CubmeapProjectionEffect.CubemapProjection)((Object)data[1]);
                boolean enable = (Boolean)data[0];
                if (proj.isPanorama() && source != this.buttonCubemap) {
                    this.buttonCubemap.setProgrammaticChangeEvents(false);
                    this.buttonCubemap.setChecked(enable);
                    this.buttonCubemap.setProgrammaticChangeEvents(true);
                    this.fieldOfView.setDisabled(enable);
                    break;
                }
                if (proj.isPlanetarium() && source != this.buttonDome) {
                    this.buttonDome.setProgrammaticChangeEvents(false);
                    this.buttonDome.setChecked(enable);
                    this.buttonDome.setProgrammaticChangeEvents(true);
                    this.fieldOfView.setDisabled(enable);
                    break;
                }
                if (!proj.isOrthosphere() || source == this.buttonOrthosphere) break;
                this.buttonOrthosphere.setProgrammaticChangeEvents(false);
                this.buttonOrthosphere.setChecked(enable);
                this.buttonOrthosphere.setProgrammaticChangeEvents(true);
                this.fieldOfView.setDisabled(enable);
                break;
            }
            case RECORD_CAMERA_CMD: {
                boolean state = (Boolean)data[0];
                if (source == this.recCamera) break;
                this.recCamera.setCheckedNoFire(state);
                break;
            }
        }
    }

    @Override
    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }
}

