/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.components;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.components.GuiComponent;
import gaiasky.gui.datasets.DatasetFiltersWindow;
import gaiasky.gui.datasets.DatasetInfoWindow;
import gaiasky.gui.datasets.DatasetTransformsWindow;
import gaiasky.gui.datasets.DatasetVisualSettingsWindow;
import gaiasky.gui.window.ColorPicker;
import gaiasky.gui.window.ColorPickerAbstract;
import gaiasky.gui.window.ColormapPicker;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Base;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.view.FocusView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.CatalogManager;
import gaiasky.util.GlobalResources;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.CollapsibleEntry;
import gaiasky.util.scene2d.ContextMenu;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.MenuItem;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DatasetsComponent
extends GuiComponent
implements IObserver {
    private final Map<String, WidgetGroup> groupMap;
    private final Map<String, OwnImageButton[]> imageMap;
    private final Map<String, ColorPickerAbstract> colorMap;
    private final Map<String, OwnSliderPlus> scalingMap;
    private final Map<String, DatasetVisualSettingsWindow> visualSettingsMap;
    private final Map<String, DatasetFiltersWindow> filtersMap;
    private final Map<String, DatasetInfoWindow> infoMap;
    private final Map<String, DatasetTransformsWindow> transformsMap;
    private final CatalogManager catalogManager;
    private VerticalGroup group;
    private OwnLabel noDatasetsLabel = null;
    private float componentWidth;

    public DatasetsComponent(Skin skin, Stage stage, CatalogManager catalogManager) {
        super(skin, stage);
        this.catalogManager = catalogManager;
        this.groupMap = new ConcurrentHashMap<String, WidgetGroup>();
        this.imageMap = new ConcurrentHashMap<String, OwnImageButton[]>();
        this.colorMap = new ConcurrentHashMap<String, ColorPickerAbstract>();
        this.scalingMap = new ConcurrentHashMap<String, OwnSliderPlus>();
        this.visualSettingsMap = new ConcurrentHashMap<String, DatasetVisualSettingsWindow>();
        this.filtersMap = new ConcurrentHashMap<String, DatasetFiltersWindow>();
        this.infoMap = new ConcurrentHashMap<String, DatasetInfoWindow>();
        this.transformsMap = new ConcurrentHashMap<String, DatasetTransformsWindow>();
        EventManager.instance.subscribe((IObserver)this, Event.CATALOG_ADD, Event.CATALOG_REMOVE, Event.CATALOG_VISIBLE, Event.CATALOG_HIGHLIGHT, Event.CATALOG_POINT_SIZE_SCALING_CMD);
    }

    @Override
    public void initialize(float componentWidth) {
        this.componentWidth = componentWidth;
        this.group = new VerticalGroup();
        this.group.columnAlign(8);
        Collection<CatalogInfo> cis = this.catalogManager.getCatalogInfos();
        if (cis != null) {
            for (CatalogInfo ci : cis) {
                this.addCatalogInfo(ci);
            }
        }
        this.component = this.group;
        this.addNoDatasets();
    }

    private void setDatasetVisibility(CatalogInfo ci, OwnImageButton eye, boolean visible, Actor source) {
        if (ci.entity != null) {
            if (source != eye) {
                eye.setCheckedNoFire(!visible);
            }
            EventManager.publish(Event.CATALOG_VISIBLE, this, ci.name, visible);
            if (Mapper.mesh.has(ci.entity)) {
                Base base = (Base)Mapper.base.get(ci.entity);
                EventManager.publish(Event.PER_OBJECT_VISIBILITY_CMD, this, ci.entity, base.getName(), visible);
            }
        }
    }

    private void setDatasetHighlight(CatalogInfo ci, OwnImageButton mark, boolean highlight, Actor source) {
        if (ci.entity != null) {
            if (source != mark) {
                mark.setCheckedNoFire(highlight);
            }
            EventManager.publish(Event.CATALOG_HIGHLIGHT, this, ci, highlight);
        }
    }

    private void showDatasetFilters(CatalogInfo ci) {
        if (!this.filtersMap.containsKey(ci.name)) {
            DatasetFiltersWindow dfw = new DatasetFiltersWindow(ci, this.skin, this.stage);
            dfw.setVisible(true);
            dfw.show(this.stage);
            dfw.setCloseListener(() -> this.filtersMap.remove(ci.name, (Object)dfw));
            this.filtersMap.put(ci.name, dfw);
        }
    }

    private void showDatasetInfo(CatalogInfo ci) {
        if (!this.infoMap.containsKey(ci.name)) {
            DatasetInfoWindow diw = new DatasetInfoWindow(ci, this.skin, this.stage);
            diw.setVisible(true);
            diw.show(this.stage);
            diw.setCloseListener(() -> this.infoMap.remove(ci.name, (Object)diw));
            this.infoMap.put(ci.name, diw);
        }
    }

    private void showDatasetVisualSettings(CatalogInfo ci) {
        if (!this.visualSettingsMap.containsKey(ci.name)) {
            DatasetVisualSettingsWindow dpw = new DatasetVisualSettingsWindow(ci, this.skin, this.stage);
            dpw.setVisible(true);
            dpw.show(this.stage);
            dpw.setCloseListener(() -> this.visualSettingsMap.remove(ci.name, dpw));
            this.visualSettingsMap.put(ci.name, dpw);
        }
    }

    private void showDatasetTransforms(CatalogInfo ci) {
        if (!this.transformsMap.containsKey(ci.name)) {
            DatasetTransformsWindow dtw = new DatasetTransformsWindow(ci, this.skin, this.stage);
            dtw.setVisible(true);
            dtw.show(this.stage);
            dtw.setCloseListener(() -> this.transformsMap.remove(ci.name, (Object)dtw));
            this.transformsMap.put(ci.name, dtw);
        }
    }

    private void addCatalogInfo(final CatalogInfo ci) {
        ColorPickerAbstract cp;
        Table controls = new Table(this.skin);
        final OwnImageButton visibilityButton = new OwnImageButton(this.skin, "eye-toggle");
        visibilityButton.setCheckedNoFire(!ci.isVisible(true));
        visibilityButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.toggle"), this.skin));
        visibilityButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.setDatasetVisibility(ci, visibilityButton, !ci.isVisible(true), (Actor)visibilityButton);
                return true;
            }
            return false;
        });
        final OwnImageButton highlightButton = new OwnImageButton(this.skin, "highlight-ds-s");
        highlightButton.setCheckedNoFire(ci.highlighted);
        highlightButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.highlight"), this.skin));
        highlightButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.setDatasetHighlight(ci, highlightButton, highlightButton.isChecked(), (Actor)highlightButton);
                return true;
            }
            return false;
        });
        OwnImageButton filtersButton = new OwnImageButton(this.skin, "filter");
        filtersButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.filter"), this.skin));
        filtersButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.showDatasetFilters(ci);
                return true;
            }
            return false;
        });
        OwnImageButton visualSettingsButton = new OwnImageButton(this.skin, "bolt");
        visualSettingsButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.visuals"), this.skin));
        visualSettingsButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.showDatasetVisualSettings(ci);
                return true;
            }
            return false;
        });
        OwnImageButton transformsButton = new OwnImageButton(this.skin, "matrix");
        transformsButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.transforms"), this.skin));
        transformsButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.showDatasetTransforms(ci);
                return true;
            }
            return false;
        });
        OwnImageButton infoButton = new OwnImageButton(this.skin, "info");
        infoButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.info"), this.skin));
        infoButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.showDatasetInfo(ci);
                return true;
            }
            return false;
        });
        OwnImageButton rubbishButton = new OwnImageButton(this.skin, "rubbish-bin");
        rubbishButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.remove"), this.skin));
        rubbishButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.CATALOG_REMOVE, this, ci.name);
                return true;
            }
            return false;
        });
        this.imageMap.put(ci.name, new OwnImageButton[]{visibilityButton, highlightButton});
        if (ci.isHighlightable()) {
            controls.add((Actor)visibilityButton).padRight(this.pad6);
            controls.add((Actor)highlightButton).padRight(this.pad30);
            controls.add((Actor)visualSettingsButton).padRight(this.pad6);
            if (ci.hasParticleAttributes()) {
                controls.add((Actor)filtersButton).padRight(this.pad6);
            }
            controls.add((Actor)transformsButton).padRight(this.pad30);
            controls.add((Actor)infoButton).padRight(this.pad6);
            controls.add((Actor)rubbishButton);
        } else {
            controls.add((Actor)visibilityButton).padRight(this.pad30);
            controls.add((Actor)transformsButton).padRight(this.pad30);
            controls.add((Actor)infoButton).padRight(this.pad6);
            controls.add((Actor)rubbishButton);
        }
        Table t = new Table(this.skin);
        t.align(10);
        if (ci.hasParticleAttributes()) {
            ColormapPicker cmp = new ColormapPicker(ci.name, ci.hlColor, ci, this.stage, this.skin);
            cmp.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.highlight.color.select"), this.skin));
            cmp.setNewColorRunnable(() -> ci.setHlColor(cmp.getPickedColor()));
            cmp.setNewColormapRunnable(() -> ci.setHlColormap(cmp.getPickedCmapIndex(), cmp.getPickedCmapAttribute(), cmp.getPickedCmapMin(), cmp.getPickedCmapMax()));
            cp = cmp;
        } else {
            ColorPicker clp = new ColorPicker(ci.name, ci.hlColor, this.stage, this.skin);
            clp.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.highlight.color.select"), this.skin));
            clp.setNewColorRunnable(() -> ci.setHlColor(clp.getPickedColor()));
            cp = clp;
        }
        this.colorMap.put(ci.name, cp);
        OwnLabel nameLabel = new OwnLabel((CharSequence)TextUtils.capString(ci.name, 23), this.skin, "hud-subheader");
        nameLabel.addListener((EventListener)new OwnTextTooltip(ci.name, this.skin));
        float pad = 4.8f;
        if (ci.isHighlightable()) {
            t.add((Actor)controls).left().padBottom(pad);
            t.add((Actor)cp).right().size(28.8f).padRight(this.pad6).padBottom(pad).row();
        } else {
            t.add((Actor)controls).colspan(2).left().padBottom(pad).row();
        }
        int cap = 25;
        String types = ci.type.toString() + " / " + String.valueOf(ci.getCt());
        OwnLabel typesLabel = new OwnLabel((CharSequence)TextUtils.capString(types, cap), this.skin, "grey-large");
        typesLabel.addListener((EventListener)new OwnTextTooltip(types, this.skin));
        t.add((Actor)typesLabel).colspan(2).left().row();
        String description = ci.description != null ? ci.description : "";
        OwnLabel desc = new OwnLabel((CharSequence)TextUtils.capString(description, cap), this.skin);
        desc.addListener((EventListener)new OwnTextTooltip(description, this.skin));
        t.add((Actor)desc).left().expandX();
        if (!description.isBlank()) {
            Link info = new Link((CharSequence)"(i)", (Label.LabelStyle)this.skin.get("link", Label.LabelStyle.class), null);
            info.addListener((EventListener)new OwnTextTooltip(description, this.skin));
            t.add((Actor)info).left().padLeft(pad);
        }
        if (ci.nParticles > 0L) {
            t.row();
            OwnLabel nObjects = new OwnLabel((CharSequence)(I18n.msg("gui.objects") + ": " + ci.nParticles), this.skin, "default-blue");
            String bytes = ci.sizeBytes > 0L ? I18n.msg("gui.size") + ": " + GlobalResources.humanReadableByteCount(ci.sizeBytes, true) : "";
            nObjects.addListener((EventListener)new OwnTextTooltip(String.valueOf(nObjects.getText()) + (String)(bytes.isEmpty() ? "" : ", " + bytes), this.skin));
            t.add((Actor)nObjects).left();
        }
        if (ci.isHighlightable()) {
            OwnSliderPlus sizeScaling = new OwnSliderPlus(I18n.msg("gui.dataset.size"), 0.1f, 5.0f, 0.01f, this.skin);
            sizeScaling.setWidth(350.0f);
            if (ci.entity != null) {
                GraphNode graph = (GraphNode)Mapper.graph.get(ci.entity);
                Highlight hl = (Highlight)Mapper.highlight.get(ci.entity);
                if (hl != null) {
                    float pointScaling = graph.parent != null && Mapper.octree.has(graph.parent) ? ((Highlight)Mapper.highlight.get((Entity)graph.parent)).pointscaling * hl.pointscaling : hl.pointscaling;
                    sizeScaling.setMappedValue(pointScaling);
                }
            }
            sizeScaling.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    double val = sizeScaling.getMappedValue();
                    EventManager.publish(Event.CATALOG_POINT_SIZE_SCALING_CMD, (Object)sizeScaling, ci.name, val);
                    return true;
                }
                return false;
            });
            t.row();
            t.add((Actor)sizeScaling).left().colspan(2).padTop(this.pad9);
            this.scalingMap.put(ci.name, sizeScaling);
        }
        Container c = new Container((Actor)t);
        c.setFillParent(true);
        c.align(10);
        c.minHeight(80.0f);
        c.width(this.componentWidth * 0.94f);
        OwnScrollPane scroll = new OwnScrollPane((Actor)c, this.skin, "minimalist-nobg");
        scroll.setScrollingDisabled(false, true);
        scroll.setForceScroll(false, false);
        scroll.setFadeScrollBars(false);
        scroll.setOverscroll(false, false);
        scroll.setSmoothScrolling(true);
        scroll.setWidth(this.componentWidth * 0.94f);
        final CollapsibleEntry catalogWidget = new CollapsibleEntry((Actor)nameLabel, (Actor)scroll, this.skin);
        catalogWidget.align(10);
        catalogWidget.pad(this.pad9);
        catalogWidget.setWidth(this.componentWidth * 0.94f);
        catalogWidget.setExpandRunnable(() -> EventManager.publish(Event.RECALCULATE_CONTROLS_WINDOW_SIZE, this, new Object[0]));
        catalogWidget.setCollapseRunnable(() -> EventManager.publish(Event.RECALCULATE_CONTROLS_WINDOW_SIZE, this, new Object[0]));
        catalogWidget.addListener((EventListener)new InputListener(this){
            final /* synthetic */ DatasetsComponent this$0;
            {
                this.this$0 = this$0;
            }

            public boolean handle(com.badlogic.gdx.scenes.scene2d.Event event) {
                InputEvent ie;
                InputEvent.Type type;
                if (event instanceof InputEvent && (type = (ie = (InputEvent)event).getType()) == InputEvent.Type.touchDown && ie.getButton() == 1) {
                    GaiaSky.postRunnable(() -> {
                        ContextMenu datasetContext = new ContextMenu(this.this$0.skin, "default");
                        final boolean currentVisibility = ci.isVisible(true);
                        MenuItem visibility = new MenuItem(I18n.msg(currentVisibility ? "gui.hide" : "gui.show"), this.this$0.skin, this.this$0.skin.getDrawable(currentVisibility ? "eye-s-off" : "eye-s-on"));
                        visibility.addListener((EventListener)new ChangeListener(this){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                this.this$1.this$0.setDatasetVisibility(ci, visibilityButton, !currentVisibility, (Actor)catalogWidget);
                            }
                        });
                        datasetContext.addItem(visibility);
                        if (ci.isHighlightable()) {
                            final boolean currentHighlight = ci2.highlighted;
                            MenuItem highlight = new MenuItem(I18n.msg(currentHighlight ? "gui.deemphasize" : "gui.highlight"), this.this$0.skin, this.this$0.skin.getDrawable(currentHighlight ? "highlight-s-off" : "highlight-s-on"));
                            highlight.addListener((EventListener)new ChangeListener(this){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                    this.this$1.this$0.setDatasetHighlight(ci, highlightButton, !currentHighlight, (Actor)catalogWidget);
                                }
                            });
                            datasetContext.addItem(highlight);
                            MenuItem settings = new MenuItem(I18n.msg("gui.settings.dataset"), this.this$0.skin, this.this$0.skin.getDrawable("prefs-icon"));
                            settings.addListener((EventListener)new ChangeListener(this){
                                final /* synthetic */ 1 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                    this.this$1.this$0.showDatasetVisualSettings(ci);
                                }
                            });
                            datasetContext.addItem(settings);
                        }
                        MenuItem delete = new MenuItem(I18n.msg("gui.download.delete"), this.this$0.skin, this.this$0.skin.getDrawable("iconic-trash"));
                        delete.addListener((EventListener)new ChangeListener(this){

                            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                EventManager.publish(Event.CATALOG_REMOVE, (Object)this, ci.name);
                            }
                        });
                        datasetContext.addItem(delete);
                        datasetContext.showMenu(this.this$0.stage, (float)Gdx.input.getX(ie.getPointer()) / Settings.settings.program.ui.scale, this.this$0.stage.getHeight() - (float)Gdx.input.getY(ie.getPointer()) / Settings.settings.program.ui.scale);
                    });
                    event.setBubbles(false);
                    return true;
                }
                return false;
            }
        });
        this.group.addActor((Actor)catalogWidget);
        this.groupMap.put(ci.name, (WidgetGroup)catalogWidget);
    }

    private void removeNoDatasets() {
        if (this.noDatasetsLabel != null) {
            this.noDatasetsLabel.remove();
            this.noDatasetsLabel = null;
            this.group.pack();
        }
    }

    private void addNoDatasets() {
        if (this.groupMap != null && this.groupMap.isEmpty() && this.noDatasetsLabel == null) {
            this.noDatasetsLabel = new OwnLabel((CharSequence)I18n.msg("gui.dataset.notfound"), this.skin);
            this.noDatasetsLabel.setWidth(this.componentWidth * 0.94f);
            this.noDatasetsLabel.setAlignment(8, 8);
            this.group.addActor((Actor)this.noDatasetsLabel);
            this.group.pack();
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case CATALOG_ADD: {
                this.removeNoDatasets();
                this.addCatalogInfo((CatalogInfo)data[0]);
                break;
            }
            case CATALOG_REMOVE: {
                String datasetName = (String)data[0];
                if (this.groupMap.containsKey(datasetName)) {
                    this.groupMap.get(datasetName).remove();
                    this.groupMap.remove(datasetName);
                    this.imageMap.remove(datasetName);
                    this.colorMap.remove(datasetName);
                    EventManager.publish(Event.RECALCULATE_CONTROLS_WINDOW_SIZE, this, new Object[0]);
                }
                this.addNoDatasets();
                break;
            }
            case CATALOG_VISIBLE: {
                if (source == this) break;
                String datasetName = (String)data[0];
                boolean visible = (Boolean)data[1];
                OwnImageButton eye = this.imageMap.get(datasetName)[0];
                eye.setCheckedNoFire(!visible);
                break;
            }
            case PER_OBJECT_VISIBILITY_CMD: {
                if (source == this) break;
                Entity e = null;
                Object object = data[0];
                if (object instanceof FocusView) {
                    FocusView view = (FocusView)object;
                    e = view.getEntity();
                } else {
                    object = data[0];
                    if (object instanceof Entity) {
                        Entity entity;
                        e = entity = (Entity)object;
                    }
                }
                if (e == null) break;
                String datasetName = (String)data[1];
                boolean checked = (Boolean)data[2];
                if (!Mapper.mesh.has(e)) break;
                OwnImageButton eye = this.imageMap.get(datasetName)[0];
                eye.setCheckedNoFire(!checked);
                break;
            }
            case CATALOG_HIGHLIGHT: {
                if (source == this) break;
                CatalogInfo ci = (CatalogInfo)data[0];
                float[] col = ci.hlColor;
                if (this.colorMap.containsKey(ci.name) && col != null && ci.plainColor) {
                    this.colorMap.get(ci.name).setPickedColor(col);
                }
                if (!this.imageMap.containsKey(ci.name)) break;
                boolean hl = (Boolean)data[1];
                OwnImageButton hig = this.imageMap.get(ci.name)[1];
                hig.setCheckedNoFire(hl);
                break;
            }
            case CATALOG_POINT_SIZE_SCALING_CMD: {
                if (source == this) break;
                String datasetName = (String)data[0];
                double val = (Double)data[1];
                if (!this.scalingMap.containsKey(datasetName)) break;
                OwnSliderPlus slider = this.scalingMap.get(datasetName);
                slider.setProgrammaticChangeEvents(false);
                slider.setMappedValue(val);
                slider.setProgrammaticChangeEvents(true);
                break;
            }
        }
    }

    @Override
    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }
}

