/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.components;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.components.GuiComponent;
import gaiasky.scene.camera.CameraManager;
import gaiasky.script.EventScriptingInterface;
import gaiasky.util.LocationLogManager;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.util.LinkedList;

public class LocationLogComponent
extends GuiComponent
implements IObserver {
    private VerticalGroup locations;

    public LocationLogComponent(Skin skin, Stage stage) {
        super(skin, stage);
        EventManager.instance.subscribe((IObserver)this, Event.NEW_LOCATION_RECORD);
    }

    @Override
    public void initialize(float componentWidth) {
        this.locations = new VerticalGroup().align(10).columnAlign(8).space(this.pad8);
        OwnScrollPane scrollPane = new OwnScrollPane((Actor)this.locations, this.skin, "minimalist-nobg");
        scrollPane.setName("location log scroll");
        scrollPane.setFadeScrollBars(false);
        scrollPane.setScrollingDisabled(true, false);
        scrollPane.setHeight(360.0f);
        scrollPane.setWidth(componentWidth);
        VerticalGroup locationGroup = new VerticalGroup().align(8).columnAlign(8).space(this.pad12);
        locationGroup.addActor((Actor)scrollPane);
        this.component = locationGroup;
        this.refresh();
    }

    private void refresh() {
        this.locations.clear();
        LinkedList<LocationLogManager.LocationRecord> locations = LocationLogManager.instance().getLocations();
        float bw = 40.0f;
        for (int i = locations.size() - 1; i >= 0; --i) {
            LocationLogManager.LocationRecord lr = locations.get(i);
            Table recordTable = new Table(this.skin);
            OwnLabel num = new OwnLabel((CharSequence)(locations.size() - i + ":"), this.skin, "default-blue");
            num.setWidth(30.0f);
            OwnLabel name = new OwnLabel((CharSequence)TextUtils.capString(lr.name, 12), this.skin, "default");
            name.addListener((EventListener)new OwnTextTooltip(lr.name, this.skin));
            name.setWidth(165.0f);
            OwnLabel time = new OwnLabel((CharSequence)("(" + lr.elapsedString() + ")"), this.skin, "msg-17");
            time.setColor(Color.CORAL);
            time.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.locationlog.visited", lr.entryTime), this.skin));
            time.setWidth(60.0f);
            OwnTextIconButton goToLoc = new OwnTextIconButton("", this.skin, "go-to");
            goToLoc.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.locationlog.goto.location", lr.entryTime), this.skin));
            goToLoc.setSize(bw, bw);
            goToLoc.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(Event.CAMERA_MODE_CMD, (Object)goToLoc, new Object[]{CameraManager.CameraMode.FREE_MODE});
                    EventManager.publish(Event.CAMERA_POS_CMD, (Object)goToLoc, new Object[]{lr.position.valuesD()});
                    EventManager.publish(Event.CAMERA_DIR_CMD, (Object)goToLoc, new Object[]{lr.direction.values()});
                    EventManager.publish(Event.CAMERA_UP_CMD, (Object)goToLoc, new Object[]{lr.up.values()});
                    EventManager.publish(Event.TIME_CHANGE_CMD, (Object)goToLoc, lr.simulationTime);
                    return true;
                }
                return false;
            });
            OwnTextIconButton goToObj = new OwnTextIconButton("", this.skin, "land-on");
            goToObj.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.locationlog.goto.object", lr.entryTime), this.skin));
            goToObj.setSize(bw, bw);
            goToObj.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    GaiaSky.postRunnable(() -> ((EventScriptingInterface)GaiaSky.instance.scripting()).setCameraFocusInstantAndGo(lr.name, false));
                    return true;
                }
                return false;
            });
            recordTable.add((Actor)num).left().padRight(this.pad8);
            recordTable.add((Actor)name).left().padRight(this.pad8);
            recordTable.add((Actor)time).left();
            Table mainTable = new Table(this.skin);
            mainTable.add((Actor)recordTable).left().padRight(this.pad12);
            mainTable.add((Actor)goToLoc).left().padRight(this.pad6);
            mainTable.add((Actor)goToObj).left();
            this.locations.addActor((Actor)mainTable);
        }
        if (locations.isEmpty()) {
            this.locations.addActor((Actor)new OwnLabel((CharSequence)I18n.msg("gui.locationlog.empty"), this.skin));
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.NEW_LOCATION_RECORD) {
            this.refresh();
        }
    }

    @Override
    public void dispose() {
    }
}

