/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.components;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.components.GuiComponent;
import gaiasky.gui.main.KeyBindings;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import gaiasky.util.time.GlobalClock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;

public class TimeComponent
extends GuiComponent
implements IObserver {
    private final ZoneId timeZone;
    private final DateTimeFormatter dfDate;
    private final DateTimeFormatter dfEra;
    private final DateTimeFormatter dfTime;
    private final int warpSteps;
    protected OwnLabel date;
    protected OwnLabel time;
    protected OwnLabel warp;
    protected OwnLabel warpForward;
    protected OwnLabel warpBackward;
    protected OwnImageButton playPause;
    protected OwnImageButton stepForward;
    protected OwnImageButton stepBackward;
    protected OwnTextIconButton dateEdit;
    protected OwnSliderPlus warpSlider;
    protected double[] timeWarpVector;
    protected boolean warpGuard = false;

    public TimeComponent(Skin skin, Stage stage) {
        super(skin, stage);
        this.timeZone = Settings.settings.program.timeZone.getTimeZone();
        this.dfDate = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(this.timeZone);
        this.dfEra = DateTimeFormatter.ofPattern("G").withLocale(I18n.locale).withZone(this.timeZone);
        this.dfTime = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(this.timeZone);
        this.warpSteps = ((GlobalClock)GaiaSky.instance.time).warpSteps;
        EventManager.instance.subscribe((IObserver)this, Event.TIME_CHANGE_INFO, Event.TIME_CHANGE_CMD, Event.TIME_WARP_CHANGED_INFO, Event.TIME_WARP_CMD, Event.TIME_STATE_CMD);
    }

    @Override
    public void initialize(float componentWidth) {
        KeyBindings kb = KeyBindings.instance;
        this.date = new OwnLabel((CharSequence)"date UT", this.skin, "big");
        this.date.setWidth(componentWidth - 65.0f);
        this.date.setAlignment(1);
        this.date.setName("label date");
        this.time = new OwnLabel((CharSequence)"time UT", this.skin, "big");
        this.time.setWidth(componentWidth - 65.0f);
        this.time.setAlignment(1);
        this.time.setName("label time");
        this.dateEdit = new OwnTextIconButton("", this.skin, "edit");
        this.dateEdit.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_DATE_TIME_EDIT_ACTION, this, new Object[0]);
            }
            return false;
        });
        this.dateEdit.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dateedit"), this.skin));
        this.warpBackward = new OwnLabel((CharSequence)I18n.msg("gui.time.bwd"), this.skin, "msg-15");
        this.warpBackward.setAlignment(8);
        this.warpBackward.setColor(Color.GRAY);
        this.warpForward = new OwnLabel((CharSequence)I18n.msg("gui.time.fwd"), this.skin, "msg-15");
        this.warpForward.setAlignment(16);
        this.warpForward.setColor(Color.GRAY);
        this.warp = new OwnLabel((CharSequence)"", this.skin, "big");
        this.warp.setText(TextUtils.secondsToTimeUnit(GaiaSky.instance.time.getWarpFactor()) + "/" + I18n.msg("gui.unit.second"));
        this.warp.setAlignment(1);
        this.warp.setWidth(componentWidth - 160.0f);
        this.warp.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.warp.tooltip"), this.skin));
        this.timeWarpVector = ((GlobalClock)GaiaSky.instance.time).generateTimeWarpVector();
        this.warpSlider = new OwnSliderPlus("", (float)(-this.warpSteps), (float)this.warpSteps, 1.0f, this.skin, "time-warp");
        this.warpSlider.setValueLabelTransform(value -> TextUtils.getFormattedTimeWarp(this.timeWarpVector[value.intValue() + this.warpSteps]));
        this.warpSlider.setValue(this.getWarpIndex(GaiaSky.instance.time.getWarpFactor()) - this.warpSteps);
        this.warpSlider.setWidth(componentWidth);
        this.warpSlider.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.warp"), this.skin));
        this.warpSlider.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent && !this.warpGuard) {
                int index = (int)this.warpSlider.getValue();
                double newWarp = this.timeWarpVector[index + this.warpSteps];
                EventManager.publish(Event.TIME_WARP_CMD, (Object)this.warpSlider, newWarp);
            }
            return false;
        });
        this.stepForward = new OwnImageButton(this.skin, "media-skip-forward");
        this.stepForward.setName("plus");
        this.stepForward.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.TIME_WARP_INCREASE_CMD, (Object)this.stepForward, new Object[0]);
                return true;
            }
            return false;
        });
        this.stepForward.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.tooltip.timewarpplus"), kb.getStringKeys("action.doubletime", true), this.skin));
        this.playPause = new OwnImageButton(this.skin, "media-play-pause");
        this.playPause.setChecked(Settings.settings.runtime.timeOn);
        this.playPause.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.TIME_STATE_CMD, (Object)this.playPause, this.playPause.isChecked());
                return true;
            }
            return false;
        });
        String[] timeHotkey = KeyBindings.instance.getStringKeys("action.pauseresume", true);
        this.playPause.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.tooltip.playstop"), timeHotkey, this.skin));
        this.stepBackward = new OwnImageButton(this.skin, "media-skip-backward");
        this.stepBackward.setName("minus");
        this.stepBackward.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.TIME_WARP_DECREASE_CMD, (Object)this.stepBackward, new Object[0]);
                return true;
            }
            return false;
        });
        this.stepBackward.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.tooltip.timewarpminus"), kb.getStringKeys("action.dividetime", true), this.skin));
        OwnTextIconButton resetTime = new OwnTextIconButton(I18n.msg("gui.resettime"), this.skin, "reset");
        resetTime.align(1);
        resetTime.setWidth(componentWidth);
        resetTime.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.resettime.tooltip"), this.skin));
        resetTime.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager m = EventManager.instance;
                m.post(Event.TIME_CHANGE_CMD, (Object)resetTime, Instant.now());
                m.post(Event.TIME_WARP_CMD, (Object)resetTime, 1.0);
                return true;
            }
            return false;
        });
        Table timeGroup = new Table(this.skin);
        Table dateGroup = new Table(this.skin);
        dateGroup.setWidth(componentWidth);
        Table datetimeGroup = new Table(this.skin);
        datetimeGroup.add((Actor)this.date).left().pad(this.pad4).row();
        datetimeGroup.add((Actor)this.time).left().pad(this.pad4);
        dateGroup.add((Actor)datetimeGroup).left().padRight(this.pad12).padLeft(this.pad9);
        dateGroup.add((Actor)this.dateEdit).right();
        Table textGroup = new Table(this.skin);
        textGroup.add((Actor)this.warpBackward).left().padRight(this.pad4);
        textGroup.add((Actor)this.warp).center().growX().padRight(this.pad4);
        textGroup.add((Actor)this.warpForward).right();
        Table controlsGroup = new Table(this.skin);
        controlsGroup.add((Actor)this.stepBackward).center().pad(this.pad3).padLeft(this.pad12 * 2.2f).padRight(this.pad6);
        controlsGroup.add((Actor)this.playPause).center().pad(this.pad3).padRight(this.pad6);
        controlsGroup.add((Actor)this.stepForward).center().pad(this.pad3).padRight(this.pad6);
        controlsGroup.add((Actor)resetTime).center().pad(this.pad3);
        Table warpGroup = new Table(this.skin);
        warpGroup.add((Actor)controlsGroup).center().row();
        warpGroup.add((Actor)this.warpSlider).center().pad(0.0f, this.pad9, 0.0f, this.pad9).row();
        warpGroup.add((Actor)textGroup).center().pad(0.0f, this.pad9, 0.0f, this.pad9).row();
        timeGroup.add((Actor)dateGroup).left().padBottom(this.pad9).row();
        timeGroup.add((Actor)new Separator(this.skin, "gray")).center().growX().padBottom(this.pad20).padLeft(this.pad20).padRight(this.pad20).row();
        timeGroup.add((Actor)warpGroup).left().padBottom(this.pad20 * 1.5f).row();
        timeGroup.add((Actor)resetTime).center();
        timeGroup.pack();
        this.component = timeGroup;
    }

    private double[] generateTimeWarpVector(int steps) {
        int i;
        double[] warp = new double[steps * 2 + 1];
        warp[steps] = 0.0;
        double w = 0.0;
        for (i = steps + 1; i < warp.length; ++i) {
            warp[i] = this.increaseWarp(w);
            w = warp[i];
        }
        w = 0.0;
        for (i = steps - 1; i >= 0; --i) {
            warp[i] = this.decreaseWarp(w);
            w = warp[i];
        }
        return warp;
    }

    private double increaseWarp(double timeWarp) {
        if (timeWarp == 0.0) {
            return 0.125;
        }
        if (timeWarp == -0.125) {
            return 0.0;
        }
        if (timeWarp < 0.0) {
            return timeWarp / 2.0;
        }
        return timeWarp * 2.0;
    }

    private double decreaseWarp(double timeWarp) {
        if (timeWarp == 0.125) {
            return 0.0;
        }
        if (timeWarp == 0.0) {
            return -0.125;
        }
        if (timeWarp < 0.0) {
            return timeWarp * 2.0;
        }
        return timeWarp / 2.0;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case TIME_CHANGE_INFO: 
            case TIME_CHANGE_CMD: {
                Instant datetime = (Instant)data[0];
                GaiaSky.postRunnable(() -> {
                    this.date.setText(this.dfDate.format(datetime) + " " + this.dfEra.format(datetime));
                    this.time.setText(this.dfTime.format(datetime) + " " + this.timeZone.getDisplayName(TextStyle.SHORT, I18n.locale));
                });
                break;
            }
            case TIME_WARP_CHANGED_INFO: 
            case TIME_WARP_CMD: {
                if (source == this.warpSlider) break;
                double newWarp = (Double)data[0];
                int index = this.getWarpIndex(newWarp);
                if (index >= 0) {
                    this.warpGuard = true;
                    this.warpSlider.setValue(index - this.warpSteps);
                    this.warpGuard = false;
                }
                this.warp.setText(TextUtils.secondsToTimeUnit(newWarp) + "/" + I18n.msg("gui.unit.second"));
                break;
            }
            case TIME_STATE_CMD: {
                if (source == this.playPause) break;
                this.playPause.setCheckedNoFire((Boolean)data[0]);
                break;
            }
        }
    }

    private int getWarpIndex(double warpValue) {
        int index = -1;
        double prev = Double.MIN_VALUE;
        for (int i = 0; i < this.timeWarpVector.length; ++i) {
            if (warpValue == this.timeWarpVector[i]) {
                index = i;
                break;
            }
            if (warpValue > prev && warpValue < this.timeWarpVector[i]) {
                index = i;
                break;
            }
            prev = this.timeWarpVector[i];
        }
        return index;
    }

    @Override
    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }
}

