/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.components;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.beans.ComboBoxBean;
import gaiasky.gui.components.GuiComponent;
import gaiasky.gui.main.KeyBindings;
import gaiasky.render.ComponentTypes;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.util.HashMap;
import java.util.Map;

public class VisibilityComponent
extends GuiComponent
implements IObserver {
    protected Map<String, Button> visibilityButtonMap;
    private ComponentTypes.ComponentType[] visibilityEntities;
    private boolean[] visible;
    private CheckBox pmArrowheads;
    private OwnSliderPlus pmNumFactorSlider;
    private OwnSliderPlus pmLenFactorSlider;
    private SelectBox<ComboBoxBean> pmColorMode;
    private Button pmToggleButton;
    private Label pmLabel;
    private VerticalGroup pmColorModeGroup;
    private VerticalGroup pmGroup;
    private boolean sendEvents = true;

    public VisibilityComponent(Skin skin, Stage stage) {
        super(skin, stage);
        EventManager.instance.subscribe((IObserver)this, Event.TOGGLE_VISIBILITY_CMD, Event.PM_LEN_FACTOR_CMD, Event.PM_NUM_FACTOR_CMD, Event.PM_COLOR_MODE_CMD, Event.PM_ARROWHEADS_CMD);
    }

    public void setVisibilityEntitites(ComponentTypes.ComponentType[] ve, boolean[] v) {
        this.visibilityEntities = ve;
        this.visible = v;
    }

    @Override
    public void initialize(float componentWidth) {
        float space4 = 6.4f;
        float space2 = 3.2f;
        float buttonPadHor = 6.0f;
        float buttonPadVert = 6.0f;
        int visTableCols = 4;
        int row = 1;
        Table visibilityTable = new Table(this.skin);
        visibilityTable.setName("visibility table");
        visibilityTable.top().center();
        this.visibilityButtonMap = new HashMap<String, Button>();
        if (this.visibilityEntities != null) {
            for (int i = 0; i < this.visibilityEntities.length; ++i) {
                ComponentTypes.ComponentType ct = this.visibilityEntities[i];
                String name = ct.getName();
                if (name == null || ct.style == null) continue;
                Image icon = new Image(this.skin.getDrawable(ct.style));
                OwnTextIconButton button = new OwnTextIconButton("", 1, icon, this.skin, "toggle");
                button.setName(ct.key);
                this.addButtonTooltip((Button)button, ct);
                button.setDisabled(ct.key.equals("element.others") && GaiaSky.instance.isVR());
                this.visibilityButtonMap.put(name, (Button)button);
                if (!ct.key.equals(name)) {
                    this.visibilityButtonMap.put(ct.key, (Button)button);
                }
                button.setChecked(this.visible[i]);
                button.addListener(arg_0 -> VisibilityComponent.lambda$initialize$0((Button)button, ct, arg_0));
                Cell c = visibilityTable.add((Actor)button).padBottom(buttonPadVert + (row % 3 == 0 ? this.pad12 : 0.0f));
                if ((i + 1) % visTableCols == 0) {
                    visibilityTable.row();
                    ++row;
                    continue;
                }
                c.padRight(buttonPadHor);
            }
        }
        this.pmLabel = new OwnLabel((CharSequence)I18n.msg("gui.velocityvectors"), this.skin, "header");
        this.pmArrowheads = new OwnCheckBox(I18n.msg("gui.pm.arrowheads"), this.skin, space2);
        this.pmArrowheads.setName("pm arrow caps");
        this.pmArrowheads.setChecked(Settings.settings.scene.properMotion.arrowHeads);
        this.pmArrowheads.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.sendEvents) {
                    EventManager.publish(Event.PM_ARROWHEADS_CMD, this.pmArrowheads, this.pmArrowheads.isChecked());
                }
                return true;
            }
            return false;
        });
        this.pmNumFactorSlider = new OwnSliderPlus(I18n.msg("gui.pmnumfactor"), 1.0f, 100.0f, 0.1f, 1.0f, 10.0f, this.skin);
        this.pmNumFactorSlider.setName("proper motion vectors number factor");
        this.pmNumFactorSlider.setWidth(componentWidth);
        this.pmNumFactorSlider.setMappedValue(Settings.settings.scene.properMotion.number);
        this.pmNumFactorSlider.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.sendEvents) {
                    EventManager.publish(Event.PM_NUM_FACTOR_CMD, (Object)this.pmNumFactorSlider, Float.valueOf(this.pmNumFactorSlider.getMappedValue()));
                }
                return true;
            }
            return false;
        });
        this.pmLenFactorSlider = new OwnSliderPlus(I18n.msg("gui.pmlenfactor"), 500.0f, 50000.0f, 0.1f, this.skin);
        this.pmLenFactorSlider.setName("proper motion vectors number factor");
        this.pmLenFactorSlider.setWidth(componentWidth);
        this.pmLenFactorSlider.setValue(Settings.settings.scene.properMotion.length);
        this.pmLenFactorSlider.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.sendEvents) {
                    EventManager.publish(Event.PM_LEN_FACTOR_CMD, (Object)this.pmLenFactorSlider, Float.valueOf(this.pmLenFactorSlider.getValue()));
                }
                return true;
            }
            return false;
        });
        Label pmColorModeLabel = new Label((CharSequence)I18n.msg("gui.pm.colormode"), this.skin, "default");
        Object[] cms = new ComboBoxBean[]{new ComboBoxBean(I18n.msg("gui.pm.colormode.dir"), 0), new ComboBoxBean(I18n.msg("gui.pm.colormode.speed"), 1), new ComboBoxBean(I18n.msg("gui.pm.colormode.hasrv"), 2), new ComboBoxBean(I18n.msg("gui.pm.colormode.redshift"), 3), new ComboBoxBean(I18n.msg("gui.pm.colormode.redshift.cam"), 4), new ComboBoxBean(I18n.msg("gui.pm.colormode.single"), 5)};
        this.pmColorMode = new OwnSelectBox<ComboBoxBean>(this.skin);
        this.pmColorMode.setItems(cms);
        this.pmColorMode.setWidth(componentWidth);
        this.pmColorMode.setSelectedIndex(Settings.settings.scene.properMotion.colorMode);
        this.pmColorMode.setName("proper motion color mode");
        this.pmColorMode.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.sendEvents) {
                    EventManager.publish(Event.PM_COLOR_MODE_CMD, this.pmColorMode, this.pmColorMode.getSelectedIndex());
                }
                return true;
            }
            return false;
        });
        this.pmColorModeGroup = new VerticalGroup();
        this.pmColorModeGroup.space(space2);
        this.pmColorModeGroup.align(8).columnAlign(8);
        this.pmColorModeGroup.addActor((Actor)pmColorModeLabel);
        this.pmColorModeGroup.addActor(this.pmColorMode);
        this.pmGroup = new VerticalGroup().align(8).columnAlign(8);
        this.pmGroup.space(space4);
        this.pmToggleButton = this.visibilityButtonMap.get(ComponentTypes.ComponentType.VelocityVectors.key);
        this.pmToggleButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.pmGroup != null) {
                    this.velocityVectorsEnabled(this.pmToggleButton.isChecked());
                }
                return true;
            }
            return false;
        });
        this.velocityVectorsEnabled(GaiaSky.instance.sceneRenderer.isOn(ComponentTypes.ComponentType.VelocityVectors));
        OwnTextIconButton individualVisibility = new OwnTextIconButton(I18n.msg("gui.visibility.individual"), this.skin, "eye");
        individualVisibility.align(1);
        individualVisibility.setWidth(componentWidth);
        individualVisibility.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_PER_OBJECT_VISIBILITY_ACTION, (Object)individualVisibility, new Object[0]);
                return true;
            }
            return false;
        });
        Table content = new Table(this.skin);
        content.add((Actor)visibilityTable).center().row();
        content.add((Actor)individualVisibility).center().padTop(this.pad8).row();
        content.add((Actor)this.pmGroup).left().padTop(this.pad8);
        this.component = content;
    }

    private void velocityVectorsEnabled(boolean state) {
        if (state) {
            this.pmGroup.addActor((Actor)this.pmLabel);
            this.pmGroup.addActor((Actor)this.pmNumFactorSlider);
            this.pmGroup.addActor((Actor)this.pmLenFactorSlider);
            this.pmGroup.addActor((Actor)this.pmColorModeGroup);
            this.pmGroup.addActor((Actor)this.pmArrowheads);
        } else {
            this.pmGroup.removeActor((Actor)this.pmLabel);
            this.pmGroup.removeActor((Actor)this.pmNumFactorSlider);
            this.pmGroup.removeActor((Actor)this.pmLenFactorSlider);
            this.pmGroup.removeActor((Actor)this.pmColorModeGroup);
            this.pmGroup.removeActor((Actor)this.pmArrowheads);
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case TOGGLE_VISIBILITY_CMD: {
                String key = (String)data[0];
                Button b = this.visibilityButtonMap.get(key);
                if (b == null || source == b) break;
                b.setProgrammaticChangeEvents(false);
                if (data.length == 2) {
                    b.setChecked(((Boolean)data[1]).booleanValue());
                } else {
                    b.setChecked(!b.isChecked());
                }
                b.setProgrammaticChangeEvents(true);
                break;
            }
            case PM_LEN_FACTOR_CMD: {
                if (source == this.pmLenFactorSlider) break;
                this.sendEvents = false;
                float value = ((Float)data[0]).floatValue();
                this.pmLenFactorSlider.setValue(value);
                this.sendEvents = true;
                break;
            }
            case PM_NUM_FACTOR_CMD: {
                if (source == this.pmNumFactorSlider) break;
                this.sendEvents = false;
                float value = ((Float)data[0]).floatValue();
                this.pmNumFactorSlider.setMappedValue(value);
                this.sendEvents = true;
                break;
            }
            case PM_COLOR_MODE_CMD: {
                if (source == this.pmColorMode) break;
                this.sendEvents = false;
                this.pmColorMode.setSelectedIndex(((Integer)data[0]).intValue());
                this.sendEvents = true;
                break;
            }
            case PM_ARROWHEADS_CMD: {
                if (source == this.pmArrowheads) break;
                this.sendEvents = false;
                this.pmArrowheads.setChecked(((Boolean)data[0]).booleanValue());
                this.sendEvents = true;
                break;
            }
        }
    }

    private void addButtonTooltip(Button button, ComponentTypes.ComponentType ct) {
        String[] hk = KeyBindings.instance.getStringKeys("action.toggle/" + ct.key, true);
        Object text = TextUtils.capitalise(ct.getName());
        if (ct.equals((Object)ComponentTypes.ComponentType.Constellations)) {
            text = (String)text + " - " + I18n.msg("gui.tooltip.ct.constellations.hip");
        }
        if (hk != null && hk.length > 0) {
            button.addListener((EventListener)new OwnTextHotkeyTooltip((String)text, hk, this.skin, 9));
        } else {
            button.addListener((EventListener)new OwnTextTooltip((String)text, this.skin));
        }
    }

    @Override
    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    private static /* synthetic */ boolean lambda$initialize$0(Button button, ComponentTypes.ComponentType ct, com.badlogic.gdx.scenes.scene2d.Event event) {
        if (event instanceof ChangeListener.ChangeEvent) {
            EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, button, ct.key, button.isChecked());
            return true;
        }
        return false;
    }
}

