/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.components;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.components.GuiComponent;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SettingsManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class VisualSettingsComponent
extends GuiComponent
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(VisualSettingsComponent.class);
    private OwnSliderPlus starBrightness;
    private OwnSliderPlus magnitudeMultiplier;
    private OwnSliderPlus starGlowFactor;
    private OwnSliderPlus pointSize;
    private OwnSliderPlus starBaseLevel;
    private OwnSliderPlus ambientLight;
    private OwnSliderPlus labelSize;
    private OwnSliderPlus lineWidth;
    private OwnSliderPlus elevMult;

    public VisualSettingsComponent(Skin skin, Stage stage) {
        super(skin, stage);
    }

    @Override
    public void initialize(float componentWidth) {
        this.starBrightness = new OwnSliderPlus(I18n.msg("gui.star.brightness"), 0.0f, 100.0f, 0.01f, 0.4f, 8.0f, this.skin);
        this.starBrightness.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.brightness.info"), this.skin));
        this.starBrightness.setWidth(componentWidth);
        this.starBrightness.setMappedValue(Settings.settings.scene.star.brightness);
        this.starBrightness.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.STAR_BRIGHTNESS_CMD, (Object)this.starBrightness, Float.valueOf(this.starBrightness.getMappedValue()));
                return true;
            }
            return false;
        });
        this.magnitudeMultiplier = new OwnSliderPlus(I18n.msg("gui.star.brightness.pow"), 0.9f, 1.1f, 0.01f, this.skin);
        this.magnitudeMultiplier.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.brightness.pow.info"), this.skin));
        this.magnitudeMultiplier.setWidth(componentWidth);
        this.magnitudeMultiplier.setValue(Settings.settings.scene.star.power);
        this.magnitudeMultiplier.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.STAR_BRIGHTNESS_POW_CMD, (Object)this.magnitudeMultiplier, Float.valueOf(this.magnitudeMultiplier.getValue()));
                return true;
            }
            return false;
        });
        this.starGlowFactor = new OwnSliderPlus(I18n.msg("gui.star.glowfactor"), 0.01f, 0.5f, 0.001f, this.skin);
        this.starGlowFactor.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.glowfactor.info"), this.skin));
        this.starGlowFactor.setWidth(componentWidth);
        this.starGlowFactor.setMappedValue(Settings.settings.scene.star.glowFactor);
        this.starGlowFactor.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.STAR_GLOW_FACTOR_CMD, (Object)this.starGlowFactor, Float.valueOf(this.starGlowFactor.getValue()));
                return true;
            }
            return false;
        });
        this.pointSize = new OwnSliderPlus(I18n.msg("gui.star.size"), 0.1f, 20.0f, 0.01f, this.skin);
        this.pointSize.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.size.info"), this.skin));
        this.pointSize.setWidth(componentWidth);
        this.pointSize.setMappedValue(Settings.settings.scene.star.pointSize);
        this.pointSize.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.STAR_POINT_SIZE_CMD, (Object)this.pointSize, Float.valueOf(this.pointSize.getMappedValue()));
                return true;
            }
            return false;
        });
        this.starBaseLevel = new OwnSliderPlus(I18n.msg("gui.star.opacity"), 0.0f, 0.95f, 0.01f, this.skin);
        this.starBaseLevel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.opacity"), this.skin));
        this.starBaseLevel.setWidth(componentWidth);
        this.starBaseLevel.setMappedValue(Settings.settings.scene.star.opacity[0]);
        this.starBaseLevel.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.STAR_BASE_LEVEL_CMD, (Object)this.starBaseLevel, Float.valueOf(this.starBaseLevel.getMappedValue()));
                return true;
            }
            return false;
        });
        this.ambientLight = new OwnSliderPlus(I18n.msg("gui.light.ambient"), 0.0f, 1.0f, 0.01f, this.skin);
        this.ambientLight.setWidth(componentWidth);
        this.ambientLight.setMappedValue(Settings.settings.scene.renderer.ambient);
        this.ambientLight.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.AMBIENT_LIGHT_CMD, (Object)this.ambientLight, Float.valueOf(this.ambientLight.getMappedValue()));
                return true;
            }
            return false;
        });
        this.labelSize = new OwnSliderPlus(I18n.msg("gui.label.size"), 0.7f, 2.5f, 0.01f, this.skin);
        this.labelSize.setWidth(componentWidth);
        this.labelSize.setMappedValue(Settings.settings.scene.label.size);
        this.labelSize.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                float val = this.labelSize.getMappedValue();
                EventManager.publish(Event.LABEL_SIZE_CMD, (Object)this.labelSize, Float.valueOf(val));
                return true;
            }
            return false;
        });
        this.lineWidth = new OwnSliderPlus(I18n.msg("gui.line.width"), 0.2f, 3.5f, 0.01f, 0.2f, 3.5f, this.skin);
        this.lineWidth.setWidth(componentWidth);
        this.lineWidth.setMappedValue(Settings.settings.scene.renderer.line.width);
        this.lineWidth.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                float val = this.lineWidth.getMappedValue();
                EventManager.publish(Event.LINE_WIDTH_CMD, (Object)this.lineWidth, Float.valueOf(val));
                return true;
            }
            return false;
        });
        this.elevMult = new OwnSliderPlus(I18n.msg("gui.elevation.multiplier"), 0.0f, 15.0f, 0.01f, false, this.skin);
        this.elevMult.setWidth(componentWidth);
        this.elevMult.setValue((float)MathUtilsDouble.roundAvoid(Settings.settings.scene.renderer.elevation.multiplier, 1));
        this.elevMult.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                float val = this.elevMult.getValue();
                EventManager.publish(Event.ELEVATION_MULTIPLIER_CMD, (Object)this.elevMult, Float.valueOf(val));
                return true;
            }
            return false;
        });
        OwnTextIconButton resetDefaults = new OwnTextIconButton(I18n.msg("gui.resetdefaults"), this.skin, "reset");
        resetDefaults.align(1);
        resetDefaults.setWidth(componentWidth);
        resetDefaults.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.resetdefaults.tooltip"), this.skin));
        resetDefaults.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.RESET_VISUAL_SETTINGS_DEFAULTS, (Object)resetDefaults, new Object[0]);
                return true;
            }
            return false;
        });
        VerticalGroup lightingGroup = new VerticalGroup().align(8).columnAlign(8);
        lightingGroup.space(this.pad9);
        lightingGroup.addActor((Actor)this.starBrightness);
        lightingGroup.addActor((Actor)this.magnitudeMultiplier);
        lightingGroup.addActor((Actor)this.starGlowFactor);
        lightingGroup.addActor((Actor)this.pointSize);
        lightingGroup.addActor((Actor)this.starBaseLevel);
        lightingGroup.addActor((Actor)this.ambientLight);
        lightingGroup.addActor((Actor)this.lineWidth);
        lightingGroup.addActor((Actor)this.labelSize);
        lightingGroup.addActor((Actor)this.elevMult);
        lightingGroup.addActor((Actor)resetDefaults);
        this.component = lightingGroup;
        EventManager.instance.subscribe((IObserver)this, Event.STAR_POINT_SIZE_CMD, Event.STAR_BRIGHTNESS_CMD, Event.STAR_BRIGHTNESS_POW_CMD, Event.STAR_GLOW_FACTOR_CMD, Event.STAR_BASE_LEVEL_CMD, Event.LABEL_SIZE_CMD, Event.LINE_WIDTH_CMD, Event.ELEVATION_MULTIPLIER_CMD, Event.RESET_VISUAL_SETTINGS_DEFAULTS);
    }

    private void resetVisualSettingsDefaults(Object source) {
        try {
            Path confFolder = Settings.assetsPath("conf");
            Path internalFolderConfFile = confFolder.resolve(SettingsManager.getConfigFileName(Settings.settings.runtime.openXr));
            Yaml yaml = new Yaml();
            Map conf = (Map)yaml.load(Files.newInputStream(internalFolderConfFile, new OpenOption[0]));
            float br = ((Double)((Map)((Map)conf.get("scene")).get("star")).get("brightness")).floatValue();
            float pow = ((Double)((Map)((Map)conf.get("scene")).get("star")).get("power")).floatValue();
            float glo = ((Double)((Map)((Map)conf.get("scene")).get("star")).get("glowFactor")).floatValue();
            float ss = ((Double)((Map)((Map)conf.get("scene")).get("star")).get("pointSize")).floatValue();
            float pam = ((Double)((List)((Map)((Map)conf.get("scene")).get("star")).get("opacity")).get(0)).floatValue();
            float amb = ((Double)((Map)((Map)conf.get("scene")).get("renderer")).get("ambient")).floatValue();
            float ls = ((Double)((Map)((Map)conf.get("scene")).get("label")).get("size")).floatValue();
            float lw = ((Double)((Map)((Map)((Map)conf.get("scene")).get("renderer")).get("line")).get("width")).floatValue();
            float em = ((Double)((Map)((Map)((Map)conf.get("scene")).get("renderer")).get("elevation")).get("multiplier")).floatValue();
            EventManager m = EventManager.instance;
            m.post(Event.STAR_BRIGHTNESS_CMD, source, Float.valueOf(br));
            m.post(Event.STAR_BRIGHTNESS_POW_CMD, source, Float.valueOf(pow));
            m.post(Event.STAR_GLOW_FACTOR_CMD, source, Float.valueOf(glo));
            m.post(Event.STAR_POINT_SIZE_CMD, source, Float.valueOf(ss));
            m.post(Event.STAR_BASE_LEVEL_CMD, source, Float.valueOf(pam));
            m.post(Event.AMBIENT_LIGHT_CMD, source, Float.valueOf(amb));
            m.post(Event.LABEL_SIZE_CMD, source, Float.valueOf(ls));
            m.post(Event.LINE_WIDTH_CMD, source, Float.valueOf(lw));
            m.post(Event.ELEVATION_MULTIPLIER_CMD, source, Float.valueOf(em));
        }
        catch (IOException e) {
            logger.error(e, "Error loading default configuration file");
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case RESET_VISUAL_SETTINGS_DEFAULTS: {
                this.resetVisualSettingsDefaults(source);
                break;
            }
            case STAR_POINT_SIZE_CMD: {
                if (source == this.pointSize) break;
                float newSize = ((Float)data[0]).floatValue();
                this.pointSize.setProgrammaticChangeEvents(false);
                this.pointSize.setMappedValue(newSize);
                this.pointSize.setProgrammaticChangeEvents(true);
                break;
            }
            case STAR_BRIGHTNESS_CMD: {
                if (source == this.starBrightness) break;
                Float brightness = (Float)data[0];
                this.starBrightness.setProgrammaticChangeEvents(false);
                this.starBrightness.setMappedValue(brightness.floatValue());
                this.starBrightness.setProgrammaticChangeEvents(true);
                break;
            }
            case STAR_BRIGHTNESS_POW_CMD: {
                if (source == this.magnitudeMultiplier) break;
                Float pow = (Float)data[0];
                this.magnitudeMultiplier.setProgrammaticChangeEvents(false);
                this.magnitudeMultiplier.setMappedValue(pow.floatValue());
                this.magnitudeMultiplier.setProgrammaticChangeEvents(true);
                break;
            }
            case STAR_GLOW_FACTOR_CMD: {
                if (source == this.starGlowFactor) break;
                Float glowFactor = (Float)data[0];
                this.starGlowFactor.setProgrammaticChangeEvents(false);
                this.starGlowFactor.setMappedValue(glowFactor.floatValue());
                this.starGlowFactor.setProgrammaticChangeEvents(true);
                break;
            }
            case STAR_BASE_LEVEL_CMD: {
                if (source == this.starBaseLevel) break;
                Float baseLevel = (Float)data[0];
                this.starBaseLevel.setProgrammaticChangeEvents(false);
                this.starBaseLevel.setMappedValue(baseLevel.floatValue());
                this.starBaseLevel.setProgrammaticChangeEvents(true);
                break;
            }
            case LABEL_SIZE_CMD: {
                if (source == this.labelSize) break;
                Float newLabelSize = (Float)data[0];
                this.labelSize.setProgrammaticChangeEvents(false);
                this.labelSize.setMappedValue(newLabelSize.floatValue());
                this.labelSize.setProgrammaticChangeEvents(true);
                break;
            }
            case LINE_WIDTH_CMD: {
                if (source == this.lineWidth) break;
                Float newWidth = (Float)data[0];
                this.lineWidth.setProgrammaticChangeEvents(false);
                this.lineWidth.setMappedValue(newWidth.floatValue());
                this.lineWidth.setProgrammaticChangeEvents(true);
                break;
            }
            case ELEVATION_MULTIPLIER_CMD: {
                if (source == this.elevMult) break;
                Float newElevationMultiplier = (Float)data[0];
                this.elevMult.setProgrammaticChangeEvents(false);
                this.elevMult.setMappedValue(newElevationMultiplier.floatValue());
                this.elevMult.setProgrammaticChangeEvents(true);
                break;
            }
        }
    }

    @Override
    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }
}

