/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.datasets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.GaiaSky;
import gaiasky.gui.beans.AttributeComboBoxBean;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IParticleRecord;
import gaiasky.scene.component.ParticleSet;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Logger;
import gaiasky.util.TextUtils;
import gaiasky.util.filter.Filter;
import gaiasky.util.filter.FilterRule;
import gaiasky.util.filter.attrib.AttributeAbsmag;
import gaiasky.util.filter.attrib.AttributeAppmag;
import gaiasky.util.filter.attrib.AttributeColorBlue;
import gaiasky.util.filter.attrib.AttributeColorGreen;
import gaiasky.util.filter.attrib.AttributeColorRed;
import gaiasky.util.filter.attrib.AttributeDEC;
import gaiasky.util.filter.attrib.AttributeDistance;
import gaiasky.util.filter.attrib.AttributeEclLatitude;
import gaiasky.util.filter.attrib.AttributeEclLongitude;
import gaiasky.util.filter.attrib.AttributeGalLatitude;
import gaiasky.util.filter.attrib.AttributeGalLongitude;
import gaiasky.util.filter.attrib.AttributeMualpha;
import gaiasky.util.filter.attrib.AttributeMudelta;
import gaiasky.util.filter.attrib.AttributeRA;
import gaiasky.util.filter.attrib.AttributeRadvel;
import gaiasky.util.filter.attrib.AttributeUCD;
import gaiasky.util.filter.attrib.IAttribute;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.ucd.UCD;
import gaiasky.util.validator.FloatValidator;
import java.util.Locale;

public class DatasetFiltersWindow
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(DatasetFiltersWindow.class);
    private final CatalogInfo ci;
    private Table filterTable;
    private Filter filter;
    private OwnTextIconButton addFilterOrRule;
    private boolean filterEdited;

    public DatasetFiltersWindow(CatalogInfo ci, Skin skin, Stage stage) {
        super(I18n.msg("gui.dataset.filters") + " - " + ci.name, skin, stage);
        this.ci = ci;
        this.filterEdited = false;
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.setModal(false);
        this.content.add().width(700.0f).row();
        this.content.getMinHeight();
        this.buildSuper();
    }

    private boolean hasRules() {
        return this.filter != null && this.filter.hasRules();
    }

    private void updateButtonTextAndTooltip(OwnTextIconButton button) {
        boolean hasRules = this.hasRules();
        button.removeTooltipListeners();
        button.setText(I18n.msg(hasRules ? "gui.dataset.filter.rule.add" : "gui.dataset.filter.add"));
        button.addListener((EventListener)new OwnTextTooltip(I18n.msg(hasRules ? "gui.tooltip.dataset.filter.rule.add" : "gui.tooltip.dataset.filter.add"), this.skin));
    }

    @Override
    protected void build() {
        if (this.ci.hasParticleAttributes()) {
            this.filter = this.ci.filter != null ? this.ci.filter.deepCopy() : null;
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.filter"), this.skin, "hud-header")).left().colspan(2).padBottom(pad18).padTop(pad20).row();
            this.addFilterOrRule = new OwnTextIconButton("", this.skin, "add");
            this.addFilterOrRule.setSpace(pad18);
            this.addFilterOrRule.pad(pad18);
            this.updateButtonTextAndTooltip(this.addFilterOrRule);
            this.addFilterOrRule.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.hasRules()) {
                        ((DatasetFiltersWindow)this.me).addRule(this.filter);
                        this.updateButtonTextAndTooltip(this.addFilterOrRule);
                        this.filterEdited = true;
                        return true;
                    }
                    ((DatasetFiltersWindow)this.me).addFilter();
                    this.updateButtonTextAndTooltip(this.addFilterOrRule);
                    this.filterEdited = true;
                    return true;
                }
                return false;
            });
            this.content.add((Actor)this.addFilterOrRule).left().padBottom(pad34).row();
            this.filterTable = new Table(this.skin);
            this.filterTable.top().left();
            OwnScrollPane scrollPane = new OwnScrollPane((Actor)this.filterTable, this.skin, "minimalist-nobg");
            scrollPane.setScrollbarsVisible(true);
            scrollPane.setFadeScrollBars(false);
            scrollPane.setScrollingDisabled(true, false);
            scrollPane.setWidth(1180.0f);
            scrollPane.setHeight(500.0f);
            this.content.add((Actor)scrollPane).left().colspan(2).row();
            this.generateFilterTable(this.filter);
        }
    }

    private void generateFilterTable(Filter filter) {
        float minSelectWidth = 160.0f;
        this.filterTable.clearChildren();
        if (filter != null && filter.hasRules()) {
            OwnSelectBox operation = new OwnSelectBox(this.skin);
            operation.setWidth(minSelectWidth);
            operation.setItems(new String[]{"and", "or", "xor"});
            operation.setSelected(filter.getOperationString().toLowerCase(Locale.ROOT));
            operation.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    String newOp = (String)operation.getSelected();
                    filter.setOperation(newOp);
                    this.filterEdited = true;
                    return true;
                }
                return false;
            });
            this.filterTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.filter.operation"), this.skin)).left().padRight(pad18 * 2.0f).padBottom(pad18);
            this.filterTable.add(operation).left().expandX().padBottom(pad18).row();
            Array<FilterRule> rules = filter.getRules();
            Table rulesTable = new Table(this.skin);
            this.filterTable.add((Actor)rulesTable).colspan(2);
            for (FilterRule rule : rules) {
                String unitStr = rule.getAttribute().getUnit();
                String unitStrCapped = unitStr != null ? TextUtils.capString(unitStr, 12) : "";
                OwnLabel unit = new OwnLabel((CharSequence)unitStrCapped, this.skin);
                unit.setWidth(130.0f);
                if (unitStr != null && unitStr.length() > unitStrCapped.length()) {
                    unit.addListener((EventListener)new OwnTextTooltip(unitStr, this.skin));
                }
                boolean stars = Mapper.starSet.has(this.ci.entity) || Mapper.octree.has(this.ci.entity);
                Array attrs = new Array(false, stars ? 12 : 7);
                attrs.add((Object)new AttributeComboBoxBean(new AttributeDistance()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeRA()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeDEC()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeEclLatitude()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeEclLongitude()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeGalLatitude()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeGalLongitude()));
                if (stars) {
                    attrs.add((Object)new AttributeComboBoxBean(new AttributeAppmag()));
                    attrs.add((Object)new AttributeComboBoxBean(new AttributeAbsmag()));
                    attrs.add((Object)new AttributeComboBoxBean(new AttributeMualpha()));
                    attrs.add((Object)new AttributeComboBoxBean(new AttributeMudelta()));
                    attrs.add((Object)new AttributeComboBoxBean(new AttributeRadvel()));
                }
                attrs.add((Object)new AttributeComboBoxBean(new AttributeColorRed()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeColorGreen()));
                attrs.add((Object)new AttributeComboBoxBean(new AttributeColorBlue()));
                if (Mapper.particleSet.has(this.ci.entity) || Mapper.starSet.has(this.ci.entity)) {
                    IParticleRecord first;
                    ParticleSet set;
                    ParticleSet particleSet = set = Mapper.particleSet.has(this.ci.entity) ? (ParticleSet)Mapper.particleSet.get(this.ci.entity) : (ParticleSet)Mapper.starSet.get(this.ci.entity);
                    if (!set.data().isEmpty() && (first = set.data().getFirst()).hasExtra()) {
                        ObjectMap.Keys<UCD> ucds = first.extraKeys();
                        for (UCD ucd : ucds) {
                            attrs.add((Object)new AttributeComboBoxBean(new AttributeUCD(ucd)));
                        }
                    }
                }
                FloatValidator numberValidator = new FloatValidator(-3.4028235E38f, Float.MAX_VALUE);
                FloatValidator colorValidator = new FloatValidator(0.0f, 1.0f);
                boolean useColorVal = rule.getAttribute() instanceof AttributeColorRed || rule.getAttribute() instanceof AttributeColorBlue || rule.getAttribute() instanceof AttributeColorGreen;
                boolean isNumberAttribute = rule.getAttribute().isNumberAttribute();
                OwnTextField value = new OwnTextField(rule.getValue().toString(), this.skin, useColorVal ? colorValidator : (isNumberAttribute ? numberValidator : null));
                OwnSelectBox attribute = new OwnSelectBox(this.skin);
                attribute.setItems(attrs);
                attribute.setSelected(this.getAttributeBean(rule.getAttribute(), (Array<AttributeComboBoxBean>)attrs));
                attribute.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        IAttribute newAttr = ((AttributeComboBoxBean)attribute.getSelected()).attr;
                        rule.setAttribute(newAttr);
                        boolean isNum = rule.getAttribute().isNumberAttribute();
                        if (newAttr instanceof AttributeColorRed || newAttr instanceof AttributeColorBlue || newAttr instanceof AttributeColorGreen) {
                            value.setValidator(colorValidator);
                        } else if (isNum) {
                            value.setValidator(numberValidator);
                        } else {
                            value.setValidator(null);
                        }
                        unit.setText(newAttr.getUnit());
                        this.filterEdited = true;
                        return true;
                    }
                    return false;
                });
                rulesTable.add(attribute).left().padRight(pad18).padBottom(pad10);
                Object[] comparators = new String[]{"<", "<=", ">", ">=", "==", "!="};
                OwnSelectBox comparator = new OwnSelectBox(this.skin);
                comparator.setWidth(minSelectWidth);
                comparator.setItems(comparators);
                comparator.setSelected(rule.getComparator().toString());
                comparator.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        FilterRule.IComparator newComp = rule.getComparatorFromString((String)comparator.getSelected());
                        rule.setComparator(newComp);
                        this.filterEdited = true;
                        return true;
                    }
                    return false;
                });
                rulesTable.add(comparator).left().padRight(pad18).padBottom(pad10);
                value.setWidth(280.0f);
                value.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        if (value.isValid()) {
                            try {
                                rule.setValue(Float.valueOf(Float.parseFloat(value.getText())));
                                this.filterEdited = true;
                                return true;
                            }
                            catch (Exception e) {
                                rule.setValue(value.getText());
                                this.filterEdited = true;
                                return true;
                            }
                        }
                        return false;
                    }
                    return false;
                });
                rulesTable.add((Actor)value).left().padRight(pad18).padBottom(pad10);
                rulesTable.add((Actor)unit).left().padRight(pad18 * 3.0f).padBottom(pad10);
                OwnTextIconButton rubbish = new OwnTextIconButton("", this.skin, "rubbish");
                rubbish.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.filter.rule.remove"), this.skin));
                rubbish.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        this.deleteRule(filter, rule);
                        this.filterEdited = true;
                        return true;
                    }
                    return false;
                });
                rulesTable.add((Actor)rubbish).left().padBottom(pad10).row();
            }
        } else {
            this.filterTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.filter.nofilters"), this.skin)).left().padBottom(pad18).row();
        }
        this.pack();
    }

    private void deleteRule(Filter filter, FilterRule rule) {
        boolean removed;
        if (filter != null && rule != null && (removed = filter.removeRule(rule))) {
            GaiaSky.postRunnable(() -> {
                this.generateFilterTable(filter);
                this.updateButtonTextAndTooltip(this.addFilterOrRule);
            });
        }
    }

    private void addRule(Filter filter) {
        if (filter != null) {
            FilterRule rule = new FilterRule("<", new AttributeDistance(), 500);
            filter.addRule(rule);
            GaiaSky.postRunnable(() -> this.generateFilterTable(filter));
        }
    }

    private void addFilter() {
        FilterRule rule = new FilterRule("<", new AttributeDistance(), 500);
        this.filter = new Filter(rule);
        GaiaSky.postRunnable(() -> this.generateFilterTable(this.filter));
    }

    private AttributeComboBoxBean getAttributeBean(IAttribute attr, Array<AttributeComboBoxBean> attrs) {
        for (AttributeComboBoxBean attribute : attrs) {
            if (!attr.toString().contains(attribute.name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    protected boolean accept() {
        if (this.filterEdited) {
            if (this.ci.filter != null) {
                this.ci.filter = this.filter.hasRules() ? this.filter : null;
                this.ci.highlight(this.ci.highlighted);
            } else {
                this.ci.filter = this.filter.hasRules() ? this.filter : null;
                this.ci.highlight(this.ci.highlighted);
            }
        }
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

