/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.datasets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.gui.window.GenericDialog;
import gaiasky.util.CatalogInfo;
import gaiasky.util.GlobalResources;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextArea;

public class DatasetInfoWindow
extends GenericDialog {
    private final CatalogInfo ci;

    public DatasetInfoWindow(CatalogInfo ci, Skin skin, Stage stage) {
        super(I18n.msg("gui.dataset.info") + " - " + ci.name, skin, stage);
        this.ci = ci;
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setModal(false);
        this.buildSuper();
    }

    @Override
    protected void build() {
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.name"), this.skin, "hud-subheader")).top().right().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)new OwnLabel((CharSequence)this.ci.name, this.skin)).top().left().padRight(pad18).padBottom(pad18).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.source"), this.skin, "hud-subheader")).top().right().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)new OwnLabel((CharSequence)(this.ci.source != null ? this.ci.source : "-"), this.skin)).top().left().padRight(pad18).padBottom(pad18).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.type"), this.skin, "hud-subheader")).top().right().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)new OwnLabel((CharSequence)this.ci.type.toString(), this.skin)).top().left().padRight(pad18).padBottom(pad18).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.numobjects"), this.skin, "hud-subheader")).top().right().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)new OwnLabel((CharSequence)(this.ci.nParticles > 0L ? Long.toString(this.ci.nParticles) : "?"), this.skin)).top().left().padRight(pad18).padBottom(pad18).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.sizebytes"), this.skin, "hud-subheader")).top().right().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)new OwnLabel((CharSequence)(this.ci.sizeBytes > 0L ? GlobalResources.humanReadableByteCount(this.ci.sizeBytes, true) : "?"), this.skin)).top().left().padRight(pad18).padBottom(pad18).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.loaded"), this.skin, "hud-subheader")).top().right().padRight(pad18).padBottom(pad18);
        this.content.add((Actor)new OwnLabel((CharSequence)this.ci.loadDateUTC.atZone(Settings.settings.program.timeZone.getTimeZone()).toString(), this.skin)).top().left().padRight(pad18).padBottom(pad18).row();
        OwnScrollPane scroll = this.getOwnScrollPane();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.description"), this.skin, "hud-subheader")).top().right().padRight(pad18).padBottom(pad18 * 2.0f);
        this.content.add((Actor)scroll).top().left().padRight(pad18).padBottom(pad18 * 2.0f).row();
    }

    private OwnScrollPane getOwnScrollPane() {
        String descriptionString = this.ci.description != null ? this.ci.description : this.ci.name;
        OwnTextArea descriptionTextArea = new OwnTextArea(descriptionString, this.skin, "no-disabled");
        descriptionTextArea.setWidth(600.0f);
        descriptionTextArea.setDisabled(true);
        float fontHeight = descriptionTextArea.getStyle().font.getLineHeight();
        descriptionTextArea.offsets();
        descriptionTextArea.setHeight((float)(descriptionTextArea.getLines() + 3) * fontHeight);
        descriptionTextArea.clearListeners();
        OwnScrollPane scroll = new OwnScrollPane((Actor)descriptionTextArea, this.skin, "default-nobg");
        scroll.setWidth(640.0f);
        scroll.setHeight(300.0f);
        return scroll;
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

