/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.datasets;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.data.group.DatasetOptions;
import gaiasky.gui.beans.ComponentTypeBean;
import gaiasky.gui.window.ColorPicker;
import gaiasky.gui.window.GenericDialog;
import gaiasky.render.ComponentTypes;
import gaiasky.util.GlobalResources;
import gaiasky.util.GuiUtils;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextArea;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.FloatValidator;
import gaiasky.util.validator.TextFieldComparatorValidator;
import java.text.DecimalFormat;

public class DatasetLoadDialog
extends GenericDialog {
    private final String fileName;
    private final float sliderWidth;
    private final float fieldWidth;
    private final float titleWidth;
    private final float cpSize;
    private final float taWidth;
    public OwnCheckBox particles;
    public OwnCheckBox stars;
    public OwnCheckBox clusters;
    public OwnCheckBox variables;
    public OwnCheckBox fadeIn;
    public OwnCheckBox fadeOut;
    public OwnTextField dsName;
    public OwnTextField magnitudeScale;
    public OwnTextField fadeInMin;
    public OwnTextField fadeInMax;
    public OwnTextField fadeOutMin;
    public OwnTextField fadeOutMax;
    public OwnTextField profileDecay;
    public OwnSliderPlus particleSize;
    public OwnSliderPlus colorNoise;
    public OwnSliderPlus minSolidAngle;
    public OwnSliderPlus maxSolidAngle;
    public OwnSliderPlus numLabels;
    public ColorPicker particleColor;
    public ColorPicker labelColor;
    public OwnSelectBox<ComponentTypeBean> componentType;

    public DatasetLoadDialog(String title, String fileName, Skin skin, Stage ui) {
        super(title, skin, ui);
        this.fileName = fileName;
        this.sliderWidth = 664.0f;
        this.fieldWidth = 288.0f;
        this.titleWidth = 288.0f;
        this.cpSize = 32.0f;
        this.taWidth = 800.0f;
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.buildSuper();
    }

    @Override
    protected void build() {
        this.content.clear();
        OwnLabel info = new OwnLabel((CharSequence)I18n.msg("gui.dsload.info"), this.skin, "hud-subheader");
        this.content.add((Actor)info).left().padBottom(pad20).row();
        Table container = new Table(this.skin);
        Container cont = new Container((Actor)container);
        this.stars = new OwnCheckBox(I18n.msg("gui.dsload.stars"), this.skin, "radio", pad10);
        this.stars.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.stars.isChecked()) {
                    container.clear();
                    this.addStarsWidget(container);
                    this.pack();
                }
                return true;
            }
            return false;
        });
        this.stars.setChecked(true);
        this.content.add((Actor)this.stars).left().padBottom(pad18).row();
        this.particles = new OwnCheckBox(I18n.msg("gui.dsload.particles"), this.skin, "radio", pad10);
        this.particles.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.particles.isChecked()) {
                    container.clear();
                    this.addParticlesWidget(container);
                    this.pack();
                }
                return true;
            }
            return false;
        });
        this.particles.setChecked(false);
        this.content.add((Actor)this.particles).left().padBottom(pad18).row();
        this.clusters = new OwnCheckBox(I18n.msg("gui.dsload.clusters"), this.skin, "radio", pad10);
        this.clusters.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.clusters.isChecked()) {
                    container.clear();
                    this.addStarClustersWidget(container);
                    this.pack();
                }
                return true;
            }
            return false;
        });
        this.clusters.setChecked(false);
        this.content.add((Actor)this.clusters).left().padBottom(pad18).row();
        this.variables = new OwnCheckBox(I18n.msg("gui.dsload.variable"), this.skin, "radio", pad10);
        this.variables.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.variables.isChecked()) {
                    container.clear();
                    this.addVariableStarsWidget(container);
                    this.pack();
                }
                return true;
            }
            return false;
        });
        this.variables.setChecked(false);
        this.content.add((Actor)this.variables).left().padBottom(pad18 * 2.0f).row();
        new ButtonGroup((Button[])new OwnCheckBox[]{this.particles, this.stars, this.clusters, this.variables});
        this.content.add((Actor)cont).left();
    }

    private void addStarsWidget(Table container) {
        OwnLabel starProps = new OwnLabel((CharSequence)I18n.msg("gui.dsload.stars.properties"), this.skin, "hud-subheader");
        container.add((Actor)starProps).colspan(2).left().padTop(pad20).padBottom(pad18).row();
        this.addFileName(container);
        this.addLabelColor(container);
        FloatValidator sclValidator = new FloatValidator(-100.0f, 100.0f);
        this.magnitudeScale = new OwnTextField("0.0", this.skin, sclValidator);
        this.magnitudeScale.setWidth(this.fieldWidth);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dsload.magnitude.scale"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad18);
        container.add((Actor)GuiUtils.tooltipHg((Actor)this.magnitudeScale, "gui.dsload.magnitude.scale.tooltip", this.skin)).left().padBottom(pad18).row();
        this.addFadeAttributes(container);
        this.fadeOut.setChecked(true);
        this.fadeOutMin.setText("10000");
        this.fadeOutMax.setText("80000");
    }

    private void addParticlesWidget(Table container) {
        OwnLabel particleProps = new OwnLabel((CharSequence)I18n.msg("gui.dsload.particles.properties"), this.skin, "hud-subheader");
        container.add((Actor)particleProps).colspan(2).left().padTop(pad20).padBottom(pad18).row();
        this.addFileName(container);
        this.addParticleColor(container);
        this.colorNoise = new OwnSliderPlus(I18n.msg("gui.dsload.color.noise"), 0.0f, 1.0f, 0.01f, false, this.skin);
        this.colorNoise.setName("color noise");
        this.colorNoise.setWidth(this.sliderWidth);
        this.colorNoise.setValue(0.2f);
        this.colorNoise.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.updateFrameBuffer();
                return true;
            }
            return false;
        });
        container.add((Actor)GuiUtils.tooltipHg((Actor)this.colorNoise, "gui.dsload.color.noise.tooltip", this.skin)).colspan(2).left().padBottom(pad20).row();
        this.addLabelColor(container);
        this.particleSize = new OwnSliderPlus(I18n.msg("gui.dsload.size"), 0.5f, 50.0f, 0.01f, false, this.skin);
        this.particleSize.setName("particle size");
        this.particleSize.setWidth(this.sliderWidth);
        this.particleSize.setValue(10.0f);
        this.particleSize.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.updateFrameBuffer();
                return true;
            }
            return false;
        });
        container.add((Actor)this.particleSize).colspan(2).left().padBottom(pad18).row();
        this.addMinMaxSolidAngle(container);
        this.addNumberLabels(container);
        FloatValidator falloffVal = new FloatValidator(0.3f, 200.0f);
        this.profileDecay = new OwnTextField("5.0", this.skin, falloffVal);
        this.profileDecay.setWidth(this.fieldWidth);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dsload.profiledecay"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad20);
        container.add((Actor)GuiUtils.tooltipHg((Actor)this.profileDecay, "gui.dsload.profiledecay.tooltip", this.skin)).left().padBottom(pad20).row();
        Object[] componentTypes = new ComponentTypeBean[]{new ComponentTypeBean(ComponentTypes.ComponentType.Others), new ComponentTypeBean(ComponentTypes.ComponentType.Stars), new ComponentTypeBean(ComponentTypes.ComponentType.Galaxies), new ComponentTypeBean(ComponentTypes.ComponentType.Clusters), new ComponentTypeBean(ComponentTypes.ComponentType.Asteroids), new ComponentTypeBean(ComponentTypes.ComponentType.Locations)};
        this.componentType = new OwnSelectBox(this.skin);
        this.componentType.setWidth(this.fieldWidth);
        this.componentType.setItems(componentTypes);
        this.componentType.setSelectedIndex(2);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dsload.ct"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad10);
        container.add(this.componentType).left().padBottom(pad10).row();
        this.addFadeAttributes(container);
    }

    private void addStarClustersWidget(Table container) {
        OwnLabel clustersProps = new OwnLabel((CharSequence)I18n.msg("gui.dsload.clusters.properties"), this.skin, "hud-subheader");
        container.add((Actor)clustersProps).colspan(2).left().padTop(pad20).padBottom(pad18).row();
        String scInfoStr = I18n.msg("gui.dsload.clusters.info") + "\n";
        int scLines = GlobalResources.countOccurrences(scInfoStr, '\n');
        OwnTextArea scInfo = new OwnTextArea(scInfoStr, this.skin, "info");
        scInfo.setDisabled(true);
        scInfo.setPrefRows(scLines + 1);
        scInfo.setWidth(this.taWidth);
        scInfo.clearListeners();
        container.add((Actor)scInfo).colspan(2).left().padTop(pad10).padBottom(pad18).row();
        this.addFileName(container);
        this.addParticleColor(container);
        this.addNumberLabels(container);
        this.addLabelColor(container);
        Object[] componentTypes = new ComponentTypeBean[]{new ComponentTypeBean(ComponentTypes.ComponentType.Others), new ComponentTypeBean(ComponentTypes.ComponentType.Stars), new ComponentTypeBean(ComponentTypes.ComponentType.Galaxies), new ComponentTypeBean(ComponentTypes.ComponentType.Clusters), new ComponentTypeBean(ComponentTypes.ComponentType.Asteroids), new ComponentTypeBean(ComponentTypes.ComponentType.Locations)};
        this.componentType = new OwnSelectBox(this.skin);
        this.componentType.setWidth(this.fieldWidth);
        this.componentType.setItems(componentTypes);
        this.componentType.setSelectedIndex(3);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dsload.ct"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad10);
        container.add(this.componentType).left().padBottom(pad10).row();
        this.addFadeAttributes(container);
    }

    private void addVariableStarsWidget(Table container) {
        OwnLabel starProps = new OwnLabel((CharSequence)I18n.msg("gui.dsload.variable.properties"), this.skin, "hud-subheader");
        container.add((Actor)starProps).colspan(2).left().padTop(pad20).padBottom(pad18).row();
        String scInfoStr = I18n.msg("gui.dsload.variable.info") + "\n";
        int scLines = GlobalResources.countOccurrences(scInfoStr, '\n');
        OwnTextArea scInfo = new OwnTextArea(scInfoStr, this.skin, "info");
        scInfo.setDisabled(true);
        scInfo.setPrefRows(scLines + 1);
        scInfo.setWidth(this.taWidth);
        scInfo.clearListeners();
        container.add((Actor)scInfo).colspan(2).left().padTop(pad10).padBottom(pad18).row();
        this.addFileName(container);
        this.addLabelColor(container);
        FloatValidator sclValidator = new FloatValidator(-100.0f, 100.0f);
        this.magnitudeScale = new OwnTextField("0.0", this.skin, sclValidator);
        this.magnitudeScale.setWidth(this.fieldWidth);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dsload.magnitude.scale"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad18);
        container.add((Actor)GuiUtils.tooltipHg((Actor)this.magnitudeScale, "gui.dsload.magnitude.scale.tooltip", this.skin)).left().padBottom(pad18).row();
        this.addFadeAttributes(container);
        this.fadeOut.setChecked(true);
        this.fadeOutMin.setText("10000");
        this.fadeOutMax.setText("80000");
    }

    private void addFileName(Table container) {
        this.dsName = new OwnTextField(this.fileName, this.skin);
        this.dsName.setWidth(this.fieldWidth);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dsload.name"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad18);
        container.add((Actor)this.dsName).left().padBottom(pad18).row();
    }

    private void addParticleColor(Table container) {
        this.particleColor = new ColorPicker(new float[]{0.3f, 0.3f, 1.0f, 1.0f}, this.stage, this.skin);
        this.particleColor.setNewColorRunnable(this::updateFrameBuffer);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dsload.color"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad10);
        container.add((Actor)this.particleColor).size(this.cpSize).left().padBottom(pad10).row();
    }

    private void addLabelColor(Table container) {
        this.labelColor = new ColorPicker(new float[]{0.3f, 0.3f, 1.0f, 1.0f}, this.stage, this.skin);
        container.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dsload.color.label"), this.skin, this.titleWidth)).left().padRight(pad18).padBottom(pad10);
        Table lc = new Table(this.skin);
        lc.add((Actor)this.labelColor).size(this.cpSize);
        container.add((Actor)GuiUtils.tooltipHg((Actor)lc, "gui.dsload.color.label.tooltip", this.skin)).left().padBottom(pad10).row();
    }

    private void addNumberLabels(Table container) {
        this.numLabels = new OwnSliderPlus(I18n.msg("gui.dsload.numlabels"), 0.0f, 300.0f, 1.0f, false, this.skin);
        this.numLabels.setName("number labels");
        this.numLabels.setWidth(this.sliderWidth);
        this.numLabels.setValue(80.0f);
        this.numLabels.setNumberFormatter(new DecimalFormat("####0"));
        this.numLabels.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.updateFrameBuffer();
                return true;
            }
            return false;
        });
        container.add((Actor)this.numLabels).colspan(2).left().padBottom(pad18).row();
    }

    private void addMinMaxSolidAngle(Table container) {
        this.minSolidAngle = new OwnSliderPlus(I18n.msg("gui.dsload.solidangle.min"), 0.0f, 0.01f, 1.0E-4f, false, this.skin);
        this.minSolidAngle.setName("min solid angle");
        this.minSolidAngle.setWidth(this.sliderWidth);
        this.minSolidAngle.setValue(0.0015f);
        this.minSolidAngle.setNumberFormatter(new DecimalFormat("####0.####"));
        this.minSolidAngle.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.updateFrameBuffer();
                return true;
            }
            return false;
        });
        container.add((Actor)this.minSolidAngle).colspan(2).left().padBottom(pad18).row();
        this.maxSolidAngle = new OwnSliderPlus(I18n.msg("gui.dsload.solidangle.max"), 0.01f, 0.1f, 1.0E-4f, false, this.skin);
        this.maxSolidAngle.setName("max solid angle");
        this.maxSolidAngle.setWidth(this.sliderWidth);
        this.maxSolidAngle.setValue(0.02f);
        this.maxSolidAngle.setNumberFormatter(new DecimalFormat("####0.####"));
        this.maxSolidAngle.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.updateFrameBuffer();
                return true;
            }
            return false;
        });
        container.add((Actor)this.maxSolidAngle).colspan(2).left().padBottom(pad18).row();
    }

    private void addFadeAttributes(Table container) {
        OwnLabel fadeLabel = new OwnLabel((CharSequence)I18n.msg("gui.dsload.fade"), this.skin, "hud-subheader");
        container.add((Actor)fadeLabel).colspan(2).left().padTop(pad20).padBottom(pad18).row();
        String ssInfoStr = I18n.msg("gui.dsload.fade.info") + "\n";
        int ssLines = GlobalResources.countOccurrences(ssInfoStr, '\n');
        OwnTextArea fadeInfo = new OwnTextArea(ssInfoStr, this.skin, "info");
        fadeInfo.setDisabled(true);
        fadeInfo.setPrefRows(ssLines + 1);
        fadeInfo.setWidth(this.taWidth);
        fadeInfo.clearListeners();
        container.add((Actor)fadeInfo).colspan(2).left().padTop(pad10).padBottom(pad18).row();
        this.fadeIn = new OwnCheckBox(I18n.msg("gui.dsload.fade.in"), this.skin, pad10);
        container.add((Actor)this.fadeIn).left().padRight(pad18).padBottom(pad10);
        HorizontalGroup fadeInGroup = new HorizontalGroup();
        fadeInGroup.space(pad10);
        this.fadeInMin = new OwnTextField("0", this.skin);
        this.fadeInMax = new OwnTextField("10", this.skin);
        fadeInGroup.addActor((Actor)new OwnLabel((CharSequence)"[", this.skin));
        fadeInGroup.addActor((Actor)this.fadeInMin);
        fadeInGroup.addActor((Actor)new OwnLabel((CharSequence)", ", this.skin));
        fadeInGroup.addActor((Actor)this.fadeInMax);
        fadeInGroup.addActor((Actor)new OwnLabel((CharSequence)"] pc", this.skin));
        this.fadeIn.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                boolean disable = !this.fadeIn.isChecked();
                for (Actor child : fadeInGroup.getChildren()) {
                    if (child instanceof OwnLabel) {
                        ((OwnLabel)child).setDisabled(disable);
                        continue;
                    }
                    if (!(child instanceof OwnTextField)) continue;
                    ((OwnTextField)child).setDisabled(disable);
                }
                return true;
            }
            return false;
        });
        this.fadeIn.setChecked(true);
        this.fadeIn.setProgrammaticChangeEvents(true);
        this.fadeIn.setChecked(false);
        container.add((Actor)fadeInGroup).left().padBottom(pad10).row();
        this.fadeOut = new OwnCheckBox(I18n.msg("gui.dsload.fade.out"), this.skin, pad10);
        container.add((Actor)this.fadeOut).left().padRight(pad18).padBottom(pad10);
        HorizontalGroup fadeOutGroup = new HorizontalGroup();
        fadeOutGroup.space(pad10);
        this.fadeOutMin = new OwnTextField("3000", this.skin);
        this.fadeOutMax = new OwnTextField("6000", this.skin);
        fadeOutGroup.addActor((Actor)new OwnLabel((CharSequence)"[", this.skin));
        fadeOutGroup.addActor((Actor)this.fadeOutMin);
        fadeOutGroup.addActor((Actor)new OwnLabel((CharSequence)", ", this.skin));
        fadeOutGroup.addActor((Actor)this.fadeOutMax);
        fadeOutGroup.addActor((Actor)new OwnLabel((CharSequence)"] pc", this.skin));
        this.fadeOut.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                boolean disable = !this.fadeOut.isChecked();
                for (Actor child : fadeOutGroup.getChildren()) {
                    if (child instanceof OwnLabel) {
                        ((OwnLabel)child).setDisabled(disable);
                        continue;
                    }
                    if (!(child instanceof OwnTextField)) continue;
                    ((OwnTextField)child).setDisabled(disable);
                }
                return true;
            }
            return false;
        });
        this.fadeOut.setChecked(true);
        this.fadeOut.setProgrammaticChangeEvents(true);
        this.fadeOut.setChecked(false);
        FloatValidator fadeVal = new FloatValidator(0.0f, 1.0E10f);
        TextFieldComparatorValidator fadeInMinVal = new TextFieldComparatorValidator(fadeVal, new OwnTextField[]{this.fadeInMax, this.fadeOutMin, this.fadeOutMax}, null);
        TextFieldComparatorValidator fadeInMaxVal = new TextFieldComparatorValidator(fadeVal, new OwnTextField[]{this.fadeOutMin, this.fadeOutMax}, new OwnTextField[]{this.fadeInMin});
        TextFieldComparatorValidator fadeOutMinVal = new TextFieldComparatorValidator(fadeVal, new OwnTextField[]{this.fadeOutMax}, new OwnTextField[]{this.fadeInMin, this.fadeInMax});
        TextFieldComparatorValidator fadeOutMaxVal = new TextFieldComparatorValidator(fadeVal, null, new OwnTextField[]{this.fadeInMin, this.fadeInMax, this.fadeOutMin});
        this.fadeInMin.setValidator(fadeInMinVal);
        this.fadeInMax.setValidator(fadeInMaxVal);
        this.fadeOutMin.setValidator(fadeOutMinVal);
        this.fadeOutMax.setValidator(fadeOutMaxVal);
        container.add((Actor)fadeOutGroup).left().padBottom(pad10).row();
    }

    public DatasetOptions generateDatasetOptions() {
        DatasetOptions datasetOptions = new DatasetOptions();
        if (this.stars.isChecked()) {
            datasetOptions.type = DatasetOptions.DatasetLoadType.STARS;
            datasetOptions.magnitudeScale = this.magnitudeScale.getDoubleValue(0.0);
        } else if (this.particles.isChecked()) {
            datasetOptions.type = DatasetOptions.DatasetLoadType.PARTICLES;
            datasetOptions.ct = ((ComponentTypeBean)this.componentType.getSelected()).ct;
            datasetOptions.profileDecay = this.profileDecay.getDoubleValue(5.0);
            datasetOptions.particleColor = this.particleColor.getPickedColorDouble();
            datasetOptions.particleColorNoise = this.colorNoise.getValue();
            datasetOptions.particleSize = (double)this.particleSize.getValue() * (Settings.settings.scene.renderer.pointCloud.isTriangles() ? 1.0E-13 : 1.0);
            datasetOptions.particleSizeLimits = new double[]{this.minSolidAngle.getValue(), this.maxSolidAngle.getValue()};
            datasetOptions.numLabels = (int)this.numLabels.getValue();
        } else if (this.clusters.isChecked()) {
            datasetOptions.type = DatasetOptions.DatasetLoadType.PARTICLES_EXT;
            datasetOptions.ct = ((ComponentTypeBean)this.componentType.getSelected()).ct;
            datasetOptions.profileDecay = this.profileDecay != null ? this.profileDecay.getDoubleValue(5.0) : 5.0;
            datasetOptions.particleColor = this.particleColor.getPickedColorDouble();
            double d = datasetOptions.particleColorNoise = this.colorNoise != null ? (double)this.colorNoise.getValue() : 0.0;
            datasetOptions.particleSize = this.particleSize != null ? (double)this.particleSize.getValue() * (Settings.settings.scene.renderer.pointCloud.isTriangles() ? 1.0E-13 : 1.0) : 1.0;
            datasetOptions.particleSizeLimits = new double[]{0.0, 1.57};
            datasetOptions.numLabels = 100;
            datasetOptions.modelType = "icosphere";
            datasetOptions.modelPrimitive = "GL_LINES";
        } else if (this.variables.isChecked()) {
            datasetOptions.type = DatasetOptions.DatasetLoadType.VARIABLES;
            datasetOptions.magnitudeScale = this.magnitudeScale.getDoubleValue(0.0);
        }
        datasetOptions.catalogName = this.dsName.getText();
        datasetOptions.labelColor = this.labelColor.getPickedColorDouble();
        this.addFadeInfo(datasetOptions);
        return datasetOptions;
    }

    private void addFadeInfo(DatasetOptions dops) {
        if (this.fadeIn.isChecked()) {
            dops.fadeIn = new double[]{this.fadeInMin.getDoubleValue(0.0), this.fadeInMax.getDoubleValue(0.0)};
        }
        if (this.fadeOut.isChecked()) {
            dops.fadeOut = new double[]{this.fadeOutMin.getDoubleValue(2000.0), this.fadeOutMax.getDoubleValue(8000.0)};
        }
    }

    private void updateFrameBuffer() {
    }

    @Override
    protected boolean accept() {
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

