/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.datasets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.ButtonGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import gaiasky.GaiaSky;
import gaiasky.event.EventManager;
import gaiasky.gui.datasets.DatasetWatcher;
import gaiasky.gui.window.GenericDialog;
import gaiasky.input.WindowGamepadListener;
import gaiasky.input.WindowKbdListener;
import gaiasky.util.DownloadHelper;
import gaiasky.util.GuiUtils;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.ProgressRunnable;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.datadesc.DataDescriptor;
import gaiasky.util.datadesc.DataDescriptorUtils;
import gaiasky.util.datadesc.DatasetDesc;
import gaiasky.util.datadesc.DatasetDownloadUtils;
import gaiasky.util.datadesc.DatasetType;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.CollapsiblePane;
import gaiasky.util.scene2d.ContextMenu;
import gaiasky.util.scene2d.FileChooser;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.MenuItem;
import gaiasky.util.scene2d.OwnButton;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnImage;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnProgressBar;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jafama.FastMath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class DatasetManagerWindow
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(DatasetManagerWindow.class);
    private static final Map<String, String> iconMap = new HashMap<String, String>();
    private final DatasetDesc[] selectedDataset;
    private final float[][] scroll;
    private final Map<String, Pair<DatasetDesc, Net.HttpRequest>> currentDownloads;
    private final Map<String, Button>[] buttonMap;
    private final List<Pair<DatasetDesc, Actor>> selectionOrder;
    private final Color highlight;
    private final boolean dataLocation;
    private final DecimalFormat nf = new DecimalFormat("##0.0");
    private final Set<DatasetWatcher> watchers;
    private final AtomicBoolean initialized;
    private DataDescriptor serverDd;
    private DatasetMode currentMode;
    private Cell<?> right;
    private OwnScrollPane leftScroll;
    private int selectedIndex = 0;
    private DatasetWatcher rightPaneWatcher;
    private static final int MAX_REC = 150;

    public DatasetManagerWindow(Stage stage, Skin skin, DataDescriptor serverDd) {
        this(stage, skin, serverDd, true, I18n.msg("gui.close"));
    }

    public DatasetManagerWindow(Stage stage, Skin skin, DataDescriptor serverDd, boolean dataLocation, String acceptText) {
        super(I18n.msg("gui.download.title") + (String)(serverDd != null && serverDd.updatesAvailable ? " - " + I18n.msg("gui.download.updates", serverDd.numUpdates) : ""), skin, stage);
        this.serverDd = serverDd;
        this.highlight = ColorUtils.gYellowC;
        this.watchers = new HashSet<DatasetWatcher>();
        this.scroll = new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}};
        this.selectedDataset = new DatasetDesc[2];
        this.initialized = new AtomicBoolean(false);
        this.buttonMap = new HashMap[2];
        this.buttonMap[0] = new HashMap<String, Button>();
        this.buttonMap[1] = new HashMap<String, Button>();
        this.currentDownloads = Collections.synchronizedMap(new HashMap());
        this.selectionOrder = new ArrayList<Pair<DatasetDesc, Actor>>();
        this.dataLocation = dataLocation;
        this.defaultMouseKbdListener = false;
        this.mouseKbdListener = new DatasetManagerKbdListener(this);
        this.defaultGamepadListener = false;
        this.gamepadListener = new DatasetManagerGamepadListener(Settings.settings.controls.gamepad.mappingsFile);
        this.setAcceptText(acceptText);
        this.buildSuper();
    }

    public static int getTypeWeight(String type) {
        return switch (type) {
            case "data-pack" -> -2;
            case "texture-pack" -> -1;
            case "catalog-lod" -> 0;
            case "catalog-gaia" -> 1;
            case "catalog-star" -> 2;
            case "catalog-gal" -> 3;
            case "catalog-cluster" -> 4;
            case "catalog-sso" -> 5;
            case "catalog-other" -> 6;
            case "system" -> 7;
            case "spacecraft" -> 8;
            case "mesh" -> 9;
            case "volume" -> 10;
            case "virtualtex-pack" -> 11;
            case "other" -> 12;
            default -> 13;
        };
    }

    public static String getIcon(String type) {
        if (type != null && iconMap.containsKey(type)) {
            return iconMap.get(type);
        }
        return "icon-elem-others";
    }

    @Override
    protected void build() {
        this.initialized.set(false);
        float tabWidth = 500.0f;
        final float width = 1800.0f;
        try {
            Files.createDirectories(SysUtils.getDefaultDatasetsDir(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            logger.error(e);
            return;
        }
        HorizontalGroup tabGroup = new HorizontalGroup();
        tabGroup.align(1);
        String tabInstalledText = this.serverDd != null && this.serverDd.updatesAvailable ? I18n.msg("gui.download.tab.installed.updates", this.serverDd.numUpdates) : I18n.msg("gui.download.tab.installed");
        final OwnTextButton tabAvail = new OwnTextButton(I18n.msg("gui.download.tab.available"), this.skin, "toggle-big");
        tabAvail.pad(pad10);
        tabAvail.setWidth(tabWidth);
        final OwnTextButton tabInstalled = new OwnTextButton(tabInstalledText, this.skin, "toggle-big");
        tabInstalled.pad(pad10);
        tabInstalled.setWidth(tabWidth);
        tabGroup.addActor((Actor)tabAvail);
        tabGroup.addActor((Actor)tabInstalled);
        this.content.add((Actor)tabGroup).center().expandX().row();
        this.tabStack = new Stack();
        final Table contentAvail = new Table(this.skin);
        contentAvail.align(2);
        contentAvail.pad(pad18);
        final Table contentInstalled = new Table(this.skin);
        contentInstalled.align(2);
        contentInstalled.pad(pad18);
        this.addTabContent((Group)contentAvail);
        this.addTabContent((Group)contentInstalled);
        this.content.add((Actor)this.tabStack).expand().fill().padBottom(pad34).row();
        ChangeListener tabListener = new ChangeListener(this){
            final /* synthetic */ DatasetManagerWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (tabAvail.isChecked()) {
                    if (this.this$0.initialized.get()) {
                        this.this$0.selectedTab = 0;
                    }
                    this.this$0.reloadAvailable(contentAvail, width);
                }
                if (tabInstalled.isChecked()) {
                    if (this.this$0.initialized.get()) {
                        this.this$0.selectedTab = 1;
                    }
                    this.this$0.reloadInstalled(contentInstalled, width);
                }
                contentAvail.setVisible(tabAvail.isChecked());
                contentInstalled.setVisible(tabInstalled.isChecked());
                this.this$0.content.pack();
                this.this$0.setKeyboardFocus();
            }
        };
        tabAvail.addListener((EventListener)tabListener);
        tabInstalled.addListener((EventListener)tabListener);
        ButtonGroup tabs = new ButtonGroup();
        tabs.setMinCheckCount(1);
        tabs.setMaxCheckCount(1);
        tabs.add((Button)tabAvail);
        tabs.add((Button)tabInstalled);
        if (this.serverDd != null && this.serverDd.updatesAvailable) {
            this.selectedTab = 1;
        }
        tabs.setChecked(this.selectedTab == 0 ? tabAvail.getText().toString() : tabInstalled.getText().toString());
        if (this.dataLocation) {
            this.addDataLocation(this.content);
        }
        Link manualDownload = new Link(I18n.msg("gui.download.manual"), this.skin, "link", Settings.settings.program.url.dataMirror);
        this.content.add((Actor)manualDownload).center();
        this.initialized.set(true);
    }

    private void addDataLocation(Table content) {
        float buttonPad = 1.6f;
        String catLoc = Settings.settings.data.location;
        Table dataLocTable = new Table(this.skin);
        OwnLabel catalogsLocLabel = new OwnLabel((CharSequence)I18n.msg("gui.download.location"), this.skin);
        OwnImageButton catalogsLocTooltip = new OwnImageButton(this.skin, "tooltip");
        catalogsLocTooltip.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.download.location.info"), this.skin));
        HorizontalGroup catalogsLocGroup = new HorizontalGroup();
        catalogsLocGroup.space(pad18);
        catalogsLocGroup.addActor((Actor)catalogsLocLabel);
        catalogsLocGroup.addActor((Actor)catalogsLocTooltip);
        String dataLocationString = Path.of(catLoc, new String[0]).toString();
        OwnTextButton dataLocationButton = new OwnTextButton(TextUtils.capString(dataLocationString, 85), this.skin);
        dataLocationButton.addListener((EventListener)new OwnTextTooltip(dataLocationString, this.skin));
        dataLocationButton.pad(buttonPad * 4.0f);
        dataLocationButton.setMinWidth(1000.0f);
        dataLocTable.add((Actor)catalogsLocGroup).left().padBottom(pad18);
        dataLocTable.add((Actor)dataLocationButton).left().padLeft(pad10).padBottom(pad18).row();
        Cell notice = dataLocTable.add((Actor)null).colspan(2).padBottom(pad18);
        notice.row();
        content.add((Actor)dataLocTable).center().row();
        dataLocationButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                FileChooser fc = new FileChooser(I18n.msg("gui.download.pickloc"), this.skin, this.stage, Path.of(Settings.settings.data.location, new String[0]), FileChooser.FileChooserTarget.DIRECTORIES);
                fc.setShowHidden(Settings.settings.program.fileChooser.showHidden);
                fc.setShowHiddenConsumer(showHidden -> {
                    Settings.settings.program.fileChooser.showHidden = showHidden;
                });
                fc.setResultListener((success, result) -> {
                    if (success) {
                        if (Files.isReadable(result) && Files.isWritable(result)) {
                            dataLocationButton.setText(result.toAbsolutePath().toString());
                            Settings.settings.data.location = result.toAbsolutePath().toString().replaceAll("\\\\", "/");
                            SysUtils.mkdir(SysUtils.getDataTempDir(Settings.settings.data.location));
                            this.me.pack();
                            GaiaSky.postRunnable(() -> {
                                Settings.settings.data.dataFiles.clear();
                                this.reloadAll();
                            });
                        } else {
                            OwnLabel warn = new OwnLabel((CharSequence)I18n.msg("gui.download.pickloc.permissions"), this.skin);
                            warn.setColor(ColorUtils.gRedC);
                            notice.setActor((Actor)warn);
                            return false;
                        }
                    }
                    notice.clearActor();
                    return true;
                });
                fc.show(this.stage);
                return true;
            }
            return false;
        });
    }

    private void reloadAvailable(Table content, float width) {
        this.currentMode = DatasetMode.AVAILABLE;
        this.reloadBothPanes(content, width, this.serverDd, this.currentMode);
    }

    private void reloadInstalled(Table content, float width) {
        DataDescriptor localDd = DataDescriptorUtils.instance().buildLocalDatasets(this.serverDd);
        this.currentMode = DatasetMode.INSTALLED;
        this.reloadBothPanes(content, width, localDd, this.currentMode);
    }

    private void reloadBothPanes(Table content, float width, DataDescriptor dataDescriptor, DatasetMode mode) {
        content.clear();
        if (dataDescriptor == null || dataDescriptor.datasets.isEmpty()) {
            if (mode == DatasetMode.AVAILABLE) {
                content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.download.noconnection.title"), this.skin)).center().padTop(pad34 * 2.0f).padBottom(pad18).row();
            }
            content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dschooser.nodatasets"), this.skin)).center().padTop(mode == DatasetMode.AVAILABLE ? 0.0f : pad34 * 2.0f).row();
        } else {
            Cell left = content.add().top().left().padRight(pad34);
            this.right = content.add().top().left();
            int datasets = this.reloadLeftPane(left, dataDescriptor, mode, width);
            if (datasets > 0) {
                this.reloadRightPane(this.right, this.selectedDataset[mode.ordinal()], mode);
            } else {
                content.clear();
                content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dschooser.nodatasets"), this.skin)).center().padTop(mode == DatasetMode.AVAILABLE ? 0.0f : pad34 * 2.0f).row();
            }
        }
        this.me.pack();
    }

    private int reloadLeftPane(Cell<?> left, final DataDescriptor dataDescriptor, final DatasetMode mode, final float width) {
        Table leftContent = new Table(this.skin);
        final Table leftTable = new Table(this.skin);
        final OwnTextField filter = new OwnTextField("", this.skin, "big");
        filter.setMessageText(I18n.msg("gui.filter"));
        filter.setWidth(400.0f);
        filter.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ DatasetManagerWindow this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.populateLeftTable(leftTable, mode, dataDescriptor, Settings.settings.data.dataFiles, width, filter.getText());
            }
        });
        leftTable.align(18);
        this.leftScroll = new OwnScrollPane((Actor)leftTable, this.skin, "minimalist-nobg");
        this.leftScroll.setScrollingDisabled(true, false);
        this.leftScroll.setForceScroll(false, true);
        this.leftScroll.setSmoothScrolling(false);
        this.leftScroll.addListener(event -> {
            InputEvent ie;
            if (event instanceof InputEvent && (ie = (InputEvent)event).getType() == InputEvent.Type.scrolled) {
                this.scroll[mode.ordinal()][0] = this.leftScroll.getScrollX();
                this.scroll[mode.ordinal()][1] = this.leftScroll.getScrollY();
            }
            return false;
        });
        this.selectionOrder.clear();
        this.selectedIndex = 0;
        int added = this.populateLeftTable(leftTable, mode, dataDescriptor, Settings.settings.data.dataFiles, width, "");
        float maxScrollHeight = this.stage.getHeight() * 0.65f;
        this.leftScroll.setFadeScrollBars(false);
        this.leftScroll.setWidth(width * 0.52f);
        this.leftScroll.setHeight(maxScrollHeight);
        this.leftScroll.layout();
        this.leftScroll.setScrollX(this.scroll[mode.ordinal()][0]);
        this.leftScroll.setScrollY(this.scroll[mode.ordinal()][1]);
        leftContent.add((Actor)filter).top().center().padBottom(pad18).row();
        leftContent.add((Actor)this.leftScroll).top().left();
        left.setActor((Actor)leftContent);
        return added;
    }

    private int populateLeftTable(Table leftTable, DatasetMode mode, DataDescriptor dataDescriptor, List<String> currentSetting, float width, String filter) {
        leftTable.clear();
        int added = 0;
        for (DatasetType type : dataDescriptor.types) {
            List<DatasetDesc> datasets = type.datasets;
            List<DatasetDesc> filtered = datasets.stream().filter(d -> d.filter(filter) && (mode != DatasetMode.AVAILABLE || !d.exists)).collect(Collectors.toList());
            added += this.addDatasetTypeGroup(leftTable, mode, currentSetting, type, filtered, width, filter);
        }
        leftTable.pack();
        return added;
    }

    private int addDatasetTypeGroup(Table leftTable, final DatasetMode mode, final List<String> currentSetting, DatasetType type, List<DatasetDesc> filtered, float width, String filter) {
        int added = 0;
        if (!filtered.isEmpty()) {
            Array groupCheckBoxes = new Array();
            Table contentTable = new Table(this.skin);
            Table buttons = null;
            if (mode == DatasetMode.INSTALLED) {
                OwnImageButton selectAll = new OwnImageButton(this.skin, "select-all");
                selectAll.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        for (CheckBox checkBox : groupCheckBoxes) {
                            if (checkBox.isDisabled()) continue;
                            checkBox.setChecked(true);
                        }
                        return true;
                    }
                    return false;
                });
                selectAll.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.select.all"), this.skin));
                OwnImageButton selectNone = new OwnImageButton(this.skin, "select-none");
                selectNone.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        for (CheckBox checkBox : groupCheckBoxes) {
                            if (checkBox.isDisabled()) continue;
                            checkBox.setChecked(false);
                        }
                        return true;
                    }
                    return false;
                });
                selectNone.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.select.none"), this.skin));
                float buttonSize = 17.0f;
                buttons = new Table(this.skin);
                buttons.padRight(pad20);
                buttons.add((Actor)selectAll).size(17.0f, 17.0f).right().bottom().padRight(pad10);
                buttons.add((Actor)selectNone).size(17.0f, 17.0f).right().bottom();
            }
            OwnImage paneImage = new OwnImage(this.skin.getDrawable(DatasetManagerWindow.getIcon(type.typeStr)));
            paneImage.setSize(45.0f, 45.0f);
            String typeString = I18n.hasMessage("gui.download.type." + type.typeStr) ? I18n.msg("gui.download.type." + type.typeStr) : TextUtils.trueCapitalise(type.typeStr);
            CollapsiblePane groupPane = new CollapsiblePane(this.stage, (Image)paneImage, typeString, (Actor)contentTable, width * 0.5f, this.skin, "hud-header", "expand-collapse", null, filter != null && !filter.isBlank(), null, new Actor[]{buttons});
            leftTable.add((Actor)groupPane).left().padTop(pad34 * 2.0f).row();
            this.selectionOrder.add(new Pair<Object, Button>(null, groupPane.getExpandCollapseActor()));
            boolean anySelected = false;
            for (final DatasetDesc dataset : filtered) {
                Object installOrSelect;
                Table t = new Table(this.skin);
                t.pad(pad18, pad18, 0.0f, pad18);
                String tooltipText = dataset.key;
                OwnImage typeImage = new OwnImage(this.skin.getDrawable(DatasetManagerWindow.getIcon(dataset.type)));
                float scl = 0.7f;
                float iw = typeImage.getWidth();
                float ih = typeImage.getHeight();
                typeImage.setSize(iw * scl, ih * scl);
                typeImage.addListener((EventListener)new OwnTextTooltip(dataset.type, this.skin, 10));
                String titleString = dataset.name;
                OwnLabel title = new OwnLabel((CharSequence)TextUtils.capString(titleString, 60), this.skin, "huge");
                title.setWidth(width * 0.41f);
                if (dataset.outdated) {
                    title.setColor(this.highlight);
                    tooltipText = I18n.msg("gui.download.version.new", Integer.toString(dataset.serverVersion), Integer.toString(dataset.myVersion));
                }
                float installOrSelectSize = 43.0f;
                if (mode == DatasetMode.AVAILABLE || dataset.outdated) {
                    OwnTextIconButton install = new OwnTextIconButton("", this.skin, "install");
                    install.setContentAlign(1);
                    install.addListener((EventListener)new OwnTextTooltip(I18n.msg(dataset.outdated ? "gui.download.update" : "gui.download.install"), this.skin));
                    install.addListener(event -> {
                        if (event instanceof ChangeListener.ChangeEvent) {
                            if (dataset.outdated) {
                                this.actionUpdateDataset(dataset);
                            } else {
                                this.actionDownloadDataset(dataset);
                            }
                        }
                        return false;
                    });
                    install.setSize(installOrSelectSize, installOrSelectSize);
                    if (this.currentDownloads.containsKey(dataset.key)) {
                        install.setDisabled(true);
                    }
                    installOrSelect = install;
                    anySelected = true;
                } else {
                    final OwnCheckBox select = new OwnCheckBox("", this.skin, 0.0f);
                    groupCheckBoxes.add((Object)select);
                    installOrSelect = select;
                    if (dataset.baseData || dataset.type.equals("texture-pack")) {
                        select.setChecked(true);
                        select.setDisabled(true);
                    } else if (dataset.minGsVersion > 3061001) {
                        select.setChecked(false);
                        select.setDisabled(true);
                        title.setColor(ColorUtils.gRedC);
                        tooltipText = I18n.msg("gui.download.version.gs.mismatch", Integer.toString(3061001), Integer.toString(dataset.minGsVersion));
                        select.getStyle().disabledFontColor = ColorUtils.gRedC;
                        String filePath = dataset.catalogFile.path();
                        if (Settings.settings.data.dataFiles.contains(filePath)) {
                            Settings.settings.data.dataFiles.remove(filePath);
                            logger.info(I18n.msg("gui.download.disabled.version", dataset.name, Integer.toString(dataset.minGsVersion), Integer.toString(3061001)));
                        }
                    } else {
                        select.setChecked(DatasetDownloadUtils.isPathIn(Settings.settings.data.dataFile(dataset.checkStr), currentSetting));
                        select.addListener((EventListener)new OwnTextTooltip(dataset.checkPath.toString(), this.skin));
                    }
                    select.setSize(installOrSelectSize, installOrSelectSize);
                    select.setHeight(40.0f);
                    select.addListener((EventListener)new ChangeListener(this){
                        final /* synthetic */ DatasetManagerWindow this$0;
                        {
                            this.this$0 = this$0;
                        }

                        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                            if (select.isChecked()) {
                                this.this$0.actionEnableDataset(dataset, select);
                            } else {
                                this.this$0.actionDisableDataset(dataset);
                            }
                            GaiaSky.postRunnable(() -> this.this$0.reloadRightPane(this.this$0.right, dataset, mode));
                        }
                    });
                    anySelected = anySelected || select.isChecked();
                }
                OwnLabel size = new OwnLabel((CharSequence)dataset.size, this.skin, "grey-large");
                size.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.download.size.tooltip"), this.skin, 10));
                size.setWidth(88.0f);
                OwnLabel version = null;
                if (mode == DatasetMode.AVAILABLE) {
                    version = new OwnLabel((CharSequence)I18n.msg("gui.download.version.server", dataset.serverVersion), this.skin, "grey-large");
                } else if (mode == DatasetMode.INSTALLED) {
                    if (dataset.outdated) {
                        version = new OwnLabel((CharSequence)I18n.msg("gui.download.version.new", Integer.toString(dataset.serverVersion), Integer.toString(dataset.myVersion)), this.skin, "grey-large");
                        version.setColor(this.highlight);
                    } else {
                        version = new OwnLabel((CharSequence)I18n.msg("gui.download.version.local", dataset.myVersion), this.skin, "grey-large");
                    }
                }
                HorizontalGroup versionSize = new HorizontalGroup();
                versionSize.space(pad34 * 2.0f);
                versionSize.addActor(version);
                versionSize.addActor((Actor)size);
                OwnProgressBar progress = new OwnProgressBar(0.0f, 100.0f, 0.1f, false, this.skin, "small-horizontal");
                progress.setPrefWidth(850.0f);
                progress.setValue(60.0f);
                progress.setVisible(false);
                t.add((Actor)typeImage).size(typeImage.getWidth(), typeImage.getHeight()).left().padRight(pad18);
                t.add((Actor)title).left().padRight(pad18);
                t.add((Actor)installOrSelect).right().row();
                t.add();
                t.add((Actor)versionSize).colspan(2).left().padRight(pad18).padBottom(pad10).row();
                t.add((Actor)progress).colspan(3).expandX();
                t.pack();
                OwnButton button = new OwnButton((Actor)t, this.skin, "dataset", false);
                button.setWidth(width * 0.52f);
                title.addListener((EventListener)new OwnTextTooltip(tooltipText, this.skin, 10));
                this.buttonMap[mode.ordinal()].put(dataset.key, button);
                button.addListener((EventListener)new InputListener(this, (Actor)installOrSelect){
                    final /* synthetic */ Actor val$installOrSelect;
                    final /* synthetic */ DatasetManagerWindow this$0;
                    {
                        this.val$installOrSelect = actor;
                        this.this$0 = this$0;
                    }

                    public boolean handle(Event event) {
                        InputEvent ie;
                        InputEvent.Type type;
                        if (event instanceof InputEvent && (type = (ie = (InputEvent)event).getType()) == InputEvent.Type.touchDown) {
                            if (ie.getButton() == 0) {
                                GaiaSky.postRunnable(() -> this.this$0.reloadRightPane(this.this$0.right, dataset, mode));
                                this.this$0.selectedDataset[mode.ordinal()] = dataset;
                            } else if (ie.getButton() == 1) {
                                GaiaSky.postRunnable(() -> {
                                    ContextMenu datasetContext = new ContextMenu(this.this$0.skin, "default");
                                    if (mode == DatasetMode.INSTALLED) {
                                        if (dataset2.outdated) {
                                            MenuItem update = new MenuItem(I18n.msg("gui.download.update"), this.this$0.skin, this.this$0.skin.getDrawable("iconic-arrow-circle-bottom"));
                                            update.addListener((EventListener)new ChangeListener(this){
                                                final /* synthetic */ 4 this$1;
                                                {
                                                    this.this$1 = this$1;
                                                }

                                                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                                    this.this$1.this$0.actionUpdateDataset(dataset);
                                                }
                                            });
                                            datasetContext.addItem(update);
                                        }
                                        if (!dataset2.baseData && !dataset2.type.equals("texture-pack") && dataset2.minGsVersion <= 3061001) {
                                            boolean enabled = DatasetDownloadUtils.isPathIn(dataset2.catalogFile.path(), currentSetting);
                                            if (enabled) {
                                                MenuItem disable = new MenuItem(I18n.msg("gui.download.disable"), this.this$0.skin, this.this$0.skin.getDrawable("check-off-disabled"));
                                                disable.addListener((EventListener)new ChangeListener(this){
                                                    final /* synthetic */ 4 this$1;
                                                    {
                                                        this.this$1 = this$1;
                                                    }

                                                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                                        this.this$1.this$0.actionDisableDataset(dataset);
                                                        if (val$installOrSelect instanceof OwnCheckBox) {
                                                            OwnCheckBox cb = (OwnCheckBox)val$installOrSelect;
                                                            cb.setProgrammaticChangeEvents(false);
                                                            cb.setChecked(false);
                                                            cb.setProgrammaticChangeEvents(true);
                                                        }
                                                        GaiaSky.postRunnable(() -> this.this$1.this$0.reloadRightPane(this.this$1.this$0.right, dataset, DatasetMode.INSTALLED));
                                                    }
                                                });
                                                datasetContext.addItem(disable);
                                            } else {
                                                MenuItem enable = new MenuItem(I18n.msg("gui.download.enable"), this.this$0.skin, this.this$0.skin.getDrawable("check-on"));
                                                enable.addListener((EventListener)new ChangeListener(this){
                                                    final /* synthetic */ 4 this$1;
                                                    {
                                                        this.this$1 = this$1;
                                                    }

                                                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                                        this.this$1.this$0.actionEnableDataset(dataset, null);
                                                        if (val$installOrSelect instanceof OwnCheckBox) {
                                                            OwnCheckBox cb = (OwnCheckBox)val$installOrSelect;
                                                            cb.setProgrammaticChangeEvents(false);
                                                            cb.setChecked(true);
                                                            cb.setProgrammaticChangeEvents(true);
                                                        }
                                                        GaiaSky.postRunnable(() -> this.this$1.this$0.reloadRightPane(this.this$1.this$0.right, dataset, DatasetMode.INSTALLED));
                                                    }
                                                });
                                                datasetContext.addItem(enable);
                                            }
                                            datasetContext.addSeparator();
                                        }
                                        MenuItem delete = new MenuItem(I18n.msg("gui.download.delete"), this.this$0.skin, this.this$0.skin.getDrawable("iconic-trash"));
                                        delete.addListener((EventListener)new ClickListener(this){
                                            final /* synthetic */ 4 this$1;
                                            {
                                                this.this$1 = this$1;
                                            }

                                            public void clicked(InputEvent event, float x, float y) {
                                                this.this$1.this$0.actionDeleteDataset(dataset);
                                                super.clicked(event, x, y);
                                            }
                                        });
                                        datasetContext.addItem(delete);
                                    } else if (mode == DatasetMode.AVAILABLE) {
                                        MenuItem install = new MenuItem(I18n.msg("gui.download.install"), this.this$0.skin, this.this$0.skin.getDrawable("iconic-cloud-download"));
                                        install.addListener((EventListener)new ChangeListener(this){
                                            final /* synthetic */ 4 this$1;
                                            {
                                                this.this$1 = this$1;
                                            }

                                            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                                this.this$1.this$0.actionDownloadDataset(dataset);
                                            }
                                        });
                                        datasetContext.addItem(install);
                                    }
                                    int h = (int)this.this$0.stage.getHeight();
                                    float unitsPerPixel = GaiaSky.instance.getUnitsPerPixel();
                                    float px = (float)Gdx.input.getX(ie.getPointer()) * unitsPerPixel;
                                    float py = (float)h - (float)Gdx.input.getY(ie.getPointer()) * unitsPerPixel - 32.0f;
                                    datasetContext.showMenu(this.this$0.stage, px, py);
                                });
                            }
                        }
                        return super.handle(event);
                    }
                });
                contentTable.add((Actor)button).left().row();
                this.selectionOrder.add(new Pair<DatasetDesc, OwnCheckBox>(dataset, (OwnCheckBox)((Object)installOrSelect)));
                if (this.selectedDataset[mode.ordinal()] == null) {
                    this.selectedDataset[mode.ordinal()] = dataset;
                    this.selectedIndex = this.selectionOrder.size() - 1;
                }
                this.watchers.add(new DatasetWatcher(dataset, progress, installOrSelect instanceof OwnTextIconButton ? (OwnTextIconButton)((Object)installOrSelect) : null, null, null));
                ++added;
            }
            if (anySelected) {
                groupPane.expandPane();
            }
        }
        return added;
    }

    private void reloadRightPane(Cell<?> cell, DatasetDesc dataset, DatasetMode mode) {
        if (this.rightPaneWatcher != null) {
            this.rightPaneWatcher.dispose();
            this.watchers.remove(this.rightPaneWatcher);
            this.rightPaneWatcher = null;
        }
        Table rightTable = new Table(this.skin);
        if (dataset == null) {
            OwnLabel l = new OwnLabel((CharSequence)I18n.msg("gui.download.noselected"), this.skin);
            rightTable.add((Actor)l).center().padTop(pad34 * 3.0f);
        } else {
            String filesString;
            String dType = dataset.type != null ? dataset.type : "other";
            OwnImage typeImage = new OwnImage(this.skin.getDrawable(DatasetManagerWindow.getIcon(dType)));
            float scl = 0.7f;
            float iw = typeImage.getWidth();
            float ih = typeImage.getHeight();
            typeImage.setSize(iw * scl, ih * scl);
            typeImage.addListener((EventListener)new OwnTextTooltip(dType, this.skin, 10));
            String titleString = dataset.name;
            OwnLabel title = new OwnLabel((CharSequence)TextUtils.breakCharacters(titleString, 45), this.skin, "hud-header");
            title.addListener((EventListener)new OwnTextTooltip(dataset.description, this.skin, 10));
            HorizontalGroup titleGroup = new HorizontalGroup();
            titleGroup.space(pad18);
            titleGroup.addActor((Actor)typeImage);
            titleGroup.addActor((Actor)title);
            OwnLabel status = null;
            if (mode == DatasetMode.AVAILABLE) {
                status = new OwnLabel((CharSequence)I18n.msg("gui.download.available"), this.skin, "mono");
            } else if (mode == DatasetMode.INSTALLED) {
                if (dataset.baseData || dType.equals("texture-pack")) {
                    status = new OwnLabel((CharSequence)I18n.msg("gui.download.enabled"), this.skin, "mono");
                } else if (dataset.minGsVersion > 3061001) {
                    status = new OwnLabel((CharSequence)I18n.msg("gui.download.version.gs.mismatch.short", Integer.toString(3061001), Integer.toString(dataset.minGsVersion)), this.skin, "mono");
                    status.setColor(ColorUtils.gRedC);
                } else {
                    List<String> currentSetting = Settings.settings.data.dataFiles;
                    boolean enabled = DatasetDownloadUtils.isPathIn(dataset.catalogFile.path(), currentSetting);
                    status = new OwnLabel((CharSequence)I18n.msg(enabled ? "gui.download.enabled" : "gui.download.disabled"), this.skin, "mono");
                }
            }
            String typeString = I18n.hasMessage("gui.download.type." + dType) ? I18n.msg("gui.download.type." + dType) : dType;
            OwnLabel type = new OwnLabel((CharSequence)I18n.msg("gui.download.type", typeString), this.skin, "grey-large");
            type.addListener((EventListener)new OwnTextTooltip(dType, this.skin, 10));
            OwnLabel version = null;
            if (mode == DatasetMode.AVAILABLE) {
                version = new OwnLabel((CharSequence)I18n.msg("gui.download.version.server", dataset.serverVersion), this.skin, "grey-large");
            } else if (mode == DatasetMode.INSTALLED) {
                if (dataset.outdated) {
                    version = new OwnLabel((CharSequence)I18n.msg("gui.download.version.new", Integer.toString(dataset.serverVersion), Integer.toString(dataset.myVersion)), this.skin, "grey-large");
                    version.setColor(this.highlight);
                } else {
                    version = new OwnLabel((CharSequence)I18n.msg("gui.download.version.local", dataset.myVersion), this.skin, "grey-large");
                }
            }
            OwnLabel key = new OwnLabel((CharSequence)I18n.msg("gui.download.name", dataset.key), this.skin, "grey-large");
            OwnLabel creator = new OwnLabel((CharSequence)I18n.msg("gui.download.creator", TextUtils.capString(dataset.creator, 70)), this.skin, "grey-large");
            OwnLabel size = new OwnLabel((CharSequence)I18n.msg("gui.download.size", dataset.size), this.skin, "grey-large");
            size.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.download.size.tooltip"), this.skin, 10));
            String nObjStr = dataset.nObjects > 0L ? I18n.msg("gui.dataset.nobjects", (int)dataset.nObjects) : I18n.msg("gui.dataset.nobjects.none");
            OwnLabel nObjects = new OwnLabel((CharSequence)nObjStr, this.skin, "grey-large");
            nObjects.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.download.nobjects.tooltip") + ": " + dataset.nObjectsStr, this.skin, 10));
            Table linksGroup = null;
            if (dataset.links != null) {
                linksGroup = new Table(this.skin);
                int i = 0;
                for (String link : dataset.links) {
                    if (link.isBlank()) continue;
                    String linkStr = link.replace("@mirror-url@", Settings.settings.program.url.dataMirror);
                    Link linkActor = new Link((CharSequence)TextUtils.breakCharacters(linkStr, 70, true), this.skin, link);
                    if (i > 0) {
                        linksGroup.row();
                    }
                    linksGroup.add((Actor)linkActor).left();
                    ++i;
                }
            }
            Table infoTable = new Table(this.skin);
            infoTable.align(10);
            String descriptionString = dataset.description;
            OwnLabel desc = new OwnLabel((CharSequence)TextUtils.breakCharacters(descriptionString, 70), this.skin);
            desc.setWidth(1000.0f);
            String releaseNotesString = dataset.releaseNotes;
            if (releaseNotesString == null || releaseNotesString.isBlank()) {
                releaseNotesString = "-";
            }
            releaseNotesString = TextUtils.breakCharacters(releaseNotesString, 70);
            OwnLabel releaseNotesTitle = new OwnLabel((CharSequence)I18n.msg("gui.download.releasenotes"), this.skin, "grey-large");
            OwnLabel releaseNotes = new OwnLabel((CharSequence)releaseNotesString, this.skin);
            releaseNotes.setWidth(1000.0f);
            String[] credits = dataset.credits;
            Table creditsContent = null;
            OwnLabel creditsTitle = null;
            if (credits != null && credits.length > 0) {
                creditsContent = new Table(this.skin);
                creditsTitle = new OwnLabel((CharSequence)I18n.msg("gui.download.credits"), this.skin, "grey-large");
                for (String c : credits) {
                    if (c == null || c.isEmpty()) continue;
                    creditsContent.add((CharSequence)"-").left().top().padRight(pad10);
                    creditsContent.add((Actor)new OwnLabel((CharSequence)TextUtils.breakCharacters(c, 70), this.skin)).left().row();
                }
            }
            OwnLabel filesTitle = new OwnLabel((CharSequence)I18n.msg("gui.download.files"), this.skin, "grey-large");
            if (dataset.files == null || dataset.files.length == 0) {
                filesString = "-";
            } else {
                filesString = TextUtils.arrayToStr(dataset.files, "", "", "\n");
                Object dataLocation = Settings.settings.data.location;
                if (!((String)dataLocation).endsWith(File.separator) && !((String)dataLocation).endsWith("/")) {
                    dataLocation = (String)dataLocation + "/";
                }
                filesString = filesString.replace((CharSequence)dataLocation, "$data/");
            }
            OwnLabel files = new OwnLabel((CharSequence)filesString, this.skin, "mono");
            String dataLocationNoteString = "$data/  =  " + Settings.settings.data.location;
            OwnLabel dataLocationNote = new OwnLabel((CharSequence)TextUtils.capString(dataLocationNoteString, 60), this.skin, "mono-pink");
            dataLocationNote.addListener((EventListener)new OwnTextTooltip(dataLocationNoteString, this.skin, 10));
            infoTable.add((Actor)desc).top().left().padBottom(pad34).row();
            infoTable.add((Actor)releaseNotesTitle).top().left().padBottom(pad18).row();
            infoTable.add((Actor)releaseNotes).top().left().padBottom(pad34).row();
            if (creditsContent != null) {
                infoTable.add((Actor)creditsTitle).top().left().padBottom(pad18).row();
                infoTable.add((Actor)creditsContent).top().left().padBottom(pad34).row();
            }
            infoTable.add((Actor)filesTitle).top().left().padBottom(pad18).row();
            infoTable.add((Actor)files).top().left().padBottom(pad34).row();
            infoTable.add((Actor)dataLocationNote).top().left();
            OwnScrollPane infoScroll = new OwnScrollPane((Actor)infoTable, this.skin, "minimalist-nobg");
            infoScroll.setScrollingDisabled(true, false);
            infoScroll.setExpand(true);
            infoScroll.setSmoothScrolling(false);
            infoScroll.setFadeScrollBars(false);
            infoScroll.setWidth(1050.0f);
            OwnTextIconButton cancelDownloadButton = null;
            if (this.currentDownloads.containsKey(dataset.key)) {
                Pair<DatasetDesc, Net.HttpRequest> pair = this.currentDownloads.get(dataset.key);
                final Net.HttpRequest request = pair.getSecond();
                cancelDownloadButton = new OwnTextIconButton(I18n.msg("gui.download.cancel"), this.skin, "quit");
                cancelDownloadButton.pad(14.4f);
                cancelDownloadButton.getLabel().setColor(1.0f, 0.0f, 0.0f, 1.0f);
                cancelDownloadButton.addListener((EventListener)new ChangeListener(this){

                    public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                        if (request != null) {
                            GaiaSky.postRunnable(() -> Gdx.net.cancelHttpRequest(request));
                        }
                    }
                });
            }
            rightTable.add((Actor)titleGroup).top().left().padBottom(pad10).padTop(pad34).row();
            rightTable.add((Actor)status).top().left().padLeft(pad18 * 3.0f).padBottom(pad34).row();
            rightTable.add((Actor)type).top().left().padBottom(pad10).row();
            rightTable.add((Actor)version).top().left().padBottom(pad10).row();
            rightTable.add((Actor)key).top().left().padBottom(pad10).row();
            if (dataset.creator != null) {
                rightTable.add((Actor)creator).top().left().padBottom(pad10).row();
            }
            rightTable.add((Actor)size).top().left().padBottom(pad10).row();
            rightTable.add((Actor)nObjects).top().left().padBottom(pad18).row();
            rightTable.add((Actor)linksGroup).top().left().padBottom(pad34 * 2.0f).row();
            rightTable.add((Actor)infoScroll).top().left().padBottom(pad34).row();
            rightTable.add((Actor)cancelDownloadButton).padTop(pad34).center();
            rightTable.pack();
            float maxScrollHeight = this.stage.getHeight() * 0.65f;
            OwnScrollPane scrollPane = new OwnScrollPane((Actor)rightTable, this.skin, "minimalist-nobg");
            scrollPane.setScrollingDisabled(true, false);
            scrollPane.setSmoothScrolling(false);
            scrollPane.setFadeScrollBars(false);
            scrollPane.setWidth(1050.0f);
            scrollPane.setHeight(Math.min(maxScrollHeight, rightTable.getHeight()));
            cell.setActor((Actor)scrollPane);
            cell.top().left();
            this.rightPaneWatcher = new DatasetWatcher(dataset, null, null, status, rightTable);
            this.watchers.add(this.rightPaneWatcher);
        }
    }

    public void refresh() {
        this.content.clear();
        this.build();
    }

    private void downloadDataset(DatasetDesc dataset) {
        this.downloadDataset(dataset, null);
    }

    private void downloadDataset(DatasetDesc dataset, Runnable successRunnable) {
        Path tempDir = SysUtils.getDataTempDir(Settings.settings.data.location);
        try {
            FileStore fileStore = Files.getFileStore(tempDir);
            if (dataset.sizeBytes > 0L && (double)dataset.sizeBytes + (double)dataset.sizeBytes * 1.5 >= (double)fileStore.getUsableSpace()) {
                String title = I18n.msg("gui.download.space.error.title");
                String msg = I18n.msg("gui.download.space.error", fileStore.toString());
                logger.error(msg);
                GuiUtils.addNotificationWindow(title, msg, this.skin, this.stage, null);
                return;
            }
        }
        catch (IOException e) {
            logger.warn("Error getting file store for temp dir: " + String.valueOf(tempDir));
        }
        String name = dataset.name;
        String url = dataset.file.replace("@mirror-url@", Settings.settings.program.url.dataMirror);
        String filename = FilenameUtils.getName((String)url);
        FileHandle tempDownload = Gdx.files.absolute(String.valueOf(tempDir) + "/" + filename + ".part");
        ProgressRunnable progressDownload = (read, total, progress, speed) -> {
            try {
                double readMb = (double)read / 1000000.0;
                double totalMb = (double)total / 1000000.0;
                String progressString = progress >= 100.0 ? I18n.msg("gui.done") : I18n.msg("gui.download.downloading", this.nf.format(progress));
                double mbPerSecond = speed / 1000.0;
                String speedString = this.nf.format(readMb) + "/" + this.nf.format(totalMb) + " MB (" + this.nf.format(mbPerSecond) + " MB/s)";
                GaiaSky.postRunnable(() -> EventManager.publish(gaiasky.event.Event.DATASET_DOWNLOAD_PROGRESS_INFO, (Object)this, dataset.key, Float.valueOf((float)progress), progressString, speedString));
            }
            catch (Exception e) {
                logger.warn(I18n.msg("gui.download.error.progress"));
            }
        };
        ProgressRunnable progressHashResume = (read, total, progress, speed) -> {
            double readMb = (double)read / 1000000.0;
            double totalMb = (double)total / 1000000.0;
            String progressString = progress >= 100.0 ? I18n.msg("gui.done") : I18n.msg("gui.download.checksum.check", this.nf.format(progress));
            double mbPerSecond = speed / 1000.0;
            String speedString = this.nf.format(readMb) + "/" + this.nf.format(totalMb) + " MB (" + this.nf.format(mbPerSecond) + " MB/s)";
            GaiaSky.postRunnable(() -> EventManager.publish(gaiasky.event.Event.DATASET_DOWNLOAD_PROGRESS_INFO, (Object)this, dataset.key, Float.valueOf((float)progress), progressString, speedString));
        };
        Consumer<String> finish = digest -> {
            String dataLocation;
            int errors;
            String errorMsg;
            block11: {
                errorMsg = null;
                errors = 0;
                logger.info(I18n.msg("gui.download.extracting", tempDownload.path()));
                dataLocation = Settings.settings.data.location + File.separatorChar;
                if (digest != null && dataset.sha256 != null) {
                    String serverDigest = dataset.sha256;
                    try {
                        boolean ok = serverDigest.equals(digest);
                        if (ok) {
                            logger.info(I18n.msg("gui.download.checksum.ok", name));
                            break block11;
                        }
                        logger.error(I18n.msg("gui.download.checksum.fail", name));
                        errorMsg = I18n.msg("gui.download.checksum.fail.msg");
                        ++errors;
                        EventManager.publish(gaiasky.event.Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.checksum.error", name), Float.valueOf(-1.0f));
                    }
                    catch (Exception e) {
                        logger.info(I18n.msg("gui.download.checksum.error", name));
                        errorMsg = I18n.msg("gui.download.checksum.fail.msg");
                        ++errors;
                        EventManager.publish(gaiasky.event.Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.checksum.error", name), Float.valueOf(-1.0f));
                    }
                } else {
                    logger.info(I18n.msg("gui.download.checksum.notfound", name));
                    EventManager.publish(gaiasky.event.Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.checksum.notfound", name), Float.valueOf(-1.0f));
                }
            }
            if (errors == 0) {
                try {
                    DatasetDownloadUtils.decompress(tempDownload.path(), new File(dataLocation), dataset);
                }
                catch (Exception e) {
                    logger.error(e, I18n.msg("gui.download.decompress.error", name));
                    errorMsg = I18n.msg("gui.download.decompress.error.msg");
                    ++errors;
                }
                finally {
                    DatasetDownloadUtils.cleanupTempFile(tempDownload.path());
                }
            }
            String errorMessage = errorMsg;
            int numErrors = errors;
            GaiaSky.postRunnable(() -> {
                this.currentDownloads.remove(dataset.key);
                if (numErrors == 0) {
                    EventManager.publish(gaiasky.event.Event.DATASET_DOWNLOAD_FINISH_INFO, (Object)this, dataset.key, 0);
                    dataset.exists = true;
                    this.actionEnableDataset(dataset, null);
                    if (successRunnable != null) {
                        successRunnable.run();
                    }
                    this.resetSelectedDataset();
                    EventManager.publish(gaiasky.event.Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.finished", name), Float.valueOf(-1.0f));
                    Timer.schedule((Timer.Task)new Timer.Task(){

                        public void run() {
                            DatasetManagerWindow.this.reloadAll();
                        }
                    }, (float)0.5f);
                } else {
                    logger.error(I18n.msg("gui.download.failed", name + " - " + url));
                    tempDownload.delete();
                    this.setStatusError(dataset, errorMessage);
                    this.currentDownloads.remove(dataset.key);
                    this.resetSelectedDataset();
                    EventManager.publish(gaiasky.event.Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.failed", name), Float.valueOf(-1.0f));
                    Timer.schedule((Timer.Task)new Timer.Task(){

                        public void run() {
                            DatasetManagerWindow.this.reloadAll();
                        }
                    }, (float)1.5f);
                }
            });
        };
        Runnable fail = () -> {
            logger.error(I18n.msg("gui.download.failed", name + " - " + url));
            tempDownload.delete();
            this.setStatusError(dataset);
            this.currentDownloads.remove(dataset.key);
            this.resetSelectedDataset();
            EventManager.publish(gaiasky.event.Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.failed", name), Float.valueOf(-1.0f));
            Timer.schedule((Timer.Task)new Timer.Task(){

                public void run() {
                    DatasetManagerWindow.this.reloadAll();
                }
            }, (float)1.5f);
        };
        Runnable cancel = () -> {
            logger.error(I18n.msg("gui.download.cancelled", name + " - " + url));
            this.setStatusCancelled(dataset);
            this.currentDownloads.remove(dataset.key);
            this.resetSelectedDataset();
            EventManager.publish(gaiasky.event.Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.download.cancelled", name), Float.valueOf(10.0f));
            Timer.schedule((Timer.Task)new Timer.Task(){

                public void run() {
                    DatasetManagerWindow.this.reloadAll();
                }
            }, (float)0.5f);
        };
        Net.HttpRequest request = DownloadHelper.downloadFile(url, tempDownload, Settings.settings.program.offlineMode, progressDownload, progressHashResume, finish, fail, cancel);
        GaiaSky.postRunnable(() -> EventManager.publish(gaiasky.event.Event.DATASET_DOWNLOAD_START_INFO, (Object)this, dataset.key, request));
        this.currentDownloads.put(dataset.key, new Pair<DatasetDesc, Net.HttpRequest>(dataset, request));
    }

    private void setStatusError(DatasetDesc ds) {
        this.setStatusError(ds, null);
    }

    private void setStatusError(DatasetDesc ds, String message) {
        if (message != null && !message.isEmpty()) {
            EventManager.publish(gaiasky.event.Event.DATASET_DOWNLOAD_FINISH_INFO, (Object)this, ds.key, 1, message);
        } else {
            EventManager.publish(gaiasky.event.Event.DATASET_DOWNLOAD_FINISH_INFO, (Object)this, ds.key, 1);
        }
    }

    private void setStatusCancelled(DatasetDesc ds) {
        EventManager.publish(gaiasky.event.Event.DATASET_DOWNLOAD_FINISH_INFO, (Object)this, ds.key, 2);
    }

    @Override
    protected boolean accept() {
        GenericDialog myself = this.me;
        final HashMap<String, Pair<DatasetDesc, Net.HttpRequest>> copy = new HashMap<String, Pair<DatasetDesc, Net.HttpRequest>>(this.currentDownloads);
        if (!copy.isEmpty()) {
            GenericDialog question = new GenericDialog(this, I18n.msg("gui.download.close.title"), this.skin, this.stage){
                final /* synthetic */ DatasetManagerWindow this$0;
                {
                    this.this$0 = this$0;
                    super(title, skin, stage);
                }

                @Override
                protected void build() {
                    this.content.clear();
                    this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.download.close", this.this$0.currentDownloads.size()), this.skin)).left().padBottom(pad34).row();
                    this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.download.close.current"), this.skin)).left().padBottom(pad18).row();
                    for (String key : copy.keySet()) {
                        DatasetDesc dd = (DatasetDesc)((Pair)copy.get(key)).getFirst();
                        this.content.add((Actor)new OwnLabel((CharSequence)dd.name, this.skin, "warp")).center().padBottom(pad10).row();
                    }
                }

                @Override
                protected boolean accept() {
                    Set keys = copy.keySet();
                    for (String key : keys) {
                        Net.HttpRequest request = (Net.HttpRequest)((Pair)copy.get(key)).getSecond();
                        Gdx.net.cancelHttpRequest(request);
                    }
                    if (this.acceptListener != null) {
                        this.acceptListener.run();
                    }
                    return true;
                }

                @Override
                protected void cancel() {
                }

                @Override
                public void dispose() {
                }
            };
            question.setAcceptText(I18n.msg("gui.yes"));
            question.setCancelText(I18n.msg("gui.no"));
            question.buildSuper();
            question.show(this.stage);
        } else {
            myself.hide();
        }
        return false;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }

    private void backupScrollValues() {
        if (this.leftScroll != null) {
            this.scroll[0][0] = this.leftScroll.getScrollX();
            this.scroll[0][1] = this.leftScroll.getScrollY();
        }
    }

    private void restoreScrollValues() {
        if (this.leftScroll != null) {
            GaiaSky.postRunnable(() -> {
                this.leftScroll.setScrollX(this.scroll[0][0]);
                this.leftScroll.setScrollY(this.scroll[0][1]);
            });
        }
    }

    @Override
    public void setKeyboardFocus() {
        Button button;
        if (this.stage != null && this.selectedDataset[this.selectedTab] != null && (button = this.buttonMap[this.selectedTab].get(this.selectedDataset[this.selectedTab].key)) != null) {
            this.stage.setKeyboardFocus((Actor)button);
        }
    }

    private void cleanWatchers() {
        for (DatasetWatcher watcher : this.watchers) {
            watcher.dispose();
        }
        this.watchers.clear();
        this.rightPaneWatcher = null;
    }

    private void reloadAll() {
        this.cleanWatchers();
        this.serverDd = DataDescriptorUtils.instance().buildServerDatasets(null);
        this.backupScrollValues();
        this.leftScroll = null;
        this.content.clear();
        this.build();
        this.pack();
        this.restoreScrollValues();
    }

    private void actionDownloadDataset(DatasetDesc dataset) {
        this.downloadDataset(dataset);
    }

    private void actionUpdateDataset(DatasetDesc dataset) {
        this.downloadDataset(dataset, () -> {
            dataset.outdated = false;
            if (dataset.server != null) {
                dataset.server.outdated = false;
                dataset.server.myVersion = dataset.server.serverVersion;
                dataset.myVersion = dataset.server.serverVersion;
                if (this.serverDd != null) {
                    this.serverDd.numUpdates = FastMath.max((int)(this.serverDd.numUpdates - 1), (int)0);
                    this.serverDd.updatesAvailable = this.serverDd.numUpdates > 0;
                }
            } else {
                dataset.myVersion = dataset.serverVersion;
            }
        });
    }

    private void actionEnableDataset(final DatasetDesc dataset, final OwnCheckBox cb) {
        if (dataset.type.equals("texture-pack")) {
            return;
        }
        String filePath = null;
        if (dataset.checkStr != null) {
            filePath = TextUtils.ensureStartsWith(dataset.checkStr, "$data/");
        }
        if (filePath != null && !filePath.isBlank() && !Settings.settings.data.dataFiles.contains(filePath)) {
            final Optional<String> opt = this.checkDatasetIncompatibilities(dataset);
            if (opt.isEmpty()) {
                Settings.settings.data.dataFiles.add(filePath);
            } else {
                if (cb != null) {
                    cb.setProgrammaticChangeEvents(false);
                    cb.setChecked(false);
                    cb.setProgrammaticChangeEvents(true);
                }
                final String path = filePath;
                GenericDialog question = new GenericDialog(this, I18n.msg("gui.download.incompatibility"), this.skin, this.stage){
                    final /* synthetic */ DatasetManagerWindow this$0;
                    {
                        this.this$0 = this$0;
                        super(title, skin, stage);
                    }

                    @Override
                    protected void build() {
                        this.content.clear();
                        Drawable warningIcon = this.skin.getDrawable("iconic-warning");
                        OwnImage warning = new OwnImage(warningIcon);
                        warning.setSize(38.0f, 38.0f);
                        warning.setColor(ColorUtils.gYellowC);
                        this.content.add((Actor)warning).left().padRight(pad20).padBottom(pad34);
                        this.content.add((Actor)new OwnLabel((CharSequence)TextUtils.breakCharacters((String)opt.get(), 60), this.skin)).left().padBottom(pad34).row();
                        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.download.incompatibility.proceed"), this.skin)).left().colspan(2).padBottom(pad18).row();
                    }

                    @Override
                    protected boolean accept() {
                        Settings.settings.data.dataFiles.add(path);
                        if (cb != null) {
                            cb.setProgrammaticChangeEvents(false);
                            cb.setChecked(true);
                            cb.setProgrammaticChangeEvents(true);
                            GaiaSky.postRunnable(() -> this.this$0.reloadRightPane(this.this$0.right, dataset, this.this$0.currentMode));
                        }
                        return true;
                    }

                    @Override
                    protected void cancel() {
                    }

                    @Override
                    public void dispose() {
                    }
                };
                question.setAcceptText(I18n.msg("gui.yes"));
                question.setCancelText(I18n.msg("gui.no"));
                question.buildSuper();
                question.show(this.stage);
            }
        }
    }

    private Optional<String> checkDatasetIncompatibilities(DatasetDesc dataset) {
        if (dataset.datasetType.typeStr.equalsIgnoreCase("catalog-lod")) {
            List<DatasetDesc> lodDatasets = dataset.datasetType.datasets;
            for (DatasetDesc lodDataset : lodDatasets) {
                if (lodDataset == dataset || !DatasetDownloadUtils.isEnabled(lodDataset)) continue;
                return Optional.of(I18n.msg("gui.download.incompatibility.lod"));
            }
        }
        if (dataset.datasetType.typeStr.equalsIgnoreCase("catalog-cluster")) {
            List<DatasetDesc> clusterDatasets = dataset.datasetType.datasets;
            for (DatasetDesc clusterDataset : clusterDatasets) {
                if (clusterDataset == dataset || !DatasetDownloadUtils.isEnabled(clusterDataset)) continue;
                return Optional.of(I18n.msg("gui.download.incompatibility.cluster"));
            }
        }
        if (dataset.datasetType.typeStr.equalsIgnoreCase("catalog-gal") && dataset.key.contains("sdss")) {
            List<DatasetDesc> galDatasets = dataset.datasetType.datasets;
            for (DatasetDesc sdssDataset : galDatasets) {
                if (!sdssDataset.key.contains("sdss") || sdssDataset == dataset || !DatasetDownloadUtils.isEnabled(sdssDataset)) continue;
                return Optional.of(I18n.msg("gui.download.incompatibility.sdss"));
            }
        }
        return Optional.empty();
    }

    private void actionDisableDataset(DatasetDesc dataset) {
        if (!dataset.baseData) {
            String filePath = null;
            if (dataset.checkStr != null) {
                filePath = TextUtils.ensureStartsWith(dataset.checkStr, "$data/");
            }
            if (filePath != null && !filePath.isBlank()) {
                Settings.settings.data.dataFiles.remove(filePath);
            }
        }
    }

    private void actionDeleteDataset(final DatasetDesc dataset) {
        GenericDialog question = new GenericDialog(this, I18n.msg("gui.download.delete.title"), this.skin, this.stage){
            final /* synthetic */ DatasetManagerWindow this$0;
            {
                this.this$0 = this$0;
                super(title, skin, stage);
            }

            @Override
            protected void build() {
                this.content.clear();
                String title = dataset.name;
                this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.download.delete.text"), this.skin)).left().padBottom(pad18 * 2.0f).row();
                this.content.add((Actor)new OwnLabel((CharSequence)title, this.skin, "warp")).center().padBottom(pad18 * 2.0f).row();
            }

            @Override
            protected boolean accept() {
                DatasetDesc serverDataset = this.this$0.serverDd != null ? this.this$0.serverDd.findDatasetByKey(dataset.key) : null;
                boolean deleted = false;
                if (dataset.files != null) {
                    for (String fileToDelete : dataset.files) {
                        try {
                            Path basePath;
                            if (fileToDelete.endsWith("/")) {
                                fileToDelete = fileToDelete.substring(0, fileToDelete.length() - 1);
                            }
                            String baseParent = "";
                            String baseName = fileToDelete;
                            if (fileToDelete.contains("/")) {
                                baseParent = fileToDelete.substring(0, fileToDelete.lastIndexOf(47));
                                baseName = fileToDelete.substring(fileToDelete.lastIndexOf(47) + 1);
                            }
                            Path dataPath = !(basePath = Path.of(baseParent, new String[0])).isAbsolute() ? Paths.get(Settings.settings.data.location, new String[0]).resolve(baseParent) : basePath;
                            File directory = dataPath.toRealPath(new LinkOption[0]).toFile();
                            Collection files = FileUtils.listFilesAndDirs((File)directory, (IOFileFilter)WildcardFileFilter.builder().setWildcards(new String[]{baseName}).get(), (IOFileFilter)WildcardFileFilter.builder().setWildcards(new String[]{baseName}).get());
                            for (File file : files) {
                                if (file.equals(directory) || !file.exists()) continue;
                                FileUtils.forceDelete((File)file);
                            }
                            deleted = true;
                        }
                        catch (Exception e) {
                            logger.error(e);
                        }
                    }
                } else if (dataset.checkPath != null) {
                    try {
                        FileUtils.forceDelete((File)dataset.checkPath.toFile());
                        deleted = true;
                    }
                    catch (IOException e) {
                        logger.error(e);
                    }
                }
                if (deleted && serverDataset != null) {
                    serverDataset.exists = false;
                    this.this$0.actionDisableDataset(dataset);
                    this.this$0.resetSelectedDataset();
                }
                GaiaSky.postRunnable(() -> this.this$0.reloadAll());
                return true;
            }

            @Override
            protected void cancel() {
            }

            @Override
            public void dispose() {
            }
        };
        question.setAcceptText(I18n.msg("gui.yes"));
        question.setCancelText(I18n.msg("gui.no"));
        question.buildSuper();
        question.show(this.stage);
    }

    private void resetSelectedDataset() {
        this.selectedDataset[0] = null;
        this.selectedDataset[1] = null;
        this.scroll[0][0] = 0.0f;
        this.scroll[0][1] = 0.0f;
        this.scroll[1][0] = 0.0f;
        this.scroll[1][1] = 0.0f;
    }

    private boolean up() {
        return this.up(0);
    }

    private boolean up(int recNum) {
        Disableable d;
        Actor actor;
        Pair<DatasetDesc, Actor> selection;
        if (recNum > 150) {
            return false;
        }
        --this.selectedIndex;
        if (this.selectedIndex < 0) {
            this.selectedIndex = this.selectionOrder.size() - 1;
        }
        if (!(selection = this.selectionOrder.get(this.selectedIndex)).getSecond().isDescendantOf((Actor)this.leftScroll) || (actor = selection.getSecond()) instanceof Disableable && (d = (Disableable)actor).isDisabled()) {
            return this.up(recNum + 1);
        }
        return this.updateSelection();
    }

    private boolean down() {
        return this.down(0);
    }

    private boolean down(int recNum) {
        Disableable d;
        Actor actor;
        if (recNum > 150) {
            return false;
        }
        this.selectedIndex = (this.selectedIndex + 1) % this.selectionOrder.size();
        Pair<DatasetDesc, Actor> selection = this.selectionOrder.get(this.selectedIndex);
        if (!selection.getSecond().isDescendantOf((Actor)this.leftScroll) || (actor = selection.getSecond()) instanceof Disableable && (d = (Disableable)actor).isDisabled()) {
            return this.down(recNum + 1);
        }
        return this.updateSelection();
    }

    private boolean updateSelection() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.selectionOrder.size()) {
            Pair<DatasetDesc, Actor> selection = this.selectionOrder.get(this.selectedIndex);
            Actor target = selection.getSecond();
            this.stage.setKeyboardFocus(target);
            if (selection.getFirst() != null) {
                while (!((target = target.getParent()) instanceof Button)) {
                }
            }
            Vector2 coordinates = target.localToAscendantCoordinates(this.leftScroll.getActor(), new Vector2(target.getX(), target.getY()));
            this.leftScroll.scrollTo(coordinates.x, coordinates.y, target.getWidth(), FastMath.min((float)200.0f, (float)(target.getHeight() * 10.0f)));
            if (selection.getFirst() != null) {
                GaiaSky.postRunnable(() -> this.reloadRightPane(this.right, (DatasetDesc)selection.getFirst(), this.currentMode));
                this.selectedDataset[this.currentMode.ordinal()] = selection.getFirst();
            }
            return true;
        }
        return false;
    }

    static {
        iconMap.put("other", "icon-elem-others");
        iconMap.put("data-pack", "icon-elem-others");
        iconMap.put("catalog-lod", "icon-elem-stars");
        iconMap.put("catalog-gaia", "icon-elem-stars");
        iconMap.put("catalog-star", "icon-elem-stars");
        iconMap.put("catalog-gal", "icon-elem-galaxies");
        iconMap.put("catalog-cluster", "icon-elem-clusters");
        iconMap.put("catalog-sso", "icon-elem-asteroids");
        iconMap.put("catalog-other", "icon-elem-others");
        iconMap.put("mesh", "icon-elem-meshes");
        iconMap.put("spacecraft", "icon-elem-satellites");
        iconMap.put("system", "iconic-target");
        iconMap.put("texture-pack", "icon-elem-moons");
        iconMap.put("virtualtex-pack", "iconic-image");
        iconMap.put("volume", "icon-elem-nebulae");
    }

    private class DatasetManagerKbdListener
    extends WindowKbdListener {
        public DatasetManagerKbdListener(GenericDialog dialog) {
            super(dialog);
        }

        @Override
        public boolean moveUp() {
            return DatasetManagerWindow.this.up();
        }

        @Override
        public boolean moveDown() {
            return DatasetManagerWindow.this.down();
        }
    }

    private class DatasetManagerGamepadListener
    extends WindowGamepadListener {
        public DatasetManagerGamepadListener(String mappingsFile) {
            super(mappingsFile, DatasetManagerWindow.this.me);
        }

        @Override
        public void moveUp() {
            DatasetManagerWindow.this.up();
        }

        @Override
        public void moveDown() {
            DatasetManagerWindow.this.down();
        }
    }

    private static enum DatasetMode {
        AVAILABLE,
        INSTALLED;

    }
}

