/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.datasets;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.gui.beans.StringIndexComobBoxBean;
import gaiasky.gui.beans.TransformComboBoxBean;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.AffineTransformations;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Mesh;
import gaiasky.scene.record.ITransform;
import gaiasky.scene.record.MatrixTransform;
import gaiasky.scene.record.RotateTransform;
import gaiasky.scene.record.ScaleTransform;
import gaiasky.scene.record.TranslateTransform;
import gaiasky.scene.system.initialize.MeshInitializer;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Constants;
import gaiasky.util.Logger;
import gaiasky.util.TextUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import gaiasky.util.validator.DoubleValidator;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;

public class DatasetTransformsWindow
extends GenericDialog {
    private static final Logger.Log logger = Logger.getLogger(DatasetTransformsWindow.class);
    private final CatalogInfo ci;
    private Table transformsTable;
    private AffineTransformations affine;
    private boolean transformsEdited;
    private final TransformComboBoxBean[] transformTypes = new TransformComboBoxBean[]{this.getBean("translation", TranslateTransform.class, 0), this.getBean("rotation", RotateTransform.class, 1), this.getBean("scaling", ScaleTransform.class, 2), this.getBean("refsys", MatrixTransform.class, 3)};
    private final StringIndexComobBoxBean[] refSysTypes = new StringIndexComobBoxBean[]{this.getStrBean("eqtogal", 0), this.getStrBean("galtoeq", 1), this.getStrBean("eqtoecl", 2), this.getStrBean("ecltoeq", 3), this.getStrBean("galtoecl", 4), this.getStrBean("ecltogal", 5)};

    public DatasetTransformsWindow(CatalogInfo ci, Skin skin, Stage stage) {
        super(I18n.msg("gui.dataset.transform") + " - " + ci.name, skin, stage);
        this.ci = ci;
        this.transformsEdited = false;
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.setModal(false);
        this.content.add().width(700.0f).row();
        this.content.getMinHeight();
        this.buildSuper();
    }

    private boolean hasAffine(Entity entity) {
        return Mapper.affine.has(entity);
    }

    private AffineTransformations getAffine(Entity entity) {
        if (Mapper.affine.has(entity)) {
            return (AffineTransformations)Mapper.affine.get(entity);
        }
        return null;
    }

    private void setAffine(Entity entity, Vector<ITransform> transformations) {
        if (Mapper.affine.has(entity)) {
            ((AffineTransformations)Mapper.affine.get(entity)).setTransformations(transformations);
            if (Mapper.mesh.has(entity)) {
                MeshInitializer.initializeCoordinateSystem(entity, (Mesh)Mapper.mesh.get(entity));
            }
            if (Mapper.graph.has(entity) && !Mapper.celestial.has(entity)) {
                GraphNode graph = (GraphNode)Mapper.graph.get(entity);
                if (graph.children != null && !graph.children.isEmpty()) {
                    for (Entity ch : graph.children) {
                        this.setAffine(ch, transformations);
                    }
                }
            }
        }
    }

    @Override
    protected void build() {
        if (this.hasAffine(this.ci.entity)) {
            this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform"), this.skin, "hud-header")).left().padBottom(pad18).padTop(pad20).row();
            this.content.add((Actor)new OwnLabel((CharSequence)TextUtils.breakCharacters(I18n.msg("gui.dataset.transform.info"), 55), this.skin, "default-scblue")).left().padBottom(pad18 * 2.0f).row();
            OwnTextIconButton addTransform = new OwnTextIconButton(I18n.msg("gui.dataset.transform.add"), this.skin, "add");
            addTransform.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.transform.add"), this.skin));
            addTransform.pad(pad18);
            this.content.add((Actor)addTransform).top().left().padBottom(pad34).row();
            addTransform.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    ((DatasetTransformsWindow)this.me).addTransform();
                    this.transformsEdited = true;
                    return true;
                }
                return false;
            });
            this.transformsTable = new Table(this.skin);
            this.transformsTable.top().left();
            OwnScrollPane scrollPane = new OwnScrollPane((Actor)this.transformsTable, this.skin, "minimalist-nobg");
            scrollPane.setScrollbarsVisible(true);
            scrollPane.setFadeScrollBars(false);
            scrollPane.setScrollingDisabled(true, false);
            scrollPane.setWidth(780.0f);
            scrollPane.setHeight(700.0f);
            this.content.add((Actor)scrollPane).top().left().row();
            this.affine = this.getAffine(this.ci.entity);
            if (this.affine != null) {
                this.affine = this.affine.deepCopy();
            }
            this.generateTransformationsTable(this.affine);
        }
    }

    private TransformComboBoxBean getBean(String type, Class<? extends ITransform> clss, int index) {
        return new TransformComboBoxBean(I18n.msg("gui.dataset.transform.op." + type), type, clss, index);
    }

    private StringIndexComobBoxBean getStrBean(String sht, int index) {
        return new StringIndexComobBoxBean(I18n.msg("gui.dataset.transform.refsys." + sht), sht, index);
    }

    private int getIndex(ITransform transform) {
        return switch (transform.getClass().getSimpleName()) {
            case "TranslateTransform" -> 0;
            case "RotateTransform" -> 1;
            case "ScaleTransform" -> 2;
            default -> 3;
        };
    }

    private void generateTransformationsTable(AffineTransformations affine) {
        float selectWidth = 350.0f;
        this.transformsTable.clearChildren();
        if (affine != null && !affine.isEmpty()) {
            int index = 0;
            for (ITransform transform : affine.transformations) {
                ITransform iTransform;
                Table table = new Table(this.skin);
                table.pad(pad34);
                table.setBackground("default-round");
                Table buttons = new Table(this.skin);
                OwnTextIconButton up = new OwnTextIconButton("", this.skin, "caret-up");
                up.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.transform.up"), this.skin));
                up.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        this.moveUp(transform);
                        this.transformsEdited = true;
                        return true;
                    }
                    return false;
                });
                OwnTextIconButton down = new OwnTextIconButton("", this.skin, "caret-down");
                down.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.transform.down"), this.skin));
                down.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        this.moveDown(transform);
                        this.transformsEdited = true;
                        return true;
                    }
                    return false;
                });
                OwnTextIconButton rubbish = new OwnTextIconButton("", this.skin, "rubbish");
                rubbish.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dataset.transform.remove"), this.skin));
                rubbish.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        this.deleteTransform(transform);
                        this.transformsEdited = true;
                        return true;
                    }
                    return false;
                });
                buttons.add((Actor)up).padRight(pad10);
                buttons.add((Actor)down).padRight(pad10);
                buttons.add((Actor)rubbish);
                int idx = index;
                OwnSelectBox type = new OwnSelectBox(this.skin, "big");
                type.setWidth(selectWidth);
                type.setItems(this.transformTypes);
                type.setSelectedIndex(this.getIndex(transform));
                type.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        TransformComboBoxBean bean = (TransformComboBoxBean)type.getSelected();
                        if (!transform.getClass().equals(bean.clazz())) {
                            GaiaSky.postRunnable(() -> {
                                try {
                                    affine.replace(bean.clazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), idx);
                                    this.generateTransformationsTable(affine);
                                }
                                catch (Exception e) {
                                    logger.error(e);
                                }
                                this.transformsEdited = true;
                            });
                        }
                    }
                    return false;
                });
                table.add((Actor)new OwnLabel((CharSequence)(index + 1 + ":"), this.skin, "hud-header")).top().left().padRight(pad20);
                table.add(type).top().left().expandX().padRight(pad18);
                table.add((Actor)buttons).top().right().padBottom(pad10).row();
                table.add((Actor)new Separator(this.skin, "small")).colspan(3).width(700.0f).top().center().row();
                Table transformTable = new Table(this.skin);
                table.add((Actor)transformTable).colspan(3).width(700.0f).padTop(pad20);
                DoubleValidator tValidator = new DoubleValidator(-1.0E10, 1.0E10);
                DoubleValidator aValidator = new DoubleValidator(-100.0, 100.0);
                DoubleValidator angleValidator = new DoubleValidator(-360.0, 360.0);
                DoubleValidator sValidator = new DoubleValidator(-1000000.0, 1000000.0);
                Objects.requireNonNull(transform);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TranslateTransform.class, RotateTransform.class, ScaleTransform.class, MatrixTransform.class}, (Object)iTransform, n)) {
                    case 0: {
                        double[] dArray;
                        TranslateTransform tr = (TranslateTransform)iTransform;
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.translate.x"), this.skin)).center().padRight(pad10).padBottom(pad10);
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.translate.y"), this.skin)).center().padRight(pad10).padBottom(pad10);
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.translate.z"), this.skin)).center().padBottom(pad10).row();
                        if (tr.getVector() != null) {
                            dArray = tr.getVector();
                        } else {
                            double[] dArray2 = new double[3];
                            dArray2[0] = 0.0;
                            dArray2[1] = 0.0;
                            dArray = dArray2;
                            dArray2[2] = 0.0;
                        }
                        double[] translationIn = dArray;
                        OwnTextField x = new OwnTextField(Double.toString(translationIn[0] * Constants.U_TO_PC), this.skin, tValidator);
                        x.setWidth(220.0f);
                        OwnTextField y = new OwnTextField(Double.toString(translationIn[1] * Constants.U_TO_PC), this.skin, tValidator);
                        y.setWidth(220.0f);
                        OwnTextField z = new OwnTextField(Double.toString(translationIn[2] * Constants.U_TO_PC), this.skin, tValidator);
                        z.setWidth(220.0f);
                        transformTable.add((Actor)x).center().padRight(pad10);
                        transformTable.add((Actor)y).center().padRight(pad10);
                        transformTable.add((Actor)z).center();
                        EventListener el = event -> {
                            if (event instanceof ChangeListener.ChangeEvent) {
                                double[] translation = new double[3];
                                if (x.isValid()) {
                                    translation[0] = x.getDoubleValue(0.0) * Constants.PC_TO_U;
                                    this.transformsEdited = true;
                                }
                                if (y.isValid()) {
                                    translation[1] = y.getDoubleValue(0.0) * Constants.PC_TO_U;
                                    this.transformsEdited = true;
                                }
                                if (z.isValid()) {
                                    translation[2] = z.getDoubleValue(0.0) * Constants.PC_TO_U;
                                    this.transformsEdited = true;
                                }
                                if (this.transformsEdited) {
                                    tr.setVector(translation);
                                }
                                return true;
                            }
                            return false;
                        };
                        x.addListener(el);
                        y.addListener(el);
                        z.addListener(el);
                        break;
                    }
                    case 1: {
                        double[] dArray;
                        RotateTransform tr = (RotateTransform)iTransform;
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.rotate.axis.x"), this.skin)).center().padRight(pad10).padBottom(pad10);
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.rotate.axis.y"), this.skin)).center().padRight(pad10).padBottom(pad10);
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.rotate.axis.z"), this.skin)).center().padRight(pad20).padBottom(pad10);
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.rotate.angle"), this.skin)).center().padBottom(pad10).row();
                        if (tr.getAxis() != null) {
                            dArray = tr.getAxis();
                        } else {
                            double[] dArray3 = new double[3];
                            dArray3[0] = 1.0;
                            dArray3[1] = 0.0;
                            dArray = dArray3;
                            dArray3[2] = 0.0;
                        }
                        double[] axisIn = dArray;
                        OwnTextField x = new OwnTextField(Double.toString(axisIn[0]), this.skin, aValidator);
                        OwnTextField y = new OwnTextField(Double.toString(axisIn[1]), this.skin, aValidator);
                        OwnTextField z = new OwnTextField(Double.toString(axisIn[2]), this.skin, aValidator);
                        OwnTextField angle = new OwnTextField(Double.toString(tr.getAngle()), this.skin, angleValidator);
                        transformTable.add((Actor)x).center().padRight(pad10);
                        transformTable.add((Actor)y).center().padRight(pad10);
                        transformTable.add((Actor)z).center().padRight(pad20);
                        transformTable.add((Actor)angle).center();
                        EventListener el = event -> {
                            if (event instanceof ChangeListener.ChangeEvent) {
                                double[] axis = new double[3];
                                double angleDeg = 0.0;
                                if (x.isValid()) {
                                    axis[0] = x.getDoubleValue(0.0);
                                    this.transformsEdited = true;
                                }
                                if (y.isValid()) {
                                    axis[1] = y.getDoubleValue(0.0);
                                    this.transformsEdited = true;
                                }
                                if (z.isValid()) {
                                    axis[2] = z.getDoubleValue(0.0);
                                    this.transformsEdited = true;
                                }
                                if (angle.isValid()) {
                                    angleDeg = angle.getDoubleValue(0.0);
                                    this.transformsEdited = true;
                                }
                                if (this.transformsEdited) {
                                    tr.setAxis(axis);
                                    tr.setAngle(angleDeg);
                                }
                                return true;
                            }
                            return false;
                        };
                        x.addListener(el);
                        y.addListener(el);
                        z.addListener(el);
                        angle.addListener(el);
                        break;
                    }
                    case 2: {
                        double[] dArray;
                        ScaleTransform tr = (ScaleTransform)iTransform;
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.scale.x"), this.skin)).center().padRight(pad10).padBottom(pad10);
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.scale.y"), this.skin)).center().padRight(pad10).padBottom(pad10);
                        transformTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.scale.z"), this.skin)).center().padBottom(pad10).row();
                        if (tr.getScale() != null) {
                            dArray = tr.getScale();
                        } else {
                            double[] dArray4 = new double[3];
                            dArray4[0] = 1.0;
                            dArray4[1] = 1.0;
                            dArray = dArray4;
                            dArray4[2] = 1.0;
                        }
                        double[] scaleIn = dArray;
                        OwnTextField x = new OwnTextField(Double.toString(scaleIn[0]), this.skin, sValidator);
                        OwnTextField y = new OwnTextField(Double.toString(scaleIn[1]), this.skin, sValidator);
                        OwnTextField z = new OwnTextField(Double.toString(scaleIn[2]), this.skin, sValidator);
                        transformTable.add((Actor)x).center().padRight(pad10);
                        transformTable.add((Actor)y).center().padRight(pad10);
                        transformTable.add((Actor)z).center();
                        EventListener el = event -> {
                            if (event instanceof ChangeListener.ChangeEvent) {
                                double[] scale = new double[3];
                                if (x.isValid()) {
                                    scale[0] = x.getDoubleValue(0.0);
                                    this.transformsEdited = true;
                                }
                                if (y.isValid()) {
                                    scale[1] = y.getDoubleValue(0.0);
                                    this.transformsEdited = true;
                                }
                                if (z.isValid()) {
                                    scale[2] = z.getDoubleValue(0.0);
                                    this.transformsEdited = true;
                                }
                                if (this.transformsEdited) {
                                    tr.setScale(scale);
                                }
                                return true;
                            }
                            return false;
                        };
                        x.addListener(el);
                        y.addListener(el);
                        z.addListener(el);
                        break;
                    }
                    case 3: {
                        MatrixTransform tr = (MatrixTransform)iTransform;
                        OwnSelectBox refSysTransforms = new OwnSelectBox(this.skin);
                        refSysTransforms.setWidth(selectWidth);
                        refSysTransforms.setItems(this.refSysTypes);
                        if (!tr.isEmpty()) {
                            Matrix4D matrix = tr.getMatDouble();
                            int refSysIndex = this.findRefSysTransformIndex(matrix);
                            if (refSysIndex >= 0) {
                                refSysTransforms.setSelectedIndex(refSysIndex);
                            }
                        } else {
                            refSysTransforms.setSelectedIndex(0);
                            tr.setMatrix(Coordinates.getTransformD(this.refSysTypes[0].value));
                        }
                        transformTable.add(refSysTransforms).center().padRight(pad10);
                        refSysTransforms.addListener(event -> {
                            if (event instanceof ChangeListener.ChangeEvent) {
                                StringIndexComobBoxBean bean = (StringIndexComobBoxBean)refSysTransforms.getSelected();
                                Matrix4D newMatrix = Coordinates.getTransformD(bean.value);
                                tr.setMatrix(newMatrix);
                                this.transformsEdited = true;
                                return true;
                            }
                            return false;
                        });
                        break;
                    }
                }
                this.transformsTable.add((Actor)table).row();
                ++index;
            }
        } else {
            this.transformsTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.transform.no"), this.skin)).left().padBottom(pad18).row();
        }
        this.pack();
    }

    private int findRefSysTransformIndex(Matrix4D matrix) {
        Map<String, Matrix4D> map = Coordinates.getMap();
        for (String key : map.keySet()) {
            if (key.length() >= 10) continue;
            Matrix4D mat = map.get(key);
            if (!Arrays.equals(mat.val, matrix.val)) continue;
            for (StringIndexComobBoxBean refSys : this.refSysTypes) {
                if (!refSys.value.equalsIgnoreCase(key)) continue;
                return refSys.index;
            }
        }
        return -1;
    }

    private void addTransform() {
        this.affine.setTranslate(new double[]{0.0, 0.0, 0.0});
        GaiaSky.postRunnable(() -> this.generateTransformationsTable(this.affine));
    }

    private void deleteTransform(ITransform transform) {
        boolean removed;
        if (this.affine != null && transform != null && (removed = this.affine.transformations.remove(transform))) {
            GaiaSky.postRunnable(() -> this.generateTransformationsTable(this.affine));
        }
    }

    private void moveUp(ITransform transform) {
        boolean removed;
        int currentIndex;
        if (this.affine != null && transform != null && (currentIndex = this.affine.transformations.indexOf(transform)) > 0 && (removed = this.affine.transformations.remove(transform))) {
            this.affine.transformations.insertElementAt(transform, currentIndex - 1);
            GaiaSky.postRunnable(() -> this.generateTransformationsTable(this.affine));
        }
    }

    private void moveDown(ITransform transform) {
        boolean removed;
        int currentIndex;
        if (this.affine != null && transform != null && (currentIndex = this.affine.transformations.indexOf(transform)) < this.affine.transformations.size() - 1 && (removed = this.affine.transformations.remove(transform))) {
            this.affine.transformations.insertElementAt(transform, currentIndex + 1);
            GaiaSky.postRunnable(() -> this.generateTransformationsTable(this.affine));
        }
    }

    @Override
    protected boolean accept() {
        if (this.transformsEdited) {
            if (this.hasAffine(this.ci.entity)) {
                this.setAffine(this.ci.entity, this.affine.transformations);
            } else {
                throw new RuntimeException("No affine component found.");
            }
        }
        return true;
    }

    @Override
    protected void cancel() {
    }

    @Override
    public void dispose() {
    }
}

