/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.datasets;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.window.GenericDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.component.Fade;
import gaiasky.scene.component.GraphNode;
import gaiasky.scene.component.Highlight;
import gaiasky.scene.component.ParticleSet;
import gaiasky.util.CatalogInfo;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector2D;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextArea;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.validator.FloatValidator;
import gaiasky.util.validator.TextFieldComparatorValidator;
import java.text.DecimalFormat;

public class DatasetVisualSettingsWindow
extends GenericDialog
implements IObserver {
    private final CatalogInfo ci;
    private OwnTextField highlightSizeFactor;
    private OwnTextField fadeInMin;
    private OwnTextField fadeInMax;
    private OwnTextField fadeOutMin;
    private OwnTextField fadeOutMax;
    private OwnCheckBox allVisible;
    private OwnCheckBox fadeIn;
    private OwnCheckBox fadeOut;
    private OwnSliderPlus pointSize;
    private OwnSliderPlus minSolidAngle;
    private OwnSliderPlus maxSolidAngle;
    private final float taWidth;
    private final float sliderWidth;
    private double backupMinSolidAngle;
    private double backupMaxSolidAngle;

    public DatasetVisualSettingsWindow(CatalogInfo ci, Skin skin, Stage stage) {
        super(I18n.msg("gui.dataset.visuals") + " - " + ci.name, skin, stage);
        this.ci = ci;
        this.taWidth = 800.0f;
        this.sliderWidth = 800.0f;
        this.setAcceptText(I18n.msg("gui.ok"));
        this.setCancelText(I18n.msg("gui.cancel"));
        this.setModal(false);
        this.buildSuper();
        EventManager.instance.subscribe((IObserver)this, Event.CATALOG_POINT_SIZE_SCALING_CMD);
    }

    @Override
    protected void build() {
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.particleaspect"), this.skin, "hud-header")).left().colspan(2).padBottom(pad18).row();
        this.pointSize = new OwnSliderPlus(I18n.msg("gui.dataset.size"), 0.1f, 5.0f, 0.01f, this.skin);
        this.pointSize.setWidth(this.sliderWidth);
        if (this.ci.entity != null) {
            GraphNode graph = (GraphNode)Mapper.graph.get(this.ci.entity);
            Highlight hl = (Highlight)Mapper.highlight.get(this.ci.entity);
            if (hl != null) {
                float pointScaling = graph.parent != null && Mapper.octree.has(graph.parent) ? ((Highlight)Mapper.highlight.get((Entity)graph.parent)).pointscaling * hl.pointscaling : hl.pointscaling;
                this.pointSize.setMappedValue(pointScaling);
            }
        }
        this.pointSize.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                double val = this.pointSize.getMappedValue();
                EventManager.publish(Event.CATALOG_POINT_SIZE_SCALING_CMD, (Object)this.pointSize, this.ci.name, val);
                return true;
            }
            return false;
        });
        this.content.add((Actor)this.pointSize).colspan(2).left().top().padBottom(pad18).row();
        if (this.ci.isParticleSet() && !this.ci.isStarSet()) {
            this.addMinMaxSolidAngle(this.content);
        }
        this.content.padBottom(pad20).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.highlight"), this.skin, "hud-header")).left().colspan(2).padTop(pad34).row();
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.highlight.info"), this.skin, "default-scblue")).left().colspan(2).padTop(pad20).padBottom(pad18 * 2.0f).row();
        FloatValidator pointSizeValidator = new FloatValidator(0.01f, 100.0f);
        this.highlightSizeFactor = new OwnTextField(Float.toString(this.ci.hlSizeFactor), this.skin, pointSizeValidator);
        this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.dataset.highlight.size"), this.skin)).left().padRight(pad18).padBottom(pad20);
        this.content.add((Actor)this.highlightSizeFactor).left().padRight(pad18).padBottom(pad18).row();
        this.allVisible = new OwnCheckBox(I18n.msg("gui.dataset.highlight.allvisible"), this.skin, pad18);
        this.allVisible.setChecked(this.ci.hlAllVisible);
        this.content.add((Actor)this.allVisible).left().colspan(2).padBottom(pad18 * 2.0f).row();
        this.addFadeAttributes(this.content);
    }

    private void addMinMaxSolidAngle(Table container) {
        ParticleSet set = (ParticleSet)Mapper.particleSet.get(this.ci.entity);
        this.backupMinSolidAngle = set.particleSizeLimits[0];
        this.backupMaxSolidAngle = set.particleSizeLimits[1];
        this.minSolidAngle = new OwnSliderPlus(I18n.msg("gui.dsload.solidangle.min"), 0.0f, 0.01f, 1.0E-4f, false, this.skin);
        this.minSolidAngle.setName("min solid angle");
        this.minSolidAngle.setWidth(this.sliderWidth);
        this.minSolidAngle.setValue((float)set.particleSizeLimits[0]);
        this.minSolidAngle.setNumberFormatter(new DecimalFormat("####0.####"));
        this.minSolidAngle.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                set.particleSizeLimits[0] = this.minSolidAngle.getValue();
                return true;
            }
            return false;
        });
        container.add((Actor)this.minSolidAngle).top().left().colspan(2).left().padBottom(pad18).row();
        this.maxSolidAngle = new OwnSliderPlus(I18n.msg("gui.dsload.solidangle.max"), 0.01f, 0.1f, 1.0E-4f, false, this.skin);
        this.maxSolidAngle.setName("max solid angle");
        this.maxSolidAngle.setWidth(this.sliderWidth);
        this.maxSolidAngle.setValue((float)set.particleSizeLimits[1]);
        this.maxSolidAngle.setNumberFormatter(new DecimalFormat("####0.####"));
        this.maxSolidAngle.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                set.particleSizeLimits[1] = this.maxSolidAngle.getValue();
                return true;
            }
            return false;
        });
        container.add((Actor)this.maxSolidAngle).top().left().colspan(2).left().padBottom(pad18).row();
    }

    private void addFadeAttributes(Table container) {
        float tfw = 220.0f;
        OwnLabel fadeLabel = new OwnLabel((CharSequence)I18n.msg("gui.dsload.fade"), this.skin, "hud-header");
        container.add((Actor)fadeLabel).colspan(2).left().padTop(pad20).padBottom(pad20).row();
        String ssInfoStr = I18n.msg("gui.dsload.fade.info") + "\n";
        int ssLines = GlobalResources.countOccurrences(ssInfoStr, '\n');
        OwnTextArea fadeInfo = new OwnTextArea(ssInfoStr, this.skin, "info");
        fadeInfo.setDisabled(true);
        fadeInfo.setPrefRows(ssLines + 1);
        fadeInfo.setWidth(this.taWidth);
        fadeInfo.clearListeners();
        container.add((Actor)fadeInfo).colspan(2).left().padBottom(pad18).row();
        this.fadeIn = new OwnCheckBox(I18n.msg("gui.dsload.fade.in"), this.skin, pad10);
        Vector2D fi = this.ci.entity != null ? ((Fade)Mapper.fade.get((Entity)this.ci.entity)).fadeIn : null;
        container.add((Actor)this.fadeIn).left().padRight(pad18).padBottom(pad10);
        HorizontalGroup fadeInGroup = new HorizontalGroup();
        fadeInGroup.space(pad10);
        this.fadeInMin = new OwnTextField(fi != null ? String.format("%.14f", fi.x * Constants.U_TO_PC) : "0", this.skin);
        this.fadeInMin.setWidth(tfw);
        this.fadeInMax = new OwnTextField(fi != null ? String.format("%.14f", fi.y * Constants.U_TO_PC) : "1", this.skin);
        this.fadeInMax.setWidth(tfw);
        fadeInGroup.addActor((Actor)new OwnLabel((CharSequence)"[", this.skin));
        fadeInGroup.addActor((Actor)this.fadeInMin);
        fadeInGroup.addActor((Actor)new OwnLabel((CharSequence)", ", this.skin));
        fadeInGroup.addActor((Actor)this.fadeInMax);
        fadeInGroup.addActor((Actor)new OwnLabel((CharSequence)("] " + I18n.msg("gui.unit.pc")), this.skin));
        this.fadeIn.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                boolean disable = !this.fadeIn.isChecked();
                for (Actor child : fadeInGroup.getChildren()) {
                    if (child instanceof OwnLabel) {
                        ((OwnLabel)child).setDisabled(disable);
                        continue;
                    }
                    if (!(child instanceof OwnTextField)) continue;
                    ((OwnTextField)child).setDisabled(disable);
                }
                return true;
            }
            return false;
        });
        this.fadeIn.setChecked(fi == null);
        this.fadeIn.setProgrammaticChangeEvents(true);
        this.fadeIn.setChecked(fi != null);
        container.add((Actor)fadeInGroup).left().padBottom(pad10).row();
        this.fadeOut = new OwnCheckBox(I18n.msg("gui.dsload.fade.out"), this.skin, pad10);
        Vector2D fo = this.ci.entity != null ? ((Fade)Mapper.fade.get((Entity)this.ci.entity)).fadeOut : null;
        container.add((Actor)this.fadeOut).left().padRight(pad18).padBottom(pad10);
        HorizontalGroup fadeOutGroup = new HorizontalGroup();
        fadeOutGroup.space(pad10);
        this.fadeOutMin = new OwnTextField(fo != null ? String.format("%.10f", fo.x * Constants.U_TO_PC) : "5000", this.skin);
        this.fadeOutMin.setWidth(tfw);
        this.fadeOutMax = new OwnTextField(fo != null ? String.format("%.10f", fo.y * Constants.U_TO_PC) : "10000", this.skin);
        this.fadeOutMax.setWidth(tfw);
        fadeOutGroup.addActor((Actor)new OwnLabel((CharSequence)"[", this.skin));
        fadeOutGroup.addActor((Actor)this.fadeOutMin);
        fadeOutGroup.addActor((Actor)new OwnLabel((CharSequence)", ", this.skin));
        fadeOutGroup.addActor((Actor)this.fadeOutMax);
        fadeOutGroup.addActor((Actor)new OwnLabel((CharSequence)("] " + I18n.msg("gui.unit.pc")), this.skin));
        this.fadeOut.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                boolean disable = !this.fadeOut.isChecked();
                for (Actor child : fadeOutGroup.getChildren()) {
                    if (child instanceof OwnLabel) {
                        ((OwnLabel)child).setDisabled(disable);
                        continue;
                    }
                    if (!(child instanceof OwnTextField)) continue;
                    ((OwnTextField)child).setDisabled(disable);
                }
                return true;
            }
            return false;
        });
        this.fadeOut.setChecked(fo == null);
        this.fadeOut.setProgrammaticChangeEvents(true);
        this.fadeOut.setChecked(fo != null);
        FloatValidator fadeVal = new FloatValidator(0.0f, 1.0E10f);
        TextFieldComparatorValidator fadeInMinVal = new TextFieldComparatorValidator(fadeVal, new OwnTextField[]{this.fadeInMax, this.fadeOutMin, this.fadeOutMax}, null);
        TextFieldComparatorValidator fadeInMaxVal = new TextFieldComparatorValidator(fadeVal, new OwnTextField[]{this.fadeOutMin, this.fadeOutMax}, new OwnTextField[]{this.fadeInMin});
        TextFieldComparatorValidator fadeOutMinVal = new TextFieldComparatorValidator(fadeVal, new OwnTextField[]{this.fadeOutMax}, new OwnTextField[]{this.fadeInMin, this.fadeInMax});
        TextFieldComparatorValidator fadeOutMaxVal = new TextFieldComparatorValidator(fadeVal, null, new OwnTextField[]{this.fadeInMin, this.fadeInMax, this.fadeOutMin});
        this.fadeInMin.setValidator(fadeInMinVal);
        this.fadeInMax.setValidator(fadeInMaxVal);
        this.fadeOutMin.setValidator(fadeOutMinVal);
        this.fadeOutMax.setValidator(fadeOutMaxVal);
        container.add((Actor)fadeOutGroup).left().padBottom(pad10).row();
    }

    @Override
    protected boolean accept() {
        boolean vis;
        float newVal;
        if (this.highlightSizeFactor.isValid() && (newVal = Parser.parseFloat(this.highlightSizeFactor.getText())) != this.ci.hlSizeFactor) {
            this.ci.setHlSizeFactor(newVal);
        }
        if ((vis = this.allVisible.isChecked()) != this.ci.hlAllVisible) {
            this.ci.setHlAllVisible(vis);
        }
        if (this.ci.entity != null) {
            Fade fade = (Fade)Mapper.fade.get(this.ci.entity);
            if (this.fadeIn.isChecked()) {
                fade.setFadein(new double[]{this.fadeInMin.getDoubleValue(0.0), this.fadeInMax.getDoubleValue(10.0)});
                if (fade.fadeInMap == null) {
                    fade.setFadeInMap(new double[]{0.0, 1.0});
                }
            } else {
                fade.setFadein(null);
            }
            if (this.fadeOut.isChecked()) {
                fade.setFadeout(new double[]{this.fadeOutMin.getDoubleValue(100000.0), this.fadeOutMax.getDoubleValue(1000000.0)});
                if (fade.fadeOutMap == null) {
                    fade.setFadeOutMap(new double[]{1.0, 0.0});
                }
            } else {
                fade.setFadeout(null);
            }
        }
        return true;
    }

    @Override
    protected void cancel() {
        if (this.ci.isParticleSet() && !this.ci.isStarSet()) {
            ParticleSet set = (ParticleSet)Mapper.particleSet.get(this.ci.entity);
            set.particleSizeLimits[0] = this.backupMinSolidAngle;
            set.particleSizeLimits[1] = this.backupMaxSolidAngle;
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (this.isVisible() && this.pointSize != null && source != this.pointSize && event == Event.CATALOG_POINT_SIZE_SCALING_CMD) {
            double val = (Double)data[1];
            OwnSliderPlus slider = this.pointSize;
            slider.setProgrammaticChangeEvents(false);
            slider.setMappedValue(val);
            slider.setProgrammaticChangeEvents(true);
        }
    }
}

