/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.datasets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.util.datadesc.DatasetDesc;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnProgressBar;
import gaiasky.util.scene2d.OwnTextIconButton;

public class DatasetWatcher
implements IObserver {
    private final DatasetDesc dataset;
    private final OwnProgressBar progress;
    private final OwnTextIconButton button;
    private final OwnLabel status;
    private final Table table;
    private final Runnable success;

    public DatasetWatcher(DatasetDesc dataset, OwnProgressBar progress, OwnTextIconButton button, OwnLabel status, Table table, Runnable success) {
        this.dataset = dataset;
        this.progress = progress;
        this.button = button;
        this.status = status;
        this.table = table;
        this.success = success;
        EventManager.instance.subscribe((IObserver)this, Event.DATASET_DOWNLOAD_START_INFO, Event.DATASET_DOWNLOAD_FINISH_INFO, Event.DATASET_DOWNLOAD_PROGRESS_INFO);
    }

    public DatasetWatcher(DatasetDesc dataset, OwnProgressBar progress, OwnTextIconButton button, OwnLabel status, Table table) {
        this(dataset, progress, button, status, table, null);
    }

    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        Object object;
        if (data.length > 0 && (object = data[0]) instanceof String) {
            String key = (String)object;
            if (this.dataset.key != null && this.dataset.key.equals(key)) {
                switch (event) {
                    case DATASET_DOWNLOAD_START_INFO: {
                        if (this.progress != null) {
                            this.progress.setVisible(true);
                            this.progress.setValue(0.0f);
                        }
                        if (this.button != null) {
                            this.button.setDisabled(true);
                        }
                        if (this.status != null) {
                            this.status.setText(I18n.msg("gui.download.starting", this.dataset.name));
                        }
                        if (data.length <= 1 || this.table == null) break;
                        final Net.HttpRequest request = (Net.HttpRequest)data[1];
                        Skin skin = GaiaSky.instance.getGlobalResources().getSkin();
                        OwnTextIconButton cancelDownloadButton = new OwnTextIconButton(I18n.msg("gui.download.cancel"), skin, "quit");
                        cancelDownloadButton.pad(14.4f);
                        cancelDownloadButton.getLabel().setColor(1.0f, 0.0f, 0.0f, 1.0f);
                        cancelDownloadButton.addListener((EventListener)new ChangeListener(this){

                            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                                if (request != null) {
                                    GaiaSky.postRunnable(() -> Gdx.net.cancelHttpRequest(request));
                                }
                            }
                        });
                        this.table.row();
                        this.table.add((Actor)cancelDownloadButton).padTop(20.0f).center();
                        break;
                    }
                    case DATASET_DOWNLOAD_FINISH_INFO: {
                        String messageKey;
                        int status = (Integer)data[1];
                        switch (status) {
                            case 0: {
                                String string = "gui.download.status.found";
                                break;
                            }
                            case 1: {
                                String string = "gui.download.status.failed";
                                break;
                            }
                            case 2: {
                                String string = "gui.download.status.cancelled";
                                break;
                            }
                            case 3: {
                                String string = "gui.download.status.notfound";
                                break;
                            }
                            default: {
                                String string = messageKey = "gui.download.status.working";
                            }
                        }
                        if (this.status != null) {
                            if (data.length > 2 && data[2] != null) {
                                this.status.setText(I18n.msg(messageKey) + " " + String.valueOf(data[2]));
                            } else {
                                this.status.setText(I18n.msg(messageKey));
                            }
                        }
                        if (this.success == null) break;
                        this.success.run();
                        break;
                    }
                    case DATASET_DOWNLOAD_PROGRESS_INFO: {
                        float progress = ((Float)data[1]).floatValue();
                        String status = (String)data[2];
                        String speed = (String)data[3];
                        if (this.progress != null) {
                            this.progress.setVisible(true);
                            this.progress.setValue(progress);
                        }
                        if (this.status == null) break;
                        Object statusStr = status;
                        if (speed != null) {
                            statusStr = (String)statusStr + "  " + speed;
                        }
                        this.status.setText((CharSequence)statusStr);
                    }
                }
            }
        }
    }
}

