/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.gui.util.ExternalInformationUpdater;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.api.IVisibilitySwitch;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.component.Cluster;
import gaiasky.scene.component.Trajectory;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.coord.AbstractOrbitCoordinates;
import gaiasky.util.coord.AstroUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.coord.IBodyCoordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.text.DecimalFormat;
import java.util.Locale;

public class CameraInfoInterface
extends TableGuiInterface
implements IObserver {
    private static final int MAX_RULER_NAME_LEN = 9;
    private final FocusView view;
    private final Table focusInfo;
    private final Table moreInfo;
    private final Table rulerInfo;
    private final Table focusNames;
    private final Table content;
    private final Cell<Table> contentCell;
    private final Cell<?> focusInfoCell;
    private final Cell<?> rulerCell;
    private final Vector3D pos;
    private final Vector3Q posQ;
    protected Skin skin;
    protected OwnLabel focusName;
    protected OwnLabel focusType;
    protected OwnLabel focusId;
    protected OwnLabel focusRA;
    protected OwnLabel focusDEC;
    protected OwnLabel focusMuAlpha;
    protected OwnLabel focusMuDelta;
    protected OwnLabel focusRadVel;
    protected OwnLabel focusAngle;
    protected OwnLabel focusDistCam;
    protected OwnLabel focusDistSol;
    protected OwnLabel focusAppMagEarth;
    protected OwnLabel focusAppMagCamera;
    protected OwnLabel focusAbsMag;
    protected OwnLabel focusRadiusSpt;
    protected OwnLabel focusTEff;
    protected OwnLabel radiusSptLabel;
    protected OwnLabel tEffLabel;
    protected Button goTo;
    protected Button landOn;
    protected Button landAt;
    protected Button bookmark;
    protected Button refreshOrbit;
    protected Button proceduralGeneration;
    protected OwnImageButton objectVisibility;
    protected OwnImageButton labelVisibility;
    protected OwnLabel pointerName;
    protected OwnLabel pointerLonLat;
    protected OwnLabel pointerRADEC;
    protected OwnLabel viewRADEC;
    protected OwnLabel camName;
    protected OwnLabel camVel;
    protected OwnLabel camTracking;
    protected OwnLabel camDistSol;
    protected OwnLabel lonLatLabel;
    protected OwnLabel RADECPointerLabel;
    protected OwnLabel RADECViewLabel;
    protected OwnLabel appMagEarthLabel;
    protected OwnLabel appMagCameraLabel;
    protected OwnLabel absMagLabel;
    protected OwnLabel rulerName;
    protected OwnLabel rulerName0;
    protected OwnLabel rulerName1;
    protected OwnLabel rulerDist;
    protected HorizontalGroup focusActionsGroup;
    protected IFocus currentFocus;
    DecimalFormat nf;
    float pad1;
    float pad3;
    float pad5;
    float pad10;
    float pad15;
    float bw;
    private ExternalInformationUpdater externalInfoUpdater;
    private boolean maximized;
    private EventListener lastRefreshListener = null;

    public CameraInfoInterface(Skin skin) {
        this(skin, false);
    }

    public CameraInfoInterface(Skin skin, boolean vr) {
        super(skin);
        this.setBackground("bg-pane");
        this.maximized = true;
        this.skin = skin;
        this.content = new Table(skin);
        float width = 300.0f;
        this.nf = new DecimalFormat("##0.##");
        this.view = new FocusView();
        this.pad15 = 24.0f;
        this.pad10 = 16.0f;
        this.pad5 = 8.0f;
        this.pad3 = 4.8f;
        this.pad1 = 1.6f;
        this.bw = 41.0f;
        this.focusInfo = new Table();
        Table cameraInfo = new Table();
        Table pointerInfo = new Table();
        this.moreInfo = new Table();
        this.rulerInfo = new Table();
        this.focusName = new OwnLabel((CharSequence)"", skin, "hud-header");
        this.focusType = new OwnLabel((CharSequence)"", skin, "hud-subheader");
        this.focusId = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusNames = new Table(skin);
        this.focusRA = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusDEC = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusMuAlpha = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusMuDelta = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusRadVel = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusAppMagEarth = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusAppMagCamera = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusAbsMag = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusAngle = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusDistSol = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusDistCam = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusRadiusSpt = new OwnLabel((CharSequence)"", skin, "hud");
        this.focusTEff = new OwnLabel((CharSequence)"", skin, "hud");
        this.appMagEarthLabel = new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.appmag.earth"), skin, "hud");
        this.appMagCameraLabel = new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.appmag.camera"), skin, "hud");
        this.absMagLabel = new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.absmag"), skin, "hud");
        float pointerWidth = 100.0f;
        this.pointerName = new OwnLabel((CharSequence)I18n.msg("gui.pointer"), skin, "hud-header");
        this.pointerRADEC = new OwnLabel((CharSequence)"", skin, "hud");
        this.pointerRADEC.setWidth(pointerWidth);
        this.pointerLonLat = new OwnLabel((CharSequence)"", skin, "hud");
        this.pointerLonLat.setWidth(pointerWidth);
        this.viewRADEC = new OwnLabel((CharSequence)"", skin, "hud");
        this.viewRADEC.setWidth(pointerWidth);
        float labelWidth = 80.0f;
        this.lonLatLabel = new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.latlon"), skin, "hud");
        this.lonLatLabel.setWidth(labelWidth);
        this.RADECPointerLabel = new OwnLabel((CharSequence)(I18n.msg("gui.focusinfo.alpha") + "/" + I18n.msg("gui.focusinfo.delta")), skin, "hud");
        this.RADECPointerLabel.setWidth(labelWidth);
        this.RADECViewLabel = new OwnLabel((CharSequence)(I18n.msg("gui.focusinfo.alpha") + "/" + I18n.msg("gui.focusinfo.delta")), skin, "hud");
        this.RADECViewLabel.setWidth(labelWidth);
        OwnTextIconButton pointerImgBtn1 = new OwnTextIconButton("", skin, "pointer");
        pointerImgBtn1.setSize(this.bw, this.bw);
        pointerImgBtn1.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.pointer"), skin));
        OwnTextIconButton pointerImgBtn2 = new OwnTextIconButton("", skin, "pointer");
        pointerImgBtn2.setSize(this.bw, this.bw);
        pointerImgBtn2.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.pointer"), skin));
        OwnTextIconButton viewImgBtn = new OwnTextIconButton("", skin, "eye");
        viewImgBtn.setSize(this.bw, this.bw);
        viewImgBtn.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.view"), skin));
        this.camName = new OwnLabel((CharSequence)I18n.msg("gui.camera"), skin, "hud-header");
        this.camTracking = new OwnLabel((CharSequence)"-", skin, "hud");
        this.camVel = new OwnLabel((CharSequence)"", skin, "hud");
        this.camDistSol = new OwnLabel((CharSequence)"", skin, "hud");
        this.rulerName = new OwnLabel((CharSequence)I18n.msg("gui.ruler.title"), skin, "hud-header");
        this.rulerName0 = new OwnLabel((CharSequence)"-", skin, "hud");
        this.rulerName1 = new OwnLabel((CharSequence)"-", skin, "hud");
        HorizontalGroup rulerNameGroup = new HorizontalGroup();
        rulerNameGroup.space(this.pad5);
        rulerNameGroup.addActor((Actor)this.rulerName0);
        rulerNameGroup.addActor((Actor)new OwnLabel((CharSequence)"<-->", skin, "hud"));
        rulerNameGroup.addActor((Actor)this.rulerName1);
        this.rulerDist = new OwnLabel((CharSequence)"-", skin, "hud");
        this.bookmark = new OwnImageButton(skin, "bookmark");
        this.bookmark.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.bookmark"), skin));
        this.bookmark.addListener(event -> {
            if (this.currentFocus != null && event instanceof ChangeListener.ChangeEvent) {
                if (this.bookmark.isChecked()) {
                    EventManager.publish(Event.BOOKMARKS_ADD, this.bookmark, this.currentFocus.getName(), false);
                } else {
                    EventManager.publish(Event.BOOKMARKS_REMOVE_ALL, this.bookmark, this.currentFocus.getName());
                }
            }
            return false;
        });
        this.goTo = new OwnTextIconButton("", skin, "go-to");
        this.goTo.addListener(event -> {
            if (this.currentFocus != null && event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.NAVIGATE_TO_OBJECT, this.goTo, this.currentFocus);
                return true;
            }
            return false;
        });
        this.goTo.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.goto"), skin));
        this.landOn = new OwnTextIconButton("", skin, "land-on");
        this.landOn.addListener(event -> {
            if (this.currentFocus != null && event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.LAND_ON_OBJECT, this.landOn, this.currentFocus);
                return true;
            }
            return false;
        });
        this.landOn.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.landon"), skin));
        this.landAt = new OwnTextIconButton("", skin, "land-at");
        this.landAt.addListener(event -> {
            if (this.currentFocus != null && event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_LAND_AT_LOCATION_CMD, this.landAt, this.currentFocus);
                return true;
            }
            return false;
        });
        this.landAt.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.landat"), skin));
        this.refreshOrbit = new OwnTextIconButton("", skin, "reload");
        this.proceduralGeneration = new OwnTextIconButton("", skin, "fork");
        this.proceduralGeneration.addListener(event -> {
            FocusView view = (FocusView)this.currentFocus;
            if (this.currentFocus != null && Mapper.atmosphere.has(view.getEntity()) && event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_PROCEDURAL_GEN_CMD, this.proceduralGeneration, this.currentFocus);
                return true;
            }
            return false;
        });
        this.proceduralGeneration.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.ui.procedural"), skin));
        this.objectVisibility = new OwnImageButton(skin, "eye-toggle");
        this.objectVisibility.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.PER_OBJECT_VISIBILITY_CMD, (Object)this.objectVisibility, this.currentFocus, this.currentFocus.getName(), !this.objectVisibility.isChecked());
                return true;
            }
            return false;
        });
        this.labelVisibility = new OwnImageButton(skin, "label-toggle");
        this.labelVisibility.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.FORCE_OBJECT_LABEL_CMD, (Object)this.labelVisibility, this.currentFocus, this.currentFocus.getName(), !this.labelVisibility.isChecked());
                return true;
            }
            return false;
        });
        this.goTo.setSize(this.bw, this.bw);
        this.landOn.setSize(this.bw, this.bw);
        this.landAt.setSize(this.bw, this.bw);
        this.refreshOrbit.setSize(this.bw, this.bw);
        this.proceduralGeneration.setSize(this.bw, this.bw);
        this.focusActionsGroup = new HorizontalGroup();
        this.focusActionsGroup.space(this.pad5);
        this.focusActionsGroup.addActor((Actor)this.objectVisibility);
        this.focusActionsGroup.addActor((Actor)this.labelVisibility);
        this.focusActionsGroup.addActor((Actor)this.bookmark);
        this.focusActionsGroup.addActor((Actor)this.goTo);
        this.focusActionsGroup.addActor((Actor)this.landOn);
        this.focusActionsGroup.addActor((Actor)this.landAt);
        this.focusActionsGroup.addActor((Actor)this.refreshOrbit);
        this.focusActionsGroup.addActor((Actor)this.proceduralGeneration);
        float w = 170.0f;
        this.focusId.setWidth(w);
        this.focusRA.setWidth(w);
        this.focusDEC.setWidth(w);
        this.focusMuAlpha.setWidth(w);
        this.focusMuDelta.setWidth(w);
        this.focusRadVel.setWidth(w);
        this.focusAngle.setWidth(w);
        this.focusDistSol.setWidth(w);
        this.focusDistCam.setWidth(w);
        this.camTracking.setWidth(w);
        this.camVel.setWidth(w);
        this.focusInfo.add((Actor)this.focusName).width(width).left().colspan(2).padBottom(this.pad5).row();
        this.focusInfo.add((Actor)this.focusActionsGroup).width(width).left().colspan(2).padBottom(this.pad5).row();
        this.focusInfo.add((Actor)this.focusType).left().padBottom(this.pad5).colspan(2).row();
        this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.id"), skin, "hud")).left();
        this.focusInfo.add((Actor)this.focusId).left().padLeft(this.pad15).row();
        this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.names"), skin, "hud")).left().padBottom(this.pad5);
        this.focusInfo.add((Actor)this.focusNames).left().padBottom(this.pad5).padLeft(this.pad15).row();
        if (!vr) {
            this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.alpha"), skin, "hud")).left();
            this.focusInfo.add((Actor)this.focusRA).left().padLeft(this.pad15).row();
            this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.delta"), skin, "hud")).left();
            this.focusInfo.add((Actor)this.focusDEC).left().padLeft(this.pad15).row();
            this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.mualpha"), skin, "hud")).left();
            this.focusInfo.add((Actor)this.focusMuAlpha).left().padLeft(this.pad15).row();
            this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.mudelta"), skin, "hud")).left();
            this.focusInfo.add((Actor)this.focusMuDelta).left().padLeft(this.pad15).row();
            this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.radvel"), skin, "hud")).left();
            this.focusInfo.add((Actor)this.focusRadVel).left().padLeft(this.pad15).row();
            this.focusInfo.add((Actor)this.appMagEarthLabel).left();
            this.focusInfo.add((Actor)this.focusAppMagEarth).left().padLeft(this.pad15).row();
            this.focusInfo.add((Actor)this.appMagCameraLabel).left();
            this.focusInfo.add((Actor)this.focusAppMagCamera).left().padLeft(this.pad15).row();
            this.focusInfo.add((Actor)this.absMagLabel).left();
            this.focusInfo.add((Actor)this.focusAbsMag).left().padLeft(this.pad15).row();
        }
        this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.angle"), skin, "hud")).left();
        this.focusInfo.add((Actor)this.focusAngle).left().padLeft(this.pad15).row();
        this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.distance.sol"), skin, "hud")).left();
        this.focusInfo.add((Actor)this.focusDistSol).left().padLeft(this.pad15).row();
        this.focusInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.distance.cam"), skin, "hud")).left();
        this.focusInfo.add((Actor)this.focusDistCam).left().padLeft(this.pad15).row();
        this.radiusSptLabel = new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.radius"), skin, "hud");
        this.focusInfo.add((Actor)this.radiusSptLabel).left();
        this.focusInfo.add((Actor)this.focusRadiusSpt).left().padLeft(this.pad15).row();
        this.tEffLabel = new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.teff"), skin, "hud");
        this.focusInfo.add((Actor)this.tEffLabel).left();
        this.focusInfo.add((Actor)this.focusTEff).left().padLeft(this.pad15).row();
        this.focusInfo.add((Actor)this.moreInfo).left().colspan(2).padBottom(this.pad10);
        if (!vr) {
            pointerInfo.add((Actor)this.pointerName).width(width).left().colspan(3).row();
            pointerInfo.add((Actor)pointerImgBtn1).left().padRight(this.pad3);
            pointerInfo.add((Actor)this.RADECPointerLabel).left();
            pointerInfo.add((Actor)this.pointerRADEC).expandX().left().padLeft(this.pad5).row();
            pointerInfo.add((Actor)pointerImgBtn2).left().padRight(this.pad3);
            pointerInfo.add((Actor)this.lonLatLabel).left();
            pointerInfo.add((Actor)this.pointerLonLat).expandX().left().padLeft(this.pad5).row();
            pointerInfo.add((Actor)viewImgBtn).left().padRight(this.pad3).padBottom(this.pad10);
            pointerInfo.add((Actor)this.RADECViewLabel).left();
            pointerInfo.add((Actor)this.viewRADEC).expandX().left().padLeft(this.pad5).padBottom(this.pad10);
        }
        cameraInfo.add((Actor)this.camName).width(width).left().colspan(2).row();
        cameraInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.camera.track"), skin, "hud")).left();
        cameraInfo.add((Actor)this.camTracking).left().padLeft(this.pad15).row();
        cameraInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.camera.vel"), skin, "hud")).left();
        cameraInfo.add((Actor)this.camVel).left().padLeft(this.pad15).row();
        cameraInfo.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.focusinfo.distance.sol"), skin, "hud")).left();
        cameraInfo.add((Actor)this.camDistSol).left().padLeft(this.pad15);
        this.rulerInfo.add((Actor)this.rulerName).left().row();
        this.rulerInfo.add((Actor)rulerNameGroup).left().row();
        this.rulerInfo.add((Actor)this.rulerDist).left();
        final Link toggleSize = new Link((CharSequence)(this.maximized ? "(-)" : "(+)"), skin, null);
        final OwnTextTooltip toggleSizeTooltip = new OwnTextTooltip(I18n.msg("gui.minimize.pane"), skin);
        toggleSize.addListener((EventListener)toggleSizeTooltip);
        toggleSize.addListener((EventListener)new ClickListener(this){
            final /* synthetic */ CameraInfoInterface this$0;
            {
                this.this$0 = this$0;
            }

            public void clicked(InputEvent event, float x, float y) {
                if (this.this$0.maximized) {
                    this.this$0.maximized = false;
                    this.this$0.content.addAction((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.run(() -> {
                        this.this$0.contentCell.setActor(null);
                        toggleSize.setText("(+)");
                        toggleSizeTooltip.setText(I18n.msg("gui.maximize.pane"));
                    })));
                } else {
                    this.this$0.maximized = true;
                    this.this$0.contentCell.setActor((Actor)this.this$0.content);
                    this.this$0.content.addAction((Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.run(() -> {
                        toggleSize.setText("(-)");
                        toggleSizeTooltip.setText(I18n.msg("gui.minimize.pane"));
                    })));
                }
                this.this$0.pack();
            }
        });
        this.focusInfoCell = this.content.add((Actor)this.focusInfo).left();
        this.content.row();
        this.content.add((Actor)pointerInfo).left();
        this.content.row();
        this.content.add((Actor)cameraInfo).left();
        this.content.row();
        this.rulerCell = this.content.add((Actor)this.rulerInfo).left();
        this.contentCell = this.maximized ? this.add((Actor)this.content) : this.add();
        this.row();
        this.add((Actor)toggleSize).right().pad(this.pad5).row();
        this.pack();
        this.rulerCell.clearActor();
        if (!vr) {
            this.externalInfoUpdater = new ExternalInformationUpdater();
            this.externalInfoUpdater.setParameters(this.moreInfo, skin, this.pad10);
        }
        this.pos = new Vector3D();
        this.posQ = new Vector3Q();
        EventManager.instance.subscribe((IObserver)this, Event.FOCUS_CHANGED, Event.FOCUS_INFO_UPDATED, Event.CAMERA_MOTION_UPDATE, Event.CAMERA_TRACKING_OBJECT_UPDATE, Event.CAMERA_MODE_CMD, Event.LON_LAT_UPDATED, Event.RA_DEC_UPDATED, Event.RULER_ATTACH_0, Event.RULER_ATTACH_1, Event.RULER_CLEAR, Event.RULER_DIST, Event.PER_OBJECT_VISIBILITY_CMD, Event.FORCE_OBJECT_LABEL_CMD);
    }

    private void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        String deg = I18n.msg("gui.unit.deg");
        Settings settings = Settings.settings;
        switch (event) {
            case FOCUS_CHANGED: {
                Entity orbitEntity;
                Trajectory trajectory;
                AbstractOrbitCoordinates aoc;
                IBodyCoordinates iBodyCoordinates;
                Entity entity;
                gaiasky.scene.component.Coordinates coordinates;
                if (data[0] instanceof String) {
                    Entity entity2 = GaiaSky.instance.scene.getEntity((String)data[0]);
                    this.view.setEntity(entity2);
                } else {
                    FocusView v = (FocusView)data[0];
                    this.view.setEntity(v.getEntity());
                }
                this.currentFocus = this.view;
                int focusFieldMaxLength = 14;
                Object id = "";
                if (this.view.getExtra() != null || this.view.getStarSet() != null) {
                    if (this.view.getId() > 0L) {
                        id = String.valueOf(this.view.getId());
                    } else if (this.view.getHip() > 0) {
                        id = "HIP " + this.view.getHip();
                    }
                }
                if (((String)id).isEmpty()) {
                    id = "-";
                }
                String idString = TextUtils.capString((String)id, 14);
                boolean vis = Mapper.atmosphere.has(this.view.getEntity());
                this.focusActionsGroup.removeActor((Actor)this.landOn);
                this.focusActionsGroup.removeActor((Actor)this.landAt);
                this.focusActionsGroup.removeActor((Actor)this.proceduralGeneration);
                if (vis) {
                    this.focusActionsGroup.addActor((Actor)this.landOn);
                    this.focusActionsGroup.addActor((Actor)this.landAt);
                    this.focusActionsGroup.addActor((Actor)this.proceduralGeneration);
                }
                this.focusActionsGroup.removeActor((Actor)this.refreshOrbit);
                if (this.lastRefreshListener != null) {
                    this.refreshOrbit.removeListener(this.lastRefreshListener);
                    this.lastRefreshListener = null;
                }
                if ((coordinates = (gaiasky.scene.component.Coordinates)Mapper.coordinates.get(entity = this.view.getEntity())) != null && (iBodyCoordinates = coordinates.coordinates) instanceof AbstractOrbitCoordinates && (aoc = (AbstractOrbitCoordinates)iBodyCoordinates).getOrbitName() != null && (trajectory = (Trajectory)Mapper.trajectory.get(orbitEntity = GaiaSky.instance.scene.getEntity(aoc.getOrbitName()))) != null && trajectory.mustRefresh) {
                    this.focusActionsGroup.addActor((Actor)this.refreshOrbit);
                    this.lastRefreshListener = evt -> {
                        if (evt instanceof ChangeListener.ChangeEvent) {
                            GaiaSky.postRunnable(() -> EventManager.publish(Event.ORBIT_REFRESH_CMD, this.refreshOrbit, orbitEntity));
                            return true;
                        }
                        return false;
                    };
                    this.refreshOrbit.addListener(this.lastRefreshListener);
                    this.refreshOrbit.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.refreshorbit"), this.skin));
                }
                try {
                    this.focusType.setText(I18n.msg("element." + ComponentTypes.ComponentType.values()[this.view.getCt().getFirstOrdinal()].toString().toLowerCase(Locale.ROOT) + ".singular"));
                }
                catch (Exception e) {
                    this.focusType.setText("");
                }
                this.pointerLonLat.setText("-/-");
                this.bookmark.setProgrammaticChangeEvents(false);
                this.bookmark.setChecked(GaiaSky.instance.getBookmarksManager().containsName(this.currentFocus.getName()));
                this.bookmark.setProgrammaticChangeEvents(true);
                this.objectVisibility.setCheckedNoFire(!((IVisibilitySwitch)((Object)this.currentFocus)).isVisible(true));
                this.objectVisibility.addListener((EventListener)new OwnTextTooltip(I18n.msg("action.visibility", this.currentFocus.getName()), this.skin));
                this.labelVisibility.setCheckedNoFire(!this.currentFocus.isForceLabel(this.currentFocus.getName()));
                this.labelVisibility.addListener((EventListener)new OwnTextTooltip(I18n.msg("action.forcelabel", this.currentFocus.getName()), this.skin));
                this.focusId.setText(idString);
                this.focusId.clearListeners();
                this.focusId.addListener((EventListener)new OwnTextTooltip((String)id, this.skin));
                String objectName = TextUtils.capString(this.view.getLocalizedName(), 14);
                this.focusName.setText(objectName);
                this.focusName.clearListeners();
                this.focusName.addListener((EventListener)new OwnTextTooltip(this.view.getLocalizedName(), this.skin));
                this.focusNames.clearChildren();
                String[] names = this.view.getNames();
                if (names != null && names.length > 0) {
                    int chars = 0;
                    HorizontalGroup currGroup = new HorizontalGroup();
                    for (int i = 0; i < names.length; ++i) {
                        String name = names[i];
                        String nameCapped = TextUtils.capString(name, 14);
                        OwnLabel nl = new OwnLabel((CharSequence)nameCapped, this.skin, "object-name");
                        if (nameCapped.length() != name.length()) {
                            nl.addListener((EventListener)new OwnTextTooltip(name, this.skin));
                        }
                        currGroup.addActor((Actor)nl);
                        chars += nameCapped.length() + 1;
                        if (i < names.length - 1) {
                            currGroup.addActor((Actor)new OwnLabel((CharSequence)", ", this.skin));
                            ++chars;
                        }
                        if (i >= names.length - 1 || chars <= 14) continue;
                        this.focusNames.add((Actor)currGroup).left().row();
                        currGroup = new HorizontalGroup();
                        chars = 0;
                    }
                    if (chars > 0) {
                        this.focusNames.add((Actor)currGroup).left();
                    }
                } else {
                    this.focusNames.add((Actor)new OwnLabel((CharSequence)"-", this.skin));
                }
                Vector2D posSph = this.view.getPosSph();
                if (posSph != null && posSph.len() > 0.0) {
                    this.focusRA.setText(this.nf.format(posSph.x) + deg);
                    this.focusDEC.setText(this.nf.format(posSph.y) + deg);
                } else {
                    Coordinates.cartesianToSpherical(this.view.getAbsolutePosition(this.posQ), this.pos);
                    this.focusRA.setText(this.nf.format(57.29577951308232 * this.pos.x % 360.0) + deg);
                    this.focusDEC.setText(this.nf.format(57.29577951308232 * this.pos.y % 360.0) + deg);
                }
                if (this.view.hasProperMotion()) {
                    this.focusMuAlpha.setText(this.nf.format(this.view.getMuAlpha()) + " " + I18n.msg("gui.unit.masyr"));
                    this.focusMuDelta.setText(this.nf.format(this.view.getMuDelta()) + " " + I18n.msg("gui.unit.masyr"));
                    double rv = this.view.getRadialVelocity();
                    if (Double.isFinite(rv)) {
                        this.focusRadVel.setText(this.nf.format(this.view.getRadialVelocity()) + " " + I18n.msg("gui.unit.kms"));
                    } else {
                        this.focusRadVel.setText(I18n.msg("gui.focusinfo.na"));
                    }
                } else {
                    this.focusMuAlpha.setText("-");
                    this.focusMuDelta.setText("-");
                    this.focusRadVel.setText("-");
                }
                if (this.view.isCluster()) {
                    Cluster cluster = (Cluster)Mapper.cluster.get(this.view.getEntity());
                    if (cluster.numStars > 0) {
                        this.appMagEarthLabel.setText("# " + I18n.msg("element.stars"));
                        this.focusAppMagEarth.setText(Integer.toString(cluster.numStars));
                    } else {
                        this.appMagEarthLabel.setText("");
                        this.focusAppMagEarth.setText("");
                    }
                    this.focusAppMagCamera.setText("");
                    this.appMagCameraLabel.setText("");
                    this.focusAbsMag.setText("");
                    this.absMagLabel.setText("");
                } else if (this.view.isCelestial()) {
                    this.appMagEarthLabel.setText(I18n.msg("gui.focusinfo.appmag.earth"));
                    float appMag = this.view.getAppmag();
                    String appMagStr = Float.isFinite(appMag) ? this.nf.format(appMag) : "-";
                    this.focusAppMagEarth.setText(appMagStr);
                    this.appMagCameraLabel.setText(I18n.msg("gui.focusinfo.appmag.camera"));
                    this.absMagLabel.setText(I18n.msg("gui.focusinfo.absmag"));
                    this.focusAbsMag.setText(this.nf.format(this.view.getAbsmag()));
                    this.appMagEarthLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.appmag.earth.tooltip"), this.skin));
                    this.focusAppMagEarth.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.appmag.earth.tooltip"), this.skin));
                    this.appMagCameraLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.appmag.camera.tooltip"), this.skin));
                    this.focusAppMagCamera.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.appmag.camera.tooltip"), this.skin));
                    this.absMagLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.absmag.tooltip"), this.skin));
                    this.focusAbsMag.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.absmag.tooltip"), this.skin));
                } else {
                    this.appMagEarthLabel.setText(I18n.msg("gui.focusinfo.appmag.earth"));
                    float appMag = this.view.getAppmag();
                    this.focusAppMagEarth.setText(this.nf.format(appMag));
                    this.appMagCameraLabel.setText(I18n.msg("gui.focusinfo.appmag.camera"));
                    this.absMagLabel.setText(I18n.msg("gui.focusinfo.absmag"));
                    this.focusAbsMag.setText(this.nf.format(this.view.getAbsmag()));
                    this.appMagEarthLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.appmag.earth.tooltip"), this.skin));
                    this.focusAppMagEarth.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.appmag.earth.tooltip"), this.skin));
                    this.appMagCameraLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.appmag.camera.tooltip"), this.skin));
                    this.focusAppMagCamera.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.appmag.camera.tooltip"), this.skin));
                    this.absMagLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.absmag.tooltip"), this.skin));
                    this.focusAbsMag.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.focusinfo.absmag.tooltip"), this.skin));
                }
                if (ComponentTypes.ComponentType.values()[this.view.getCt().getFirstOrdinal()] == ComponentTypes.ComponentType.Stars) {
                    this.tEffLabel.setVisible(true);
                    this.focusTEff.setVisible(true);
                    this.radiusSptLabel.setText(I18n.msg("gui.focusinfo.sptype"));
                    double tEff = this.view.getTEff();
                    if (Double.isFinite(tEff) && tEff > 0.0) {
                        this.focusTEff.setText(GlobalResources.formatNumber(tEff) + " " + I18n.msg("gui.unit.kelvin"));
                        this.focusRadiusSpt.setText(AstroUtils.getSpectralType((float)tEff));
                    } else {
                        this.focusRadiusSpt.setText("?");
                        this.focusTEff.setText("?");
                    }
                } else {
                    this.radiusSptLabel.setText(I18n.msg("gui.focusinfo.radius"));
                    Pair<Double, String> rad = GlobalResources.doubleToDistanceString(this.view.getRadius(), settings.program.ui.distanceUnits);
                    this.focusRadiusSpt.setText(GlobalResources.formatNumber(Math.max(0.0, rad.getFirst())) + " " + rad.getSecond());
                    this.tEffLabel.setVisible(false);
                    this.focusTEff.setVisible(false);
                }
                this.moreInfo.clear();
                if (this.externalInfoUpdater == null) break;
                this.externalInfoUpdater.update(this.view);
                break;
            }
            case FOCUS_INFO_UPDATED: {
                this.focusAngle.setText(GlobalResources.formatNumber(Math.toDegrees((Double)data[1]) % 360.0) + deg);
                Pair<Double, String> distCam = GlobalResources.doubleToDistanceString((Double)data[0], settings.program.ui.distanceUnits);
                this.focusDistCam.setText(GlobalResources.formatNumber(Math.max(0.0, distCam.getFirst())) + " " + distCam.getSecond());
                if (data.length > 4) {
                    Pair<Double, String> distSol = GlobalResources.doubleToDistanceString((Double)data[4], settings.program.ui.distanceUnits);
                    this.focusDistSol.setText(GlobalResources.formatNumber(Math.max(0.0, distSol.getFirst())) + " " + distSol.getSecond());
                }
                this.focusAppMagCamera.setText(this.nf.format((Double)data[5]));
                if (data.length > 6 && Double.isFinite((Double)data[6])) {
                    this.focusAppMagEarth.setText(this.nf.format((Double)data[6]));
                }
                this.focusRA.setText(this.nf.format((Double)data[2] % 360.0) + deg);
                this.focusDEC.setText(this.nf.format((Double)data[3] % 360.0) + deg);
                break;
            }
            case CAMERA_MOTION_UPDATE: {
                Vector3Q campos = (Vector3Q)data[0];
                double velInternalPerSecond = (Double)data[1] * Constants.KM_TO_U * 2.777777777777778E-4;
                Pair<Double, String> velStr = GlobalResources.doubleToVelocityString(velInternalPerSecond, Settings.settings.program.ui.distanceUnits);
                this.camVel.setText(GlobalResources.formatNumber(velStr.getFirst()) + " " + velStr.getSecond());
                Pair<Double, String> distSol = GlobalResources.doubleToDistanceString(campos.lenDouble(), settings.program.ui.distanceUnits);
                this.camDistSol.setText(GlobalResources.formatNumber(Math.max(0.0, distSol.getFirst())) + " " + distSol.getSecond());
                break;
            }
            case CAMERA_TRACKING_OBJECT_UPDATE: {
                IFocus trackingObject = (IFocus)data[0];
                String trackingName = (String)data[1];
                if (trackingObject == null && trackingName == null) {
                    this.camTracking.setText("-");
                    break;
                }
                this.camTracking.setText(trackingName);
                break;
            }
            case CAMERA_MODE_CMD: {
                CameraManager.CameraMode mode = (CameraManager.CameraMode)((Object)data[0]);
                if (mode.equals((Object)CameraManager.CameraMode.FOCUS_MODE)) {
                    this.displayInfo(this.focusInfoCell, (Actor)this.focusInfo);
                    break;
                }
                this.hideInfo(this.focusInfoCell);
                break;
            }
            case LON_LAT_UPDATED: {
                Double lon = (Double)data[0];
                Double lat = (Double)data[1];
                this.pointerLonLat.setText(this.nf.format(lat) + deg + "/" + this.nf.format(lon) + deg);
                break;
            }
            case RA_DEC_UPDATED: {
                Double pmRa = (Double)data[0];
                Double pmDec = (Double)data[1];
                Double vRa = (Double)data[2];
                Double vDec = (Double)data[3];
                this.pointerRADEC.setText(this.nf.format(pmRa) + deg + "/" + this.nf.format(pmDec) + deg);
                this.viewRADEC.setText(this.nf.format(vRa) + deg + "/" + this.nf.format(vDec) + deg);
                break;
            }
            case RULER_ATTACH_0: {
                String n0 = (String)data[0];
                this.rulerName0.setText(TextUtils.capString(n0, 9));
                this.displayInfo(this.rulerCell, (Actor)this.rulerInfo);
                break;
            }
            case RULER_ATTACH_1: {
                String n1 = (String)data[0];
                this.rulerName1.setText(TextUtils.capString(n1, 9));
                this.displayInfo(this.rulerCell, (Actor)this.rulerInfo);
                break;
            }
            case RULER_CLEAR: {
                this.rulerName0.setText("-");
                this.rulerName1.setText("-");
                this.rulerDist.setText(I18n.msg("gui.sc.distance") + ": -");
                this.hideInfo(this.rulerCell);
                break;
            }
            case RULER_DIST: {
                String rd = (String)data[1];
                this.rulerDist.setText(I18n.msg("gui.sc.distance") + ": " + rd);
                break;
            }
            case PER_OBJECT_VISIBILITY_CMD: {
                boolean visible;
                Object name;
                if (source == this.objectVisibility) break;
                Object pmDec = data[0];
                if (pmDec instanceof IVisibilitySwitch) {
                    IVisibilitySwitch vs = (IVisibilitySwitch)pmDec;
                    name = (String)data[1];
                    if (vs == this.currentFocus && this.currentFocus.hasName((String)name)) {
                        visible = (Boolean)data[2];
                        this.objectVisibility.setCheckedNoFire(!visible);
                    }
                }
                if (!((name = data[0]) instanceof Entity)) break;
                Entity entity = (Entity)name;
                name = (String)data[1];
                if (this.currentFocus != this.view || this.view.getEntity() != entity || !this.currentFocus.hasName((String)name)) break;
                visible = (Boolean)data[2];
                this.objectVisibility.setCheckedNoFire(!visible);
                break;
            }
            case FORCE_OBJECT_LABEL_CMD: {
                Object name;
                if (source == this.labelVisibility || !((name = data[0]) instanceof Entity)) break;
                Entity entity = (Entity)name;
                name = (String)data[1];
                if (this.currentFocus != this.view || this.view.getEntity() != entity || !this.currentFocus.hasName((String)name)) break;
                boolean forceLabel = (Boolean)data[2];
                this.labelVisibility.setCheckedNoFire(forceLabel);
                break;
            }
        }
    }

    public void programmaticUpdate() {
        ICamera camera = GaiaSky.instance.getICamera();
        this.notify(Event.CAMERA_MODE_CMD, this, new Object[]{camera.getMode()});
        if (camera.getMode().isFocus()) {
            this.notify(Event.FOCUS_CHANGED, this, camera.getFocus());
        }
    }

    private void displayInfo(Cell cell, Actor info) {
        cell.setActor(info);
        this.pack();
    }

    private void hideInfo(Cell cell) {
        cell.clearActor();
        this.pack();
    }

    @Override
    public void dispose() {
        this.unsubscribe();
    }

    @Override
    public void update() {
    }
}

