/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.script.ConsoleManager;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.runtime.SwitchBootstraps;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConsoleInterface
extends TableGuiInterface
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(ConsoleInterface.class);
    private final ConsoleManager manager;
    private final Table inputTable;
    private final OwnTextField input;
    private final Table output;
    private final OwnScrollPane outputScroll;
    private final OwnTextIconButton close;
    private final OwnTextIconButton copyToClipboard;
    private final OwnLabel prompt;
    int historyIndex = -1;
    float pad = 10.0f;
    private boolean captureNotification = false;
    private Logger.LoggerLevel level;
    private String message;
    private boolean initialized = false;
    private final String green = "\u001b[32m";
    private final String yellow = "\u001b[33m";
    private final String blue = "\u001b[34m";
    private final String reset = "\u001b[0m";
    private final Vector2 vec2 = new Vector2();

    public ConsoleInterface(Skin skin, ConsoleManager manager) {
        super(skin);
        this.manager = manager;
        this.close = new OwnTextIconButton("", skin, "quit");
        this.close.setSize(39.0f, 35.0f);
        this.close.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.closeConsole();
            }
            return false;
        });
        this.close.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.close"), skin));
        Clipboard clipboard = Gdx.app.getClipboard();
        this.copyToClipboard = new OwnTextIconButton("", skin, "clipboard");
        this.copyToClipboard.setSize(39.0f, 35.0f);
        this.copyToClipboard.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent && !manager.messages().isEmpty()) {
                StringBuilder buffer = new StringBuilder();
                for (ConsoleManager.Message m : manager.messages()) {
                    buffer.append(m.cleanMessage()).append('\n');
                }
                clipboard.setContents(buffer.toString());
            }
            return false;
        });
        this.copyToClipboard.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.clipboard.copy"), skin));
        this.prompt = new OwnLabel((CharSequence)">", skin, "header");
        this.input = new OwnTextField("", skin, "monospace-txt");
        this.input.addListener(event -> {
            if (event instanceof InputEvent) {
                InputEvent ie = (InputEvent)event;
                if (this.getParent() != null) {
                    if (ie.getType() == InputEvent.Type.keyTyped) {
                        int key = ie.getKeyCode();
                        if (key == 68) {
                            this.input.setProgrammaticChangeEvents(false);
                            String text = this.input.getText();
                            text = text.substring(0, text.length() - 1);
                            this.input.setText(text);
                            this.input.setProgrammaticChangeEvents(true);
                        } else {
                            this.historyIndex = -1;
                        }
                    } else if (ie.getType() == InputEvent.Type.keyDown) {
                        switch (ie.getKeyCode()) {
                            case 66: {
                                this.processCommand(this.input.getText());
                                this.input.setText("");
                                break;
                            }
                            case 68: 
                            case 111: 
                            case 115: {
                                this.closeConsole();
                                break;
                            }
                            case 19: {
                                if (manager.cmdHistory().isEmpty()) break;
                                this.historyIndex = this.historyIndex == -1 ? Math.max(0, manager.cmdHistory().size - 1) : Math.max(0, this.historyIndex - 1);
                                this.input.setProgrammaticChangeEvents(false);
                                this.input.setText((String)manager.cmdHistory().get(this.historyIndex));
                                this.input.setProgrammaticChangeEvents(true);
                                this.input.setCursorPosition(this.input.getText().length());
                                break;
                            }
                            case 20: {
                                if (manager.cmdHistory().isEmpty()) break;
                                this.historyIndex = Math.min(manager.cmdHistory().size - 1, this.historyIndex + 1);
                                this.input.setProgrammaticChangeEvents(false);
                                this.input.setText((String)manager.cmdHistory().get(this.historyIndex));
                                this.input.setProgrammaticChangeEvents(true);
                                this.input.setCursorPosition(this.input.getText().length());
                            }
                        }
                    }
                }
            }
            return false;
        });
        this.inputTable = new Table(skin);
        this.inputTable.add((Actor)this.prompt).left().padLeft(this.pad).padRight(this.pad);
        this.inputTable.add((Actor)this.input).left();
        this.output = new Table(skin);
        this.output.setBackground("table-bg");
        this.output.pad(this.pad);
        this.output.top().left();
        this.outputScroll = new OwnScrollPane((Actor)this.output, skin, "default-nobg");
        this.outputScroll.setHeight(400.0f);
        this.outputScroll.setForceScroll(false, true);
        this.outputScroll.setSmoothScrolling(true);
        this.outputScroll.setFadeScrollBars(false);
        this.rebuildMainTable();
        this.pack();
        if (manager.messages().isEmpty()) {
            this.addOutputInfo("\u001b[34m" + I18n.msg("gui.console.welcome") + "\u001b[0m");
            this.addOutputInfo("");
        } else {
            this.restoreConsoleMessages();
        }
        EventManager.instance.subscribe((IObserver)this, Event.POST_NOTIFICATION);
        this.initialized = true;
    }

    private void rebuildMainTable() {
        float upp = GaiaSky.instance.getUnitsPerPixel();
        float w = ((float)Gdx.graphics.getWidth() - this.pad - this.prompt.getWidth()) * upp - 500.0f;
        this.input.setWidth(w - this.pad * 2.0f);
        this.outputScroll.setWidth(w);
        Table mainTable = new Table(this.getSkin());
        mainTable.pad(this.pad);
        mainTable.setBackground("bg-pane-border");
        mainTable.center();
        mainTable.add((Actor)new OwnLabel((CharSequence)("  " + I18n.msg("gui.console.title")), this.getSkin(), "header")).left().expandX().padBottom(this.pad);
        mainTable.add((Actor)this.copyToClipboard).right().padBottom(this.pad).padRight(this.pad);
        mainTable.add((Actor)this.close).right().padBottom(this.pad).row();
        mainTable.add((Actor)this.outputScroll).colspan(3).width(w).left().padLeft(this.pad).fillX().row();
        mainTable.add((Actor)this.inputTable).colspan(3).left().width(w).padLeft(this.pad).fillX().pad(0.0f);
        mainTable.pack();
        this.clearChildren();
        this.add((Actor)mainTable);
    }

    public void showConsole() {
        this.rebuildMainTable();
        this.input.getStage().setKeyboardFocus((Actor)this.input);
        this.addAction((Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)Settings.settings.program.ui.getAnimationSeconds())));
    }

    public void closeConsole() {
        this.addAction((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.run(this::remove)));
    }

    public boolean remove() {
        this.input.getStage().setKeyboardFocus(null);
        return super.remove();
    }

    private void restoreConsoleMessages() {
        this.output.clearChildren(true);
        for (ConsoleManager.Message msg : this.manager.messages()) {
            this.addMessageWidget(msg);
        }
    }

    private void addOutputInfo(String msg) {
        this.addOutput(msg, ConsoleManager.MsgType.INFO);
    }

    private void addOutputOk(String msg) {
        this.addOutput(msg, ConsoleManager.MsgType.OK);
    }

    private void addOutputReturn(String msg) {
        this.addOutput(msg, ConsoleManager.MsgType.RETURN);
    }

    private void addOutputError(String err) {
        this.addOutput(err, ConsoleManager.MsgType.ERROR);
    }

    private void addOutput(String messageText, ConsoleManager.MsgType type) {
        if (messageText != null) {
            int maxLen = (int)((double)this.outputScroll.getWidth() * 0.045);
            String text = TextUtils.breakCharacters(messageText, maxLen);
            ConsoleManager.Message msg = new ConsoleManager.Message(text, type, Instant.now());
            this.addMessageWidget(msg);
            this.manager.messages().add((Object)msg);
            if (this.initialized) {
                logger.info(String.format("%s: %s", msg.time(), msg.cleanMessage()));
            }
        }
    }

    private void addMessageWidget(ConsoleManager.Message msg) {
        OwnLabel status = new OwnLabel((CharSequence)msg.type().getCodeString(), this.getSkin(), "mono");
        status.addListener((EventListener)new OwnTextTooltip(msg.type().getNameString(), this.getSkin()));
        status.setColor(msg.type().getTagColor());
        Actor message = this.constructMessage(msg);
        Clipboard clipboard = Gdx.app.getClipboard();
        OwnTextIconButton clipboardButton = new OwnTextIconButton("", this.getSkin(), "clipboard");
        clipboardButton.setSize(36.0f, 32.0f);
        clipboardButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                clipboard.setContents(msg.cleanMessage());
            }
            return false;
        });
        clipboardButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.clipboard.copy"), this.getSkin()));
        this.output.add((Actor)status).left().top().padRight(this.pad * 2.0f);
        this.output.add(message).left().top().expandX().padRight(this.pad * 2.0f);
        this.output.add((Actor)clipboardButton).left().top().padRight(this.pad * 2.0f).row();
        Vector2 coordinates = status.localToAscendantCoordinates((Actor)this.output, this.vec2.set(status.getX(), status.getY()));
        this.outputScroll.scrollTo(coordinates.x, coordinates.y, status.getWidth(), status.getHeight());
    }

    private Actor constructMessage(ConsoleManager.Message msg) {
        Color currCol = Color.WHITE;
        int segments = 0;
        int maxLen = (int)((double)this.outputScroll.getWidth() * 0.055);
        Table vg = new Table(this.getSkin());
        HorizontalGroup hg = new HorizontalGroup();
        hg.align(10);
        vg.add((Actor)hg).left().top().row();
        String subString = TextUtils.breakCharacters(msg.msg(), maxLen);
        boolean finished = false;
        while (!finished) {
            if (subString.startsWith("\u001b[")) {
                int mIdx = subString.indexOf(109);
                int code = Integer.parseInt(subString.substring(2, mIdx));
                subString = subString.substring(mIdx + 1);
                currCol = switch (code) {
                    case 30 -> Color.BLACK;
                    case 31 -> ColorUtils.gRedC;
                    case 32 -> ColorUtils.gGreenC;
                    case 33 -> ColorUtils.gYellowC;
                    case 34 -> ColorUtils.gBlueC;
                    case 35 -> ColorUtils.ddMagentaC;
                    case 36 -> ColorUtils.oCyanC;
                    default -> Color.WHITE;
                };
                finished = subString.isEmpty();
            } else {
                int nextCodeIdx = subString.indexOf("\u001b[");
                if (nextCodeIdx < 0) {
                    hg = this.addTextLabel(subString, vg, hg, currCol);
                    finished = true;
                } else {
                    String pre = subString.substring(0, nextCodeIdx);
                    hg = this.addTextLabel(pre, vg, hg, currCol);
                    subString = subString.substring(nextCodeIdx);
                }
            }
            ++segments;
        }
        if (segments == 0) {
            OwnLabel actor = new OwnLabel((CharSequence)TextUtils.breakCharacters(msg.msg(), maxLen), this.getSkin(), "mono");
            actor.setColor(msg.type().getMsgColor());
            return actor;
        }
        return vg;
    }

    private HorizontalGroup addTextLabel(String str, Table vg, HorizontalGroup hg, Color col) {
        if (str.indexOf(10) < 0) {
            OwnLabel text = new OwnLabel((CharSequence)str, this.getSkin(), "mono");
            text.setColor(col);
            hg.addActor((Actor)text);
        } else {
            int idx;
            Object part = str;
            while ((idx = ((String)part).indexOf(10)) >= 0) {
                String pre = ((String)part).substring(0, idx);
                OwnLabel text = new OwnLabel((CharSequence)pre, this.getSkin(), "mono");
                text.setColor(col);
                hg.addActor((Actor)text);
                hg = new HorizontalGroup();
                hg.align(8);
                vg.add((Actor)hg).left().top().row();
                part = "   " + ((String)part).substring(idx + 1);
            }
            if (!((String)part).isEmpty()) {
                OwnLabel text = new OwnLabel((CharSequence)part, this.getSkin(), "mono");
                text.setColor(col);
                hg.addActor((Actor)text);
            }
        }
        return hg;
    }

    private String processMethod(String key, Method m) {
        Parameter[] params;
        String prefix = this.getPrefix(key, "");
        StringBuilder sb = new StringBuilder("  \u001b[32m" + prefix + m.getName() + "\u001b[0m");
        for (Parameter p : params = m.getParameters()) {
            Class<?> c = p.getType();
            if (!(c.isPrimitive() || c.isArray() || c.equals(String.class))) {
                return null;
            }
            sb.append(" ").append(p.getName()).append(":").append("\u001b[33m").append(c.getSimpleName()).append("\u001b[0m");
        }
        return sb.toString();
    }

    private String getPrefix(String method, String defaultValue) {
        String prefix = defaultValue;
        int idx = method.lastIndexOf(".");
        if (idx > 0) {
            prefix = method.substring(0, idx + 1);
        }
        return prefix;
    }

    private String[] tokenizeParameters(String params) {
        ArrayList<String> list = new ArrayList<String>();
        int n = params.length();
        boolean modeStr = false;
        StringBuilder curr = new StringBuilder();
        block4: for (int i = 0; i < n; ++i) {
            char c = params.charAt(i);
            switch (c) {
                case '\"': {
                    if (modeStr) {
                        list.add(curr.toString());
                        curr = new StringBuilder();
                    }
                    modeStr = !modeStr;
                    continue block4;
                }
                case ' ': {
                    if (!modeStr) {
                        list.add(curr.toString());
                        curr = new StringBuilder();
                        continue block4;
                    }
                    curr.append(c);
                    continue block4;
                }
                default: {
                    curr.append(c);
                }
            }
        }
        if (!curr.isEmpty()) {
            list.add(curr.toString());
        }
        String[] arr = new String[list.size()];
        return list.toArray(arr);
    }

    private void processCommand(String cmd) {
        String command0;
        if (cmd == null || cmd.isEmpty()) {
            return;
        }
        cmd = cmd.trim();
        this.manager.addCommandToHistory(cmd);
        String[] parameters = null;
        if (cmd.contains(" ")) {
            int idx = cmd.indexOf(" ");
            command0 = cmd.substring(0, idx);
            parameters = this.tokenizeParameters(cmd.substring(idx + 1));
        } else {
            command0 = cmd;
        }
        int numParams = parameters != null ? parameters.length : 0;
        String command = this.manager.unwrapShortcut(command0);
        if ("help".equals(command)) {
            if (numParams == 0) {
                this.addOutputOk(command);
                this.printMethods(this.manager.methodMap(), "");
                this.addOutputInfo("");
                this.printShortcuts(this.manager.shortcutMap());
            } else if (numParams >= 1) {
                String string = parameters[0];
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"api", "apiv1", "apiv2", "shortcuts"}, (Object)string, n)) {
                    case 0: {
                        this.addOutputOk(command);
                        this.printMethods(this.manager.methodMap(), "");
                        break;
                    }
                    case 1: {
                        this.addOutputOk(command);
                        this.printMethods(this.manager.methodMapAPIv1(), "v1");
                        break;
                    }
                    case 2: {
                        if (numParams == 2) {
                            String moduleName = parameters[1];
                            Map<String, Array<Method>> methods = this.manager.methodMapAPIv2(moduleName);
                            if (methods.isEmpty()) {
                                this.addOutputError(I18n.msg("gui.console.module.methods.error", moduleName));
                                break;
                            }
                            this.addOutputOk(command);
                            this.printMethods(methods, "v2", moduleName);
                            break;
                        }
                        this.addOutputOk(command);
                        this.printMethods(this.manager.methodMapAPIv2(), "v2");
                        break;
                    }
                    case 3: {
                        this.addOutputOk(command);
                        this.printShortcuts(this.manager.shortcutMap());
                        break;
                    }
                    default: {
                        this.addOutputError(I18n.msg("gui.console.cmd.parameters", cmd));
                    }
                }
            } else {
                this.addOutputError(I18n.msg("gui.console.cmd.parameters", cmd));
            }
        } else if (this.manager.hasMethod(command)) {
            Array<Method> methods = this.manager.getMethods(command);
            int matched = 0;
            for (Method method : methods) {
                Parameter[] params = method.getParameters();
                if (numParams != params.length) continue;
                ++matched;
                Object[] arguments = new Object[params.length];
                Class[] types = new Class[params.length];
                boolean ok = true;
                for (int i = 0; i < params.length; ++i) {
                    Parameter p = params[i];
                    String stringValue = parameters[i];
                    types[i] = p.getType();
                    try {
                        int vi;
                        Object[] dvec;
                        String[] svec;
                        if (Integer.TYPE.equals(types[i]) || Integer.class.equals((Object)types[i])) {
                            arguments[i] = Integer.parseInt(stringValue);
                            continue;
                        }
                        if (Long.TYPE.equals(types[i]) || Long.class.equals((Object)types[i])) {
                            arguments[i] = Long.parseLong(stringValue);
                            continue;
                        }
                        if (Float.TYPE.equals(types[i]) || Float.class.equals((Object)types[i])) {
                            arguments[i] = Float.valueOf(Float.parseFloat(stringValue));
                            continue;
                        }
                        if (Double.TYPE.equals(types[i]) || Double.class.equals((Object)types[i])) {
                            arguments[i] = Double.parseDouble(stringValue);
                            continue;
                        }
                        if (Boolean.TYPE.equals(types[i]) || Boolean.class.equals((Object)types[i])) {
                            arguments[i] = Boolean.parseBoolean(stringValue);
                            continue;
                        }
                        if (int[].class.equals((Object)types[i]) || Integer[].class.equals((Object)types[i])) {
                            svec = this.splitArrayString(stringValue);
                            dvec = new int[svec.length];
                            for (vi = 0; vi < svec.length; ++vi) {
                                dvec[vi] = Integer.parseInt(svec[vi]);
                            }
                            arguments[i] = dvec;
                            continue;
                        }
                        if (float[].class.equals((Object)types[i]) || Float[].class.equals((Object)types[i])) {
                            svec = this.splitArrayString(stringValue);
                            dvec = new float[svec.length];
                            for (vi = 0; vi < svec.length; ++vi) {
                                dvec[vi] = (int)Float.parseFloat(svec[vi]);
                            }
                            arguments[i] = dvec;
                            continue;
                        }
                        if (double[].class.equals((Object)types[i]) || Double[].class.equals((Object)types[i])) {
                            svec = this.splitArrayString(stringValue);
                            dvec = new double[svec.length];
                            for (vi = 0; vi < svec.length; ++vi) {
                                dvec[vi] = (int)Double.parseDouble(svec[vi]);
                            }
                            arguments[i] = dvec;
                            continue;
                        }
                        if (String[].class.equals((Object)types[i])) {
                            arguments[i] = svec = this.splitArrayString(stringValue);
                            continue;
                        }
                        arguments[i] = stringValue;
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        String msg = String.format("Argument failure with parameter '%s'", p.getName());
                        logger.warn(msg);
                        ok = false;
                    }
                }
                if (!ok) continue;
                try {
                    String returnStr;
                    String prefix = this.getPrefix(cmd, ".");
                    Object instance = this.manager.getInstance(prefix);
                    this.startNotificationCapture();
                    Object returnObject = method.invoke(instance, arguments);
                    this.stopNotificationCapture();
                    if (this.notificationAvailable() && this.level == Logger.LoggerLevel.ERROR) {
                        this.addOutputError(cmd);
                        this.addOutputInfo(this.message);
                        break;
                    }
                    this.addOutputOk(cmd);
                    if (returnObject == null) break;
                    Class<?> clazz = returnObject.getClass();
                    if (int[].class.equals(clazz)) {
                        int[] obj = (int[])returnObject;
                        returnStr = Arrays.toString(obj);
                    } else if (Integer[].class.equals(clazz)) {
                        Object[] obj = (Integer[])returnObject;
                        returnStr = Arrays.toString(obj);
                    } else if (float[].class.equals(clazz)) {
                        float[] obj = (float[])returnObject;
                        returnStr = Arrays.toString(obj);
                    } else if (Float[].class.equals(clazz)) {
                        Object[] obj = (Float[])returnObject;
                        returnStr = Arrays.toString(obj);
                    } else if (double[].class.equals(clazz)) {
                        double[] obj = (double[])returnObject;
                        returnStr = Arrays.toString(obj);
                    } else if (Double[].class.equals(clazz)) {
                        Object[] obj = (Double[])returnObject;
                        returnStr = Arrays.toString(obj);
                    } else if (String[].class.equals(clazz)) {
                        Object[] obj = (String[])returnObject;
                        returnStr = Arrays.toString(obj);
                    } else {
                        returnStr = returnObject.toString();
                    }
                    this.addOutputReturn(returnStr);
                    break;
                }
                catch (Exception e) {
                    this.addOutputError(e.toString());
                    logger.error(e);
                }
            }
            if (matched == 0) {
                this.addOutputError(String.format("%s: could not match command", cmd));
                String commandName = this.manager.shortcutMap().get(cmd);
                List<String> candidates = this.manager.methodMap().keySet().stream().filter(a -> a.equalsIgnoreCase(commandName)).toList();
                if (!candidates.isEmpty()) {
                    this.addOutputInfo("Possible candidates:");
                    candidates.forEach(c -> {
                        Array<Method> l = this.manager.methodMap().get(c);
                        l.forEach(m -> this.addOutputInfo(this.processMethod((String)c, (Method)m)));
                    });
                    this.addOutputInfo("");
                }
            }
        } else {
            this.addOutputError(I18n.msg("gui.console.cmd.notfound", cmd));
        }
    }

    private void printMethods(Map<String, Array<Method>> methods, String version) {
        this.printMethods(methods, version, null);
    }

    private void printMethods(Map<String, Array<Method>> methods, String version, String module) {
        Object mod = module != null ? " (" + module + ")" : "";
        this.addOutputInfo("\u001b[34m" + I18n.msg("gui.console.api", version) + (String)mod + "\u001b[0m:");
        methods.keySet().stream().sorted().forEach(a -> {
            Array<Method> b = this.manager.methodMap().get(a);
            b.forEach(m -> this.addOutputInfo(this.processMethod((String)a, (Method)m)));
        });
    }

    private void printShortcuts(Map<String, String> shortcuts) {
        this.addOutputInfo("\u001b[34m" + I18n.msg("gui.console.shortcuts") + "\u001b[0m:");
        shortcuts.keySet().stream().sorted().forEach(a -> {
            String b = (String)shortcuts.get(a);
            this.addOutputInfo("  " + a + "\u001b[33m :=: \u001b[32m" + b);
        });
    }

    private String[] splitArrayString(String arrayString) {
        int len = arrayString.length();
        if (len >= 2 && "[".equals(arrayString.substring(0, 1)) && "]".equals(arrayString.substring(len - 1, len))) {
            return arrayString.substring(1, len - 1).split(",");
        }
        logger.warn("splitArrayString: '{}' is parsed as empty array!", arrayString);
        throw new IllegalArgumentException();
    }

    @Override
    public void update() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.POST_NOTIFICATION && this.captureNotification) {
            int startIndex;
            this.level = (Logger.LoggerLevel)((Object)data[0]);
            Object[] dat = (Object[])data[1];
            StringBuilder msg = new StringBuilder();
            for (int i = startIndex = 1; i < dat.length; ++i) {
                msg.append(dat[i].toString());
                if (i >= dat.length - 1 || i == dat.length - 2 && dat[dat.length - 1] instanceof Boolean) continue;
                msg.append(" - ");
            }
            this.message = msg.toString();
        }
    }

    private boolean notificationAvailable() {
        return this.level != null && this.message != null;
    }

    private void startNotificationCapture() {
        this.level = null;
        this.message = null;
        this.captureNotification = true;
    }

    private void stopNotificationCapture() {
        this.captureNotification = false;
    }
}

