/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Timer;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.components.BookmarksComponent;
import gaiasky.gui.components.CameraComponent;
import gaiasky.gui.components.DatasetsComponent;
import gaiasky.gui.components.GuiComponent;
import gaiasky.gui.components.LocationLogComponent;
import gaiasky.gui.components.TimeComponent;
import gaiasky.gui.components.VisibilityComponent;
import gaiasky.gui.components.VisualSettingsComponent;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.gui.main.ContainerPane;
import gaiasky.gui.main.KeyBindings;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Scene;
import gaiasky.util.CatalogManager;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;

public class ControlsInterface
extends TableGuiInterface
implements IObserver {
    private final Table tableComponentButtons;
    private final Cell<Actor> activeComponentCell;
    private final OwnTextIconButton buttonLoad;
    private final OwnTextIconButton buttonSettings;
    private final OwnTextIconButton buttonLog;
    private final OwnTextIconButton buttonHelp;
    private final OwnTextIconButton buttonQuit;
    private final Array<OwnTextButton> componentButtons;
    private final OwnTextIconButton buttonMinimap;
    private final float buttonWidth = 48.0f;
    private final float buttonHeight = 48.0f;
    private final ObjectMap<String, ContainerPane> paneMap = new ObjectMap();
    private final ObjectMap<String, OwnTextButton> buttonMap = new ObjectMap();
    private Timer.Task closeTask;

    public ControlsInterface(Skin skin, Stage stage, Scene scene, CatalogManager catalogManager, ComponentTypes.ComponentType[] visibilityEntities, boolean[] visible) {
        super(skin);
        float pad10 = 10.0f;
        float pad20 = 20.0f;
        this.componentButtons = new Array(7);
        Table tableButtons = new Table(skin);
        Table tableComponents = new Table(skin);
        this.tableComponentButtons = new Table(skin);
        tableButtons.add((Actor)this.tableComponentButtons).left().top().padTop(100.0f).padRight(10.0f).row();
        this.activeComponentCell = tableComponents.add().left().top();
        TimeComponent timeComponent = new TimeComponent(skin, stage);
        timeComponent.initialize(ControlsInterface.getContentWidth());
        this.createComponentButton(skin, I18n.msg("gui.time"), timeComponent, "action.expandcollapse.pane/gui.time");
        CameraComponent cameraComponent = new CameraComponent(skin, stage);
        cameraComponent.initialize(ControlsInterface.getContentWidth());
        this.createComponentButton(skin, 10.0f, 60.0f, "menu-camera", I18n.msg("gui.camera"), cameraComponent, "action.expandcollapse.pane/gui.camera");
        VisibilityComponent visibilityComponent = new VisibilityComponent(skin, stage);
        visibilityComponent.setVisibilityEntitites(visibilityEntities, visible);
        visibilityComponent.initialize(ControlsInterface.getContentWidth());
        this.createComponentButton(skin, 10.0f, 120.0f, "menu-types", I18n.msg("gui.visibility"), visibilityComponent, "action.expandcollapse.pane/gui.visibility");
        VisualSettingsComponent visualSettingsComponent = new VisualSettingsComponent(skin, stage);
        visualSettingsComponent.initialize(ControlsInterface.getContentWidth());
        this.createComponentButton(skin, 10.0f, 175.0f, "menu-visuals", I18n.msg("gui.lighting"), visualSettingsComponent, "action.expandcollapse.pane/gui.lighting");
        DatasetsComponent datasetsComponent = new DatasetsComponent(skin, stage, catalogManager);
        datasetsComponent.initialize(ControlsInterface.getContentWidth());
        this.createComponentButton(skin, 10.0f, 230.0f, "menu-datasets", I18n.msg("gui.dataset.title"), datasetsComponent, "action.expandcollapse.pane/gui.dataset.title");
        LocationLogComponent locationLogComponent = new LocationLogComponent(skin, stage);
        locationLogComponent.initialize(ControlsInterface.getContentWidth());
        this.createComponentButton(skin, 10.0f, 290.0f, "menu-location-log", I18n.msg("gui.locationlog"), locationLogComponent, null);
        BookmarksComponent bookmarksComponent = new BookmarksComponent(skin, stage);
        bookmarksComponent.setScene(scene);
        bookmarksComponent.initialize(ControlsInterface.getContentWidth());
        this.createComponentButton(skin, 10.0f, 350.0f, "menu-bookmarks", I18n.msg("gui.bookmarks"), bookmarksComponent, "action.expandcollapse.pane/gui.bookmarks");
        tableButtons.add().left().growY().row();
        KeyBindings kb = KeyBindings.instance;
        Table tableActionButtons = new Table(skin);
        tableButtons.add((Actor)tableActionButtons).left().bottom().padBottom(80.0f);
        this.buttonMinimap = new OwnTextIconButton("", skin, "menu-map");
        this.buttonMinimap.setSize(48.0f, 48.0f);
        this.buttonMinimap.setName("map");
        this.buttonMinimap.setChecked(Settings.settings.program.minimap.active);
        String[] minimapHotkey = kb.getStringKeys("action.toggle/gui.minimap.title", true);
        this.buttonMinimap.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.map"), minimapHotkey, skin));
        this.buttonMinimap.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.MINIMAP_DISPLAY_CMD, (Object)this.buttonMinimap, this.buttonMinimap.isChecked());
            }
            return false;
        });
        tableActionButtons.add((Actor)this.buttonMinimap).left().bottom().padBottom(10.0f).row();
        this.buttonLoad = new OwnTextIconButton("", skin, "load");
        this.buttonLoad.setSize(48.0f, 48.0f);
        this.buttonLoad.setName("loadcatalog");
        this.buttonLoad.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.loadcatalog"), kb.getStringKeys("action.loadcatalog", true), skin));
        this.buttonLoad.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_LOAD_CATALOG_ACTION, (Object)this.buttonLoad, new Object[0]);
                this.buttonLoad.setCheckedNoFire(false);
            }
            return false;
        });
        tableActionButtons.add((Actor)this.buttonLoad).left().bottom().padBottom(10.0f).row();
        this.buttonSettings = new OwnTextIconButton("", skin, "preferences");
        this.buttonSettings.setSize(48.0f, 48.0f);
        this.buttonSettings.setName("preferences");
        String[] prefsHotkey = kb.getStringKeys("action.preferences", true);
        this.buttonSettings.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.preferences"), prefsHotkey, skin));
        this.buttonSettings.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_PREFERENCES_ACTION, (Object)this.buttonSettings, new Object[0]);
                this.buttonSettings.setCheckedNoFire(false);
            }
            return false;
        });
        tableActionButtons.add((Actor)this.buttonSettings).left().bottom().padBottom(10.0f).row();
        this.buttonLog = new OwnTextIconButton("", skin, "log");
        this.buttonLog.setSize(48.0f, 48.0f);
        this.buttonLog.setName("show log");
        this.buttonLog.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.tooltip.log"), kb.getStringKeys("action.log", true), skin));
        this.buttonLog.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_LOG_CMD, (Object)this.buttonLog, new Object[0]);
                this.buttonLog.setCheckedNoFire(false);
            }
            return false;
        });
        tableActionButtons.add((Actor)this.buttonLog).left().bottom().padBottom(10.0f).row();
        this.buttonHelp = new OwnTextIconButton("", skin, "help");
        this.buttonHelp.setSize(48.0f, 48.0f);
        this.buttonHelp.setName("about");
        String[] helpHotkeys = kb.getStringKeys("action.help", true);
        this.buttonHelp.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.help"), helpHotkeys, skin));
        this.buttonHelp.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_ABOUT_ACTION, (Object)this.buttonHelp, new Object[0]);
                this.buttonHelp.setCheckedNoFire(false);
            }
            return false;
        });
        tableActionButtons.add((Actor)this.buttonHelp).left().bottom().padBottom(10.0f).row();
        this.buttonQuit = new OwnTextIconButton("", skin, "quit");
        this.buttonQuit.setSize(48.0f, 48.0f);
        this.buttonQuit.setName("quit");
        this.buttonQuit.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.quit.title"), kb.getStringKeys("action.exit", true), skin));
        this.buttonQuit.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_QUIT_ACTION, (Object)this.buttonQuit, new Object[0]);
                this.buttonQuit.setCheckedNoFire(false);
            }
            return false;
        });
        tableActionButtons.add((Actor)this.buttonQuit).left().bottom();
        this.add((Actor)tableButtons).left().top().growY();
        this.add((Actor)tableComponents).left().top().padTop(80.0f);
        EventManager.instance.subscribe((IObserver)this, Event.GUI_FOLD_CMD, Event.TOGGLE_EXPANDCOLLAPSE_PANE_CMD, Event.EXPAND_COLLAPSE_PANE_CMD, Event.MINIMAP_DISPLAY_CMD, Event.MINIMAP_TOGGLE_CMD);
    }

    private void createComponentButton(Skin skin, String title, GuiComponent component, String action) {
        this.createComponentButton(skin, 10.0f, 0.0f, "menu-time", title, component, action);
    }

    private void close(Actor pane) {
        pane.clearActions();
        pane.addAction((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)(Settings.settings.program.ui.getAnimationSeconds() * 0.5f)), (Action)Actions.run(() -> this.activeComponentCell.clearActor())));
    }

    private OwnTextIconButton createComponentButton(Skin skin, float pad, final float padTop, String buttonStyle, String title, GuiComponent component, String action) {
        final OwnTextIconButton button = new OwnTextIconButton("", skin, buttonStyle);
        button.setSize(48.0f, 48.0f);
        button.align(1);
        this.componentButtons.add((Object)button);
        this.tableComponentButtons.add((Actor)button).left().top().padBottom(pad).row();
        final ContainerPane pane = new ContainerPane(skin, title, component.getActor());
        if (Settings.settings.program.ui.expandOnMouseOver) {
            pane.addListener((EventListener)new InputListener(this){
                final /* synthetic */ ControlsInterface this$0;
                {
                    this.this$0 = this$0;
                }

                public boolean mouseMoved(InputEvent event, float x, float y) {
                    if (this.this$0.closeTask != null) {
                        this.this$0.closeTask.cancel();
                    }
                    this.this$0.closeTask = new Timer.Task(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            this.this$1.this$0.close((Actor)pane);
                        }
                    };
                    Timer.schedule((Timer.Task)this.this$0.closeTask, (float)4.0f);
                    return false;
                }
            });
        }
        String key = component.getClass().getSimpleName();
        this.paneMap.put((Object)key, (Object)pane);
        this.buttonMap.put((Object)key, (Object)button);
        if (!Settings.settings.program.ui.expandOnMouseOver) {
            if (action != null && !action.isBlank()) {
                String[] shortcutKeys = KeyBindings.instance.getStringKeys(action, true);
                if (shortcutKeys != null && shortcutKeys.length > 0) {
                    button.addListener((EventListener)new OwnTextHotkeyTooltip(title, shortcutKeys, skin));
                } else {
                    button.addListener((EventListener)new OwnTextTooltip(title, skin));
                }
            } else {
                button.addListener((EventListener)new OwnTextTooltip(title, skin));
            }
            button.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (button.isChecked()) {
                        pane.clearActions();
                        this.activeComponentCell.clearActor();
                        this.selectComponentButton(button);
                        this.activeComponentCell.padTop(padTop);
                        this.activeComponentCell.setActor((Actor)pane);
                        pane.addAction((Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)(Settings.settings.program.ui.getAnimationSeconds() * 0.5f))));
                    } else {
                        pane.clearActions();
                        pane.addAction((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)(Settings.settings.program.ui.getAnimationSeconds() * 0.5f)), (Action)Actions.run(() -> this.activeComponentCell.clearActor())));
                    }
                }
                return false;
            });
        } else {
            button.addListener((EventListener)new InputListener(this){
                final /* synthetic */ ControlsInterface this$0;
                {
                    this.this$0 = this$0;
                }

                public void enter(InputEvent event, float x, float y, int pointer, @Null Actor fromActor) {
                    if (pointer != -1) {
                        return;
                    }
                    Actor actor = event.getListenerActor();
                    if (fromActor != null && fromActor.isDescendantOf(actor)) {
                        return;
                    }
                    pane.clearActions();
                    this.this$0.activeComponentCell.clearActor();
                    this.this$0.selectComponentButton(button);
                    this.this$0.activeComponentCell.padTop(padTop);
                    this.this$0.activeComponentCell.setActor((Actor)pane);
                    pane.addAction((Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)(Settings.settings.program.ui.getAnimationSeconds() * 0.5f))));
                    if (this.this$0.closeTask != null) {
                        this.this$0.closeTask.cancel();
                    }
                    this.this$0.closeTask = new Timer.Task(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            this.this$1.this$0.close((Actor)pane);
                        }
                    };
                    Timer.schedule((Timer.Task)this.this$0.closeTask, (float)4.0f);
                }
            });
        }
        return button;
    }

    private void selectComponentButton(OwnTextButton button) {
        for (OwnTextButton b : this.componentButtons) {
            if (b == button) continue;
            b.setCheckedNoFire(false);
        }
    }

    private static float getContentWidth() {
        return 380.0f;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void update() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case GUI_FOLD_CMD: {
                if (data.length >= 1) {
                    boolean collapse = (Boolean)data[0];
                    if (!collapse) break;
                    for (OwnTextButton b : this.componentButtons) {
                        if (!b.isChecked()) continue;
                        b.setChecked(false);
                    }
                    break;
                }
                OwnTextButton open = null;
                for (OwnTextButton b : this.componentButtons) {
                    if (!b.isChecked()) continue;
                    open = b;
                    break;
                }
                if (open == null) break;
                open.setChecked(false);
                break;
            }
            case TOGGLE_EXPANDCOLLAPSE_PANE_CMD: {
                Button button;
                String name = (String)data[0];
                if (!this.buttonMap.containsKey((Object)name)) break;
                button.setChecked(!(button = (Button)this.buttonMap.get((Object)name)).isChecked());
                break;
            }
            case EXPAND_COLLAPSE_PANE_CMD: {
                String name = (String)data[0];
                Boolean expand = (Boolean)data[1];
                if (!this.buttonMap.containsKey((Object)name)) break;
                Button button = (Button)this.buttonMap.get((Object)name);
                button.setChecked(expand.booleanValue());
                break;
            }
            case MINIMAP_DISPLAY_CMD: {
                boolean show = (Boolean)data[0];
                if (source == this.buttonMinimap) break;
                this.buttonMinimap.setCheckedNoFire(show);
                break;
            }
            case MINIMAP_TOGGLE_CMD: {
                this.buttonMinimap.setCheckedNoFire(!this.buttonMinimap.isChecked());
                break;
            }
        }
    }
}

