/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.api.IGuiInterface;
import gaiasky.util.math.MathUtilsDouble;
import gaiasky.util.scene2d.OwnLabel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CustomInterface
implements IObserver,
IGuiInterface {
    private final Object lock;
    private final Skin skin;
    private final Stage ui;
    Map<Integer, Widget> customElements;
    private List<Integer> sizes;

    public CustomInterface(Stage ui, Skin skin, Object lock) {
        this.skin = skin;
        this.ui = ui;
        this.customElements = new HashMap<Integer, Widget>();
        this.initSizes(skin);
        this.lock = lock;
        EventManager.instance.subscribe((IObserver)this, Event.ADD_CUSTOM_IMAGE, Event.ADD_CUSTOM_MESSAGE, Event.REMOVE_OBJECTS, Event.REMOVE_ALL_OBJECTS, Event.ADD_CUSTOM_TEXT);
    }

    private void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    private void initSizes(Skin skin) {
        this.sizes = new ArrayList<Integer>();
        ObjectMap ls = skin.getAll(Label.LabelStyle.class);
        ObjectMap.Keys keys = ls.keys();
        for (String key : keys) {
            if (!key.startsWith("msg-")) continue;
            key = key.substring(4);
            this.sizes.add(Integer.parseInt(key));
        }
        Collections.sort(this.sizes);
    }

    public void reAddObjects() {
        Set<Integer> keys = this.customElements.keySet();
        for (Integer key : keys) {
            this.ui.addActor((Actor)this.customElements.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        float unitsPerPixel = GaiaSky.instance.getUnitsPerPixel();
        float width = (float)Gdx.graphics.getWidth() * unitsPerPixel;
        float height = (float)Gdx.graphics.getHeight() * unitsPerPixel;
        Object object = this.lock;
        synchronized (object) {
            switch (event) {
                case ADD_CUSTOM_IMAGE: {
                    Image img;
                    Integer id = (Integer)data[0];
                    Texture tex = (Texture)data[1];
                    float x = MathUtilsDouble.lint(((Float)data[2]).floatValue(), 0.0f, 1.0f, 0.0f, width);
                    float y = MathUtilsDouble.lint(((Float)data[3]).floatValue(), 0.0f, 1.0f, 0.0f, height);
                    boolean add = false;
                    if (this.customElements.containsKey(id)) {
                        if (this.customElements.get(id) instanceof Image) {
                            img = (Image)this.customElements.get(id);
                        } else {
                            this.removeObject(id);
                            img = new Image(tex);
                            add = true;
                        }
                    } else {
                        img = new Image(tex);
                        add = true;
                    }
                    img.setPosition(x, y);
                    if (data.length > 4) {
                        float r = ((Float)data[4]).floatValue();
                        float g = ((Float)data[5]).floatValue();
                        float b = ((Float)data[6]).floatValue();
                        float a = ((Float)data[7]).floatValue();
                        img.setColor(r, g, b, a);
                    }
                    if (add) {
                        this.ui.addActor((Actor)img);
                    }
                    this.customElements.put(id, (Widget)img);
                    break;
                }
                case ADD_CUSTOM_MESSAGE: {
                    OwnLabel customMsg;
                    Integer id = (Integer)data[0];
                    String msg = (String)data[1];
                    float x = MathUtilsDouble.lint(((Float)data[2]).floatValue(), 0.0f, 1.0f, 0.0f, width);
                    float y = MathUtilsDouble.lint(((Float)data[3]).floatValue(), 0.0f, 1.0f, 0.0f, height);
                    float r = ((Float)data[4]).floatValue();
                    float g = ((Float)data[5]).floatValue();
                    float b = ((Float)data[6]).floatValue();
                    float a = ((Float)data[7]).floatValue();
                    float s = ((Float)data[8]).floatValue();
                    int size = (int)s;
                    int cSize = this.findClosestSize(size);
                    float scaleFactor = (float)size / (float)cSize;
                    String style = "msg-" + cSize;
                    boolean add = false;
                    if (this.customElements.containsKey(id)) {
                        if (this.customElements.get(id) instanceof OwnLabel) {
                            customMsg = (OwnLabel)this.customElements.get(id);
                            customMsg.setText(msg);
                            customMsg.setStyle((Label.LabelStyle)this.skin.get(style, Label.LabelStyle.class));
                        } else {
                            this.removeObject(id);
                            customMsg = new OwnLabel((CharSequence)msg, this.skin, style);
                            add = true;
                        }
                    } else {
                        customMsg = new OwnLabel((CharSequence)msg, this.skin, style);
                        add = true;
                    }
                    customMsg.setColor(r, g, b, a);
                    customMsg.setPosition(x, y);
                    customMsg.setFontScale(scaleFactor);
                    if (add) {
                        this.ui.addActor((Actor)customMsg);
                    }
                    this.customElements.put(id, (Widget)customMsg);
                    break;
                }
                case ADD_CUSTOM_TEXT: {
                    TextArea customText;
                    Integer id = (Integer)data[0];
                    String msg = (String)data[1];
                    float x = MathUtilsDouble.lint(((Float)data[2]).floatValue(), 0.0f, 1.0f, 0.0f, width);
                    float y = MathUtilsDouble.lint(((Float)data[3]).floatValue(), 0.0f, 1.0f, 0.0f, height);
                    float w = MathUtilsDouble.clamp(MathUtilsDouble.lint(((Float)data[4]).floatValue(), 0.0f, 1.0f, 0.0f, width), 0.0f, width - x);
                    float h = MathUtilsDouble.clamp(MathUtilsDouble.lint(((Float)data[5]).floatValue(), 0.0f, 1.0f, 0.0f, height), 0.0f, height - y);
                    float r = ((Float)data[6]).floatValue();
                    float g = ((Float)data[7]).floatValue();
                    float b = ((Float)data[8]).floatValue();
                    float a = ((Float)data[9]).floatValue();
                    float s = ((Float)data[10]).floatValue();
                    int size = (int)s;
                    int cSize = this.findClosestSize(size);
                    String style = "msg-" + cSize;
                    boolean add = false;
                    if (this.customElements.containsKey(id)) {
                        if (this.customElements.get(id) instanceof TextArea) {
                            customText = (TextArea)this.customElements.get(id);
                            customText.setText(msg);
                            customText.setStyle((TextField.TextFieldStyle)this.skin.get(style, TextField.TextFieldStyle.class));
                        } else {
                            this.removeObject(id);
                            customText = new TextArea(msg, this.skin, style);
                            add = true;
                        }
                    } else {
                        customText = new TextArea(msg, this.skin, style);
                        add = true;
                    }
                    customText.setColor(r, g, b, a);
                    customText.setPosition(x, y);
                    customText.setDisabled(true);
                    if (w > 0.0f) {
                        customText.setWidth(w);
                    }
                    if (h > 0.0f) {
                        customText.setHeight(h);
                    }
                    if (add) {
                        this.ui.addActor((Actor)customText);
                    }
                    this.customElements.put(id, (Widget)customText);
                    break;
                }
                case REMOVE_OBJECTS: {
                    int[] ids;
                    for (int identifier : ids = (int[])data[0]) {
                        this.removeObject(identifier);
                    }
                    break;
                }
                case REMOVE_ALL_OBJECTS: {
                    Set<Integer> keys = this.customElements.keySet();
                    Iterator<Integer> it = keys.iterator();
                    while (it.hasNext()) {
                        Integer key = it.next();
                        Widget toRemove = this.customElements.get(key);
                        if (toRemove == null) continue;
                        toRemove.remove();
                        it.remove();
                    }
                    this.customElements.clear();
                    break;
                }
            }
        }
    }

    private void removeObject(Integer id) {
        Widget toRemove = this.customElements.get(id);
        if (toRemove != null) {
            toRemove.remove();
            this.customElements.remove(id);
        }
    }

    private int findClosestSize(int size) {
        for (int current : this.sizes) {
            if (size != current && size >= current) continue;
            return current;
        }
        return this.sizes.getLast();
    }

    @Override
    public void dispose() {
        this.unsubscribe();
    }

    @Override
    public void update() {
    }

    @Override
    public boolean isOn() {
        return true;
    }
}

