/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.text.DecimalFormat;

public class DebugInterface
extends TableGuiInterface
implements IObserver {
    private OwnLabel debugRuntime;
    private OwnLabel debugRAMUsed;
    private OwnLabel debugRAMFree;
    private OwnLabel debugRAMAlloc;
    private OwnLabel debugRAMTotal;
    private OwnLabel debugVRAMUsed;
    private OwnLabel debugVRAMTotal;
    private OwnLabel debugObjectsDisplay;
    private OwnLabel debugObjectsLoaded;
    private OwnLabel debugOcObserved;
    private OwnLabel debugOcQueue;
    private OwnLabel fps;
    private OwnLabel spf;
    private OwnLabel debugSamp;
    private OwnLabel debugDynRes;
    private final Object lock;
    private final Skin skin;
    private Cell<Table> extraCell;
    private Table extra;
    private final DecimalFormat fpsFormatter;
    private final DecimalFormat spfFormatter;
    private final DecimalFormat memFormatter;
    private final DecimalFormat timeFormatter;
    private boolean maximized;
    private boolean showDynRes = false;

    public DebugInterface(Skin skin, Object lock) {
        super(skin);
        this.setBackground("table-bg");
        this.maximized = false;
        this.skin = skin;
        this.pad(10.0f);
        this.fpsFormatter = new DecimalFormat("#.00");
        this.spfFormatter = new DecimalFormat("#.00##");
        this.memFormatter = new DecimalFormat("#000.00");
        this.timeFormatter = new DecimalFormat("00");
        this.build();
        this.setVisible(Settings.settings.program.debugInfo);
        this.lock = lock;
        EventManager.instance.subscribe((IObserver)this, Event.DEBUG_TIME, Event.DEBUG_RAM, Event.DEBUG_VRAM, Event.DEBUG_OBJECTS, Event.DEBUG_QUEUE, Event.DEBUG_DYN_RES, Event.FPS_INFO, Event.SHOW_DEBUG_CMD, Event.SAMP_INFO);
    }

    private void build() {
        this.clear();
        float pad05 = 8.0f;
        float pad10 = 16.0f;
        float groupSeparation = 18.0f;
        float minWidth = 120.0f;
        this.fps = new OwnLabel((CharSequence)"", this.skin, "hud-big");
        this.fps.setAlignment(16);
        this.fps.setColor(this.skin.getColor("green"));
        this.fps.setWidth(170.0f);
        this.fps.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.fps.info"), this.skin));
        this.add((Actor)this.fps).right().minWidth(minWidth);
        this.row();
        this.spf = new OwnLabel((CharSequence)"", this.skin, "hud-med");
        this.spf.setAlignment(16);
        this.spf.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.spf.info"), this.skin));
        this.add((Actor)this.spf).right().minWidth(minWidth).padBottom(pad05);
        this.row();
        this.extra = new Table(this.skin);
        final Link toggleSize = new Link((CharSequence)(this.maximized ? "(-)" : "(+)"), this.skin, null);
        final OwnTextTooltip toggleSizeTooltip = new OwnTextTooltip(I18n.msg("gui.maximize.pane"), this.skin);
        toggleSize.addListener((EventListener)toggleSizeTooltip);
        toggleSize.addListener((EventListener)new ClickListener(this){
            final /* synthetic */ DebugInterface this$0;
            {
                this.this$0 = this$0;
            }

            public void clicked(InputEvent event, float x, float y) {
                if (this.this$0.maximized) {
                    this.this$0.maximized = false;
                    this.this$0.extra.addAction((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.run(() -> {
                        this.this$0.extraCell.setActor(null);
                        toggleSize.setText("(+)");
                        toggleSizeTooltip.setText(I18n.msg("gui.maximize.pane"));
                    })));
                } else {
                    this.this$0.maximized = true;
                    this.this$0.extraCell.setActor((Actor)this.this$0.extra);
                    this.this$0.extra.addAction((Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.run(() -> {
                        toggleSize.setText("(-)");
                        toggleSizeTooltip.setText(I18n.msg("gui.minimize.pane"));
                    })));
                }
                this.this$0.pack();
            }
        });
        Link odwLink = new Link((CharSequence)"\u03b1", this.skin, null);
        odwLink.addListener((EventListener)new OwnTextTooltip("Debug individual objects...", this.skin));
        odwLink.addListener((EventListener)new ClickListener(this){

            public void clicked(InputEvent event, float x, float y) {
                EventManager.publish(Event.SHOW_OBJECT_DEBUG_ACTION, (Object)this, new Object[0]);
            }
        });
        this.extraCell = this.add();
        this.row();
        if (this.maximized) {
            this.extraCell.setActor((Actor)this.extra);
        }
        this.add((Actor)odwLink).left().padRight(pad05);
        this.add((Actor)toggleSize).right().row();
        Settings settings = Settings.settings;
        HorizontalGroup deviceGroup = new HorizontalGroup();
        deviceGroup.space(pad05);
        String glDevice = Gdx.gl.glGetString(7937);
        String glDeviceShort = TextUtils.capString(glDevice, 25);
        OwnLabel device = new OwnLabel((CharSequence)glDeviceShort, this.skin, "hud-big");
        device.setColor(this.skin.getColor("blue"));
        device.addListener((EventListener)new OwnTextTooltip(glDevice, this.skin));
        deviceGroup.addActor((Actor)device);
        if (glDevice.length() != glDeviceShort.length()) {
            OwnImageButton deviceTooltip = new OwnImageButton(this.skin, "tooltip");
            deviceTooltip.addListener((EventListener)new OwnTextTooltip(glDevice, this.skin));
            deviceGroup.addActor((Actor)deviceTooltip);
        }
        this.extra.add((Actor)deviceGroup).colspan(2).right().padBottom(pad05).row();
        if (settings.program.net.master.active) {
            OwnLabel master = new OwnLabel((CharSequence)TextUtils.surroundBrackets(I18n.msg("gui.master.instance")), this.skin, "hud-big");
            master.setColor(ColorUtils.gYellowC);
            master.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.master.instance.tooltip"), this.skin));
            this.extra.add((Actor)master).colspan(2).right().padBottom(pad10).row();
        }
        if (settings.program.net.slave.active) {
            OwnLabel slave = new OwnLabel((CharSequence)TextUtils.surroundBrackets(I18n.msg("gui.slave.instance")), this.skin, "hud-big");
            slave.setColor(ColorUtils.gYellowC);
            slave.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.slave.instance.tooltip"), this.skin));
            this.extra.add((Actor)slave).colspan(2).right().padBottom(pad10).row();
        }
        if (settings.program.safeMode) {
            OwnLabel safeMode = new OwnLabel((CharSequence)TextUtils.surroundBrackets(I18n.msg("gui.debug.safemode")), this.skin, "hud-big");
            safeMode.setColor(ColorUtils.gRedC);
            safeMode.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.safemode.tooltip"), this.skin));
            this.extra.add((Actor)safeMode).colspan(2).right().padBottom(pad10).row();
        }
        this.debugRuntime = new OwnLabel((CharSequence)"", this.skin, "hud");
        Table timeTable = new Table(this.skin);
        timeTable.add((Actor)this.debugRuntime);
        OwnLabel runTimeLabel = new OwnLabel((CharSequence)I18n.msg("gui.debug.runtime"), this.skin, "hud-big");
        runTimeLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.runtime.info"), this.skin));
        runTimeLabel.setColor(this.skin.getColor("theme"));
        this.extra.add((Actor)timeTable).right().padRight(pad10).padBottom(groupSeparation);
        this.extra.add((Actor)runTimeLabel).left().padBottom(groupSeparation);
        this.extra.row();
        this.debugRAMUsed = new OwnLabel((CharSequence)"", this.skin, "hud");
        this.debugRAMFree = new OwnLabel((CharSequence)"", this.skin, "hud");
        this.debugRAMAlloc = new OwnLabel((CharSequence)"", this.skin, "hud");
        this.debugRAMTotal = new OwnLabel((CharSequence)"", this.skin, "hud");
        Table debugRAMTable = new Table(this.skin);
        debugRAMTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.ram.used"), this.skin, "hud")).right().padRight(pad10);
        debugRAMTable.add((Actor)this.debugRAMUsed).right().row();
        debugRAMTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.ram.free"), this.skin, "hud")).right().padRight(pad10).padBottom(pad05);
        debugRAMTable.add((Actor)this.debugRAMFree).right().padBottom(pad05).row();
        debugRAMTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.ram.alloc"), this.skin, "hud")).right().padRight(pad10);
        debugRAMTable.add((Actor)this.debugRAMAlloc).right().row();
        debugRAMTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.ram.total"), this.skin, "hud")).right().padRight(pad10);
        debugRAMTable.add((Actor)this.debugRAMTotal).right();
        OwnLabel memoryLabel = new OwnLabel((CharSequence)I18n.msg("gui.debug.ram"), this.skin, "hud-big");
        memoryLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.ram.info"), this.skin));
        memoryLabel.setColor(this.skin.getColor("theme"));
        this.extra.add((Actor)debugRAMTable).right().padRight(pad10).padBottom(groupSeparation);
        this.extra.add((Actor)memoryLabel).left().padBottom(groupSeparation);
        this.extra.row();
        this.debugVRAMUsed = new OwnLabel((CharSequence)"", this.skin, "hud");
        this.debugVRAMTotal = new OwnLabel((CharSequence)"", this.skin, "hud");
        Table debugVRAMTable = new Table(this.skin);
        debugVRAMTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.vram.used"), this.skin, "hud")).right().padRight(pad10);
        debugVRAMTable.add((Actor)this.debugVRAMUsed).right().row();
        debugVRAMTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.vram.total"), this.skin, "hud")).right().padRight(pad10);
        debugVRAMTable.add((Actor)this.debugVRAMTotal).right();
        OwnLabel vmemoryLabel = new OwnLabel((CharSequence)I18n.msg("gui.debug.vram"), this.skin, "hud-big");
        vmemoryLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.vram.info"), this.skin));
        vmemoryLabel.setColor(this.skin.getColor("theme"));
        this.extra.add((Actor)debugVRAMTable).right().padRight(pad10).padBottom(groupSeparation);
        this.extra.add((Actor)vmemoryLabel).left().padBottom(groupSeparation);
        this.extra.row();
        this.debugObjectsDisplay = new OwnLabel((CharSequence)"", this.skin, "hud");
        this.debugObjectsLoaded = new OwnLabel((CharSequence)"", this.skin, "hud");
        Table objectsTable = new Table(this.skin);
        objectsTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.obj.display"), this.skin, "hud")).right().padRight(pad10);
        objectsTable.add((Actor)this.debugObjectsDisplay).right().row();
        objectsTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.obj.loaded"), this.skin, "hud")).right().padRight(pad10);
        objectsTable.add((Actor)this.debugObjectsLoaded).right();
        OwnLabel objectsLabel = new OwnLabel((CharSequence)I18n.msg("gui.debug.obj"), this.skin, "hud-big");
        objectsLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.obj.info"), this.skin));
        objectsLabel.setColor(this.skin.getColor("theme"));
        this.extra.add((Actor)objectsTable).right().padRight(pad10).padBottom(groupSeparation);
        this.extra.add((Actor)objectsLabel).left().padBottom(groupSeparation);
        this.extra.row();
        this.debugOcObserved = new OwnLabel((CharSequence)"", this.skin, "hud");
        this.debugOcQueue = new OwnLabel((CharSequence)"", this.skin, "hud");
        Table octantsTable = new Table(this.skin);
        octantsTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.lod.observed"), this.skin, "hud")).right().padRight(pad10);
        octantsTable.add((Actor)this.debugOcObserved).right().row();
        octantsTable.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.debug.lod.queue"), this.skin, "hud")).right().padRight(pad10).padBottom(pad05);
        octantsTable.add((Actor)this.debugOcQueue).right().padBottom(pad05).row();
        OwnLabel lodLabel = new OwnLabel((CharSequence)I18n.msg("gui.debug.lod"), this.skin, "hud-big");
        lodLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.lod.info"), this.skin));
        lodLabel.setColor(this.skin.getColor("theme"));
        this.extra.add((Actor)octantsTable).right().padRight(pad10).padBottom(groupSeparation);
        this.extra.add((Actor)lodLabel).left().padBottom(groupSeparation);
        this.extra.row();
        this.debugDynRes = new OwnLabel((CharSequence)"", this.skin, "hud");
        OwnLabel dynResLabel = new OwnLabel((CharSequence)I18n.msg("gui.debug.dynres.short"), this.skin, "hud-big");
        dynResLabel.setColor(this.skin.getColor("theme"));
        if (this.showDynRes) {
            this.extra.add((Actor)this.debugDynRes).right().padRight(pad10).padBottom(groupSeparation);
            this.extra.add((Actor)dynResLabel).left().padBottom(groupSeparation);
            this.extra.row();
        }
        this.debugSamp = new OwnLabel((CharSequence)"", this.skin, "hud");
        Table sampTable = new Table(this.skin);
        sampTable.add((Actor)this.debugSamp);
        OwnLabel sampLabel = new OwnLabel((CharSequence)I18n.msg("gui.debug.samp"), this.skin, "hud-big");
        sampLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.samp.info"), this.skin));
        sampLabel.setColor(this.skin.getColor("theme"));
        this.extra.add((Actor)sampTable).right().padRight(pad10);
        this.extra.add((Actor)sampLabel).left();
        this.extra.row();
        this.pack();
    }

    private void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    private Color getColor(double v, double max) {
        if (v > max * 0.95) {
            return this.skin.getColor("red");
        }
        if (v > max * 0.9) {
            return this.skin.getColor("orange");
        }
        if (v > max * 0.85) {
            return this.skin.getColor("yellow");
        }
        return this.skin.getColor("green");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        Object object = this.lock;
        synchronized (object) {
            boolean debug = Settings.settings.program.debugInfo;
            switch (event) {
                case DEBUG_TIME: {
                    if (!debug || data.length <= 0) break;
                    Double runTime = (Double)data[0];
                    this.debugRuntime.setText(this.getRunTimeString(runTime));
                    break;
                }
                case DEBUG_RAM: {
                    if (!debug || data.length <= 0) break;
                    Double used = (Double)data[0];
                    Double free = (Double)data[1];
                    Double alloc = (Double)data[2];
                    Double total = (Double)data[3];
                    String unit = " " + I18n.msg("gui.debug.ram.unit");
                    this.debugRAMUsed.setText(this.memFormatter.format(used) + unit);
                    this.debugRAMUsed.setColor(this.getColor(used, alloc));
                    this.debugRAMFree.setText(this.memFormatter.format(free) + unit);
                    this.debugRAMAlloc.setText(this.memFormatter.format(alloc) + unit);
                    this.debugRAMAlloc.setColor(this.getColor(alloc, total));
                    this.debugRAMTotal.setText(this.memFormatter.format(total) + unit);
                    break;
                }
                case DEBUG_VRAM: {
                    if (!debug || data.length <= 0) break;
                    Double used = (Double)data[0];
                    Double total = (Double)data[1];
                    if (used <= 0.0 || total <= 0.0) {
                        this.debugVRAMUsed.setText(I18n.msg("gui.debug.na"));
                        this.debugVRAMTotal.setText(I18n.msg("gui.debug.na"));
                        break;
                    }
                    String unit = " " + I18n.msg("gui.debug.vram.unit");
                    this.debugVRAMUsed.setText(this.memFormatter.format(used) + unit);
                    this.debugVRAMUsed.setColor(this.getColor(used, total));
                    this.debugVRAMTotal.setText(this.memFormatter.format(total) + unit);
                    break;
                }
                case DEBUG_OBJECTS: {
                    if (!debug || data.length <= 0) break;
                    Integer display = (Integer)data[0];
                    Integer loaded = (Integer)data[1];
                    this.debugObjectsDisplay.setText(display);
                    this.debugObjectsLoaded.setText(loaded);
                    break;
                }
                case DEBUG_QUEUE: {
                    if (!debug || data.length <= 0) break;
                    int observed = (Integer)data[0];
                    int queueSize = (Integer)data[1];
                    this.debugOcObserved.setText(observed);
                    this.debugOcQueue.setText(queueSize);
                    break;
                }
                case DEBUG_DYN_RES: {
                    if (!debug || data.length <= 0) break;
                    this.debugDynRes.setText("L" + String.valueOf(data[0]) + ": " + this.fpsFormatter.format(data[1]));
                    if (this.showDynRes) break;
                    this.showDynRes = true;
                    this.build();
                    break;
                }
                case FPS_INFO: {
                    if (!debug || data.length <= 0) break;
                    double dfps = ((Float)data[0]).floatValue();
                    double dspf = 1000.0 / dfps;
                    this.fps.setText(this.fpsFormatter.format(dfps).concat(" " + I18n.msg("gui.debug.fps")));
                    this.spf.setText(this.spfFormatter.format(dspf).concat(" " + I18n.msg("gui.debug.ms")));
                    break;
                }
                case SAMP_INFO: {
                    if (!debug || data.length <= 0) break;
                    this.debugSamp.setText((String)data[0]);
                    break;
                }
                case SHOW_DEBUG_CMD: {
                    boolean showDebugInfo = data.length >= 1 ? (Boolean)data[0] : !this.isVisible();
                    Settings.settings.program.debugInfo = showDebugInfo;
                    if (showDebugInfo) {
                        this.addAction((Action)Actions.sequence((Action)Actions.visible((boolean)true), (Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)Settings.settings.program.ui.getAnimationSeconds())));
                        break;
                    }
                    this.addAction((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.visible((boolean)false)));
                    break;
                }
            }
        }
    }

    private String getRunTimeString(Double totalSeconds) {
        double hours = Math.floor(totalSeconds / 3600.0);
        double remainingSeconds = totalSeconds % 3600.0;
        double minutes = Math.floor(remainingSeconds / 60.0);
        double seconds = Math.floor(remainingSeconds % 60.0);
        return this.timeFormatter.format(hours) + ":" + this.timeFormatter.format(minutes) + ":" + this.timeFormatter.format(seconds);
    }

    @Override
    public void dispose() {
        this.unsubscribe();
    }

    @Override
    public void update() {
    }
}

