/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.util.scene2d.OwnProgressBar;

public class LoadProgressInterface
extends TableGuiInterface
implements IObserver {
    private static final int MAX_PROGRESS_BARS = 5;
    private final ObjectMap<String, OwnProgressBar> progress;
    private final Skin skin;
    private final VerticalGroup stack;
    private final float width;
    private final Object lock = new Object();

    public LoadProgressInterface(float width, Skin skin) {
        super(skin);
        this.progress = new ObjectMap(10);
        this.skin = skin;
        this.stack = new VerticalGroup();
        this.width = width;
        this.add((Actor)this.stack).center();
        EventManager.instance.subscribe((IObserver)this, Event.UPDATE_LOAD_PROGRESS);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.UPDATE_LOAD_PROGRESS) {
            String name = (String)data[0];
            float val = ((Float)data[1]).floatValue();
            Object object = this.lock;
            synchronized (object) {
                OwnProgressBar p = null;
                if (!this.progress.containsKey((Object)name) && val < 1.0f) {
                    if (this.progress.size < 5) {
                        p = new OwnProgressBar(0.0f, 100.0f, 0.1f, false, this.skin, "small-horizontal");
                        p.setTitle(name, this.skin);
                        p.setPrefWidth(this.width);
                        this.progress.put((Object)name, (Object)p);
                        this.stack.addActor((Actor)p);
                    }
                } else {
                    p = (OwnProgressBar)((Object)this.progress.get((Object)name));
                }
                if (p != null) {
                    p.setValue(val * 100.0f);
                    if (val >= 1.0f) {
                        p.setVisible(false);
                        this.progress.remove((Object)name);
                        this.stack.removeActor((Actor)p, true);
                    }
                }
            }
        }
    }
}

