/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.scene.component.LocationMark;
import gaiasky.util.TextUtils;
import gaiasky.util.scene2d.Link;
import gaiasky.util.scene2d.OwnLabel;

public class LocationInfoInterface
extends TableGuiInterface
implements IObserver {
    private final Skin skin;
    private static final double TIMEOUT_SECS = 1.0;
    private double lastUpdateTime = -1.0;
    private String currentLocation;
    private final Table content;

    public LocationInfoInterface(Skin skin) {
        super(skin);
        this.skin = skin;
        this.content = new Table(skin);
        this.content.setBackground("default-round");
        this.content.pad(15.0f);
        EventManager.instance.subscribe((IObserver)this, Event.LOCATION_HOVER_INFO);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void update() {
        double currentTime = GaiaSky.instance.getRunTimeSeconds();
        if (currentTime - this.lastUpdateTime > 1.0) {
            this.currentLocation = null;
            this.content.clear();
            this.clear();
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.LOCATION_HOVER_INFO) {
            Integer x = (Integer)data[0];
            Integer y = (Integer)data[1];
            LocationMark loc = (LocationMark)data[2];
            if (this.currentLocation != null) {
                if (!loc.displayName.equals(this.currentLocation)) {
                    this.content.clear();
                    this.clear();
                    this.addLocationDialog(x, y, loc);
                }
            } else {
                this.addLocationDialog(x, y, loc);
            }
            this.lastUpdateTime = GaiaSky.instance.getRunTimeSeconds();
        }
    }

    private void addLocationDialog(int x, int y, LocationMark loc) {
        String description = loc.tooltipText;
        description = TextUtils.breakCharacters(description, 50);
        this.content.add((Actor)new OwnLabel((CharSequence)loc.displayName, this.skin, "header-s")).left().padBottom(12.0f).row();
        if (description != null) {
            this.content.add((Actor)new OwnLabel((CharSequence)description, this.skin)).left().padBottom(12.0f).row();
        }
        if (loc.link != null) {
            this.content.add((Actor)new Link((CharSequence)TextUtils.capString(loc.link, 50), this.skin, loc.link)).left();
        }
        this.content.pack();
        this.add((Actor)this.content).bottom().center();
        this.currentLocation = loc.displayName;
        Vector2 v = new Vector2((float)x, (float)y);
        this.getStage().screenToStageCoordinates(v);
        this.setPosition(v.x + this.content.getWidth() / 2.0f + 5.0f, v.y - this.content.getHeight() / 2.0f - 5.0f);
    }
}

