/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.util.scene2d.OwnLabel;
import java.util.HashMap;
import java.util.Map;

public class MessagesInterface
extends TableGuiInterface
implements IObserver {
    private final Object lock;
    Map<Integer, Widget> customElements = new HashMap<Integer, Widget>();
    private final Label headline;
    private final Label subhead;

    public MessagesInterface(Skin skin, Object lock) {
        super(skin);
        this.headline = new OwnLabel((CharSequence)"", skin, "headline");
        this.headline.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        this.subhead = new OwnLabel((CharSequence)"", skin, "subhead");
        this.add((Actor)this.headline).left().padBottom(20.0f);
        this.row();
        this.add((Actor)this.subhead).left();
        this.lock = lock;
        EventManager.instance.subscribe((IObserver)this, Event.POST_HEADLINE_MESSAGE, Event.CLEAR_HEADLINE_MESSAGE, Event.POST_SUBHEAD_MESSAGE, Event.CLEAR_SUBHEAD_MESSAGE, Event.CLEAR_MESSAGES);
    }

    private void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        Object object = this.lock;
        synchronized (object) {
            switch (event) {
                case POST_HEADLINE_MESSAGE: {
                    this.headline.setText((CharSequence)((String)data[0]));
                    break;
                }
                case CLEAR_HEADLINE_MESSAGE: {
                    this.headline.setText((CharSequence)"");
                    break;
                }
                case POST_SUBHEAD_MESSAGE: {
                    this.subhead.setText((CharSequence)((String)data[0]));
                    break;
                }
                case CLEAR_SUBHEAD_MESSAGE: {
                    this.subhead.setText((CharSequence)"");
                    break;
                }
                case CLEAR_MESSAGES: {
                    this.headline.setText((CharSequence)"");
                    this.subhead.setText((CharSequence)"");
                    break;
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.unsubscribe();
    }

    @Override
    public void update() {
    }
}

