/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.StringBuilder;
import gaiasky.GaiaSky;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.gui.main.MessageBean;
import gaiasky.gui.main.ModePopupInfo;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import net.jafama.FastMath;

public class NotificationsInterface
extends TableGuiInterface
implements IObserver {
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static final String TAG_SEPARATOR = " - ";
    public static LinkedList<MessageBean> historical = new LinkedList();
    final Object lock;
    DateTimeFormatter df;
    long msTimeout;
    Label message1;
    Label message2;
    Cell<Label> c1;
    Cell<Label> c2;
    boolean displaying = false;
    boolean historicalLog = false;
    boolean permanent = false;
    boolean multiple;
    boolean writeDates = true;
    boolean showSources = false;
    boolean ignoreDisplaySetting = false;

    public NotificationsInterface(Skin skin, Object lock, boolean multiple, boolean writeDates, boolean bg) {
        this(skin, lock, multiple, bg);
        this.writeDates = writeDates;
    }

    public NotificationsInterface(Skin skin, Object lock, boolean multiple, boolean writeDates, boolean historicalLog, boolean bg) {
        this(skin, lock, multiple, writeDates, bg);
        this.historicalLog = historicalLog;
    }

    public NotificationsInterface(Skin skin, Object lock, boolean multiple, boolean bg) {
        this(null, 5000L, skin, multiple, bg, lock);
    }

    public NotificationsInterface(List<MessageBean> logs, long msTimeout, Skin skin, boolean multiple, boolean bg, Object lock) {
        super(skin);
        this.lock = lock;
        if (logs != null) {
            historical.addAll(logs);
        }
        this.msTimeout = msTimeout;
        this.multiple = multiple;
        if (bg) {
            this.setBackground("table-bg");
        }
        if (multiple) {
            this.message2 = new OwnLabel((CharSequence)"", skin, "hud-med");
            this.message2.setName("message2");
            this.c2 = this.add((Actor)this.message2).left();
            this.c2.row();
        }
        this.message1 = new OwnLabel((CharSequence)"", skin, "hud-med");
        this.message1.setName("message1");
        this.c1 = this.add((Actor)this.message1).left();
        this.df = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss").withLocale(I18n.locale).withZone(ZoneOffset.UTC);
        EventManager.instance.subscribe((IObserver)this, Event.POST_NOTIFICATION, Event.SHOW_NOTIFICATIONS_CMD, Event.FOCUS_CHANGED, Event.TIME_STATE_CMD, Event.TOGGLE_VISIBILITY_CMD, Event.CAMERA_MODE_CMD, Event.TIME_WARP_CHANGED_INFO, Event.FOCUS_LOCK_CMD, Event.JAVA_EXCEPTION, Event.ORBIT_DATA_LOADED, Event.SCREENSHOT_INFO, Event.STEREOSCOPIC_CMD, Event.DISPLAY_GUI_CMD, Event.FRAME_OUTPUT_CMD, Event.STEREO_PROFILE_CMD, Event.OCTREE_PARTICLE_FADE_CMD, Event.SCREEN_NOTIFICATION_CMD, Event.MODE_POPUP_CMD, Event.CAMERA_CINEMATIC_CMD);
    }

    public void setIgnoreDisplaySetting(boolean value) {
        this.ignoreDisplaySetting = value;
    }

    public static List<MessageBean> getHistorical() {
        return historical;
    }

    public void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    private void addMessage(String msg) {
        this.addMessage(msg, false, Logger.LoggerLevel.INFO);
    }

    private void addMessage(String msg, boolean permanent, Logger.LoggerLevel level) {
        if (this.ignoreDisplaySetting || Settings.settings.program.ui.notifications) {
            GaiaSky.postRunnable(() -> {
                boolean add;
                MessageBean messageBean = new MessageBean(msg);
                boolean debug = level.equals((Object)Logger.LoggerLevel.DEBUG);
                boolean bl = add = !debug || Gdx.app.getLogLevel() >= 3;
                if (add) {
                    if (this.multiple && !historical.isEmpty() && !historical.getLast().finished(this.msTimeout)) {
                        this.setText(this.message2, this.c2, this.message1.getText());
                    }
                    this.setText(this.message1, this.c1, this.formatMessage(messageBean, level));
                    this.displaying = true;
                    this.permanent = permanent;
                    if (this.historicalLog) {
                        historical.add(messageBean);
                    }
                }
            });
        }
    }

    private String formatMessage(MessageBean msgBean, Logger.LoggerLevel level) {
        String lvl;
        String string = lvl = level.equals((Object)Logger.LoggerLevel.DEBUG) ? " DEBUG" : "";
        return (String)(this.writeDates ? this.df.format(msgBean.date()) + lvl + TAG_SEPARATOR : (lvl.isBlank() ? "" : lvl + TAG_SEPARATOR)) + msgBean.msg();
    }

    @Override
    public void update() {
        if (this.displaying && !this.permanent) {
            if (this.multiple && historical.size() > 1 && historical.get(historical.size() - 2).finished(this.msTimeout)) {
                this.clearText(this.message2, this.c2);
            }
            if (historical.getLast().finished(this.msTimeout)) {
                this.displaying = false;
                this.clearText(this.message1, this.c1);
            }
            if (!this.c1.hasActor() && !this.c2.hasActor()) {
                this.setVisible(false);
            } else if (this.c1.hasActor() || this.c2.hasActor()) {
                this.setVisible(true);
            }
        }
    }

    private void setText(Label l, Cell<Label> c, String text) {
        l.setText((CharSequence)text);
        c.setActor((Actor)l);
        this.setVisible(true);
    }

    private void setText(Label l, Cell<Label> c, StringBuilder text) {
        this.setText(l, c, text.toString());
    }

    private void clearText(Label l, Cell<Label> c) {
        l.setText((CharSequence)"");
        c.setActor(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        Object object = this.lock;
        synchronized (object) {
            switch (event) {
                case SHOW_NOTIFICATIONS_CMD: {
                    this.setVisible(this.ignoreDisplaySetting || (Boolean)data[0] != false);
                    break;
                }
                case POST_NOTIFICATION: {
                    Logger.LoggerLevel level = (Logger.LoggerLevel)((Object)data[0]);
                    Object[] dat = (Object[])data[1];
                    java.lang.StringBuilder message = new java.lang.StringBuilder();
                    boolean permanent = false;
                    int startIndex = 0;
                    if (dat.length > 1 && !this.showSources) {
                        startIndex = 1;
                    }
                    for (int i = startIndex; i < dat.length; ++i) {
                        if (i == dat.length - 1 && dat[i] instanceof Boolean) {
                            permanent = (Boolean)dat[i];
                            continue;
                        }
                        message.append(dat[i].toString());
                        if (i >= dat.length - 1 || i == dat.length - 2 && dat[dat.length - 1] instanceof Boolean) continue;
                        message.append(TAG_SEPARATOR);
                    }
                    this.addMessage(message.toString(), permanent, level);
                    break;
                }
                case FOCUS_CHANGED: {
                    if (data[0] == null) break;
                    if (data[0] instanceof String) {
                        this.addMessage(I18n.msg("notif.camerafocus", data[0]));
                        break;
                    }
                    FocusView focus = (FocusView)data[0];
                    this.addMessage(I18n.msg("notif.camerafocus", focus.getName()));
                    break;
                }
                case TIME_STATE_CMD: {
                    Boolean bool = (Boolean)data[0];
                    if (bool == null) {
                        this.addMessage(I18n.msg("notif.toggle", I18n.msg("gui.time")));
                        break;
                    }
                    this.addMessage(I18n.msg("notif.simulation." + (bool != false ? "resume" : "pause")));
                    break;
                }
                case TOGGLE_VISIBILITY_CMD: {
                    if (data.length == 2) {
                        this.addMessage(I18n.msg("notif.visibility." + ((Boolean)data[1] != false ? "on" : "off"), I18n.msg((String)data[0])));
                        break;
                    }
                    this.addMessage(I18n.msg("notif.visibility.toggle", I18n.msg((String)data[0])));
                    break;
                }
                case OCTREE_PARTICLE_FADE_CMD: {
                    String key = (Boolean)data[0] != false ? "notif.activated" : "notif.deactivated";
                    this.addMessage(I18n.msg(key, I18n.msg("element.octreeparticlefade")));
                    break;
                }
                case FOCUS_LOCK_CMD: {
                    String key = (Boolean)data[0] != false ? "notif.activated" : "notif.deactivated";
                    this.addMessage(I18n.msg(key, I18n.msg("gui.camera.lock")));
                    break;
                }
                case ORIENTATION_LOCK_CMD: {
                    String key = (Boolean)data[0] != false ? "notif.activated" : "notif.deactivated";
                    this.addMessage(I18n.msg(key, I18n.msg("gui.camera.lock.orientation")));
                    break;
                }
                case CAMERA_MODE_CMD: {
                    CameraManager.CameraMode cm = (CameraManager.CameraMode)((Object)data[0]);
                    if (cm == CameraManager.CameraMode.FOCUS_MODE) break;
                    this.addMessage(I18n.msg("notif.cameramode.change", data[0]));
                    break;
                }
                case CAMERA_CINEMATIC_CMD: {
                    Boolean state = (Boolean)data[0];
                    this.addMessage(I18n.msg("gui.camera.cinematic") + ": " + I18n.msg("gui." + (state != false ? "on" : "off")));
                    break;
                }
                case TIME_WARP_CHANGED_INFO: {
                    this.addMessage(I18n.msg("notif.timepace.change", data[0]));
                    break;
                }
                case JAVA_EXCEPTION: {
                    Throwable t = (Throwable)data[0];
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    String stackTrace = sw.toString();
                    if (data.length == 1) {
                        if (I18n.messages != null) {
                            this.addMessage(I18n.msg("notif.error", stackTrace));
                            break;
                        }
                        this.addMessage("Error: " + stackTrace);
                        break;
                    }
                    if (I18n.messages != null) {
                        this.addMessage(I18n.msg("notif.error", String.valueOf(data[1]) + TAG_SEPARATOR + stackTrace));
                        break;
                    }
                    this.addMessage("Error: " + String.valueOf(data[1]) + TAG_SEPARATOR + stackTrace);
                    break;
                }
                case ORBIT_DATA_LOADED: {
                    this.addMessage(I18n.msg("notif.orbitdata.loaded", data[1], ((PointCloudData)data[0]).getNumPoints()), false, Logger.LoggerLevel.DEBUG);
                    break;
                }
                case SCREENSHOT_INFO: {
                    this.addMessage(I18n.msg("notif.screenshot", data[0]));
                    break;
                }
                case STEREOSCOPIC_CMD: {
                    if (Settings.settings.runtime.openXr) break;
                    this.addMessage(I18n.msg("notif.toggle", I18n.msg("notif.stereoscopic")));
                    break;
                }
                case DISPLAY_GUI_CMD: {
                    boolean displayGui = (Boolean)data[0];
                    this.addMessage(I18n.msg("notif." + (!displayGui ? "activated" : "deactivated"), data[1]));
                    break;
                }
                case STEREO_PROFILE_CMD: {
                    this.addMessage(I18n.msg("notif.stereoscopic.profile", Settings.StereoProfile.values()[(Integer)data[0]].toString()));
                    break;
                }
                case FRAME_OUTPUT_CMD: {
                    boolean activated = (Boolean)data[0];
                    if (activated) {
                        this.addMessage(I18n.msg("notif.activated", I18n.msg("element.frameoutput")));
                        break;
                    }
                    this.addMessage(I18n.msg("notif.deactivated", I18n.msg("element.frameoutput")));
                    break;
                }
                case SCREEN_NOTIFICATION_CMD: {
                    String title = (String)data[0];
                    String[] msgs = (String[])data[1];
                    this.addMessage(title);
                    for (String msg : msgs) {
                        this.addMessage(msg);
                    }
                    break;
                }
                case MODE_POPUP_CMD: {
                    ModePopupInfo mpi = (ModePopupInfo)data[0];
                    if (mpi == null || !Settings.settings.runtime.displayGui || !Settings.settings.program.ui.modeChangeInfo) break;
                    this.addMessage(mpi.title);
                    this.addMessage(mpi.header);
                    for (Pair p : mpi.mappings) {
                        String[] keys = (String[])p.getFirst();
                        String action = (String)p.getSecond();
                        if (keys == null || keys.length <= 0 || action == null || action.isEmpty()) continue;
                        StringBuilder msg = new StringBuilder();
                        msg.append("<");
                        for (int i = 0; i < keys.length; ++i) {
                            msg.append(keys[i].toUpperCase());
                            if (i >= keys.length - 1) continue;
                            msg.append("+");
                        }
                        msg.append("> ").append(action);
                        this.addMessage(msg.toString());
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.unsubscribe();
    }

    public float getMessage1Width() {
        return this.message1 != null ? this.message1.getWidth() : 0.0f;
    }

    public float getMessage2Width() {
        return this.message2 != null ? this.message2.getWidth() : 0.0f;
    }

    public float getMessagesWidth() {
        return FastMath.max((float)this.getMessage1Width(), (float)this.getMessage2Width());
    }
}

