/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Timer;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.util.scene2d.OwnButton;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;

public class PopupNotificationsInterface
extends TableGuiInterface
implements IObserver {
    protected final Table me;
    protected final VerticalGroup stack;
    protected Skin skin;
    protected float pad5 = 5.0f;
    protected float pad15 = this.pad5 * 3.0f;
    protected float defaultSeconds = 8.0f;

    public PopupNotificationsInterface(Skin skin) {
        super(skin);
        this.skin = skin;
        this.me = this;
        this.stack = new VerticalGroup();
        this.stack.space(this.pad5);
        this.stack.bottom().columnRight();
        this.me.add((Actor)this.stack).top().right().pad(this.pad15);
        EventManager.instance.subscribe((IObserver)this, Event.POST_POPUP_NOTIFICATION);
    }

    public void addNotification(String message, float seconds) {
        Table t = new Table(this.skin);
        t.pad(this.pad5, this.pad15, this.pad5, this.pad15);
        OwnLabel label = new OwnLabel((CharSequence)message, this.skin, "big", 60);
        t.add((Actor)label).left().padRight(this.pad5);
        final OwnButton notification = new OwnButton((Actor)t, this.skin, "dataset", true);
        notification.setWidth(350.0f);
        notification.pad(this.pad15);
        notification.right();
        notification.addListener((EventListener)new ChangeListener(this){
            final /* synthetic */ PopupNotificationsInterface this$0;
            {
                this.this$0 = this$0;
            }

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                this.this$0.removeNotification((Actor)notification);
            }
        });
        if (seconds <= 0.0f) {
            OwnImageButton close = new OwnImageButton(this.skin, "clear");
            close.setName("quit");
            close.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.removeNotification((Actor)notification);
                }
                return false;
            });
            t.add((Actor)close).right().top().padLeft(this.pad15);
        }
        this.stack.addActor((Actor)notification);
        notification.setColor(notification.getColor().r, notification.getColor().g, notification.getColor().b, 0.0f);
        notification.addAction((Action)Actions.fadeIn((float)0.5f));
        this.stack.pack();
        if (seconds > 0.0f) {
            Timer.Task closeTask = new Timer.Task(this){
                final /* synthetic */ PopupNotificationsInterface this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.removeNotification((Actor)notification);
                }
            };
            Timer.schedule((Timer.Task)closeTask, (float)seconds);
        }
    }

    private void removeNotification(Actor notification) {
        if (this.stack != null && notification != null && notification.hasParent() && notification.getParent() == this.stack) {
            notification.addAction((Action)Actions.sequence((Action)Actions.fadeOut((float)0.5f), (Action)Actions.removeActor((Actor)notification)));
        }
    }

    @Override
    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void update() {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.POST_POPUP_NOTIFICATION) {
            String message = (String)data[0];
            float seconds = this.defaultSeconds;
            if (data.length > 1) {
                try {
                    seconds = ((Number)data[1]).floatValue();
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            this.addNotification(message, seconds);
        }
    }
}

