/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;

public class RunStateInterface
extends TableGuiInterface
implements IObserver {
    private final Cell<?> keyboardImgCell;
    private final Cell<?> stopCameraCell;
    private final Cell<?> pauseBgCell;
    private final Cell<?> frameoutputImgCell;
    private final Image keyboardImg;
    private final Image frameOutputImg;
    private final OwnTextIconButton cancelCamera;
    private final OwnTextIconButton bgLoading;
    private boolean loadingPaused = false;

    public RunStateInterface(Skin skin, boolean horizontal) {
        super(skin);
        float pad = 3.2f;
        this.keyboardImg = new Image(skin.getDrawable("no-input"));
        this.keyboardImg.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.noinput"), skin));
        this.frameOutputImg = new Image(skin.getDrawable("frameoutput"));
        this.frameOutputImg.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.frameoutputon"), skin));
        this.bgLoading = new OwnTextIconButton("", skin, "dataload-bg", "toggle");
        OwnTextTooltip pauseBgTT = new OwnTextTooltip(I18n.msg("gui.tooltip.pausebg"), skin);
        this.bgLoading.addListener((EventListener)pauseBgTT);
        this.bgLoading.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.loadingPaused) {
                    EventManager.publish(Event.RESUME_BACKGROUND_LOADING, (Object)this.bgLoading, new Object[0]);
                    this.loadingPaused = false;
                    ((Label)pauseBgTT.getActor()).setText((CharSequence)I18n.msg("gui.tooltip.pausebg"));
                } else {
                    EventManager.publish(Event.PAUSE_BACKGROUND_LOADING, (Object)this.bgLoading, new Object[0]);
                    this.loadingPaused = true;
                    ((Label)pauseBgTT.getActor()).setText((CharSequence)I18n.msg("gui.tooltip.resumebg"));
                }
            }
            return false;
        });
        this.cancelCamera = new OwnTextIconButton("", skin, "camera-stop");
        this.cancelCamera.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.stop"), skin));
        this.cancelCamera.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.PLAY_CAMERA_CMD, (Object)this.cancelCamera, false);
            }
            return false;
        });
        if (horizontal) {
            this.pauseBgCell = this.add().bottom();
            this.stopCameraCell = this.add().bottom().padLeft(pad);
            this.keyboardImgCell = this.add().bottom().padLeft(pad);
            this.frameoutputImgCell = this.add().bottom().padLeft(pad);
        } else {
            this.pauseBgCell = this.add().right().padTop(pad);
            this.pauseBgCell.row();
            this.stopCameraCell = this.add().right().padTop(pad);
            this.stopCameraCell.row();
            this.keyboardImgCell = this.add().right().padTop(pad);
            this.keyboardImgCell.row();
            this.frameoutputImgCell = this.add().right().padTop(pad);
            this.frameoutputImgCell.row();
        }
        EventManager.instance.subscribe((IObserver)this, Event.INPUT_ENABLED_CMD, Event.CAMERA_PLAY_INFO, Event.BACKGROUND_LOADING_INFO, Event.FRAME_OUTPUT_CMD, Event.OCTREE_DISPOSED);
    }

    private void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case INPUT_ENABLED_CMD: {
                GaiaSky.postRunnable(() -> {
                    boolean disabled;
                    boolean bl = disabled = (Boolean)data[0] == false;
                    if (disabled) {
                        if (this.keyboardImgCell.getActor() == null) {
                            this.keyboardImgCell.setActor((Actor)this.keyboardImg);
                        }
                    } else {
                        this.keyboardImgCell.setActor(null);
                    }
                });
                break;
            }
            case FRAME_OUTPUT_CMD: {
                GaiaSky.postRunnable(() -> {
                    boolean visible = (Boolean)data[0];
                    if (visible) {
                        if (this.frameoutputImgCell.getActor() == null) {
                            this.frameoutputImgCell.setActor((Actor)this.frameOutputImg);
                        }
                    } else {
                        this.frameoutputImgCell.setActor(null);
                    }
                });
                break;
            }
            case CAMERA_PLAY_INFO: {
                GaiaSky.postRunnable(() -> {
                    boolean visible = (Boolean)data[0];
                    if (visible) {
                        if (this.stopCameraCell.getActor() == null) {
                            this.stopCameraCell.setActor((Actor)this.cancelCamera);
                        }
                    } else {
                        this.stopCameraCell.setActor(null);
                    }
                });
                break;
            }
            case BACKGROUND_LOADING_INFO: {
                GaiaSky.postRunnable(() -> {
                    if (this.pauseBgCell.getActor() == null) {
                        this.pauseBgCell.setActor((Actor)this.bgLoading);
                    }
                });
                break;
            }
            case OCTREE_DISPOSED: {
                GaiaSky.postRunnable(() -> {
                    if (this.pauseBgCell.getActor() != null) {
                        this.pauseBgCell.clearActor();
                    }
                });
                break;
            }
        }
    }

    @Override
    public void dispose() {
        this.unsubscribe();
    }

    @Override
    public void update() {
    }
}

