/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;

public class TimeGuiInterface
extends TableGuiInterface
implements IObserver {
    private final ZoneId timeZone;
    private final DateTimeFormatter dfDate;
    private final DateTimeFormatter dfEra;
    private final DateTimeFormatter dfTime;
    private final OwnLabel date;
    private final OwnLabel time;

    public TimeGuiInterface(Skin skin) {
        super(skin);
        this.timeZone = Settings.settings.program.timeZone.getTimeZone();
        this.dfDate = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(this.timeZone);
        this.dfEra = DateTimeFormatter.ofPattern("G").withLocale(I18n.locale).withZone(this.timeZone);
        this.dfTime = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(this.timeZone);
        this.setBackground("bg-pane");
        this.date = new OwnLabel((CharSequence)"", skin, "main-title");
        this.time = new OwnLabel((CharSequence)"", skin, "main-title");
        this.add((Actor)this.time).right().pad(15.0f).padRight(30.0f);
        this.add((Actor)this.date).right().pad(15.0f);
        this.pack();
        EventManager.instance.subscribe((IObserver)this, Event.TIME_CHANGE_INFO);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.TIME_CHANGE_INFO) {
            Instant datetime = (Instant)data[0];
            GaiaSky.postRunnable(() -> {
                this.date.setText(this.dfDate.format(datetime) + " " + this.dfEra.format(datetime));
                this.time.setText(this.dfTime.format(datetime) + " " + this.timeZone.getDisplayName(TextStyle.SHORT, I18n.locale));
                this.pack();
            });
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void update() {
    }
}

