/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.iface;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.TableGuiInterface;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.api.IFocus;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.ClickableLabel;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;

public class TopInfoInterface
extends TableGuiInterface
implements IObserver {
    private final ZoneId timeZone;
    private final DateTimeFormatter dfDate;
    private final DateTimeFormatter dfEra;
    private final DateTimeFormatter dfTime;
    private final int maxNameLen = 15;
    private final OwnLabel date;
    private final OwnLabel time;
    private final OwnLabel pace;
    private final OwnLabel closest;
    private final OwnLabel focus;
    private final OwnLabel s1;
    private final Scene scene;
    private final FocusView view;
    private String lastFocusName;

    public TopInfoInterface(Skin skin, Scene scene) {
        super(skin);
        this.setBackground("table-bg");
        float pad = 18.0f;
        this.scene = scene;
        this.view = new FocusView();
        this.timeZone = Settings.settings.program.timeZone.getTimeZone();
        this.dfDate = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(this.timeZone);
        this.dfEra = DateTimeFormatter.ofPattern("G").withLocale(I18n.locale).withZone(this.timeZone);
        this.dfTime = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(this.timeZone);
        this.date = new ClickableLabel((CharSequence)I18n.msg("gui.top.date.ut"), skin, "mono", () -> EventManager.publish(Event.SHOW_DATE_TIME_EDIT_ACTION, this, new Object[0]));
        this.date.setName("label date tii");
        this.date.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dateedit"), skin));
        this.time = new ClickableLabel((CharSequence)I18n.msg("gui.top.time.ut"), skin, "mono", () -> EventManager.publish(Event.SHOW_DATE_TIME_EDIT_ACTION, this, new Object[0]));
        this.time.setName("label time tii");
        this.time.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.dateedit"), skin));
        this.pace = new OwnLabel((CharSequence)("(" + (Settings.settings.runtime.timeOn ? TextUtils.getFormattedTimeWarp() : I18n.msg("gui.top.time.off")) + ")"), skin, "mono");
        this.pace.setName("pace tii");
        Table timeTable = new Table(skin);
        timeTable.add((Actor)this.date).center().padRight(pad);
        timeTable.add((Actor)this.time).center().padRight(pad);
        timeTable.add((Actor)this.pace).center();
        this.focus = new OwnLabel((CharSequence)"", skin, "mono");
        this.focus.setName("focus tii");
        this.focus.setColor(ColorUtils.gGreenC);
        this.s1 = new OwnLabel((CharSequence)"|", skin, "mono");
        this.closest = new OwnLabel((CharSequence)"", skin, "mono");
        this.closest.setName("closest tii");
        this.closest.setColor(ColorUtils.gBlueC);
        OwnLabel s2 = new OwnLabel((CharSequence)"|", skin, "mono");
        OwnLabel home = new OwnLabel((CharSequence)I18n.msg("gui.top.home", TextUtils.capString(I18n.localize(Settings.settings.scene.homeObject), 15)), skin, "mono");
        home.setName("home tii");
        home.setColor(ColorUtils.aOrangeC);
        Table objectsTable = new Table(skin);
        objectsTable.add((Actor)home).left().padRight(pad);
        objectsTable.add((Actor)this.s1).left().padRight(pad);
        objectsTable.add((Actor)this.focus).left().padRight(pad);
        objectsTable.add((Actor)s2).left().padRight(pad);
        objectsTable.add((Actor)this.closest).left();
        this.add((Actor)timeTable).left().row();
        this.add((Actor)objectsTable).colspan(3).left().padTop(pad * 0.3f).left();
        EventManager.instance.subscribe((IObserver)this, Event.TIME_CHANGE_INFO, Event.TIME_CHANGE_CMD, Event.TIME_WARP_CHANGED_INFO, Event.TIME_STATE_CMD, Event.CAMERA_CLOSEST_INFO, Event.CAMERA_MODE_CMD, Event.FOCUS_CHANGE_CMD);
    }

    private void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case TIME_CHANGE_INFO: 
            case TIME_CHANGE_CMD: {
                Instant datetime = (Instant)data[0];
                GaiaSky.postRunnable(() -> {
                    this.date.setText(this.dfDate.format(datetime) + " " + this.dfEra.format(datetime));
                    this.time.setText(this.dfTime.format(datetime) + " " + this.timeZone.getDisplayName(TextStyle.SHORT, I18n.locale));
                    this.pack();
                });
                break;
            }
            case TIME_WARP_CHANGED_INFO: {
                if (data.length != 1) break;
                this.pace.setText("(" + TextUtils.getFormattedTimeWarp((Double)data[0]) + ")");
                break;
            }
            case TIME_STATE_CMD: {
                Boolean t = (Boolean)data[0];
                if (!t.booleanValue()) {
                    this.pace.setText("(" + I18n.msg("gui.top.time.off") + ")");
                    break;
                }
                this.pace.setText("(" + TextUtils.getFormattedTimeWarp() + ")");
                break;
            }
            case CAMERA_CLOSEST_INFO: {
                IFocus closestObject = (IFocus)data[0];
                if (closestObject != null) {
                    this.closest.setText(TextUtils.capString(closestObject.getClosestLocalizedName(), 15));
                    this.closest.setText(I18n.msg("gui.top.closest", this.closest.getText()));
                    break;
                }
                this.closest.setText("");
                break;
            }
            case CAMERA_MODE_CMD: {
                CameraManager.CameraMode mode = (CameraManager.CameraMode)((Object)data[0]);
                if (!mode.isFocus()) {
                    this.focus.setText("");
                    this.s1.setText("");
                    break;
                }
                this.focus.setText(I18n.msg("gui.top.focus", this.lastFocusName));
                this.s1.setText("|");
                break;
            }
            case FOCUS_CHANGE_CMD: {
                String candidate;
                IFocus f = null;
                Entity e = data[0] instanceof String ? this.scene.getEntity((String)data[0]) : (data[0] instanceof FocusView ? ((FocusView)data[0]).getEntity() : (Entity)data[0]);
                if (e == null) break;
                if (Mapper.focus.has(e)) {
                    this.view.setEntity(e);
                    f = this.view;
                }
                if (f == null || (candidate = I18n.localize(f.getCandidateName())) == null) break;
                this.lastFocusName = TextUtils.capString(candidate, 15);
                this.focus.setText(I18n.msg("gui.top.focus", this.lastFocusName));
                this.s1.setText("|");
                break;
            }
        }
        this.pack();
    }

    public void programmaticUpdate() {
        ICamera camera = GaiaSky.instance.getICamera();
        this.notify(Event.CAMERA_MODE_CMD, this, new Object[]{camera.getMode()});
        if (camera.getMode().isFocus()) {
            this.notify(Event.FOCUS_CHANGE_CMD, this, camera.getFocus());
        }
    }

    @Override
    public void dispose() {
        this.unsubscribe();
    }

    @Override
    public void update() {
    }
}

