/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import gaiasky.gui.api.IGamepadMappings;
import gaiasky.gui.main.GamepadMappings;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.math.MathUtilsDouble;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public abstract class AbstractGamepadMappings
implements IGamepadMappings {
    protected static final Logger.Log logger = Logger.getLogger(AbstractGamepadMappings.class);
    public double AXIS_VALUE_POW = 4.0;
    public double ZERO_POINT = 0.2;
    public int AXIS_LSTICK_H = -1;
    public double AXIS_LSTICK_H_SENS = 1.0;
    public int AXIS_RSTICK_H = -1;
    public double AXIS_RSTICK_H_SENS = 1.0;
    public int AXIS_RSTICK_V = -1;
    public double AXIS_RSTICK_V_SENS = 1.0;
    public int AXIS_LSTICK_V = -1;
    public double AXIS_LSTICK_V_SENS = 1.0;
    public int AXIS_RB = -1;
    public int AXIS_LB = -1;
    public int AXIS_RT = -1;
    public double AXIS_RT_SENS = 1.0;
    public int AXIS_LT = -1;
    public double AXIS_LT_SENS = 1.0;
    public int AXIS_DPAD_H = -1;
    public int AXIS_DPAD_V = -1;
    public int BUTTON_DPAD_UP = -1;
    public int BUTTON_DPAD_DOWN = -1;
    public int BUTTON_DPAD_LEFT = -1;
    public int BUTTON_DPAD_RIGHT = -1;
    public int BUTTON_A = -1;
    public int BUTTON_B = -1;
    public int BUTTON_X = -1;
    public int BUTTON_Y = -1;
    public int BUTTON_START = -1;
    public int BUTTON_SELECT = -1;
    public int BUTTON_RT = -1;
    public int BUTTON_RB = -1;
    public int BUTTON_LT = -1;
    public int BUTTON_LB = -1;
    public int BUTTON_LSTICK = -1;
    public int BUTTON_RSTICK = -1;

    public static IGamepadMappings readGamepadMappings(String mappingsFile) {
        GamepadMappings mappings = null;
        Path mappingsPath = Path.of(mappingsFile, new String[0]);
        if (Files.exists(mappingsPath, new LinkOption[0])) {
            mappings = new GamepadMappings(null, mappingsPath);
        } else {
            Path assetsLoc = Path.of(Settings.ASSETS_LOC, new String[0]);
            Path internalMappings = assetsLoc.resolve(mappingsFile);
            if (Files.exists(internalMappings, new LinkOption[0])) {
                mappings = new GamepadMappings(null, internalMappings);
            } else {
                Path defaultPath = assetsLoc.resolve("mappings").resolve("SDL_Controller.controller");
                if (Files.exists(defaultPath, new LinkOption[0])) {
                    mappings = new GamepadMappings(null, defaultPath);
                    Settings.settings.controls.gamepad.mappingsFile = defaultPath.toAbsolutePath().toString();
                }
            }
        }
        return mappings;
    }

    @Override
    public double getZeroPoint() {
        return this.ZERO_POINT;
    }

    @Override
    public double getAxisValuePower() {
        return this.AXIS_VALUE_POW;
    }

    @Override
    public int getAxisLstickH() {
        return this.AXIS_LSTICK_H;
    }

    @Override
    public int getAxisRstickH() {
        return this.AXIS_RSTICK_H;
    }

    @Override
    public int getAxisRstickV() {
        return this.AXIS_RSTICK_V;
    }

    @Override
    public int getAxisLstickV() {
        return this.AXIS_LSTICK_V;
    }

    @Override
    public int getAxisRB() {
        return this.AXIS_RB;
    }

    @Override
    public int getAxisLB() {
        return this.AXIS_LB;
    }

    @Override
    public int getAxisRT() {
        return this.AXIS_RT;
    }

    @Override
    public int getAxisLT() {
        return this.AXIS_LT;
    }

    @Override
    public int getAxisDpadH() {
        return this.AXIS_DPAD_H;
    }

    @Override
    public int getAxisDpadV() {
        return this.AXIS_DPAD_V;
    }

    @Override
    public int getButtonY() {
        return this.BUTTON_Y;
    }

    @Override
    public int getButtonX() {
        return this.BUTTON_X;
    }

    @Override
    public int getButtonA() {
        return this.BUTTON_A;
    }

    @Override
    public int getButtonB() {
        return this.BUTTON_B;
    }

    @Override
    public int getButtonDpadUp() {
        return this.BUTTON_DPAD_UP;
    }

    @Override
    public int getButtonDpadDown() {
        return this.BUTTON_DPAD_DOWN;
    }

    @Override
    public int getButtonDpadLeft() {
        return this.BUTTON_DPAD_LEFT;
    }

    @Override
    public int getButtonDpadRight() {
        return this.BUTTON_DPAD_RIGHT;
    }

    @Override
    public int getButtonLstick() {
        return this.BUTTON_LSTICK;
    }

    @Override
    public int getButtonRstick() {
        return this.BUTTON_RSTICK;
    }

    @Override
    public int getButtonStart() {
        return this.BUTTON_START;
    }

    @Override
    public int getButtonSelect() {
        return this.BUTTON_SELECT;
    }

    @Override
    public int getButtonRT() {
        return this.BUTTON_RT;
    }

    @Override
    public int getButtonRB() {
        return this.BUTTON_RB;
    }

    @Override
    public int getButtonLT() {
        return this.BUTTON_LT;
    }

    @Override
    public int getButtonLB() {
        return this.BUTTON_LB;
    }

    @Override
    public double getAxisLstickHSensitivity() {
        return MathUtilsDouble.clamp(this.AXIS_LSTICK_H_SENS, 0.01, 100.0);
    }

    @Override
    public double getAxisRstickHSensitivity() {
        return MathUtilsDouble.clamp(this.AXIS_RSTICK_H_SENS, 0.01, 100.0);
    }

    @Override
    public double getAxisRstickVSensitivity() {
        return MathUtilsDouble.clamp(this.AXIS_RSTICK_V_SENS, 0.01, 100.0);
    }

    @Override
    public double getAxisLstickVSensitivity() {
        return MathUtilsDouble.clamp(this.AXIS_LSTICK_V_SENS, 0.01, 100.0);
    }

    @Override
    public double getAxisRTSensitivity() {
        return MathUtilsDouble.clamp(this.AXIS_RT_SENS, 0.01, 100.0);
    }

    @Override
    public double getAxisLTSensitivity() {
        return MathUtilsDouble.clamp(this.AXIS_LT_SENS, 0.01, 100.0);
    }
}

