/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.api.IGui;
import gaiasky.gui.api.IGuiInterface;
import gaiasky.render.ComponentTypes;

public abstract class AbstractGui
implements IObserver,
IGui {
    protected Graphics graphics;
    protected Stage stage;
    protected Skin skin;
    protected Array<IGuiInterface> interfaces;
    protected String name;
    protected boolean vr;
    protected float unitsPerPixel = 1.0f;
    protected final Object lock;
    protected int backBufferWidth = -1;
    protected int backBufferHeight = -1;

    public AbstractGui(Graphics graphics, Float unitsPerPixel) {
        this.graphics = graphics;
        this.unitsPerPixel = unitsPerPixel.floatValue();
        this.lock = new Object();
        this.name = this.getClass().getSimpleName();
    }

    @Override
    public void update(double dt) {
        this.stage.act((float)dt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(int rw, int rh) {
        Object object = this.lock;
        synchronized (object) {
            this.stage.draw();
        }
    }

    @Override
    public Stage getGuiStage() {
        return this.stage;
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
        if (this.interfaces != null) {
            for (IGuiInterface iface : this.interfaces) {
                iface.dispose();
            }
        }
        if (this.stage != null) {
            this.stage.dispose();
        }
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void resize(int width, int height) {
        GaiaSky.postRunnable(() -> this.resizeImmediate(width, height));
    }

    @Override
    public void resizeImmediate(int width, int height) {
        this.stage.getViewport().update(width, height, true);
        this.rebuildGui();
    }

    protected abstract void rebuildGui();

    @Override
    public boolean cancelTouchFocus() {
        if (this.stage.getKeyboardFocus() != null || this.stage.getScrollFocus() != null) {
            this.stage.setScrollFocus(null);
            this.stage.setKeyboardFocus(null);
            return true;
        }
        return false;
    }

    @Override
    public Actor findActor(String name) {
        return this.stage.getRoot().findActor(name);
    }

    @Override
    public void setVisibilityToggles(ComponentTypes.ComponentType[] entities, ComponentTypes visible) {
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
    }

    @Override
    public void setVR(boolean vr) {
        this.vr = vr;
    }

    @Override
    public boolean isVR() {
        return this.vr;
    }

    @Override
    public boolean mustDraw() {
        return true;
    }

    @Override
    public boolean updateUnitsPerPixel(float upp) {
        this.unitsPerPixel = upp;
        Viewport viewport = this.stage.getViewport();
        if (viewport instanceof ScreenViewport) {
            ScreenViewport svp = (ScreenViewport)viewport;
            svp.setUnitsPerPixel(this.unitsPerPixel);
            svp.update(this.graphics.getWidth(), this.graphics.getHeight(), true);
            return true;
        }
        return false;
    }

    @Override
    public float getUnitsPerPixel() {
        return this.unitsPerPixel;
    }

    @Override
    public void setBackBufferSize(int width, int height) {
        this.backBufferHeight = height;
        this.backBufferWidth = width;
    }

    public int getBackBufferWidth() {
        return this.backBufferWidth > 0 ? this.backBufferWidth : 1920;
    }

    public int getBackBufferHeight() {
        return this.backBufferHeight > 0 ? this.backBufferHeight : 1080;
    }
}

