/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Gdx;
import gaiasky.data.util.PointCloudData;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.NotificationsInterface;
import gaiasky.gui.main.MessageBean;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

public class ConsoleLogger
implements IObserver {
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static final String TAG_SEPARATOR = " - ";
    DateTimeFormatter df;
    long msTimeout = 5000L;
    boolean useHistorical;

    public ConsoleLogger() {
        this(true);
    }

    private ConsoleLogger(boolean useHistorical) {
        this.useHistorical = useHistorical;
        try {
            this.df = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss").withLocale(I18n.locale).withZone(ZoneOffset.UTC);
        }
        catch (Exception e) {
            this.df = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM, FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(ZoneOffset.UTC);
        }
        this.subscribe();
    }

    public void setUseHistorical(boolean useHistorical) {
        this.useHistorical = useHistorical;
    }

    public void subscribe() {
        EventManager.instance.subscribe((IObserver)this, Event.POST_NOTIFICATION, Event.FOCUS_CHANGED, Event.TIME_STATE_CMD, Event.TOGGLE_VISIBILITY_CMD, Event.CAMERA_MODE_CMD, Event.TIME_WARP_CHANGED_INFO, Event.FOCUS_LOCK_CMD, Event.JAVA_EXCEPTION, Event.ORBIT_DATA_LOADED, Event.SCREENSHOT_INFO, Event.STEREOSCOPIC_CMD, Event.DISPLAY_GUI_CMD, Event.FRAME_OUTPUT_CMD, Event.STEREO_PROFILE_CMD, Event.OCTREE_PARTICLE_FADE_CMD);
    }

    public void unsubscribe() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    private void addMessage(String msg) {
        Instant date = Instant.now();
        this.log(this.df.format(date), msg, Logger.LoggerLevel.INFO);
        if (this.useHistorical) {
            NotificationsInterface.historical.add(new MessageBean(msg, date));
        }
    }

    private String tag(Instant date, Logger.LoggerLevel level) {
        String lvl = level.ordinal() != Logger.LoggerLevel.INFO.ordinal() ? " " + String.valueOf((Object)level) : "";
        return this.df.format(date) + lvl;
    }

    private void addMessage(String msg, Logger.LoggerLevel level) {
        Instant date = Instant.now();
        this.log(this.tag(date, level), msg, level);
        if (this.useHistorical) {
            NotificationsInterface.historical.add(new MessageBean(msg, date));
        }
    }

    private void log(String tag, String msg, Logger.LoggerLevel level) {
        boolean debug = level.equals((Object)Logger.LoggerLevel.DEBUG);
        boolean err = level.equals((Object)Logger.LoggerLevel.ERROR);
        if (Gdx.app != null) {
            if (debug) {
                Gdx.app.debug(tag, msg);
            } else if (err) {
                Gdx.app.error(tag, msg);
            } else {
                Gdx.app.log(tag, msg);
            }
        } else if (Logger.level.ordinal() >= level.ordinal()) {
            if (level.equals((Object)Logger.LoggerLevel.ERROR)) {
                System.err.println("[" + tag + "] " + msg);
            } else {
                System.out.println("[" + tag + "] " + msg);
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case POST_NOTIFICATION: {
                Logger.LoggerLevel level = (Logger.LoggerLevel)((Object)data[0]);
                Object[] dat = (Object[])data[1];
                StringBuilder message = new StringBuilder();
                for (int i = 0; i < dat.length; ++i) {
                    if (i == dat.length - 1 && dat[i] instanceof Boolean) continue;
                    message.append(dat[i].toString());
                    if (i >= dat.length - 1 || i == dat.length - 2 && dat[data.length - 1] instanceof Boolean) continue;
                    message.append(TAG_SEPARATOR);
                }
                this.addMessage(message.toString(), level);
                break;
            }
            case FOCUS_CHANGED: {
                if (data[0] == null) break;
                if (data[0] instanceof String) {
                    this.addMessage(I18n.msg("notif.camerafocus", data[0]));
                    break;
                }
                FocusView focus = (FocusView)data[0];
                this.addMessage(I18n.msg("notif.camerafocus", focus.getName()));
                break;
            }
            case TIME_STATE_CMD: {
                Boolean bool = (Boolean)data[0];
                if (bool == null) {
                    this.addMessage(I18n.msg("notif.toggle", I18n.msg("gui.time")));
                    break;
                }
                this.addMessage(I18n.msg("notif.simulation." + (bool != false ? "resume" : "pause")));
                break;
            }
            case TOGGLE_VISIBILITY_CMD: {
                if (data.length == 2) {
                    this.addMessage(I18n.msg("notif.visibility." + ((Boolean)data[1] != false ? "on" : "off"), I18n.msg((String)data[0])));
                    break;
                }
                this.addMessage(I18n.msg("notif.visibility.toggle", I18n.msg((String)data[0])));
                break;
            }
            case OCTREE_PARTICLE_FADE_CMD: {
                String key = (Boolean)data[0] != false ? "notif.activated" : "notif.deactivated";
                this.addMessage(I18n.msg(key, I18n.msg("element.octreeparticlefade")));
                break;
            }
            case FOCUS_LOCK_CMD: {
                String key = (Boolean)data[0] != false ? "notif.activated" : "notif.deactivated";
                this.addMessage(I18n.msg(key, I18n.msg("gui.camera.lock")));
                break;
            }
            case ORIENTATION_LOCK_CMD: {
                String key = (Boolean)data[0] != false ? "notif.activated" : "notif.deactivated";
                this.addMessage(I18n.msg(key, I18n.msg("gui.camera.lock.orientation")));
                break;
            }
            case CAMERA_MODE_CMD: {
                CameraManager.CameraMode cm = (CameraManager.CameraMode)((Object)data[0]);
                if (cm == CameraManager.CameraMode.FOCUS_MODE) break;
                this.addMessage(I18n.msg("notif.cameramode.change", data[0]));
                break;
            }
            case TIME_WARP_CHANGED_INFO: {
                this.addMessage(I18n.msg("notif.timepace.change", data[0]));
                break;
            }
            case JAVA_EXCEPTION: {
                Throwable t = (Throwable)data[0];
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                String stackTrace = sw.toString();
                if (data.length == 1) {
                    if (I18n.messages != null) {
                        this.addMessage(I18n.msg("notif.error", stackTrace));
                        break;
                    }
                    this.addMessage("Error: " + stackTrace);
                    break;
                }
                if (I18n.messages != null) {
                    this.addMessage(I18n.msg("notif.error", String.valueOf(data[1]) + TAG_SEPARATOR + stackTrace));
                    break;
                }
                this.addMessage("Error: " + String.valueOf(data[1]) + TAG_SEPARATOR + stackTrace);
                break;
            }
            case ORBIT_DATA_LOADED: {
                this.addMessage(I18n.msg("notif.orbitdata.loaded", data[1], ((PointCloudData)data[0]).getNumPoints()), Logger.LoggerLevel.DEBUG);
                break;
            }
            case SCREENSHOT_INFO: {
                this.addMessage(I18n.msg("notif.screenshot", data[0]));
                break;
            }
            case STEREOSCOPIC_CMD: {
                if (Settings.settings.runtime.openXr) break;
                this.addMessage(I18n.msg("notif.toggle", I18n.msg("notif.stereoscopic")));
                break;
            }
            case DISPLAY_GUI_CMD: {
                boolean displayGui = (Boolean)data[0];
                this.addMessage(I18n.msg("notif." + (!displayGui ? "activated" : "deactivated"), data[1]));
                break;
            }
            case STEREO_PROFILE_CMD: {
                this.addMessage(I18n.msg("notif.stereoscopic.profile", Settings.StereoProfile.values()[(Integer)data[0]].toString()));
                break;
            }
            case FRAME_OUTPUT_CMD: {
                boolean activated = (Boolean)data[0];
                if (activated) {
                    this.addMessage(I18n.msg("notif.activated", I18n.msg("element.frameoutput")));
                    break;
                }
                this.addMessage(I18n.msg("notif.deactivated", I18n.msg("element.frameoutput")));
                break;
            }
        }
    }

    public void dispose() {
        this.unsubscribe();
    }
}

