/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.gui.iface.DebugInterface;
import gaiasky.gui.main.AbstractGui;

public class DebugGui
extends AbstractGui {
    protected DebugInterface debugInterface;
    private Container<Actor> di;

    public DebugGui(Skin skin, Graphics graphics, Float unitsPerPixel) {
        super(graphics, unitsPerPixel);
        this.skin = skin;
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        ScreenViewport vp = new ScreenViewport();
        vp.setUnitsPerPixel(this.unitsPerPixel);
        this.stage = new Stage((Viewport)vp, (Batch)sb);
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
        float pad = 16.0f;
        this.debugInterface = new DebugInterface(this.skin, this.lock);
        this.debugInterface.right().top();
        this.di = new Container((Actor)this.debugInterface);
        this.di.setFillParent(true);
        this.di.right().top();
        this.di.pad(pad, 0.0f, 0.0f, pad);
        this.rebuildGui();
    }

    @Override
    protected void rebuildGui() {
        if (this.stage != null) {
            this.stage.clear();
            if (this.debugInterface != null && this.di != null) {
                this.stage.addActor(this.di);
            }
        }
    }

    @Override
    public boolean cancelTouchFocus() {
        return false;
    }
}

