/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.MessagesInterface;
import gaiasky.gui.main.AbstractGui;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class FrameOutputGui
extends AbstractGui {
    protected Label time;
    protected Table mainTable;
    protected MessagesInterface messagesInterface;
    protected DateTimeFormatter df;

    public FrameOutputGui(Skin skin, Graphics graphics, Float unitsPerPixel) {
        super(graphics, unitsPerPixel);
        this.skin = skin;
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        ScreenViewport vp = new ScreenViewport();
        vp.setUnitsPerPixel(this.unitsPerPixel);
        this.stage = new Stage((Viewport)vp, (Batch)sb);
        this.df = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss").withLocale(I18n.locale).withZone(ZoneOffset.UTC);
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
        this.mainTable = new Table(this.skin);
        this.time = new OwnLabel((CharSequence)"", this.skin, "default");
        this.mainTable.add((Actor)this.time);
        this.mainTable.setFillParent(true);
        this.mainTable.right().bottom();
        this.mainTable.pad(5.0f);
        this.messagesInterface = new MessagesInterface(this.skin, this.lock);
        this.messagesInterface.setFillParent(true);
        this.messagesInterface.left().bottom();
        this.messagesInterface.pad(0.0f, 300.0f, 150.0f, 0.0f);
        this.rebuildGui();
        EventManager.instance.subscribe((IObserver)this, Event.TIME_CHANGE_INFO);
    }

    @Override
    protected void rebuildGui() {
        if (this.stage != null) {
            this.stage.clear();
            this.stage.addActor((Actor)this.mainTable);
            this.stage.addActor((Actor)this.messagesInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event event, Object source, Object ... data) {
        Object object = this.lock;
        synchronized (object) {
            if (Objects.requireNonNull(event) == Event.TIME_CHANGE_INFO) {
                this.time.setText((CharSequence)this.df.format((Instant)data[0]));
            }
        }
    }
}

