/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.api.IGuiInterface;
import gaiasky.gui.iface.CameraInfoInterface;
import gaiasky.gui.iface.ConsoleInterface;
import gaiasky.gui.iface.ControlsInterface;
import gaiasky.gui.iface.CustomInterface;
import gaiasky.gui.iface.LoadProgressInterface;
import gaiasky.gui.iface.LocationInfoInterface;
import gaiasky.gui.iface.MessagesInterface;
import gaiasky.gui.iface.NotificationsInterface;
import gaiasky.gui.iface.PopupNotificationsInterface;
import gaiasky.gui.iface.RunStateInterface;
import gaiasky.gui.iface.TopInfoInterface;
import gaiasky.gui.main.AbstractGui;
import gaiasky.gui.main.SceneContextMenu;
import gaiasky.gui.main.UpdatePopup;
import gaiasky.gui.minimap.MinimapInterface;
import gaiasky.gui.window.ArchiveViewWindow;
import gaiasky.gui.window.ControlsWindow;
import gaiasky.gui.window.DataInfoWindow;
import gaiasky.gui.window.LandAtWindow;
import gaiasky.gui.window.LogWindow;
import gaiasky.gui.window.MinimapWindow;
import gaiasky.gui.window.ProceduralGenerationWindow;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.view.FocusView;
import gaiasky.util.CatalogManager;
import gaiasky.util.GaiaSkyAssets;
import gaiasky.util.GlobalResources;
import gaiasky.util.GuiUtils;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.FileChooser;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.update.VersionCheckEvent;
import gaiasky.util.update.VersionChecker;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.DecimalFormat;
import java.time.Instant;

public class FullGui
extends AbstractGui {
    private static final Logger.Log logger = Logger.getLogger(FullGui.class);
    private final GlobalResources globalResources;
    private final FocusView view;
    private CatalogManager catalogManager;
    protected ControlsWindow controlsWindow;
    protected ControlsInterface controlsInterface;
    protected Container<CameraInfoInterface> fi;
    protected Container<TopInfoInterface> ti;
    protected Container<NotificationsInterface> ni;
    protected CameraInfoInterface focusInterface;
    protected NotificationsInterface notificationsInterface;
    protected MessagesInterface messagesInterface;
    protected CustomInterface customInterface;
    protected RunStateInterface runStateInterface;
    protected TopInfoInterface topInfoInterface;
    protected PopupNotificationsInterface popupNotificationsInterface;
    protected MinimapInterface minimapInterface;
    protected MinimapWindow minimapWindow;
    protected ConsoleInterface consoleInterface;
    protected LoadProgressInterface loadProgressInterface;
    protected LocationInfoInterface locationInfoInterface;
    protected LogWindow logWindow;
    protected DataInfoWindow dataInfoWindow;
    protected ArchiveViewWindow archiveViewWindow;
    protected DecimalFormat nf;
    protected Label pointerXCoord;
    protected Label pointerYCoord;
    protected float pad;
    protected float pad5;
    protected Scene scene;
    private ComponentTypes.ComponentType[] visibilityEntities;
    private boolean[] visible;

    public FullGui(Skin skin, Graphics graphics, Float unitsPerPixel, GlobalResources globalResources) {
        super(graphics, unitsPerPixel);
        this.skin = skin;
        this.globalResources = globalResources;
        this.view = new FocusView();
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        ScreenViewport vp = new ScreenViewport();
        vp.setUnitsPerPixel(this.unitsPerPixel);
        this.stage = new Stage((Viewport)vp, (Batch)sb);
        vp.update(this.graphics.getWidth(), this.graphics.getHeight(), true);
    }

    public void initialize(Stage ui) {
        this.stage = ui;
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
        this.interfaces = new Array();
        this.catalogManager = ((GaiaSkyAssets)assetManager.get((String)"gaiasky-assets", GaiaSkyAssets.class)).catalogManager;
        this.buildGui();
        EventManager.instance.subscribe((IObserver)this, Event.FOV_CHANGED_CMD, Event.UPDATE_DATA_INFO_CMD, Event.SHOW_DATA_INFO_CMD, Event.SHOW_ARCHIVE_VIEW_CMD, Event.UPDATE_ARCHIVE_VIEW_CMD, Event.SHOW_PLAYCAMERA_CMD, Event.REMOVE_KEYBOARD_FOCUS_CMD, Event.REMOVE_GUI_COMPONENT_CMD, Event.ADD_GUI_COMPONENT_CMD, Event.SHOW_LOG_CMD, Event.RA_DEC_UPDATED, Event.LON_LAT_UPDATED, Event.CONTEXT_MENU_CMD, Event.SHOW_LAND_AT_LOCATION_CMD, Event.DISPLAY_POINTER_COORDS_CMD, Event.MINIMAP_TOGGLE_CMD, Event.MINIMAP_DISPLAY_CMD, Event.SHOW_PROCEDURAL_GEN_CMD, Event.CONSOLE_CMD);
    }

    protected void buildGui() {
        this.pad = 16.0f;
        this.pad5 = 8.0f;
        for (ComponentTypes.ComponentType ct : ComponentTypes.ComponentType.values()) {
            ct.getName();
        }
        this.nf = new DecimalFormat("##0.##");
        this.notificationsInterface = new NotificationsInterface(this.skin, this.lock, true, true, true, true);
        this.notificationsInterface.pad(this.pad5);
        this.ni = new Container((Actor)this.notificationsInterface);
        this.ni.setFillParent(true);
        this.ni.bottom().left();
        this.ni.pad(0.0f, this.pad, this.pad, 0.0f);
        this.interfaces.add((Object)this.notificationsInterface);
        if (Settings.settings.program.ui.newUI) {
            this.controlsInterface = new ControlsInterface(this.skin, this.stage, this.scene, this.catalogManager, this.visibilityEntities, this.visible);
            this.controlsInterface.setFillParent(true);
            this.controlsInterface.top().left();
            this.controlsInterface.pad(this.pad5);
            this.interfaces.add((Object)this.controlsInterface);
        } else {
            this.addControlsWindow();
        }
        this.focusInterface = new CameraInfoInterface(this.skin);
        this.fi = new Container((Actor)this.focusInterface);
        this.fi.setFillParent(true);
        this.fi.bottom().right();
        this.fi.pad(0.0f, 0.0f, this.pad, this.pad);
        this.interfaces.add((Object)this.focusInterface);
        this.messagesInterface = new MessagesInterface(this.skin, this.lock);
        this.messagesInterface.setFillParent(true);
        this.messagesInterface.left().bottom();
        this.messagesInterface.pad(0.0f, 300.0f, 200.0f, 0.0f);
        this.interfaces.add((Object)this.messagesInterface);
        this.topInfoInterface = new TopInfoInterface(this.skin, this.scene);
        this.topInfoInterface.top();
        this.topInfoInterface.pad(this.pad5, this.pad, this.pad5, this.pad);
        this.ti = new Container((Actor)this.topInfoInterface);
        this.ti.setFillParent(true);
        this.ti.top().left();
        this.ti.pad(this.pad);
        this.interfaces.add((Object)this.topInfoInterface);
        this.initializeMinimap(this.stage);
        this.runStateInterface = new RunStateInterface(this.skin, true);
        this.runStateInterface.setFillParent(true);
        this.runStateInterface.center().bottom();
        this.runStateInterface.pad(0.0f, 0.0f, this.pad, 0.0f);
        this.interfaces.add((Object)this.runStateInterface);
        this.popupNotificationsInterface = new PopupNotificationsInterface(this.skin);
        this.popupNotificationsInterface.setFillParent(true);
        this.popupNotificationsInterface.right().top();
        this.interfaces.add((Object)this.popupNotificationsInterface);
        this.addLoadProgressInterface();
        this.customInterface = new CustomInterface(this.stage, this.skin, this.lock);
        this.interfaces.add((Object)this.customInterface);
        this.consoleInterface = new ConsoleInterface(this.skin, GaiaSky.instance.getConsoleManager());
        this.consoleInterface.setFillParent(true);
        this.consoleInterface.bottom().left().padLeft(70.0f);
        this.locationInfoInterface = new LocationInfoInterface(this.skin);
        this.interfaces.add((Object)this.locationInfoInterface);
        this.pointerXCoord = new OwnLabel((CharSequence)"", this.skin, "default");
        this.pointerXCoord.setAlignment(4);
        this.pointerXCoord.setVisible(Settings.settings.program.pointer.coordinates);
        this.pointerYCoord = new OwnLabel((CharSequence)"", this.skin, "default");
        this.pointerYCoord.setAlignment(17);
        this.pointerYCoord.setVisible(Settings.settings.program.pointer.coordinates);
        this.rebuildGui();
        if (Settings.settings.program.update.lastCheck == null || Instant.now().toEpochMilli() - Settings.settings.program.update.lastCheck.toEpochMilli() > Settings.ProgramSettings.UpdateSettings.VERSION_CHECK_INTERVAL_MS) {
            Timer.Task t = this.getVersionCheckTask();
            Timer.schedule((Timer.Task)t, (float)10.0f);
        }
    }

    private Timer.Task getVersionCheckTask() {
        VersionChecker vc = new VersionChecker(Settings.settings.program.url.versionCheck);
        vc.setListener(event -> {
            if (event instanceof VersionCheckEvent) {
                VersionCheckEvent vce = (VersionCheckEvent)event;
                if (!vce.isFailed()) {
                    String tagVersion = vce.getTag();
                    Integer versionNumber = vce.getVersionNumber();
                    Settings.settings.program.update.lastCheck = Instant.now();
                    if (versionNumber > Settings.settings.version.versionNumber) {
                        logger.info(I18n.msg("gui.newversion.available", Settings.settings.version.version, tagVersion));
                        UpdatePopup newVersion = new UpdatePopup(tagVersion, this.stage, this.skin);
                        newVersion.pack();
                        float ww = newVersion.getWidth();
                        float margin = 8.0f;
                        newVersion.setPosition((float)this.graphics.getWidth() - ww - margin, margin);
                        this.stage.addActor((Actor)newVersion);
                    } else {
                        logger.info(I18n.msg("gui.newversion.nonew", Settings.settings.program.update.getLastCheckedString()));
                    }
                } else {
                    logger.info(I18n.msg("gui.newversion.fail"));
                }
            }
            return false;
        });
        final Thread vct = new Thread(vc);
        return new Timer.Task(this){

            public void run() {
                logger.info(I18n.msg("gui.newversion.checking"));
                vct.start();
            }
        };
    }

    @Override
    protected void rebuildGui() {
        if (this.stage != null) {
            this.stage.clear();
            if (this.controlsWindow != null) {
                boolean collapsed = this.controlsWindow.isCollapsed();
                this.controlsWindow.recalculateSize();
                if (collapsed) {
                    this.controlsWindow.collapseInstant();
                }
                this.controlsWindow.setPosition(0.0f, (float)this.graphics.getHeight() * this.unitsPerPixel - this.controlsWindow.getHeight());
                this.stage.addActor((Actor)this.controlsWindow);
            }
            if (this.ni != null) {
                this.stage.addActor(this.ni);
            }
            if (this.controlsInterface != null) {
                this.stage.addActor((Actor)this.controlsInterface);
            }
            if (this.messagesInterface != null) {
                this.stage.addActor((Actor)this.messagesInterface);
            }
            if (this.fi != null) {
                this.stage.addActor(this.fi);
            }
            if (this.runStateInterface != null) {
                this.stage.addActor((Actor)this.runStateInterface);
            }
            if (this.ti != null) {
                this.stage.addActor(this.ti);
            }
            if (this.minimapInterface != null) {
                this.stage.addActor((Actor)this.minimapInterface);
            }
            if (this.loadProgressInterface != null) {
                this.stage.addActor((Actor)this.loadProgressInterface);
            }
            if (this.locationInfoInterface != null) {
                this.stage.addActor((Actor)this.locationInfoInterface);
            }
            if (this.pointerXCoord != null && this.pointerYCoord != null) {
                this.stage.addActor((Actor)this.pointerXCoord);
                this.stage.addActor((Actor)this.pointerYCoord);
            }
            if (this.customInterface != null) {
                this.customInterface.reAddObjects();
            }
            if (this.popupNotificationsInterface != null) {
                this.stage.addActor((Actor)this.popupNotificationsInterface);
            }
            this.stage.addListener(event -> {
                if (event instanceof InputEvent) {
                    InputEvent ie = (InputEvent)event;
                    if (ie.getType() == InputEvent.Type.mouseMoved) {
                        ScrollPane scrollPanelAncestor = GuiUtils.getScrollPaneAncestor(ie.getTarget());
                        this.stage.setScrollFocus((Actor)scrollPanelAncestor);
                    } else if (ie.getType() == InputEvent.Type.touchDown && ie.getTarget() instanceof TextField) {
                        this.stage.setKeyboardFocus(ie.getTarget());
                    }
                }
                return false;
            });
            this.stage.addListener(event -> {
                InputEvent ie;
                if (event instanceof InputEvent && (ie = (InputEvent)event).getType() == InputEvent.Type.touchDown && !ie.isHandled()) {
                    this.stage.setKeyboardFocus(null);
                }
                return false;
            });
        }
    }

    @Override
    public boolean cancelTouchFocus() {
        if (this.stage.getScrollFocus() != null) {
            this.stage.setScrollFocus(null);
            this.stage.setKeyboardFocus(null);
            return true;
        }
        return false;
    }

    @Override
    public void update(double dt) {
        this.stage.act((float)dt);
        for (IGuiInterface i : this.interfaces) {
            if (!i.isOn()) continue;
            i.update();
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case SHOW_PROCEDURAL_GEN_CMD: {
                FocusView planet = (FocusView)data[0];
                if (!Mapper.model.has(planet.getEntity())) break;
                Actor w = this.findActor("procedural-window");
                if (w != null && w.hasParent()) {
                    if (w.isVisible()) break;
                    w.setVisible(true);
                    break;
                }
                ProceduralGenerationWindow proceduralWindow = new ProceduralGenerationWindow(planet, this.stage, this.skin);
                proceduralWindow.setName("procedural-window");
                proceduralWindow.show(this.stage);
                break;
            }
            case SHOW_LAND_AT_LOCATION_CMD: {
                FocusView target = (FocusView)data[0];
                LandAtWindow landAtLocation = new LandAtWindow(target.getEntity(), this.stage, this.skin);
                landAtLocation.show(this.stage);
                break;
            }
            case SHOW_PLAYCAMERA_CMD: {
                FileChooser fc = new FileChooser(I18n.msg("gui.camera.title"), this.skin, this.stage, SysUtils.getDefaultCameraDir(), FileChooser.FileChooserTarget.FILES);
                fc.setShowHidden(Settings.settings.program.fileChooser.showHidden);
                fc.setShowHiddenConsumer(showHidden -> {
                    Settings.settings.program.fileChooser.showHidden = showHidden;
                });
                fc.setAcceptText(I18n.msg("gui.camera.run"));
                fc.setFileFilter(pathname -> pathname.getFileName().toString().endsWith(".dat") || pathname.getFileName().toString().endsWith(".gsc"));
                fc.setAcceptedFiles("*.dat, *.gsc");
                fc.setResultListener((success, result) -> {
                    if (success) {
                        if (Files.exists(result, new LinkOption[0]) && Files.exists(result, new LinkOption[0])) {
                            EventManager.publish(Event.PLAY_CAMERA_CMD, (Object)fc, true, result);
                            return true;
                        }
                        logger.error("Selection must be a file: " + String.valueOf(result.toAbsolutePath()));
                    }
                    return false;
                });
                fc.show(this.stage);
                break;
            }
            case SHOW_LOG_CMD: {
                if (this.logWindow == null) {
                    this.logWindow = new LogWindow(this.stage, this.skin);
                }
                this.logWindow.update();
                if (this.logWindow.isVisible() && this.logWindow.hasParent()) break;
                this.logWindow.show(this.stage);
                break;
            }
            case UPDATE_DATA_INFO_CMD: {
                if (this.dataInfoWindow == null || !this.dataInfoWindow.isVisible() || !this.dataInfoWindow.hasParent()) break;
                FocusView object = (FocusView)data[0];
                this.dataInfoWindow.update(object);
                break;
            }
            case SHOW_DATA_INFO_CMD: {
                FocusView object = (FocusView)data[0];
                if (this.dataInfoWindow == null) {
                    this.dataInfoWindow = new DataInfoWindow(this.stage, this.skin);
                }
                this.dataInfoWindow.update(object);
                if (this.dataInfoWindow.isVisible() && this.dataInfoWindow.hasParent()) break;
                this.dataInfoWindow.show(this.stage);
                break;
            }
            case UPDATE_ARCHIVE_VIEW_CMD: {
                if (this.archiveViewWindow == null || !this.archiveViewWindow.isVisible() || !this.archiveViewWindow.hasParent()) break;
                FocusView starFocus = (FocusView)data[0];
                this.archiveViewWindow.update(starFocus);
                break;
            }
            case SHOW_ARCHIVE_VIEW_CMD: {
                FocusView starFocus = (FocusView)data[0];
                if (this.archiveViewWindow == null) {
                    this.archiveViewWindow = new ArchiveViewWindow(this.stage, this.skin);
                }
                this.archiveViewWindow.update(starFocus);
                if (this.archiveViewWindow.isVisible() && this.archiveViewWindow.hasParent()) break;
                this.archiveViewWindow.show(this.stage);
                break;
            }
            case REMOVE_KEYBOARD_FOCUS_CMD: {
                this.stage.setKeyboardFocus(null);
                break;
            }
            case REMOVE_GUI_COMPONENT_CMD: {
                String name = (String)data[0];
                String methodName = "remove" + TextUtils.capitalise(name);
                try {
                    Method method = ClassReflection.getMethod(this.getClass(), (String)methodName, (Class[])new Class[0]);
                    method.invoke((Object)this, new Object[0]);
                }
                catch (ReflectionException e) {
                    logger.error(e);
                }
                this.rebuildGui();
                break;
            }
            case ADD_GUI_COMPONENT_CMD: {
                String name = (String)data[0];
                String methodName = "add" + TextUtils.capitalise(name);
                try {
                    Method method = ClassReflection.getMethod(this.getClass(), (String)methodName, (Class[])new Class[0]);
                    method.invoke((Object)this, new Object[0]);
                }
                catch (ReflectionException e) {
                    logger.error(e);
                }
                this.rebuildGui();
                break;
            }
            case RA_DEC_UPDATED: {
                if (!Settings.settings.program.pointer.coordinates) break;
                Stage ui = this.pointerYCoord.getStage();
                float uiScale = Settings.settings.program.ui.scale;
                Double ra = (Double)data[0];
                Double dec = (Double)data[1];
                Integer x = (Integer)data[4];
                Integer y = (Integer)data[5];
                this.pointerXCoord.setText((CharSequence)I18n.msg("gui.focusinfo.pointer.ra", this.nf.format(ra)));
                this.pointerXCoord.setPosition((float)x.intValue() / uiScale, 1.6f);
                this.pointerYCoord.setText((CharSequence)I18n.msg("gui.focusinfo.pointer.dec", this.nf.format(dec)));
                this.pointerYCoord.setPosition(ui.getWidth() + 1.6f, ui.getHeight() - (float)y.intValue() / uiScale);
                break;
            }
            case LON_LAT_UPDATED: {
                if (!Settings.settings.program.pointer.coordinates) break;
                Stage ui = this.pointerYCoord.getStage();
                float uiScale = Settings.settings.program.ui.scale;
                Double lon = (Double)data[0];
                Double lat = (Double)data[1];
                Integer x = (Integer)data[2];
                Integer y = (Integer)data[3];
                this.pointerXCoord.setText((CharSequence)I18n.msg("gui.focusinfo.pointer.lon", this.nf.format(lon)));
                this.pointerXCoord.setPosition((float)x.intValue() / uiScale, 1.6f);
                this.pointerYCoord.setText((CharSequence)I18n.msg("gui.focusinfo.pointer.lat", this.nf.format(lat)));
                this.pointerYCoord.setPosition(ui.getWidth() + 1.6f, ui.getHeight() - (float)y.intValue() / uiScale);
                break;
            }
            case DISPLAY_POINTER_COORDS_CMD: {
                Boolean display = (Boolean)data[0];
                this.pointerXCoord.setVisible(display.booleanValue());
                this.pointerYCoord.setVisible(display.booleanValue());
                break;
            }
            case CONTEXT_MENU_CMD: {
                Entity candidate = (Entity)data[0];
                int screenX = (Integer)data[1];
                int screenY = (Integer)data[2];
                FocusView focusView = null;
                if (candidate != null) {
                    this.view.setEntity(candidate);
                    focusView = this.view;
                }
                SceneContextMenu popup = new SceneContextMenu(this.skin, "default", screenX, screenY, focusView, this.catalogManager, this.scene);
                int h = (int)this.getGuiStage().getHeight();
                float px = (float)screenX * this.unitsPerPixel;
                float py = (float)h - (float)screenY * this.unitsPerPixel - 32.0f;
                popup.showMenu(this.stage, px, py);
                break;
            }
            case MINIMAP_TOGGLE_CMD: {
                if (Settings.settings.program.minimap.inWindow) {
                    this.toggleMinimapWindow(this.stage);
                    break;
                }
                this.toggleMinimapInterface(this.stage);
                break;
            }
            case MINIMAP_DISPLAY_CMD: {
                Boolean show = (Boolean)data[0];
                if (Settings.settings.program.minimap.inWindow) {
                    this.showMinimapWindow(this.stage, show);
                    break;
                }
                this.showMinimapInterface(this.stage, show);
                break;
            }
            case CONSOLE_CMD: {
                boolean show;
                if (data != null && data.length > 0) {
                    show = (Boolean)data[0];
                } else {
                    boolean bl = show = !this.consoleInterface.hasParent();
                }
                if (show) {
                    this.interfaces.add((Object)this.consoleInterface);
                    if (this.consoleInterface.hasParent() && this.consoleInterface.getParent() == this.stage.getRoot()) break;
                    this.stage.addActor((Actor)this.consoleInterface);
                    this.consoleInterface.showConsole();
                    break;
                }
                if (this.consoleInterface == null) break;
                this.interfaces.removeValue((Object)this.consoleInterface, true);
                this.consoleInterface.closeConsole();
                break;
            }
        }
    }

    public void setScene(Scene scene) {
        this.scene = scene;
    }

    @Override
    public void setVisibilityToggles(ComponentTypes.ComponentType[] entities, ComponentTypes visible) {
        this.visibilityEntities = entities;
        ComponentTypes.ComponentType[] values = ComponentTypes.ComponentType.values();
        this.visible = new boolean[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.visible[i] = visible.get(values[i].ordinal());
        }
    }

    public void addControlsWindow() {
        this.controlsWindow = new ControlsWindow(Settings.getSuperShortApplicationName(), this.skin, this.stage, this.catalogManager);
        this.controlsWindow.setScene(this.scene);
        this.controlsWindow.setVisibilityToggles(this.visibilityEntities, this.visible);
        this.controlsWindow.initialize();
        this.controlsWindow.left();
        this.controlsWindow.getTitleTable().align(8);
        this.controlsWindow.setFillParent(false);
        this.controlsWindow.setMovable(true);
        this.controlsWindow.setResizable(false);
        this.controlsWindow.padRight(5.0f);
        this.controlsWindow.padBottom(5.0f);
        this.controlsWindow.collapseInstant();
    }

    public void initializeMinimap(Stage ui) {
        if (Settings.settings.program.minimap.active) {
            if (Settings.settings.program.minimap.inWindow) {
                this.showMinimapWindow(ui, true);
            } else if (this.minimapInterface == null) {
                this.minimapInterface = new MinimapInterface(this.skin, this.globalResources.getShapeShader(), this.globalResources.getSpriteShader());
                this.minimapInterface.setFillParent(true);
                this.minimapInterface.right().top();
                this.minimapInterface.pad(this.pad, 0.0f, 0.0f, this.pad);
                this.interfaces.add((Object)this.minimapInterface);
            }
        }
    }

    public void showMinimapInterface(Stage ui, boolean show) {
        if (show && this.minimapInterface == null) {
            this.minimapInterface = new MinimapInterface(this.skin, this.globalResources.getShapeShader(), this.globalResources.getSpriteShader());
            this.minimapInterface.setFillParent(true);
            this.minimapInterface.right().top();
            this.minimapInterface.pad(this.pad, 0.0f, 0.0f, this.pad);
            this.interfaces.add((Object)this.minimapInterface);
        }
        if (show) {
            if (!this.minimapInterface.hasParent() || this.minimapInterface.getParent() != ui.getRoot()) {
                ui.addActor((Actor)this.minimapInterface);
                this.minimapInterface.addAction((Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)Settings.settings.program.ui.getAnimationSeconds())));
            }
        } else if (this.minimapInterface != null) {
            this.minimapInterface.addAction((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.run(() -> this.minimapInterface.remove())));
        }
    }

    public void addLoadProgressInterface() {
        this.loadProgressInterface = new LoadProgressInterface(400.0f, this.skin);
        this.loadProgressInterface.setFillParent(true);
        this.loadProgressInterface.center().bottom();
        this.loadProgressInterface.pad(0.0f, 0.0f, 0.0f, 0.0f);
        this.interfaces.add((Object)this.loadProgressInterface);
    }

    public void toggleMinimapInterface(Stage stage) {
        this.showMinimapInterface(stage, this.minimapInterface == null || !this.minimapInterface.isVisible() || !this.minimapInterface.hasParent());
    }

    public void showMinimapWindow(Stage stage, boolean show) {
        if (show && this.minimapWindow == null) {
            this.minimapWindow = new MinimapWindow(stage, this.skin, this.globalResources.getShapeShader(), this.globalResources.getSpriteShader());
        }
        if (show) {
            this.minimapWindow.show(stage, (float)this.graphics.getWidth() - this.minimapWindow.getWidth(), (float)this.graphics.getHeight() - this.minimapWindow.getHeight());
        } else if (this.minimapWindow != null) {
            this.minimapWindow.hide();
        }
    }

    public void toggleMinimapWindow(Stage ui) {
        this.showMinimapWindow(ui, this.minimapWindow == null || !this.minimapWindow.isVisible() || !this.minimapWindow.hasParent());
    }

    @Override
    public boolean updateUnitsPerPixel(float upp) {
        boolean cool = super.updateUnitsPerPixel(upp);
        if (cool && this.controlsWindow != null) {
            this.controlsWindow.setPosition(0.0f, (float)this.graphics.getHeight() * this.unitsPerPixel - this.controlsWindow.getHeight());
            this.controlsWindow.recalculateSize();
            if (this.stage.getHeight() < this.controlsWindow.getHeight()) {
                this.controlsWindow.collapseInstant();
            }
        }
        return cool;
    }
}

