/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.beans.CameraComboBoxBean;
import gaiasky.gui.bookmarks.BookmarksManager;
import gaiasky.gui.iface.CameraInfoInterface;
import gaiasky.gui.iface.TopInfoInterface;
import gaiasky.gui.main.AbstractGui;
import gaiasky.gui.main.GamepadMappings;
import gaiasky.gui.main.KeyBindings;
import gaiasky.gui.window.GamepadConfigWindow;
import gaiasky.input.GuiGamepadListener;
import gaiasky.render.ComponentTypes;
import gaiasky.render.postprocess.effects.CubmeapProjectionEffect;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.camera.ICamera;
import gaiasky.scene.view.FilterView;
import gaiasky.scene.view.FocusView;
import gaiasky.util.GuiUtils;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SlaveManager;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.BookmarkButton;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnScrollPane;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnSliderPlus;
import gaiasky.util.scene2d.OwnTextButton;
import gaiasky.util.scene2d.OwnTextField;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.vr.openxr.XrDriver;
import gaiasky.vr.openxr.input.XrControllerDevice;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jafama.FastMath;

public class GamepadGui
extends AbstractGui {
    private static final Logger.Log logger = Logger.getLogger(GamepadGui.class);
    private boolean initialized = false;
    private final Table content;
    private final Table menu;
    private final List<Actor[][]> model;
    private final List<OwnTextButton> tabButtons;
    private final List<ScrollPane> tabContents;
    private final EventManager em;
    private final float pad5;
    private final float pad10;
    private final float pad20;
    private final float pad30;
    private final float pad40;
    private float th;
    private final float bw;
    private final float bh;
    private final FocusView view;
    private final FilterView filterView;
    boolean hackProgrammaticChangeEvents = true;
    private Table searchT;
    private Cell<?> contentCell;
    private Cell<?> infoCell;
    private OwnTextButton vrInfoButton;
    private OwnTextButton searchButton;
    private OwnTextButton bookmarksButton;
    private OwnTextButton cameraButton;
    private OwnTextButton timeButton;
    private OwnTextButton graphicsButton;
    private OwnTextButton typesButton;
    private OwnTextButton controlsButton;
    private OwnTextButton systemButton;
    private OwnTextIconButton button3d;
    private OwnTextIconButton buttonDome;
    private OwnTextIconButton buttonCubemap;
    private OwnTextIconButton buttonOrthoSphere;
    private OwnTextIconButton buttonGoHome;
    private TopInfoInterface topLine;
    private CameraInfoInterface focusInterface;
    private OwnCheckBox cinematic;
    private OwnCheckBox crosshairFocus;
    private OwnCheckBox crosshairClosest;
    private OwnCheckBox crosshairHome;
    private OwnCheckBox debugInfo;
    private OwnSelectBox<CameraComboBoxBean> cameraMode;
    private OwnTextButton timeStartStop;
    private OwnTextButton timeUp;
    private OwnTextButton timeDown;
    private OwnTextButton timeReset;
    private OwnTextButton starGlowButton;
    private OwnTextButton invertYButton;
    private OwnTextButton invertXButton;
    private OwnSliderPlus fovSlider;
    private OwnSliderPlus camSpeedSlider;
    private OwnSliderPlus camRotSlider;
    private OwnSliderPlus camTurnSlider;
    private OwnSliderPlus bloomSlider;
    private OwnSliderPlus unsharpMaskSlider;
    private OwnSliderPlus starBrightness;
    private OwnSliderPlus magnitudeMultiplier;
    private OwnSliderPlus starGlowFactor;
    private OwnSliderPlus pointSize;
    private OwnSliderPlus starBaseLevel;
    private OwnSliderPlus lensFlare;
    private OwnSliderPlus motionBlur;
    private OwnTextField searchField;
    private OwnLabel infoMessage;
    private OwnLabel cameraModeLabel;
    private OwnLabel cameraFocusLabel;
    private Actor[][] currentModel;
    private Scene scene;
    private GamepadGuiListener gamepadListener;
    private Set<ControllerListener> backupGamepadListeners;
    private String currentInputText = "";
    private final Map<String, Button> visibilityButtonMap;
    private Cell<Container>[] bookmarkColumns;
    private final int maxBookmarkDepth = 4;
    private static int selectedTab = 0;
    private int fi = 0;
    private int fj = 0;

    public GamepadGui(Skin skin, Graphics graphics, Float unitsPerPixel, boolean vrMode) {
        super(graphics, unitsPerPixel);
        this.skin = skin;
        this.em = EventManager.instance;
        this.vr = vrMode;
        this.model = new ArrayList<Actor[][]>();
        this.content = new Table(skin);
        this.content.setVisible(false);
        this.menu = new Table(skin);
        this.tabButtons = new ArrayList<OwnTextButton>();
        this.tabContents = new ArrayList<ScrollPane>();
        this.visibilityButtonMap = new HashMap<String, Button>();
        this.pad5 = 8.0f;
        this.pad10 = 16.0f;
        this.pad20 = 32.0f;
        this.pad30 = 48.0f;
        this.pad40 = 98.0f;
        this.bw = 300.0f;
        this.bh = 60.0f;
        this.view = new FocusView();
        this.filterView = new FilterView();
    }

    public GamepadGui(Skin skin, Graphics graphics, Float unitsPerPixel) {
        this(skin, graphics, unitsPerPixel, false);
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        ScreenViewport vp = new ScreenViewport();
        vp.setUnitsPerPixel(this.unitsPerPixel);
        this.stage = new Stage((Viewport)vp, (Batch)sb);
        this.gamepadListener = new GamepadGuiListener(this, Settings.settings.controls.gamepad.mappingsFile);
        this.registerEvents();
        this.initialized = true;
    }

    public void initialize(Stage stage) {
        this.stage = stage;
        this.registerEvents();
    }

    private void registerEvents() {
        EventManager.instance.subscribe((IObserver)this, gaiasky.event.Event.SHOW_CONTROLLER_GUI_ACTION, gaiasky.event.Event.TIME_STATE_CMD, gaiasky.event.Event.SCENE_LOADED, gaiasky.event.Event.CAMERA_MODE_CMD, gaiasky.event.Event.FOCUS_CHANGE_CMD);
        EventManager.instance.subscribe((IObserver)this, gaiasky.event.Event.STAR_POINT_SIZE_CMD, gaiasky.event.Event.STAR_BRIGHTNESS_CMD, gaiasky.event.Event.STAR_BRIGHTNESS_POW_CMD, gaiasky.event.Event.STAR_GLOW_FACTOR_CMD, gaiasky.event.Event.STAR_BASE_LEVEL_CMD, gaiasky.event.Event.LABEL_SIZE_CMD, gaiasky.event.Event.LINE_WIDTH_CMD);
        EventManager.instance.subscribe((IObserver)this, gaiasky.event.Event.CUBEMAP_CMD, gaiasky.event.Event.STEREOSCOPIC_CMD, gaiasky.event.Event.TOGGLE_VISIBILITY_CMD);
        EventManager.instance.subscribe((IObserver)this, gaiasky.event.Event.TIME_CHANGE_INFO, gaiasky.event.Event.TIME_CHANGE_CMD, gaiasky.event.Event.INVERT_X_CMD, gaiasky.event.Event.INVERT_Y_CMD);
        EventManager.instance.subscribe((IObserver)this, gaiasky.event.Event.TIME_WARP_CHANGED_INFO, gaiasky.event.Event.TIME_WARP_CMD);
        EventManager.instance.subscribe((IObserver)this, gaiasky.event.Event.CROSSHAIR_CLOSEST_CMD, gaiasky.event.Event.CROSSHAIR_FOCUS_CMD, gaiasky.event.Event.CROSSHAIR_HOME_CMD);
    }

    public void build() {
        this.rebuildGui();
    }

    @Override
    protected void rebuildGui() {
        this.content.clear();
        this.menu.clear();
        this.tabButtons.clear();
        this.tabContents.clear();
        this.model.clear();
        float tw1 = this.vr ? 1632.0f : FastMath.min((float)Gdx.graphics.getWidth(), (float)1450.0f) - 60.0f;
        this.th = this.vr ? 918.0f : FastMath.min((float)Gdx.graphics.getHeight(), (float)860.0f) - 60.0f;
        float ww = 400.0f;
        float wh = 64.0f;
        float sh = 96.0f;
        float tfw = 240.0f;
        float tw = 224.0f;
        if (this.vr) {
            this.topLine = new TopInfoInterface(this.skin, GaiaSky.instance.scene);
            this.buttonGoHome = new OwnTextIconButton("", this.skin, "home");
            this.buttonGoHome.addListener((EventListener)new OwnTextTooltip(I18n.msg("context.goto", Settings.settings.scene.homeObject), this.skin, 10));
            this.buttonGoHome.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(gaiasky.event.Event.GO_HOME_INSTANT_CMD, (Object)this.buttonGoHome, new Object[0]);
                    return true;
                }
                return false;
            });
            this.model.add(null);
            Table infoT = new Table(this.skin);
            infoT.setSize(tw1, this.th);
            Table vrInfoT = new Table(this.skin);
            vrInfoT.setSize(tw1, this.th);
            OwnLabel welcomeTitle = new OwnLabel((CharSequence)Settings.getApplicationTitle(Settings.settings.runtime.openXr), this.skin, "header-large");
            OwnLabel version = new OwnLabel((CharSequence)Settings.settings.version.version, this.skin, "header-raw");
            vrInfoT.add((Actor)welcomeTitle).center().top().padBottom(this.pad20).colspan(2).row();
            vrInfoT.add((Actor)version).center().top().padBottom(this.pad40).colspan(2).row();
            XrDriver driver = GaiaSky.instance.xrDriver;
            if (driver != null) {
                this.addDeviceTypeInfo(vrInfoT, I18n.msg("gui.vr.system"), driver.systemString);
                this.addDeviceTypeInfo(vrInfoT, I18n.msg("gui.vr.runtime.name"), driver.runtimeName);
                this.addDeviceTypeInfo(vrInfoT, I18n.msg("gui.vr.runtime.version"), driver.runtimeVersionString);
                XrControllerDevice left = (XrControllerDevice)driver.getControllerDevices().get(0);
                XrControllerDevice right = (XrControllerDevice)driver.getControllerDevices().get(1);
                this.addDeviceTypeInfo(vrInfoT, I18n.msg("gui.vr.controller.left"), I18n.msg("gui.vr.controller.active", left.isActive()));
                this.addDeviceTypeInfo(vrInfoT, I18n.msg("gui.vr.controller.right"), I18n.msg("gui.vr.controller.active", right.isActive()));
            }
            infoT.add((Actor)vrInfoT).left().center().padRight(this.pad30 * 2.0f);
            this.focusInterface = new CameraInfoInterface(this.skin, this.vr);
            infoT.add((Actor)this.focusInterface).left().center();
            this.tabContents.add(this.container(infoT, tw1, this.th));
            this.updatePads(infoT);
        }
        Actor[][] searchModel = new Actor[11][5];
        this.model.add(searchModel);
        this.searchT = new Table(this.skin);
        this.searchT.setSize(tw1, this.th);
        this.searchField = new OwnTextField("", this.skin, "big");
        this.searchField.setProgrammaticChangeEvents(true);
        this.searchField.setSize(ww, wh);
        this.searchField.setMessageText("Search...");
        this.searchField.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent && !this.searchField.getText().equals(this.currentInputText) && !this.searchField.getText().isBlank()) {
                this.currentInputText = this.searchField.getText();
                String name = this.currentInputText.toLowerCase(Locale.ROOT).trim();
                if (!this.checkString(name, this.scene)) {
                    if (name.matches("[0-9]+")) {
                        this.checkString("hip " + name, this.scene);
                    } else if (name.matches("hip [0-9]+") || name.matches("HIP [0-9]+")) {
                        this.checkString(name.substring(4), this.scene);
                    }
                }
            }
            return false;
        });
        this.searchT.add((Actor)this.searchField).colspan(11).padBottom(this.pad5).row();
        this.infoMessage = new OwnLabel((CharSequence)"", this.skin, "default-blue");
        this.infoCell = this.searchT.add();
        this.infoCell.colspan(11).padBottom(this.pad20).row();
        this.addTextKey("1", searchModel, 0, 0, false);
        this.addTextKey("2", searchModel, 1, 0, false);
        this.addTextKey("3", searchModel, 2, 0, false);
        this.addTextKey("4", searchModel, 3, 0, false);
        this.addTextKey("5", searchModel, 4, 0, false);
        this.addTextKey("6", searchModel, 5, 0, false);
        this.addTextKey("7", searchModel, 6, 0, false);
        this.addTextKey("8", searchModel, 7, 0, false);
        this.addTextKey("9", searchModel, 8, 0, false);
        this.addTextKey("0", searchModel, 9, 0, false);
        this.addTextKey("<--", event -> {
            if (event instanceof ChangeListener.ChangeEvent && !this.searchField.getText().isBlank()) {
                this.searchField.setText(this.searchField.getText().substring(0, this.searchField.getText().length() - 1));
            }
            return false;
        }, searchModel, 10, 0, true, tfw / 1.5f, 0);
        this.addTextKey("Q", searchModel, 0, 1, false);
        this.addTextKey("W", searchModel, 1, 1, false);
        this.addTextKey("E", searchModel, 2, 1, false);
        this.addTextKey("R", searchModel, 3, 1, false);
        this.addTextKey("T", searchModel, 4, 1, false);
        this.addTextKey("Y", searchModel, 5, 1, false);
        this.addTextKey("U", searchModel, 6, 1, false);
        this.addTextKey("I", searchModel, 7, 1, false);
        this.addTextKey("O", searchModel, 8, 1, false);
        this.addTextKey("P", searchModel, 9, 1, true);
        this.addTextKey("A", searchModel, 0, 2, false);
        this.addTextKey("S", searchModel, 1, 2, false);
        this.addTextKey("D", searchModel, 2, 2, false);
        this.addTextKey("F", searchModel, 3, 2, false);
        this.addTextKey("G", searchModel, 4, 2, false);
        this.addTextKey("H", searchModel, 5, 2, false);
        this.addTextKey("J", searchModel, 6, 2, false);
        this.addTextKey("K", searchModel, 7, 2, false);
        this.addTextKey("L", searchModel, 8, 2, false);
        this.addTextKey("'", searchModel, 9, 2, true);
        this.addTextKey("Z", searchModel, 0, 3, false);
        this.addTextKey("X", searchModel, 1, 3, false);
        this.addTextKey("C", searchModel, 2, 3, false);
        this.addTextKey("V", searchModel, 3, 3, false);
        this.addTextKey("B", searchModel, 4, 3, false);
        this.addTextKey("N", searchModel, 5, 3, false);
        this.addTextKey("M", searchModel, 6, 3, false);
        this.addTextKey(".", searchModel, 7, 3, false);
        this.addTextKey(",", searchModel, 8, 3, false);
        this.addTextKey("-", searchModel, 9, 3, true);
        this.searchT.add().padRight(this.pad5).padBottom(this.pad10);
        this.searchT.add().padRight(this.pad5).padBottom(this.pad10);
        this.addTextKey("SPACE", event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.searchField.setText(this.searchField.getText() + " ");
            }
            return false;
        }, searchModel, 7, 4, false, tfw * 2.0f, 6);
        this.addTextKey("Clear", event -> {
            if (event instanceof ChangeListener.ChangeEvent && !this.searchField.getText().isBlank()) {
                this.searchField.setText("");
            }
            return false;
        }, searchModel, 8, 4, false, tfw / 1.5f, 3);
        this.tabContents.add(this.container(this.searchT, tw1, this.th));
        this.updatePads(this.searchT);
        BookmarksManager bm = GaiaSky.instance.getBookmarksManager();
        List<BookmarksManager.BookmarkNode> bookmarks = bm.getBookmarks();
        Actor[][] bookmarksModel = new Actor[4][bookmarks.size()];
        this.model.add(bookmarksModel);
        Table bookmarksT = new Table(this.skin);
        bookmarksT.setSize(tw1, this.th);
        bookmarksT.align(10);
        bookmarksT.pad(this.pad10);
        bookmarksT.top().left();
        this.bookmarkColumns = new Cell[4];
        for (int l = 0; l < 4; ++l) {
            this.bookmarkColumns[l] = bookmarksT.add().left().width(this.bw);
        }
        this.fillBookmarksColumn(this.bookmarkColumns, 0, bookmarks, bookmarksModel, this.bw, this.bh);
        this.tabContents.add(this.container(bookmarksT, tw1, this.th));
        this.updatePads(bookmarksT);
        ICamera camera = GaiaSky.instance.getICamera();
        Actor[][] cameraModel = new Actor[4][10];
        this.model.add(cameraModel);
        Table camT = new Table(this.skin);
        camT.setSize(tw1, this.th);
        CameraManager cam = GaiaSky.instance.getCameraManager();
        Label modeLabel = new Label((CharSequence)I18n.msg("gui.camera.mode"), this.skin, "header-raw");
        if (!this.vr) {
            int cameraModes = CameraManager.CameraMode.values().length;
            Object[] cameraOptions = new CameraComboBoxBean[cameraModes];
            for (int i = 0; i < cameraModes; ++i) {
                cameraOptions[i] = new CameraComboBoxBean(Objects.requireNonNull(CameraManager.CameraMode.getMode(i)).toStringI18n(), CameraManager.CameraMode.getMode(i));
            }
            this.cameraMode = new OwnSelectBox(this.skin, "big");
            cameraModel[0][0] = this.cameraMode;
            this.cameraMode.setWidth(ww);
            this.cameraMode.setItems(cameraOptions);
            this.cameraMode.setSelectedIndex(cam.getMode().ordinal());
            this.cameraMode.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    CameraComboBoxBean selection = (CameraComboBoxBean)this.cameraMode.getSelected();
                    CameraManager.CameraMode mode = selection.mode;
                    EventManager.publish(gaiasky.event.Event.CAMERA_MODE_CMD, this.cameraMode, new Object[]{mode});
                    return true;
                }
                return false;
            });
            camT.add((Actor)modeLabel).right().padBottom(this.pad20).padRight(this.pad20);
            camT.add(this.cameraMode).left().padBottom(this.pad20).row();
            Label cinematicLabel = new Label((CharSequence)I18n.msg("gui.camera.cinematic"), this.skin, "header-raw");
            this.cinematic = new OwnCheckBox("", this.skin, 0.0f);
            cameraModel[0][1] = this.cinematic;
            this.cinematic.setChecked(Settings.settings.scene.camera.cinematic);
            this.cinematic.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(gaiasky.event.Event.CAMERA_CINEMATIC_CMD, (Object)this.cinematic, this.cinematic.isChecked());
                    return true;
                }
                return false;
            });
            camT.add((Actor)cinematicLabel).right().padBottom(this.pad20).padRight(this.pad20);
            camT.add((Actor)this.cinematic).left().padBottom(this.pad20).row();
            Label fovLabel = new Label((CharSequence)I18n.msg("gui.camera.fov"), this.skin, "header-raw");
            this.fovSlider = new OwnSliderPlus("", 1.0f, 150.0f, 0.1f, false, this.skin, "header-raw");
            cameraModel[0][2] = this.fovSlider;
            this.fovSlider.setValueSuffix("\u00b0");
            this.fovSlider.setName("field of view");
            this.fovSlider.setWidth(ww);
            this.fovSlider.setValue(Settings.settings.scene.camera.fov);
            this.fovSlider.setDisabled(Settings.settings.program.modeCubemap.isFixedFov());
            this.fovSlider.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent && !SlaveManager.projectionActive() && !Settings.settings.program.modeCubemap.isFixedFov()) {
                    float value = this.fovSlider.getMappedValue();
                    EventManager.publish(gaiasky.event.Event.FOV_CHANGED_CMD, (Object)this.fovSlider, Float.valueOf(value));
                    return true;
                }
                return false;
            });
            camT.add((Actor)fovLabel).right().padBottom(this.pad20).padRight(this.pad20);
            camT.add((Actor)this.fovSlider).left().padBottom(this.pad20).row();
        } else {
            String modeString = camera.getMode().toStringI18n();
            this.cameraModeLabel = new OwnLabel((CharSequence)modeString, this.skin, "header");
            camT.add((Actor)modeLabel).right().padBottom(this.pad20).padRight(this.pad20);
            camT.add((Actor)this.cameraModeLabel).left().padBottom(this.pad20).row();
            String focusString = camera.getMode().isFocus() ? camera.getFocus().getLocalizedName() : "-";
            Label focusLabel = new Label((CharSequence)I18n.msg("camera.FOCUS_MODE"), this.skin, "header-raw");
            this.cameraFocusLabel = new OwnLabel((CharSequence)focusString, this.skin, "header");
            camT.add((Actor)focusLabel).right().padBottom(this.pad20).padRight(this.pad20);
            camT.add((Actor)this.cameraFocusLabel).left().padBottom(this.pad20).row();
        }
        Label speedLabel = new Label((CharSequence)I18n.msg("gui.camera.speed"), this.skin, "header-raw");
        this.camSpeedSlider = new OwnSliderPlus("", 0.0f, 100.0f, 1.0f, 0.1f, 15.0f, this.skin, "header-raw");
        cameraModel[0][3] = this.camSpeedSlider;
        this.camSpeedSlider.setName("camera speed");
        this.camSpeedSlider.setWidth(ww);
        this.camSpeedSlider.setMappedValue(Settings.settings.scene.camera.speed);
        this.camSpeedSlider.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.CAMERA_SPEED_CMD, (Object)this.camSpeedSlider, Float.valueOf(this.camSpeedSlider.getMappedValue()), false);
                return true;
            }
            return false;
        });
        camT.add((Actor)speedLabel).right().padBottom(this.pad20).padRight(this.pad20);
        camT.add((Actor)this.camSpeedSlider).left().padBottom(this.pad20).row();
        Label rotationLabel = new Label((CharSequence)I18n.msg("gui.rotation.speed"), this.skin, "header-raw");
        this.camRotSlider = new OwnSliderPlus("", 0.0f, 100.0f, 1.0f, 200.0f, 10000.0f, this.skin, "header-raw");
        cameraModel[0][4] = this.camRotSlider;
        this.camRotSlider.setName("rotate speed");
        this.camRotSlider.setWidth(ww);
        this.camRotSlider.setMappedValue(Settings.settings.scene.camera.rotate);
        this.camRotSlider.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.ROTATION_SPEED_CMD, (Object)this.camRotSlider, Float.valueOf(this.camRotSlider.getMappedValue()));
                return true;
            }
            return false;
        });
        camT.add((Actor)rotationLabel).right().padBottom(this.pad20).padRight(this.pad20);
        camT.add((Actor)this.camRotSlider).left().padBottom(this.pad20).row();
        Label turnLabel = new Label((CharSequence)I18n.msg("gui.turn.speed"), this.skin, "header-raw");
        this.camTurnSlider = new OwnSliderPlus("", 0.0f, 100.0f, 1.0f, 200.0f, 3000.0f, this.skin, "header-raw");
        cameraModel[0][5] = this.camTurnSlider;
        this.camTurnSlider.setName("turn speed");
        this.camTurnSlider.setWidth(ww);
        this.camTurnSlider.setMappedValue(Settings.settings.scene.camera.turn);
        this.camTurnSlider.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.TURNING_SPEED_CMD, (Object)this.camTurnSlider, Float.valueOf(this.camTurnSlider.getMappedValue()), false);
                return true;
            }
            return false;
        });
        camT.add((Actor)turnLabel).right().padBottom(this.pad20).padRight(this.pad20);
        camT.add((Actor)this.camTurnSlider).left().padBottom(this.pad20).row();
        OwnLabel crosshairFocusLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.crosshair.focus"), this.skin);
        this.crosshairFocus = new OwnCheckBox("", this.skin);
        cameraModel[0][6] = this.crosshairFocus;
        this.crosshairFocus.setName("ch focus");
        this.crosshairFocus.setChecked(Settings.settings.scene.crosshair.focus);
        this.crosshairFocus.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.CROSSHAIR_FOCUS_CMD, this, this.crosshairFocus.isChecked());
            }
            return false;
        });
        camT.add((Actor)crosshairFocusLabel).right().padBottom(this.pad20).padRight(this.pad20);
        camT.add((Actor)this.crosshairFocus).left().padBottom(this.pad20).row();
        OwnLabel crosshairClosestLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.crosshair.closest"), this.skin);
        this.crosshairClosest = new OwnCheckBox("", this.skin);
        cameraModel[0][7] = this.crosshairClosest;
        this.crosshairClosest.setName("ch closest");
        this.crosshairClosest.setChecked(Settings.settings.scene.crosshair.closest);
        this.crosshairClosest.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.CROSSHAIR_CLOSEST_CMD, this, this.crosshairClosest.isChecked());
            }
            return false;
        });
        camT.add((Actor)crosshairClosestLabel).right().padBottom(this.pad20).padRight(this.pad20);
        camT.add((Actor)this.crosshairClosest).left().padBottom(this.pad20).row();
        OwnLabel crosshairHomeLabel = new OwnLabel((CharSequence)I18n.msg("gui.ui.crosshair.home"), this.skin);
        this.crosshairHome = new OwnCheckBox("", this.skin);
        cameraModel[0][8] = this.crosshairHome;
        this.crosshairHome.setName("ch home");
        this.crosshairHome.setChecked(Settings.settings.scene.crosshair.home);
        this.crosshairHome.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.CROSSHAIR_HOME_CMD, this, this.crosshairHome.isChecked());
            }
            return false;
        });
        camT.add((Actor)crosshairHomeLabel).right().padBottom(this.pad20).padRight(this.pad20);
        camT.add((Actor)this.crosshairHome).left().padBottom(this.pad20).row();
        if (!this.vr) {
            Table modeButtons = new Table(this.skin);
            Image icon3d = new Image(this.skin.getDrawable("3d-icon"));
            this.button3d = new OwnTextIconButton("", icon3d, this.skin, "toggle");
            cameraModel[0][9] = this.button3d;
            this.button3d.setChecked(Settings.settings.program.modeStereo.active);
            String[] hk3d = KeyBindings.instance.getStringKeys("action.toggle/element.stereomode", true);
            this.button3d.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.stereomode")), hk3d, this.skin));
            this.button3d.setName("3d");
            this.button3d.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.button3d.isChecked()) {
                        this.buttonCubemap.setProgrammaticChangeEvents(true);
                        this.buttonCubemap.setChecked(false);
                        this.buttonDome.setProgrammaticChangeEvents(true);
                        this.buttonDome.setChecked(false);
                        this.buttonOrthoSphere.setProgrammaticChangeEvents(true);
                        this.buttonOrthoSphere.setChecked(false);
                    }
                    EventManager.publish(gaiasky.event.Event.STEREOSCOPIC_CMD, (Object)this.button3d, this.button3d.isChecked());
                    return true;
                }
                return false;
            });
            modeButtons.add((Actor)this.button3d).padRight(this.pad20);
            Image iconDome = new Image(this.skin.getDrawable("dome-icon"));
            this.buttonDome = new OwnTextIconButton("", iconDome, this.skin, "toggle");
            cameraModel[1][9] = this.buttonDome;
            this.buttonDome.setChecked(Settings.settings.program.modeCubemap.active && Settings.settings.program.modeCubemap.isPlanetariumOn());
            String[] hkDome = KeyBindings.instance.getStringKeys("action.toggle/element.planetarium", true);
            this.buttonDome.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.planetarium")), hkDome, this.skin));
            this.buttonDome.setName("dome");
            this.buttonDome.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.buttonDome.isChecked()) {
                        this.buttonCubemap.setProgrammaticChangeEvents(true);
                        this.buttonCubemap.setChecked(false);
                        this.button3d.setProgrammaticChangeEvents(true);
                        this.button3d.setChecked(false);
                        this.buttonOrthoSphere.setProgrammaticChangeEvents(true);
                        this.buttonOrthoSphere.setChecked(false);
                    }
                    EventManager.publish(gaiasky.event.Event.CUBEMAP_CMD, (Object)this.buttonDome, new Object[]{this.buttonDome.isChecked(), CubmeapProjectionEffect.CubemapProjection.AZIMUTHAL_EQUIDISTANT});
                    this.fovSlider.setDisabled(this.buttonDome.isChecked());
                    return true;
                }
                return false;
            });
            modeButtons.add((Actor)this.buttonDome).padRight(this.pad20);
            Image iconCubemap = new Image(this.skin.getDrawable("cubemap-icon"));
            this.buttonCubemap = new OwnTextIconButton("", iconCubemap, this.skin, "toggle");
            cameraModel[2][9] = this.buttonCubemap;
            this.buttonCubemap.setProgrammaticChangeEvents(false);
            this.buttonCubemap.setChecked(Settings.settings.program.modeCubemap.active && Settings.settings.program.modeCubemap.isPanoramaOn());
            String[] hkCubemap = KeyBindings.instance.getStringKeys("action.toggle/element.360", true);
            this.buttonCubemap.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.360")), hkCubemap, this.skin));
            this.buttonCubemap.setName("cubemap");
            this.buttonCubemap.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.buttonCubemap.isChecked()) {
                        this.buttonDome.setProgrammaticChangeEvents(true);
                        this.buttonDome.setChecked(false);
                        this.button3d.setProgrammaticChangeEvents(true);
                        this.button3d.setChecked(false);
                        this.buttonOrthoSphere.setProgrammaticChangeEvents(true);
                        this.buttonOrthoSphere.setChecked(false);
                    }
                    EventManager.publish(gaiasky.event.Event.CUBEMAP_CMD, (Object)this.buttonCubemap, new Object[]{this.buttonCubemap.isChecked(), CubmeapProjectionEffect.CubemapProjection.EQUIRECTANGULAR});
                    this.fovSlider.setDisabled(this.buttonCubemap.isChecked());
                    return true;
                }
                return false;
            });
            modeButtons.add((Actor)this.buttonCubemap).padRight(this.pad20);
            Image iconOrthosphere = new Image(this.skin.getDrawable("orthosphere-icon"));
            this.buttonOrthoSphere = new OwnTextIconButton("", iconOrthosphere, this.skin, "toggle");
            cameraModel[3][9] = this.buttonOrthoSphere;
            this.buttonOrthoSphere.setProgrammaticChangeEvents(false);
            this.buttonOrthoSphere.setChecked(Settings.settings.program.modeCubemap.active && Settings.settings.program.modeCubemap.isOrthosphereOn());
            String[] hkOrthosphere = KeyBindings.instance.getStringKeys("action.toggle/element.orthosphere", true);
            this.buttonOrthoSphere.addListener((EventListener)new OwnTextHotkeyTooltip(TextUtils.capitalise(I18n.msg("element.orthosphere")), hkOrthosphere, this.skin));
            this.buttonOrthoSphere.setName("orthosphere");
            this.buttonOrthoSphere.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    if (this.buttonOrthoSphere.isChecked()) {
                        this.buttonCubemap.setProgrammaticChangeEvents(true);
                        this.buttonCubemap.setChecked(false);
                        this.buttonDome.setProgrammaticChangeEvents(true);
                        this.buttonDome.setChecked(false);
                        this.button3d.setProgrammaticChangeEvents(true);
                        this.button3d.setChecked(false);
                    }
                    EventManager.publish(gaiasky.event.Event.CUBEMAP_CMD, (Object)this.buttonOrthoSphere, new Object[]{this.buttonOrthoSphere.isChecked(), CubmeapProjectionEffect.CubemapProjection.ORTHOSPHERE});
                    this.fovSlider.setDisabled(this.buttonOrthoSphere.isChecked());
                    return true;
                }
                return false;
            });
            modeButtons.add((Actor)this.buttonOrthoSphere).padRight(this.pad20);
            camT.add((Actor)modeButtons).colspan(2).center().padTop(this.pad40);
        }
        this.tabContents.add(this.container(camT, tw1, this.th));
        this.updatePads(camT);
        Actor[][] timeModel = new Actor[3][2];
        this.model.add(timeModel);
        Table timeT = new Table(this.skin);
        boolean timeOn = Settings.settings.runtime.timeOn;
        this.timeStartStop = new OwnTextButton(I18n.msg(timeOn ? "gui.time.pause" : "gui.time.start"), this.skin, "toggle-big");
        timeModel[1][0] = this.timeStartStop;
        this.timeStartStop.setWidth(ww);
        this.timeStartStop.setChecked(timeOn);
        this.timeStartStop.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.em.post(gaiasky.event.Event.TIME_STATE_CMD, (Object)this.timeStartStop, this.timeStartStop.isChecked());
                this.timeStartStop.setText(I18n.msg(this.timeStartStop.isChecked() ? "gui.time.pause" : "gui.time.start"));
                return true;
            }
            return false;
        });
        this.timeUp = new OwnTextIconButton(I18n.msg("gui.time.speedup"), 16, this.skin, "fwd");
        timeModel[2][0] = this.timeUp;
        this.timeUp.setWidth(ww);
        this.timeUp.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.em.post(gaiasky.event.Event.TIME_WARP_INCREASE_CMD, (Object)this.timeUp);
                return true;
            }
            return false;
        });
        this.timeDown = new OwnTextIconButton(I18n.msg("gui.time.slowdown"), this.skin, "bwd");
        timeModel[0][0] = this.timeDown;
        this.timeDown.setWidth(ww);
        this.timeDown.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.em.post(gaiasky.event.Event.TIME_WARP_DECREASE_CMD, (Object)this.timeDown);
                return true;
            }
            return false;
        });
        this.timeReset = new OwnTextIconButton(I18n.msg("action.resettime"), 1, this.skin, "reload");
        timeModel[1][1] = this.timeReset;
        this.timeReset.setWidth(ww);
        this.timeReset.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.em.post(gaiasky.event.Event.TIME_CHANGE_CMD, (Object)this.timeReset, Instant.now());
                return true;
            }
            return false;
        });
        timeT.add((Actor)this.timeDown).padBottom(this.pad30).padRight(this.pad10);
        timeT.add((Actor)this.timeStartStop).padBottom(this.pad30).padRight(this.pad10);
        timeT.add((Actor)this.timeUp).padBottom(this.pad30).row();
        timeT.add((Actor)this.timeReset).padRight(this.pad10).padLeft(this.pad10).colspan(3).padBottom(this.pad10).row();
        this.tabContents.add(this.container(timeT, tw1, this.th));
        this.updatePads(timeT);
        int visTableCols = 6;
        Actor[][] typesModel = new Actor[visTableCols][7];
        this.model.add(typesModel);
        Table typesT = new Table(this.skin);
        float buttonPadHor = 9.6f;
        float buttonPadVert = 4.0f;
        ComponentTypes.ComponentType[] visibilityEntities = ComponentTypes.ComponentType.values();
        boolean[] visible = new boolean[visibilityEntities.length];
        for (int i = 0; i < visibilityEntities.length; ++i) {
            visible[i] = GaiaSky.instance.sceneRenderer.visible.get(visibilityEntities[i].ordinal());
        }
        int di = 0;
        int dj = 0;
        for (int i = 0; i < visibilityEntities.length; ++i) {
            ComponentTypes.ComponentType ct = visibilityEntities[i];
            String name = ct.getName();
            if (name == null || ct.style == null) continue;
            Image icon = new Image(this.skin.getDrawable(ct.style));
            OwnTextIconButton button = new OwnTextIconButton("", icon, this.skin, "toggle");
            button.setName(ct.key);
            typesModel[di][dj] = button;
            button.setChecked(visible[i]);
            button.addListener((EventListener)new OwnTextTooltip(ct.getName(), this.skin));
            button.addListener(arg_0 -> GamepadGui.lambda$rebuildGui$22((Button)button, ct, arg_0));
            this.addButtonTooltip((Button)button, ct, name);
            button.setDisabled(ct.key.equals("element.others") && GaiaSky.instance.isVR());
            this.visibilityButtonMap.put(ct.key, (Button)button);
            Array.ArrayIterator c = typesT.add((Actor)button).padBottom(buttonPadVert).left();
            if ((i + 1) % visTableCols == 0) {
                typesT.row();
                di = 0;
                ++dj;
                continue;
            }
            c.padRight(buttonPadHor);
            ++di;
        }
        typesT.setSize(tw1, this.th);
        this.tabContents.add(this.container(typesT, tw1, this.th));
        this.updatePads(typesT);
        Actor[][] controlsModel = new Actor[1][3];
        this.model.add(controlsModel);
        Table controlsT = new Table(this.skin);
        if (this.vr) {
            Texture vrctrl_tex = new Texture(Gdx.files.internal("img/controller/hud-info-ui.png"));
            vrctrl_tex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            Image vrctrl = new Image(vrctrl_tex);
            controlsT.add((Actor)vrctrl).top().pad(this.pad20);
        } else {
            Array controllers = Controllers.getControllers();
            Controller controller = null;
            for (Controller c : controllers) {
                if (Settings.settings.controls.gamepad.isControllerBlacklisted(c.getName())) continue;
                controller = c;
                break;
            }
            if (controller == null) {
                OwnLabel noControllers = new OwnLabel((CharSequence)I18n.msg("gui.controller.nocontrollers"), this.skin, "header-blue");
                controlsT.add((Actor)noControllers).padBottom(this.pad10).row();
                controlsModel[0][0] = new OwnTextButton("", this.skin, "toggle-big");
            } else {
                String controllerName = controller.getName();
                Table controllerTable = new Table(this.skin);
                OwnLabel detectedController = new OwnLabel((CharSequence)I18n.msg("gui.controller.detected"), this.skin, "header-raw");
                OwnLabel controllerNameLabel = new OwnLabel((CharSequence)controllerName, this.skin, "header-blue");
                OwnTextButton configureControllerButton = new OwnTextButton(I18n.msg("gui.controller.configure"), this.skin, "big");
                configureControllerButton.setWidth(ww);
                configureControllerButton.setHeight(wh);
                configureControllerButton.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        GamepadMappings mappings = new GamepadMappings(controllerName, Path.of(Settings.settings.controls.gamepad.mappingsFile, new String[0]));
                        GamepadConfigWindow ccw = new GamepadConfigWindow(controllerName, mappings, this.stage, this.skin);
                        ccw.setAcceptListener(() -> {
                            if (ccw.savedFile != null) {
                                EventManager.publish(gaiasky.event.Event.RELOAD_CONTROLLER_MAPPINGS, this, ccw.savedFile.toAbsolutePath().toString());
                            }
                        });
                        ccw.show(this.stage);
                        return true;
                    }
                    return false;
                });
                controllerTable.add((Actor)detectedController).padBottom(this.pad10).padRight(this.pad20);
                controllerTable.add((Actor)controllerNameLabel).padBottom(this.pad10).row();
                controllerTable.add((Actor)configureControllerButton).center().colspan(2);
                controlsT.add((Actor)controllerTable).padBottom(this.pad20 * 2.0f).row();
                controlsModel[0][0] = configureControllerButton;
            }
            this.invertXButton = new OwnTextButton(I18n.msg("gui.controller.axis.invert", "X"), this.skin, "toggle-big");
            controlsModel[0][1] = this.invertXButton;
            this.invertXButton.setWidth(ww);
            this.invertXButton.setChecked(Settings.settings.controls.gamepad.invertX);
            this.invertXButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(gaiasky.event.Event.INVERT_X_CMD, this, this.invertXButton.isChecked());
                    return true;
                }
                return false;
            });
            controlsT.add((Actor)this.invertXButton).padBottom(this.pad10).row();
            this.invertYButton = new OwnTextButton(I18n.msg("gui.controller.axis.invert", "Y"), this.skin, "toggle-big");
            controlsModel[0][2] = this.invertYButton;
            this.invertYButton.setWidth(ww);
            this.invertYButton.setChecked(Settings.settings.controls.gamepad.invertY);
            this.invertYButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(gaiasky.event.Event.INVERT_Y_CMD, this, this.invertYButton.isChecked());
                    return true;
                }
                return false;
            });
            controlsT.add((Actor)this.invertYButton);
        }
        controlsT.setSize(tw1, this.th);
        this.tabContents.add(this.container(controlsT, tw1, this.th));
        this.updatePads(controlsT);
        Actor[][] graphicsModel = new Actor[2][7];
        this.model.add(graphicsModel);
        Table graphicsT = new Table(this.skin);
        this.starBrightness = new OwnSliderPlus(I18n.msg("gui.star.brightness"), 0.0f, 100.0f, 0.01f, 0.4f, 8.0f, this.skin, "header-raw");
        this.starBrightness.setWidth(ww);
        this.starBrightness.setHeight(sh);
        this.starBrightness.setMappedValue(Settings.settings.scene.star.brightness);
        this.starBrightness.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent && this.hackProgrammaticChangeEvents) {
                EventManager.publish(gaiasky.event.Event.STAR_BRIGHTNESS_CMD, (Object)this.starBrightness, Float.valueOf(this.starBrightness.getMappedValue()));
                return true;
            }
            return false;
        });
        this.magnitudeMultiplier = new OwnSliderPlus(I18n.msg("gui.star.brightness.pow"), 0.9f, 1.1f, 0.01f, false, this.skin, "header-raw");
        this.magnitudeMultiplier.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.brightness.pow.info"), this.skin));
        this.magnitudeMultiplier.setWidth(ww);
        this.magnitudeMultiplier.setHeight(sh);
        this.magnitudeMultiplier.setValue(Settings.settings.scene.star.power);
        this.magnitudeMultiplier.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.STAR_BRIGHTNESS_POW_CMD, (Object)this.magnitudeMultiplier, Float.valueOf(this.magnitudeMultiplier.getValue()));
                return true;
            }
            return false;
        });
        this.starGlowFactor = new OwnSliderPlus(I18n.msg("gui.star.glowfactor"), 0.01f, 0.5f, 0.001f, false, this.skin, "header-raw");
        this.starGlowFactor.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.glowfactor.info"), this.skin));
        this.starGlowFactor.setWidth(ww);
        this.starGlowFactor.setHeight(sh);
        this.starGlowFactor.setMappedValue(Settings.settings.scene.star.glowFactor);
        this.starGlowFactor.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent && this.hackProgrammaticChangeEvents) {
                EventManager.publish(gaiasky.event.Event.STAR_GLOW_FACTOR_CMD, (Object)this.starGlowFactor, Float.valueOf(this.starGlowFactor.getValue()));
                return true;
            }
            return false;
        });
        this.pointSize = new OwnSliderPlus(I18n.msg("gui.star.size"), 0.1f, 20.0f, 0.01f, false, this.skin, "header-raw");
        this.pointSize.setWidth(ww);
        this.pointSize.setHeight(sh);
        this.pointSize.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.size.info"), this.skin));
        this.pointSize.setMappedValue(Settings.settings.scene.star.pointSize);
        this.pointSize.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent && this.hackProgrammaticChangeEvents) {
                EventManager.publish(gaiasky.event.Event.STAR_POINT_SIZE_CMD, (Object)this.pointSize, Float.valueOf(this.pointSize.getMappedValue()));
                return true;
            }
            return false;
        });
        this.starBaseLevel = new OwnSliderPlus(I18n.msg("gui.star.opacity"), 0.0f, 0.95f, 0.01f, false, this.skin, "header-raw");
        this.starBaseLevel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.star.opacity"), this.skin));
        this.starBaseLevel.setWidth(ww);
        this.starBaseLevel.setHeight(sh);
        this.starBaseLevel.setMappedValue(Settings.settings.scene.star.opacity[0]);
        this.starBaseLevel.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent && this.hackProgrammaticChangeEvents) {
                EventManager.publish(gaiasky.event.Event.STAR_BASE_LEVEL_CMD, (Object)this.starBaseLevel, Float.valueOf(this.starBaseLevel.getMappedValue()));
                return true;
            }
            return false;
        });
        this.bloomSlider = new OwnSliderPlus(I18n.msg("gui.bloom"), 0.0f, 2.0f, 0.01f, false, this.skin, "header-raw");
        this.bloomSlider.setWidth(ww);
        this.bloomSlider.setHeight(sh);
        this.bloomSlider.setValue(Settings.settings.postprocess.bloom.intensity);
        this.bloomSlider.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.BLOOM_CMD, (Object)this.bloomSlider, Float.valueOf(this.bloomSlider.getValue()));
                return true;
            }
            return false;
        });
        this.unsharpMaskSlider = new OwnSliderPlus(I18n.msg("gui.unsharpmask"), 0.0f, 3.0f, 0.01f, false, this.skin, "header-raw");
        this.unsharpMaskSlider.setWidth(ww);
        this.unsharpMaskSlider.setHeight(sh);
        this.unsharpMaskSlider.setValue(Settings.settings.postprocess.unsharpMask.factor);
        this.unsharpMaskSlider.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.UNSHARP_MASK_CMD, (Object)this.unsharpMaskSlider, Float.valueOf(this.unsharpMaskSlider.getValue()));
                return true;
            }
            return false;
        });
        if (!this.vr) {
            this.lensFlare = new OwnSliderPlus(I18n.msg("gui.lensflare"), 0.0f, 1.5f, 0.01f, false, this.skin, "header-raw");
            this.lensFlare.setWidth(ww);
            this.lensFlare.setHeight(sh);
            this.lensFlare.setValue(Settings.settings.postprocess.lensFlare.strength);
            this.lensFlare.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(gaiasky.event.Event.LENS_FLARE_CMD, (Object)this.lensFlare, Float.valueOf(this.lensFlare.getValue()));
                    return true;
                }
                return false;
            });
            this.starGlowButton = new OwnTextButton(I18n.msg("gui.lightscattering"), this.skin, "toggle-big");
            this.starGlowButton.setWidth(ww);
            this.starGlowButton.setChecked(Settings.settings.postprocess.lightGlow.active);
            this.starGlowButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(gaiasky.event.Event.LIGHT_GLOW_CMD, (Object)this.starGlowButton, this.starGlowButton.isChecked());
                    return true;
                }
                return false;
            });
            this.motionBlur = new OwnSliderPlus(I18n.msg("gui.motionblur"), 0.0f, 2.0f, 0.01f, false, this.skin, "header-raw");
            this.motionBlur.setWidth(ww);
            this.motionBlur.setHeight(sh);
            this.motionBlur.setMappedValue(Settings.settings.postprocess.motionBlur.strength);
            this.motionBlur.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(gaiasky.event.Event.MOTION_BLUR_CMD, (Object)this.motionBlur, Float.valueOf(this.motionBlur.getMappedValue()));
                    return true;
                }
                return false;
            });
        }
        OwnTextIconButton resetDefaults = new OwnTextIconButton(I18n.msg("gui.resetdefaults"), this.skin, "reset");
        resetDefaults.align(1);
        resetDefaults.setWidth(ww);
        resetDefaults.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.resetdefaults.tooltip"), this.skin));
        resetDefaults.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.RESET_VISUAL_SETTINGS_DEFAULTS, (Object)resetDefaults, new Object[0]);
                return true;
            }
            return false;
        });
        if (!this.vr) {
            graphicsModel[0][0] = this.starBrightness;
            graphicsModel[0][1] = this.magnitudeMultiplier;
            graphicsModel[0][2] = this.starGlowFactor;
            graphicsModel[0][3] = this.pointSize;
            graphicsModel[0][4] = this.starBaseLevel;
            graphicsModel[0][5] = this.bloomSlider;
            graphicsModel[0][6] = this.unsharpMaskSlider;
            graphicsModel[1][0] = this.lensFlare;
            graphicsModel[1][1] = this.starGlowButton;
            graphicsModel[1][2] = this.motionBlur;
            graphicsModel[1][4] = resetDefaults;
            graphicsT.add((Actor)this.starBrightness).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add((Actor)this.lensFlare).padBottom(this.pad10).row();
            graphicsT.add((Actor)this.magnitudeMultiplier).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add((Actor)this.starGlowButton).padBottom(this.pad10).row();
            graphicsT.add((Actor)this.starGlowFactor).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add((Actor)this.motionBlur).padBottom(this.pad10).row();
            graphicsT.add((Actor)this.pointSize).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add().padBottom(this.pad10).row();
            graphicsT.add((Actor)this.starBaseLevel).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add((Actor)resetDefaults).padBottom(this.pad10).row();
            graphicsT.add((Actor)this.bloomSlider).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add().row();
            graphicsT.add((Actor)this.unsharpMaskSlider).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add().row();
        } else {
            graphicsModel[0][0] = this.starBrightness;
            graphicsModel[0][1] = this.starGlowFactor;
            graphicsModel[0][2] = this.starBaseLevel;
            graphicsModel[0][3] = this.bloomSlider;
            graphicsModel[1][0] = this.magnitudeMultiplier;
            graphicsModel[1][1] = this.pointSize;
            graphicsModel[1][2] = this.unsharpMaskSlider;
            graphicsModel[1][4] = resetDefaults;
            graphicsT.add((Actor)this.starBrightness).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add((Actor)this.magnitudeMultiplier).padBottom(this.pad10).row();
            graphicsT.add((Actor)this.starGlowFactor).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add((Actor)this.pointSize).padBottom(this.pad10).row();
            graphicsT.add((Actor)this.starBaseLevel).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add((Actor)this.unsharpMaskSlider).padBottom(this.pad10).row();
            graphicsT.add((Actor)this.bloomSlider).padBottom(this.pad10).padRight(this.pad40);
            graphicsT.add((Actor)resetDefaults).padBottom(this.pad10).row();
        }
        this.tabContents.add(this.container(graphicsT, tw1, this.th));
        this.updatePads(graphicsT);
        Actor[][] systemModel = new Actor[1][2];
        this.model.add(systemModel);
        Table sysT = new Table(this.skin);
        Label debugLabel = new Label((CharSequence)I18n.msg("gui.system.debuginfo"), this.skin, "header-raw");
        this.debugInfo = new OwnCheckBox("", this.skin, 0.0f);
        systemModel[0][0] = this.debugInfo;
        this.debugInfo.setChecked(Settings.settings.program.debugInfo);
        this.debugInfo.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(gaiasky.event.Event.SHOW_DEBUG_CMD, (Object)this.debugInfo, this.debugInfo.isChecked());
                return true;
            }
            return false;
        });
        sysT.add((Actor)debugLabel).right().padBottom(this.pad40).padRight(this.pad20);
        sysT.add((Actor)this.debugInfo).left().padBottom(this.pad40).row();
        OwnTextIconButton quit = new OwnTextIconButton(I18n.msg("gui.quit.title"), 1, this.skin, "quit");
        systemModel[0][1] = quit;
        quit.setWidth(ww);
        quit.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                GaiaSky.postRunnable(() -> Gdx.app.exit());
                return true;
            }
            return false;
        });
        sysT.add((Actor)quit).colspan(2);
        this.tabContents.add(this.container(sysT, tw1, this.th));
        this.updatePads(sysT);
        if (this.vr) {
            this.vrInfoButton = new OwnTextButton(I18n.msg("gui.info"), this.skin, "toggle-big");
            this.tabButtons.add(this.vrInfoButton);
            this.vrInfoButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    selectedTab = this.tabButtons.indexOf((Object)this.vrInfoButton);
                    this.updateTabs();
                }
                return false;
            });
        }
        this.searchButton = new OwnTextButton(I18n.msg("gui.search"), this.skin, "toggle-big");
        this.tabButtons.add(this.searchButton);
        this.searchButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                selectedTab = this.tabButtons.indexOf((Object)this.searchButton);
                this.updateTabs();
            }
            return false;
        });
        this.bookmarksButton = new OwnTextButton(I18n.msg("gui.bookmarks"), this.skin, "toggle-big");
        this.tabButtons.add(this.bookmarksButton);
        this.bookmarksButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                selectedTab = this.tabButtons.indexOf((Object)this.bookmarksButton);
                this.updateTabs();
            }
            return false;
        });
        this.cameraButton = new OwnTextButton(I18n.msg("gui.camera"), this.skin, "toggle-big");
        this.tabButtons.add(this.cameraButton);
        this.cameraButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                selectedTab = this.tabButtons.indexOf((Object)this.cameraButton);
                this.updateTabs();
            }
            return false;
        });
        this.timeButton = new OwnTextButton(I18n.msg("gui.time"), this.skin, "toggle-big");
        this.tabButtons.add(this.timeButton);
        this.timeButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                selectedTab = this.tabButtons.indexOf((Object)this.timeButton);
                this.updateTabs();
            }
            return false;
        });
        this.typesButton = new OwnTextButton(I18n.msg("gui.types"), this.skin, "toggle-big");
        this.tabButtons.add(this.typesButton);
        this.typesButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                selectedTab = this.tabButtons.indexOf((Object)this.typesButton);
                this.updateTabs();
            }
            return false;
        });
        this.controlsButton = new OwnTextButton(I18n.msg("gui.controls"), this.skin, "toggle-big");
        this.tabButtons.add(this.controlsButton);
        this.controlsButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                selectedTab = this.tabButtons.indexOf((Object)this.controlsButton);
                this.updateTabs();
            }
            return false;
        });
        this.graphicsButton = new OwnTextButton(I18n.msg("gui.graphics"), this.skin, "toggle-big");
        this.tabButtons.add(this.graphicsButton);
        this.graphicsButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                selectedTab = this.tabButtons.indexOf((Object)this.graphicsButton);
                this.updateTabs();
            }
            return false;
        });
        this.systemButton = new OwnTextButton(I18n.msg("gui.system"), this.skin, "toggle-big");
        this.tabButtons.add(this.systemButton);
        this.systemButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                selectedTab = this.tabButtons.indexOf((Object)this.systemButton);
                this.updateTabs();
            }
            return false;
        });
        for (OwnTextButton b : this.tabButtons) {
            b.pad(this.pad10);
            b.setMinWidth(tw);
        }
        OwnTextIconButton rb = new OwnTextIconButton("RB", 8, this.skin, "caret-down");
        rb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.tabRight();
            }
            return false;
        });
        rb.pad(this.pad10);
        OwnTextIconButton lb = new OwnTextIconButton("LB", 8, this.skin, "caret-up");
        lb.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.tabLeft();
            }
            return false;
        });
        lb.pad(this.pad10);
        this.menu.add((Actor)lb).center().padBottom(this.pad30).row();
        if (this.vr) {
            this.menu.add((Actor)this.vrInfoButton).left().row();
        }
        this.menu.add((Actor)this.searchButton).left().row();
        this.menu.add((Actor)this.bookmarksButton).left().row();
        this.menu.add((Actor)this.cameraButton).left().row();
        this.menu.add((Actor)this.timeButton).left().row();
        this.menu.add((Actor)this.typesButton).left().row();
        this.menu.add((Actor)this.controlsButton).left().row();
        this.menu.add((Actor)this.graphicsButton).left().row();
        this.menu.add((Actor)this.systemButton).left().padBottom(this.pad30).row();
        this.menu.add((Actor)rb).center();
        Table padTable = new Table(this.skin);
        padTable.pad(this.pad30);
        padTable.setBackground("bg-pane-border");
        if (this.vr) {
            Cell topCell = padTable.add((Actor)this.topLine).center().colspan(2);
            topCell.row();
        }
        this.menu.pack();
        padTable.add((Actor)this.menu).left();
        this.contentCell = padTable.add().expandX().left();
        this.contentCell.row();
        if (this.vr) {
            padTable.add((Actor)this.buttonGoHome).right().colspan(2);
        }
        this.content.add((Actor)padTable);
        this.content.setFillParent(true);
        this.content.center();
        this.content.pack();
        this.updateTabs();
        this.updateFocused(true);
        if (this.scene == null) {
            this.scene = GaiaSky.instance.scene;
        }
        this.initialized = true;
    }

    private void fillBookmarksColumn(Cell<Container>[] columns, int columnIndex, List<BookmarksManager.BookmarkNode> bookmarks, Actor[][] model, float w, float h) {
        this.fillBookmarksColumn(columns, columnIndex, bookmarks, model, w, h, true);
    }

    private void fillBookmarksColumn(Cell<Container>[] columns, int columnIndex, List<BookmarksManager.BookmarkNode> bookmarks, Actor[][] model, float w, float h, boolean select) {
        assert (columns != null) : "Column list can't be null";
        assert (columnIndex < columns.length && columnIndex >= 0) : "Column index out of bounds";
        Cell<Container> column = columns[columnIndex];
        column.clearActor();
        column.left().top().padRight(this.pad5);
        column.width(w + 20.0f);
        Table group = new Table(this.skin);
        group.top();
        int row = 0;
        model[columnIndex] = new Actor[bookmarks.size()];
        for (BookmarksManager.BookmarkNode node : bookmarks) {
            BookmarkButton button = new BookmarkButton(node, this.skin);
            button.setSize(w, h);
            if (node.isTypeFolder()) {
                int rowIndex = row;
                button.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        this.selectInRow(columnIndex, rowIndex, true);
                        this.updateFocused();
                    }
                    return false;
                });
            }
            group.add((Actor)button).left().row();
            model[columnIndex][row++] = button;
        }
        OwnScrollPane scroll = new OwnScrollPane((Actor)group, this.skin, "minimalist-nobg");
        scroll.setFadeScrollBars(false);
        scroll.setScrollbarsVisible(true);
        scroll.setScrollingDisabled(true, false);
        scroll.setWidth(w + 20.0f);
        scroll.setHeight(this.th - 30.0f);
        column.setActor((Actor)scroll);
        column.top();
        if (select) {
            this.selectInCol(columnIndex, 0, true);
            this.updateFocused();
        }
    }

    private void updateFocusedBookmark() {
        Actor actor;
        if ((this.vr && selectedTab == 2 || !this.vr && selectedTab == 1) && this.fi < 3 && (actor = this.currentModel[this.fi][this.fj]) instanceof BookmarkButton) {
            BookmarkButton selectedBookmark = (BookmarkButton)actor;
            ScrollPane scroll = GuiUtils.getScrollPaneAncestor((Actor)selectedBookmark);
            if (scroll != null) {
                Vector2 coordinates = selectedBookmark.localToAscendantCoordinates(scroll.getActor(), new Vector2(selectedBookmark.getX(), selectedBookmark.getY()));
                scroll.scrollTo(coordinates.x, coordinates.y, selectedBookmark.getWidth(), selectedBookmark.getHeight() + 250.0f);
            }
            if (selectedBookmark.bookmark.isTypeFolder()) {
                this.fillBookmarksColumn(this.bookmarkColumns, this.fi + 1, selectedBookmark.bookmark.children, this.currentModel, this.bw, this.bh, false);
            } else {
                for (int i = this.fi + 1; i < 4; ++i) {
                    this.bookmarkColumns[i].clearActor();
                    this.currentModel[i] = null;
                }
            }
        }
    }

    private void addDeviceTypeInfo(Table table, String name, String text) {
        table.add((Actor)new OwnLabel((CharSequence)name, this.skin, "header")).top().left().padRight(this.pad40).padBottom(this.pad10);
        table.add((Actor)new OwnLabel((CharSequence)text, this.skin, "big")).top().left().padBottom(this.pad10).row();
    }

    private void addTextKey(String text, Actor[][] m, int i, int j, boolean nl) {
        this.addTextKey(text, event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                this.searchField.setText(this.searchField.getText() + text.toLowerCase(Locale.ROOT));
            }
            return false;
        }, m, i, j, nl, -1.0f, 1);
    }

    private void addTextKey(String text, EventListener el, Actor[][] m, int i, int j, boolean nl, float width, int colspan) {
        OwnTextButton key = new OwnTextButton(text, this.skin, "big");
        if (width > 0.0f) {
            key.setWidth(width);
        } else {
            key.setMinWidth(70.0f);
        }
        key.addListener(el);
        m[i][j] = key;
        Cell c = this.searchT.add((Actor)key).left().padRight(this.pad5).padBottom(this.pad10);
        if (nl) {
            c.row();
        }
        if (colspan > 1) {
            c.colspan(colspan);
        }
    }

    public boolean checkString(String text, Scene scene) {
        try {
            if (scene.index().containsEntity(text)) {
                Entity node = scene.index().getEntity(text);
                if (Mapper.focus.has(node)) {
                    this.view.setEntity(node);
                    this.view.getFocus(text);
                    this.filterView.setEntity(node);
                    boolean timeOverflow = this.view.isCoordinatesTimeOverflow();
                    boolean canSelect = !this.view.isSet() || this.view.getSet().canSelect(this.filterView);
                    boolean ctOn = GaiaSky.instance.isOn(this.view.getCt());
                    if (!timeOverflow && canSelect && ctOn) {
                        GaiaSky.postRunnable(() -> {
                            EventManager.publish(gaiasky.event.Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE, true});
                            EventManager.publish(gaiasky.event.Event.FOCUS_CHANGE_CMD, this, node, true);
                        });
                        this.info(null);
                    } else if (timeOverflow) {
                        this.info(I18n.msg("gui.objects.search.timerange", text));
                    } else if (!canSelect) {
                        this.info(I18n.msg("gui.objects.search.filter", text));
                    } else {
                        this.info(I18n.msg("gui.objects.search.invisible", text, this.view.getCt().toString()));
                    }
                    return true;
                }
            } else {
                this.info(null);
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return false;
    }

    private void info(String info) {
        if (info == null) {
            this.infoMessage.setText("");
            this.info(false);
        } else {
            this.infoMessage.setText(info);
            this.info(true);
        }
    }

    private void info(boolean visible) {
        if (visible) {
            this.infoCell.setActor((Actor)this.infoMessage);
        } else {
            this.infoCell.setActor(null);
        }
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
        this.stage.setKeyboardFocus(null);
    }

    @Override
    public void update(double dt) {
        super.update(dt);
        if (this.gamepadListener.isActive()) {
            this.gamepadListener.update();
        }
    }

    private ScrollPane container(Table t, float w, float h) {
        OwnScrollPane c = new OwnScrollPane((Actor)t, this.skin, "minimalist-nobg");
        t.center();
        c.setFadeScrollBars(true);
        c.setupFadeScrollBars(1.0f, 3.0f);
        c.setForceScroll(false, false);
        if (w > 0.0f && h > 0.0f) {
            c.setSize(w, h);
        }
        return c;
    }

    private void updatePads(Table t) {
        Array cells = t.getCells();
        for (Cell c : cells) {
            if (!(c.getActor() instanceof Button) || c.getActor() instanceof CheckBox) continue;
            ((Button)c.getActor()).pad(this.pad20);
        }
    }

    public void updateTabs() {
        for (OwnTextButton tb : this.tabButtons) {
            tb.setProgrammaticChangeEvents(false);
            tb.setChecked(false);
            tb.setProgrammaticChangeEvents(true);
        }
        this.tabButtons.get(selectedTab).setProgrammaticChangeEvents(false);
        this.tabButtons.get(selectedTab).setChecked(true);
        this.tabButtons.get(selectedTab).setProgrammaticChangeEvents(true);
        this.contentCell.setActor(null);
        this.currentModel = this.model.get(selectedTab);
        this.contentCell.setActor((Actor)this.tabContents.get(selectedTab));
        this.selectFirst();
        this.updateFocused();
    }

    public boolean selectInRow(int i, int j, boolean right) {
        int bi = this.fi;
        this.fi = i;
        this.fj = j;
        if (this.currentModel == null) {
            return false;
        }
        if (this.currentModel.length > 0 && this.currentModel[this.fi] != null) {
            if (this.fj >= this.currentModel[this.fi].length) {
                this.fj = this.currentModel[this.fi].length - 1;
            }
            while (this.currentModel[this.fi][this.fj] == null) {
                this.fi = (this.fi + (right ? 1 : -1)) % this.currentModel.length;
                if (this.fi < 0) {
                    this.fi = this.currentModel.length - 1;
                }
                if (this.fi == i || this.currentModel[this.fi] == null) {
                    return false;
                }
                if (this.fj < this.currentModel[this.fi].length) continue;
                this.fj = this.currentModel[this.fi].length - 1;
            }
            return true;
        }
        if (this.currentModel[this.fi] == null) {
            this.fi = bi;
        }
        return false;
    }

    public boolean selectInCol(int i, int j, boolean down) {
        this.fi = i;
        this.fj = j;
        if (this.currentModel != null && this.currentModel.length > 0) {
            while (this.currentModel[this.fi][this.fj] == null) {
                if (this.selectInRow(this.fi, this.fj, true)) {
                    return true;
                }
                this.fj = (this.fj + (down ? 1 : -1)) % this.currentModel[this.fi].length;
                if (this.fj != j) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void selectFirst() {
        this.selectInRow(0, 0, true);
    }

    public void updateFocused() {
        this.updateFocused(false);
    }

    public void updateFocused(boolean force) {
        if ((force || this.content.getParent() != null) && this.currentModel != null && this.currentModel.length != 0) {
            Actor actor = this.currentModel[this.fi][this.fj];
            if (!this.vr && GuiUtils.isInputWidget(actor)) {
                this.stage.setKeyboardFocus(actor);
            }
            this.updateFocusedBookmark();
        }
    }

    public void tabLeft() {
        selectedTab = selectedTab - 1 < 0 ? this.tabButtons.size() - 1 : --selectedTab;
        this.updateTabs();
    }

    public void tabRight() {
        selectedTab = (selectedTab + 1) % this.tabButtons.size();
        this.updateTabs();
    }

    public void up() {
        if (this.currentModel != null && this.currentModel[this.fi] != null && this.selectInCol(this.fi, this.update(this.fj, -1, this.currentModel[this.fi].length), false)) {
            this.updateFocused();
        }
    }

    public void down() {
        if (this.currentModel != null && this.currentModel[this.fi] != null && this.selectInCol(this.fi, this.update(this.fj, 1, this.currentModel[this.fi].length), true)) {
            this.updateFocused();
        }
    }

    public void left() {
        if (this.currentModel != null && this.selectInRow(this.update(this.fi, -1, this.currentModel.length), this.fj, false)) {
            this.updateFocused();
        }
    }

    public void right() {
        if (this.currentModel != null && this.selectInRow(this.update(this.fi, 1, this.currentModel.length), this.fj, true)) {
            this.updateFocused();
        }
    }

    private Actor getFocusedActor() {
        return this.currentModel != null ? this.currentModel[this.fi][this.fj] : null;
    }

    private int update(int val, int inc, int len) {
        if (len <= 0) {
            return val;
        }
        if (inc >= 0) {
            return (val + inc) % len;
        }
        if (val + inc < 0) {
            return inc + len;
        }
        return val + inc;
    }

    public void back() {
        EventManager.publish(gaiasky.event.Event.SHOW_CONTROLLER_GUI_ACTION, this, new Object[0]);
    }

    public Table getContent() {
        return this.content;
    }

    @Override
    public void notify(gaiasky.event.Event event, Object source, Object ... data) {
        if (this.initialized) {
            switch (event) {
                case SCENE_LOADED: {
                    this.scene = (Scene)data[0];
                    break;
                }
                case SHOW_CONTROLLER_GUI_ACTION: {
                    if (this.content.isVisible() && this.content.hasParent()) {
                        this.removeGamepadGui();
                        break;
                    }
                    this.addGamepadGui();
                    break;
                }
                case TOGGLE_VISIBILITY_CMD: {
                    String key;
                    Button b;
                    if (this.visibilityButtonMap == null || (b = this.visibilityButtonMap.get(key = (String)data[0])) == null || source == b) break;
                    b.setProgrammaticChangeEvents(false);
                    if (data.length == 2) {
                        b.setChecked(((Boolean)data[1]).booleanValue());
                    } else {
                        b.setChecked(!b.isChecked());
                    }
                    b.setProgrammaticChangeEvents(true);
                    break;
                }
                case TIME_STATE_CMD: {
                    if (this.timeStartStop == null) break;
                    boolean on = (Boolean)data[0];
                    this.timeStartStop.setProgrammaticChangeEvents(false);
                    this.timeStartStop.setChecked(on);
                    this.timeStartStop.setText(on ? "Stop time" : "Start time");
                    this.timeStartStop.setProgrammaticChangeEvents(true);
                    break;
                }
                case CAMERA_MODE_CMD: {
                    if (this.cameraMode != null && source != this.cameraMode && !this.vr) {
                        CameraManager.CameraMode mode = (CameraManager.CameraMode)((Object)data[0]);
                        Array cModes = this.cameraMode.getItems();
                        CameraComboBoxBean selected = null;
                        for (CameraComboBoxBean cameraModeBean : cModes) {
                            if (cameraModeBean.mode != mode) continue;
                            selected = cameraModeBean;
                            break;
                        }
                        if (selected == null) break;
                        this.cameraMode.getSelection().setProgrammaticChangeEvents(false);
                        this.cameraMode.setSelected(selected);
                        this.cameraMode.getSelection().setProgrammaticChangeEvents(true);
                        break;
                    }
                    if (this.cameraModeLabel == null) break;
                    CameraManager.CameraMode mode = (CameraManager.CameraMode)((Object)data[0]);
                    this.cameraModeLabel.setText(mode.toStringI18n());
                    if (mode == CameraManager.CameraMode.FOCUS_MODE || this.cameraFocusLabel == null) break;
                    this.cameraFocusLabel.setText("-");
                    break;
                }
                case FOCUS_CHANGE_CMD: {
                    String focusName;
                    if (this.cameraFocusLabel == null) break;
                    if (data[0] instanceof String) {
                        focusName = (String)data[0];
                    } else {
                        Object selected = data[0];
                        if (selected instanceof FocusView) {
                            FocusView focusView = (FocusView)selected;
                            this.view.setEntity(focusView.getEntity());
                            focusName = this.view.getLocalizedName();
                        } else {
                            Entity entity = (Entity)data[0];
                            this.view.setEntity(entity);
                            focusName = this.view.getLocalizedName();
                        }
                    }
                    this.cameraFocusLabel.setText(focusName);
                    break;
                }
                case STAR_POINT_SIZE_CMD: {
                    if (source == this.pointSize || this.pointSize == null) break;
                    this.hackProgrammaticChangeEvents = false;
                    float newSize = ((Float)data[0]).floatValue();
                    this.pointSize.setMappedValue(newSize);
                    this.hackProgrammaticChangeEvents = true;
                    break;
                }
                case STAR_BRIGHTNESS_CMD: {
                    if (source == this.starBrightness || this.starBrightness == null) break;
                    Float brightness = (Float)data[0];
                    this.hackProgrammaticChangeEvents = false;
                    this.starBrightness.setMappedValue(brightness.floatValue());
                    this.hackProgrammaticChangeEvents = true;
                    break;
                }
                case STAR_BRIGHTNESS_POW_CMD: {
                    if (source == this.magnitudeMultiplier || this.magnitudeMultiplier == null) break;
                    Float pow = (Float)data[0];
                    this.hackProgrammaticChangeEvents = false;
                    this.magnitudeMultiplier.setMappedValue(pow.floatValue());
                    this.hackProgrammaticChangeEvents = true;
                    break;
                }
                case STAR_GLOW_FACTOR_CMD: {
                    if (source == this.starGlowFactor || this.starGlowFactor == null) break;
                    Float glowFactor = (Float)data[0];
                    this.hackProgrammaticChangeEvents = false;
                    this.starGlowFactor.setMappedValue(glowFactor.floatValue());
                    this.hackProgrammaticChangeEvents = true;
                    break;
                }
                case STAR_BASE_LEVEL_CMD: {
                    if (source == this.starBaseLevel || this.starBaseLevel == null) break;
                    Float baseLevel = (Float)data[0];
                    this.hackProgrammaticChangeEvents = false;
                    this.starBaseLevel.setMappedValue(baseLevel.floatValue());
                    this.hackProgrammaticChangeEvents = true;
                    break;
                }
                case STEREOSCOPIC_CMD: {
                    if (this.button3d == null || source == this.button3d || this.vr) break;
                    this.button3d.setProgrammaticChangeEvents(false);
                    this.button3d.setChecked((Boolean)data[0]);
                    this.button3d.setProgrammaticChangeEvents(true);
                    break;
                }
                case CUBEMAP_CMD: {
                    if (this.vr) break;
                    CubmeapProjectionEffect.CubemapProjection proj = (CubmeapProjectionEffect.CubemapProjection)((Object)data[1]);
                    boolean enable = (Boolean)data[0];
                    if (proj.isPanorama() && source != this.buttonCubemap && this.buttonCubemap != null) {
                        this.buttonCubemap.setProgrammaticChangeEvents(false);
                        this.buttonCubemap.setChecked(enable);
                        this.buttonCubemap.setProgrammaticChangeEvents(true);
                        this.fovSlider.setDisabled(enable);
                        break;
                    }
                    if (proj.isPlanetarium() && source != this.buttonDome && this.buttonDome != null) {
                        this.buttonDome.setProgrammaticChangeEvents(false);
                        this.buttonDome.setChecked(enable);
                        this.buttonDome.setProgrammaticChangeEvents(true);
                        this.fovSlider.setDisabled(enable);
                        break;
                    }
                    if (!proj.isOrthosphere() || source == this.buttonOrthoSphere || this.buttonOrthoSphere == null) break;
                    this.buttonOrthoSphere.setProgrammaticChangeEvents(false);
                    this.buttonOrthoSphere.setChecked(enable);
                    this.buttonOrthoSphere.setProgrammaticChangeEvents(true);
                    this.fovSlider.setDisabled(enable);
                    break;
                }
                case CROSSHAIR_CLOSEST_CMD: {
                    if (source == this || this.crosshairClosest == null) break;
                    this.crosshairClosest.setProgrammaticChangeEvents(false);
                    this.crosshairClosest.setChecked((Boolean)data[0]);
                    this.crosshairClosest.setProgrammaticChangeEvents(true);
                    break;
                }
                case CROSSHAIR_FOCUS_CMD: {
                    if (source == this || this.crosshairFocus == null) break;
                    this.crosshairFocus.setProgrammaticChangeEvents(false);
                    this.crosshairFocus.setChecked((Boolean)data[0]);
                    this.crosshairFocus.setProgrammaticChangeEvents(true);
                    break;
                }
                case CROSSHAIR_HOME_CMD: {
                    if (source == this || this.crosshairHome == null) break;
                    this.crosshairHome.setProgrammaticChangeEvents(false);
                    this.crosshairHome.setChecked((Boolean)data[0]);
                    this.crosshairHome.setProgrammaticChangeEvents(true);
                    break;
                }
                case INVERT_X_CMD: {
                    if (source == this || this.invertXButton == null) break;
                    this.invertXButton.setProgrammaticChangeEvents(false);
                    this.invertXButton.setChecked((Boolean)data[0]);
                    this.invertXButton.setProgrammaticChangeEvents(true);
                    break;
                }
                case INVERT_Y_CMD: {
                    if (source == this || this.invertYButton == null) break;
                    this.invertYButton.setProgrammaticChangeEvents(false);
                    this.invertYButton.setChecked((Boolean)data[0]);
                    this.invertYButton.setProgrammaticChangeEvents(true);
                    break;
                }
            }
        }
    }

    private void addButtonTooltip(Button button, ComponentTypes.ComponentType ct, String name) {
        String[] hk = KeyBindings.instance.getStringKeys("action.toggle/" + ct.key, true);
        Object text = TextUtils.capitalise(name);
        if (ct.equals((Object)ComponentTypes.ComponentType.Constellations)) {
            text = (String)text + " - " + I18n.msg("gui.tooltip.ct.constellations.hip");
        }
        if (hk != null && hk.length > 0) {
            button.addListener((EventListener)new OwnTextHotkeyTooltip((String)text, hk, this.skin, 9));
        } else {
            button.addListener((EventListener)new OwnTextTooltip((String)text, this.skin));
        }
    }

    public boolean removeGamepadGui() {
        if (this.content.isVisible() && this.content.hasParent()) {
            this.searchField.setText("");
            this.content.addAction((Action)Actions.sequence((Action)Actions.alpha((float)1.0f), (Action)Actions.fadeOut((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.visible((boolean)false), (Action)Actions.run(() -> {
                this.content.remove();
                this.content.clear();
                this.stage.setKeyboardFocus(null);
                this.removeGamepadListener();
            })));
            return true;
        }
        return false;
    }

    public void addGamepadGui() {
        if (!this.content.isVisible() || !this.content.hasParent()) {
            this.rebuildGui();
            this.programmaticUpdate();
            this.stage.addActor((Actor)this.content);
            this.content.addAction((Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.visible((boolean)true), (Action)Actions.fadeIn((float)Settings.settings.program.ui.getAnimationSeconds()), (Action)Actions.run(() -> {
                this.updateFocused();
                this.addGamepadListener();
            })));
            EventManager.publish(gaiasky.event.Event.CLOSE_ALL_GUI_WINDOWS_CMD, this, new Object[0]);
        }
    }

    public void programmaticUpdate() {
        if (this.topLine != null) {
            this.topLine.programmaticUpdate();
        }
        if (this.focusInterface != null) {
            this.focusInterface.programmaticUpdate();
        }
    }

    private void addGamepadListener() {
        if (this.gamepadListener != null) {
            Settings.ControlsSettings.GamepadSettings gamepadSettings = Settings.settings.controls.gamepad;
            this.backupGamepadListeners = gamepadSettings.getControllerListeners();
            gamepadSettings.removeAllControllerListeners();
            gamepadSettings.addControllerListener(this.gamepadListener);
        }
    }

    private void removeGamepadListener() {
        if (this.gamepadListener != null) {
            Settings.ControlsSettings.GamepadSettings gamepadSettings = Settings.settings.controls.gamepad;
            gamepadSettings.removeControllerListener(this.gamepadListener);
            gamepadSettings.setControllerListeners(this.backupGamepadListeners);
            this.backupGamepadListeners = null;
        }
    }

    @Override
    public void resizeImmediate(int width, int height) {
        this.stage.getViewport().update(width, height, true);
        if (this.content.isVisible() && this.content.hasParent()) {
            this.rebuildGui();
        }
    }

    private static /* synthetic */ boolean lambda$rebuildGui$22(Button button, ComponentTypes.ComponentType ct, Event event) {
        if (event instanceof ChangeListener.ChangeEvent) {
            EventManager.publish(gaiasky.event.Event.TOGGLE_VISIBILITY_CMD, button, ct.key, button.isChecked());
            return true;
        }
        return false;
    }

    private static class GamepadGuiListener
    extends GuiGamepadListener {
        private final GamepadGui gui;

        public GamepadGuiListener(GamepadGui gui, String mappingsFile) {
            super(mappingsFile, gui.stage);
            this.gui = gui;
        }

        @Override
        public boolean buttonUp(Controller controller, int buttonCode) {
            super.buttonUp(controller, buttonCode);
            if (buttonCode == this.mappings.getButtonA()) {
                this.actionUp();
                return true;
            }
            return false;
        }

        @Override
        public void actionDown() {
            Actor target = this.stage.getKeyboardFocus();
            if (target != null) {
                if (target instanceof CheckBox) {
                    CheckBox cb = (CheckBox)target;
                    if (!cb.isDisabled()) {
                        cb.setChecked(!cb.isChecked());
                    }
                } else if (target instanceof Button) {
                    Button b = (Button)target;
                    InputEvent inputEvent = (InputEvent)Pools.obtain(InputEvent::new);
                    inputEvent.setTarget((Actor)b);
                    inputEvent.setType(InputEvent.Type.touchDown);
                    b.fire((Event)inputEvent);
                    Pools.free((Object)inputEvent);
                } else {
                    ChangeListener.ChangeEvent event = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent::new);
                    event.setTarget(target);
                    target.fire((Event)event);
                    Pools.free((Object)event);
                }
            }
        }

        public void actionUp() {
            Actor target = this.stage.getKeyboardFocus();
            if (target != null && target instanceof Button) {
                Button b = (Button)target;
                InputEvent inputEvent = (InputEvent)Pools.obtain(InputEvent::new);
                inputEvent.setTarget((Actor)b);
                inputEvent.setType(InputEvent.Type.touchUp);
                b.fire((Event)inputEvent);
                Pools.free((Object)inputEvent);
            }
        }

        @Override
        public Array<Group> getContentContainers() {
            Array a = new Array(1);
            a.add((Object)this.gui.content);
            return a;
        }

        @Override
        public void back() {
            this.gui.back();
        }

        @Override
        public void start() {
            this.gui.back();
        }

        @Override
        public void select() {
        }

        @Override
        public void tabLeft() {
            this.gui.tabLeft();
        }

        @Override
        public void tabRight() {
            this.gui.tabRight();
        }

        @Override
        public void moveUp() {
            this.gui.up();
        }

        @Override
        public void moveDown() {
            this.gui.down();
        }

        @Override
        public void moveLeft() {
            this.gui.left();
        }

        @Override
        public void moveRight() {
            this.gui.right();
        }

        @Override
        public void rightStickVertical(float value) {
            super.rightStickVertical(this.gui.getFocusedActor(), value);
        }

        @Override
        public void rightStickHorizontal(float value) {
            super.rightStickHorizontal(this.gui.getFocusedActor(), value);
        }

        @Override
        public void rightTrigger(float value) {
            super.rightTrigger(this.gui.getFocusedActor(), value);
        }

        @Override
        public void leftTrigger(float value) {
            super.leftTrigger(this.gui.getFocusedActor(), value);
        }
    }
}

