/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import gaiasky.gui.main.AbstractGamepadMappings;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.parse.Parser;
import gaiasky.util.properties.SortedProperties;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class GamepadMappings
extends AbstractGamepadMappings {
    private String controllerName;

    public GamepadMappings(String controllerName) {
        this.controllerName = controllerName;
    }

    public GamepadMappings(String controllerName, Path mappingsFile) {
        this(controllerName);
        if (controllerName == null || controllerName.isBlank()) {
            this.controllerName = FilenameUtils.removeExtension((String)mappingsFile.getFileName().toString());
        }
        SortedProperties mappings = new SortedProperties();
        try {
            Path internalMappings;
            if (!Files.exists(mappingsFile, new LinkOption[0]) && Files.exists(internalMappings = Path.of(Settings.ASSETS_LOC, new String[0]).resolve(mappingsFile), new LinkOption[0])) {
                mappingsFile = internalMappings;
            }
            InputStream is = Files.newInputStream(mappingsFile, new OpenOption[0]);
            mappings.load(is);
            is.close();
            this.AXIS_VALUE_POW = this.parseDouble(mappings, "4.0", "axis.value.pow");
            this.AXIS_LSTICK_H = this.parseInt(mappings, "axis.roll", "axis.lstick.h");
            this.AXIS_LSTICK_H_SENS = this.parseDouble(mappings, "1.0", "axis.roll.sensitivity", "axis.lstick.h.sensitivity");
            this.AXIS_RSTICK_H = this.parseInt(mappings, "axis.pitch", "axis.rstick.h");
            this.AXIS_RSTICK_H_SENS = this.parseDouble(mappings, "1.0", "axis.pitch.sensitivity", "axis.rstick.h.sensitivity");
            this.AXIS_RSTICK_V = this.parseInt(mappings, "axis.yaw", "axis.rstick.v");
            this.AXIS_RSTICK_V_SENS = this.parseDouble(mappings, "1.0", "axis.yaw.sensitivity", "axis.rstick.v.sensitivity");
            this.AXIS_LSTICK_V = this.parseInt(mappings, "axis.move", "axis.lstick.v");
            this.AXIS_LSTICK_V_SENS = this.parseDouble(mappings, "1.0", "axis.move.sensitivity", "axis.lstick.v.sensitivity");
            this.AXIS_RB = this.parseInt(mappings, "axis.rb");
            this.AXIS_LB = this.parseInt(mappings, "axis.lb");
            this.AXIS_RT = this.parseInt(mappings, "axis.velocityup", "axis.rt");
            this.AXIS_RT_SENS = this.parseDouble(mappings, "-1", "axis.velocityup.sensitivity", "axis.rt.sensitivity");
            this.AXIS_LT = this.parseInt(mappings, "axis.velocitydown", "axis.lt");
            this.AXIS_LT_SENS = this.parseDouble(mappings, "1.0", "axis.velocitydown.sensitivity", "axis.lt.sensitivity");
            this.AXIS_DPAD_H = this.parseInt(mappings, "axis.dpad.h");
            this.AXIS_DPAD_V = this.parseInt(mappings, "axis.dpad.v");
            this.BUTTON_DPAD_UP = this.parseInt(mappings, "button.up", "button.dpad.u");
            this.BUTTON_DPAD_DOWN = this.parseInt(mappings, "button.down", "button.dpad.d");
            this.BUTTON_DPAD_LEFT = this.parseInt(mappings, "button.dpad.l");
            this.BUTTON_DPAD_RIGHT = this.parseInt(mappings, "button.dpad.r");
            this.BUTTON_A = this.parseInt(mappings, "button.velocityup", "button.a");
            this.BUTTON_B = this.parseInt(mappings, "button.velocitydown", "button.b");
            this.BUTTON_X = this.parseInt(mappings, "button.velocitytenth", "button.x");
            this.BUTTON_Y = this.parseInt(mappings, "button.velocityhalf", "button.y");
            this.BUTTON_RSTICK = this.parseInt(mappings, "button.rstick", "button.mode.toggle");
            this.BUTTON_LSTICK = this.parseInt(mappings, "button.lstick");
            this.BUTTON_RT = this.parseInt(mappings, "button.rt");
            this.BUTTON_RB = this.parseInt(mappings, "button.rb");
            this.BUTTON_LT = this.parseInt(mappings, "button.lt");
            this.BUTTON_LB = this.parseInt(mappings, "button.lb");
            this.BUTTON_START = this.parseInt(mappings, "button.start");
            this.BUTTON_SELECT = this.parseInt(mappings, "button.select");
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error(e, "Error reading inputListener mappings");
        }
    }

    public boolean persist(Path path) {
        SortedProperties mappings = new SortedProperties();
        mappings.setProperty("axis.value.pow", Double.toString(this.AXIS_VALUE_POW));
        mappings.setProperty("axis.lstick.h", Integer.toString(this.AXIS_LSTICK_H));
        mappings.setProperty("axis.lstick.h.sensitivity", Double.toString(this.AXIS_LSTICK_H_SENS));
        mappings.setProperty("axis.lstick.v", Integer.toString(this.AXIS_LSTICK_V));
        mappings.setProperty("axis.lstick.v.sensitivity", Double.toString(this.AXIS_LSTICK_V_SENS));
        mappings.setProperty("axis.rstick.h", Integer.toString(this.AXIS_RSTICK_H));
        mappings.setProperty("axis.rstick.h.sensitivity", Double.toString(this.AXIS_RSTICK_H_SENS));
        mappings.setProperty("axis.rstick.v", Integer.toString(this.AXIS_RSTICK_V));
        mappings.setProperty("axis.rstick.v.sensitivity", Double.toString(this.AXIS_RSTICK_V_SENS));
        mappings.setProperty("axis.rb", Integer.toString(this.AXIS_RB));
        mappings.setProperty("axis.lb", Integer.toString(this.AXIS_LB));
        mappings.setProperty("axis.rt", Integer.toString(this.AXIS_RT));
        mappings.setProperty("axis.rt.sensitivity", Double.toString(this.AXIS_RT_SENS));
        mappings.setProperty("axis.lt", Integer.toString(this.AXIS_LT));
        mappings.setProperty("axis.lt.sensitivity", Double.toString(this.AXIS_LT_SENS));
        mappings.setProperty("button.a", Integer.toString(this.BUTTON_A));
        mappings.setProperty("button.b", Integer.toString(this.BUTTON_B));
        mappings.setProperty("button.x", Integer.toString(this.BUTTON_X));
        mappings.setProperty("button.y", Integer.toString(this.BUTTON_Y));
        mappings.setProperty("button.start", Integer.toString(this.BUTTON_START));
        mappings.setProperty("button.select", Integer.toString(this.BUTTON_SELECT));
        mappings.setProperty("button.rstick", Integer.toString(this.BUTTON_RSTICK));
        mappings.setProperty("button.lstick", Integer.toString(this.BUTTON_LSTICK));
        mappings.setProperty("button.rt", Integer.toString(this.BUTTON_RT));
        mappings.setProperty("button.rb", Integer.toString(this.BUTTON_RB));
        mappings.setProperty("button.lt", Integer.toString(this.BUTTON_LT));
        mappings.setProperty("button.lb", Integer.toString(this.BUTTON_LB));
        mappings.setProperty("button.dpad.u", Integer.toString(this.BUTTON_DPAD_UP));
        mappings.setProperty("button.dpad.d", Integer.toString(this.BUTTON_DPAD_DOWN));
        mappings.setProperty("button.dpad.r", Integer.toString(this.BUTTON_DPAD_RIGHT));
        mappings.setProperty("button.dpad.l", Integer.toString(this.BUTTON_DPAD_LEFT));
        mappings.setProperty("axis.dpad.h", Integer.toString(this.AXIS_DPAD_H));
        mappings.setProperty("axis.dpad.v", Integer.toString(this.AXIS_DPAD_V));
        try {
            OutputStream os = Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            mappings.store(os, "Controller mappings definition file for " + this.controllerName);
            logger.info("Controller mappings file written successfully: " + String.valueOf(path.toAbsolutePath()));
            return true;
        }
        catch (Exception e) {
            logger.error(e);
            return false;
        }
    }

    private int parseInt(Properties mappings, String ... properties) {
        try {
            for (String property : properties) {
                if (!mappings.containsKey(property)) continue;
                return Integer.parseInt(mappings.getProperty(property, "-1"));
            }
            throw new RuntimeException("Properties not found: " + GlobalResources.toString(properties, "", ","));
        }
        catch (Exception e) {
            return Integer.parseInt("-1");
        }
    }

    private double parseDouble(Properties mappings, String defaultValue, String ... properties) {
        try {
            for (String property : properties) {
                if (!mappings.containsKey(property)) continue;
                return Double.parseDouble(mappings.getProperty(property, defaultValue));
            }
            throw new RuntimeException("Properties not found: " + GlobalResources.toString(properties, "", ","));
        }
        catch (Exception e) {
            return Parser.parseDouble(defaultValue);
        }
    }
}

