/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import gaiasky.GaiaSky;
import gaiasky.data.group.DatasetOptions;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.BookmarkInfoDialog;
import gaiasky.gui.api.IGui;
import gaiasky.gui.bookmarks.BookmarkNameDialog;
import gaiasky.gui.bookmarks.BookmarksManager;
import gaiasky.gui.datasets.DatasetLoadDialog;
import gaiasky.gui.main.GamepadGui;
import gaiasky.gui.main.ModePopupInfo;
import gaiasky.gui.window.AboutWindow;
import gaiasky.gui.window.DateDialog;
import gaiasky.gui.window.GenericDialog;
import gaiasky.gui.window.IndividualVisibilityWindow;
import gaiasky.gui.window.KeyframesWindow;
import gaiasky.gui.window.ObjectDebugWindow;
import gaiasky.gui.window.PreferencesWindow;
import gaiasky.gui.window.QuitWindow;
import gaiasky.gui.window.ReleaseNotesWindow;
import gaiasky.gui.window.SearchDialog;
import gaiasky.gui.window.SlaveConfigWindow;
import gaiasky.gui.window.TextureWindow;
import gaiasky.render.ComponentTypes;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.ParticleSet;
import gaiasky.scene.entity.EntityUtils;
import gaiasky.scene.view.FocusView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.CatalogManager;
import gaiasky.util.GlobalResources;
import gaiasky.util.Logger;
import gaiasky.util.MasterManager;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import gaiasky.util.scene2d.FileChooser;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextButton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.lwjgl.glfw.GLFW;

public class GuiRegistry
implements IObserver {
    private static final Logger.Log logger = Logger.getLogger(GuiRegistry.class);
    protected final Scene scene;
    private final Array<IGui> guis;
    private final Array<IGui> specialGuis;
    private final Object renderLock = new Object();
    private final CatalogManager catalogManager;
    private final FocusView view;
    public Table modeChangeInfoPopup;
    public IGui current;
    public IGui previous;
    private Skin skin;
    private PreferencesWindow preferencesWindow;
    private AboutWindow aboutWindow;
    private SearchDialog searchDialog;
    private DateDialog dateDialog;
    private BookmarkNameDialog locationBookmarkDialog;
    private BookmarkInfoDialog bookmarkInfoDialog;
    private ObjectDebugWindow objectDebugWindow;
    private KeyframesWindow keyframesWindow;
    private IndividualVisibilityWindow indVisWindow;
    private Timer.Task removePopup;
    private Path lastOpenLocation;
    private SlaveConfigWindow slaveConfigWindow;
    private InputMultiplexer inputMultiplexer = null;

    public GuiRegistry(Skin skin, Scene scene, CatalogManager catalogManager) {
        this.skin = skin;
        this.scene = scene;
        this.guis = new Array(true, 2);
        this.specialGuis = new Array(true, 1);
        this.catalogManager = catalogManager;
        this.view = new FocusView();
        EventManager.instance.subscribe((IObserver)this, Event.SHOW_SEARCH_ACTION, Event.SHOW_QUIT_ACTION, Event.SHOW_ABOUT_ACTION, Event.SHOW_LOAD_CATALOG_ACTION, Event.SHOW_PREFERENCES_ACTION, Event.SHOW_KEYFRAMES_WINDOW_ACTION, Event.SHOW_SLAVE_CONFIG_ACTION, Event.SHOW_TEXTURE_WINDOW_ACTION, Event.UI_THEME_RELOAD_INFO, Event.MODE_POPUP_CMD, Event.DISPLAY_GUI_CMD, Event.CAMERA_MODE_CMD, Event.UI_RELOAD_CMD, Event.SHOW_PER_OBJECT_VISIBILITY_ACTION, Event.SHOW_RESTART_ACTION, Event.CLOSE_ALL_GUI_WINDOWS_CMD, Event.SHOW_DATE_TIME_EDIT_ACTION, Event.SHOW_ADD_POSITION_BOOKMARK_ACTION, Event.SHOW_BOOKMARK_INFO_ACTION, Event.SHOW_OBJECT_DEBUG_ACTION);
    }

    public void setInputMultiplexer(InputMultiplexer inputMultiplexer) {
        this.inputMultiplexer = inputMultiplexer;
    }

    public void change(IGui gui, IGui previous) {
        if (this.current != gui) {
            this.unset(previous);
            this.set(gui);
        }
    }

    public void change(IGui gui) {
        if (this.current != gui) {
            this.unset();
            this.set(gui);
        }
    }

    public void unset() {
        this.unset(this.current);
    }

    public void unset(IGui gui) {
        if (gui != null) {
            this.unregisterGui(gui);
            this.inputMultiplexer.removeProcessor((InputProcessor)gui.getGuiStage());
        }
        this.previous = gui;
    }

    public void set(IGui gui) {
        if (gui != null) {
            this.registerGui(gui);
            this.inputMultiplexer.addProcessor(0, (InputProcessor)gui.getGuiStage());
        }
        this.current = gui;
    }

    public void setPrevious(IGui gui) {
        this.previous = gui;
    }

    public void registerGui(IGui gui) {
        if (!this.guis.contains((Object)gui, true)) {
            this.guis.add((Object)gui);
        }
    }

    public void registerSpecialGui(IGui gui) {
        if (!this.specialGuis.contains((Object)gui, true)) {
            this.specialGuis.add((Object)gui);
        }
    }

    public void unregisterGui(IGui gui) {
        this.guis.removeValue((Object)gui, true);
    }

    public void unregisterSpecialGui(IGui gui) {
        this.specialGuis.removeValue((Object)gui, true);
    }

    public void unregisterAll() {
        this.guis.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int rw, int rh) {
        if (Settings.settings.runtime.displayGui) {
            Object object = this.renderLock;
            synchronized (object) {
                for (int i = 0; i < this.guis.size; ++i) {
                    ((IGui)this.guis.get(i)).getGuiStage().getViewport().apply();
                    try {
                        ((IGui)this.guis.get(i)).render(rw, rh);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (Settings.settings.program.displayTimeNoUi) {
            Object object = this.renderLock;
            synchronized (object) {
                for (int i = 0; i < this.specialGuis.size; ++i) {
                    ((IGui)this.specialGuis.get(i)).getGuiStage().getViewport().apply();
                    try {
                        ((IGui)this.specialGuis.get(i)).render(rw, rh);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void addProcessor(IGui gui) {
        if (this.inputMultiplexer != null && gui != null) {
            this.inputMultiplexer.addProcessor((InputProcessor)gui.getGuiStage());
        }
    }

    public void removeProcessor(IGui gui) {
        if (this.inputMultiplexer != null && gui != null) {
            this.inputMultiplexer.removeProcessor((InputProcessor)gui.getGuiStage());
        }
    }

    public void update(double dt) {
        for (IGui gui : this.guis) {
            gui.update(dt);
        }
        if (!Settings.settings.runtime.displayGui && Settings.settings.program.displayTimeNoUi) {
            for (IGui gui : this.specialGuis) {
                gui.update(dt);
            }
        }
    }

    public void publishReleaseNotes() {
        Path releaseNotesFile;
        Path releaseNotesRev = SysUtils.getReleaseNotesRevisionFile();
        int releaseNotesVersion = 0;
        if (Files.exists(releaseNotesRev, new LinkOption[0]) && Files.isRegularFile(releaseNotesRev, new LinkOption[0])) {
            try {
                String contents = Files.readString(releaseNotesRev).trim();
                releaseNotesVersion = Parser.parseInt(contents);
            }
            catch (Exception e) {
                logger.warn(I18n.msg("error.file.read", releaseNotesRev.toString()));
            }
        }
        if (releaseNotesVersion < Settings.settings.version.versionNumber && Files.exists(releaseNotesFile = SysUtils.getReleaseNotesFile(), new LinkOption[0])) {
            Timer.Task releaseNotesTask = new Timer.Task(this){
                final /* synthetic */ GuiRegistry this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    Stage ui = this.this$0.current.getGuiStage();
                    ReleaseNotesWindow releaseNotesWindow = new ReleaseNotesWindow(ui, this.this$0.skin, releaseNotesFile);
                    releaseNotesWindow.show(ui);
                }
            };
            Timer.schedule((Timer.Task)releaseNotesTask, (float)3.0f);
        }
    }

    public void dispose() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
        if (this.searchDialog != null) {
            this.searchDialog.dispose();
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (this.current != null) {
            Stage stage = this.current.getGuiStage();
            switch (event) {
                case SHOW_SEARCH_ACTION: {
                    if (this.searchDialog == null) {
                        this.searchDialog = new SearchDialog(this.skin, stage, this.scene, true);
                    } else {
                        this.searchDialog.clearText();
                    }
                    if (!(!this.searchDialog.isVisible() | !this.searchDialog.hasParent())) break;
                    this.searchDialog.show(stage);
                    break;
                }
                case SHOW_QUIT_ACTION: {
                    Runnable quitRunnable;
                    if (this.removeModeChangePopup() || this.removeGamepadGui()) break;
                    if (GLFW.glfwGetInputMode((long)((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle(), (int)208897) == 212995) {
                        GLFW.glfwSetInputMode((long)((Lwjgl3Graphics)Gdx.graphics).getWindow().getWindowHandle(), (int)208897, (int)212993);
                        break;
                    }
                    Runnable runnable = quitRunnable = data.length > 0 ? (Runnable)data[0] : null;
                    if (Settings.settings.program.exitConfirmation) {
                        QuitWindow quit = new QuitWindow(stage, this.skin);
                        if (data.length > 0) {
                            quit.setAcceptListener(quitRunnable);
                        }
                        quit.show(stage);
                        break;
                    }
                    if (quitRunnable != null) {
                        quitRunnable.run();
                    }
                    GaiaSky.postRunnable(() -> Gdx.app.exit());
                    break;
                }
                case CAMERA_MODE_CMD: {
                    this.removeModeChangePopup();
                    break;
                }
                case SHOW_ABOUT_ACTION: {
                    if (this.aboutWindow == null) {
                        this.aboutWindow = new AboutWindow(stage, this.skin);
                    }
                    if (this.aboutWindow.isVisible() && this.aboutWindow.hasParent()) break;
                    this.aboutWindow.show(stage);
                    break;
                }
                case SHOW_PREFERENCES_ACTION: {
                    Array<Actor> prefs = this.getElementsOfType(PreferencesWindow.class);
                    if (prefs.isEmpty()) {
                        if (this.preferencesWindow != null) {
                            this.preferencesWindow.dispose();
                            this.preferencesWindow = null;
                        }
                        this.preferencesWindow = new PreferencesWindow(stage, this.skin, GaiaSky.instance.getGlobalResources());
                        if (this.preferencesWindow.isVisible() && this.preferencesWindow.hasParent()) break;
                        this.preferencesWindow.show(stage);
                        break;
                    }
                    for (Actor pref : prefs) {
                        if (!(pref instanceof PreferencesWindow)) continue;
                        ((PreferencesWindow)pref).cancel();
                        ((PreferencesWindow)pref).hide();
                    }
                    break;
                }
                case SHOW_PER_OBJECT_VISIBILITY_ACTION: {
                    if (this.indVisWindow == null) {
                        this.indVisWindow = new IndividualVisibilityWindow(this.scene, stage, this.skin);
                    }
                    if (this.indVisWindow.isVisible() && this.indVisWindow.hasParent()) break;
                    this.indVisWindow.show(stage);
                    break;
                }
                case SHOW_SLAVE_CONFIG_ACTION: {
                    if (!MasterManager.hasSlaves()) break;
                    if (this.slaveConfigWindow == null) {
                        this.slaveConfigWindow = new SlaveConfigWindow(stage, this.skin);
                    }
                    if (this.slaveConfigWindow.isVisible() && this.slaveConfigWindow.hasParent()) break;
                    this.slaveConfigWindow.show(stage);
                    break;
                }
                case SHOW_LOAD_CATALOG_ACTION: {
                    if (this.lastOpenLocation == null && Settings.settings.program.fileChooser.lastLocation != null && !Settings.settings.program.fileChooser.lastLocation.isEmpty()) {
                        try {
                            this.lastOpenLocation = Paths.get(Settings.settings.program.fileChooser.lastLocation, new String[0]);
                        }
                        catch (Exception e) {
                            this.lastOpenLocation = null;
                        }
                    }
                    if (this.lastOpenLocation == null) {
                        this.lastOpenLocation = SysUtils.getUserHome();
                    } else if (!Files.exists(this.lastOpenLocation, new LinkOption[0]) || !Files.isDirectory(this.lastOpenLocation, new LinkOption[0])) {
                        this.lastOpenLocation = SysUtils.getHomeDir();
                    }
                    FileChooser fc = new FileChooser(I18n.msg("gui.loadcatalog"), this.skin, stage, this.lastOpenLocation, FileChooser.FileChooserTarget.FILES);
                    fc.setShowHidden(Settings.settings.program.fileChooser.showHidden);
                    fc.setShowHiddenConsumer(showHidden -> {
                        Settings.settings.program.fileChooser.showHidden = showHidden;
                    });
                    fc.setAcceptText(I18n.msg("gui.loadcatalog"));
                    fc.setFileFilter(pathname -> pathname.getFileName().toString().endsWith(".vot") || pathname.getFileName().toString().endsWith(".csv") || pathname.getFileName().toString().endsWith(".fits") || pathname.getFileName().toString().endsWith(".json"));
                    fc.setAcceptedFiles("*.vot, *.csv, *.fits, *.json");
                    fc.setResultListener((success, result) -> {
                        if (success) {
                            if (Files.exists(result, new LinkOption[0]) && Files.exists(result, new LinkOption[0])) {
                                try {
                                    String fileName = result.getFileName().toString();
                                    if (fileName.endsWith(".json")) {
                                        GaiaSky.instance.getExecutorService().execute(() -> {
                                            boolean loaded = GaiaSky.instance.scripting().loadJsonCatalog(fileName, result.toAbsolutePath().toString());
                                            if (!loaded) {
                                                logger.warn("The dataset could not be loaded: " + String.valueOf(result.toAbsolutePath()));
                                            }
                                        });
                                    } else {
                                        DatasetLoadDialog dld = new DatasetLoadDialog(I18n.msg("gui.dsload.title") + ": " + fileName, fileName, this.skin, stage);
                                        Runnable doLoad = () -> GaiaSky.instance.getExecutorService().execute(() -> {
                                            DatasetOptions datasetOptions = dld.generateDatasetOptions();
                                            GaiaSky.instance.scripting().loadDataset(datasetOptions.catalogName, result.toAbsolutePath().toString(), CatalogInfo.CatalogInfoSource.UI, datasetOptions, true);
                                            CatalogInfo ci = this.catalogManager.get(datasetOptions.catalogName);
                                            if (datasetOptions.type.isSelectable() && ci != null && ci.entity != null) {
                                                this.view.setEntity(ci.entity);
                                                if (this.view.isSet()) {
                                                    ParticleSet set = this.view.getSet();
                                                    if (set.data() != null && !set.data().isEmpty() && EntityUtils.isVisibilityOn(ci.entity)) {
                                                        EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                                                        EventManager.publish(Event.FOCUS_CHANGE_CMD, this, set.getFirstParticleName());
                                                    }
                                                } else if (this.view.getGraph().children != null && !this.view.getGraph().children.isEmpty() && EntityUtils.isVisibilityOn((Entity)this.view.getGraph().children.get(0))) {
                                                    EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                                                    EventManager.publish(Event.FOCUS_CHANGE_CMD, this, EntityUtils.isVisibilityOn((Entity)this.view.getGraph().children.get(0)));
                                                }
                                                GaiaSky.instance.scripting().expandUIPane("Datasets");
                                            } else {
                                                logger.info("No data loaded (did the load crash?)");
                                            }
                                        });
                                        dld.setAcceptListener(doLoad);
                                        dld.show(stage);
                                    }
                                    this.lastOpenLocation = result.getParent();
                                    Settings.settings.program.fileChooser.lastLocation = this.lastOpenLocation.toAbsolutePath().toString();
                                    return true;
                                }
                                catch (Exception e) {
                                    logger.error(I18n.msg("notif.error", result.getFileName()), e);
                                    return false;
                                }
                            }
                            logger.error("Selection must be a file: " + String.valueOf(result.toAbsolutePath()));
                            return false;
                        }
                        this.lastOpenLocation = !Files.isDirectory(result, new LinkOption[0]) ? result.getParent() : result;
                        Settings.settings.program.fileChooser.lastLocation = this.lastOpenLocation.toAbsolutePath().toString();
                        return false;
                    });
                    fc.show(stage);
                    break;
                }
                case SHOW_KEYFRAMES_WINDOW_ACTION: {
                    if (this.keyframesWindow == null) {
                        this.keyframesWindow = new KeyframesWindow(this.scene, stage, this.skin);
                    }
                    if (!this.keyframesWindow.isVisible() || !this.keyframesWindow.hasParent()) {
                        this.keyframesWindow.reset();
                        this.keyframesWindow.show(stage, 0.0f, 0.0f);
                    }
                    if (GaiaSky.instance.isOn(ComponentTypes.ComponentType.Others)) break;
                    EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.keyframe.ct"), Float.valueOf(10.0f));
                    break;
                }
                case SHOW_TEXTURE_WINDOW_ACTION: {
                    TextureWindow textureWindow = this.getTextureWindow(data, stage);
                    textureWindow.show(stage, 0.0f, 50.0f);
                    break;
                }
                case SHOW_DATE_TIME_EDIT_ACTION: {
                    if (this.dateDialog == null) {
                        this.dateDialog = new DateDialog(stage, this.skin);
                    }
                    this.dateDialog.updateTime(GaiaSky.instance.time.getTime(), Settings.settings.program.timeZone.getTimeZone());
                    this.dateDialog.show(stage);
                    break;
                }
                case SHOW_OBJECT_DEBUG_ACTION: {
                    if (this.objectDebugWindow == null) {
                        this.objectDebugWindow = new ObjectDebugWindow(stage, this.skin, this.scene);
                    }
                    this.objectDebugWindow.show(stage);
                    break;
                }
                case SHOW_ADD_POSITION_BOOKMARK_ACTION: {
                    if (this.locationBookmarkDialog == null) {
                        this.locationBookmarkDialog = new BookmarkNameDialog(stage, this.skin);
                    }
                    this.locationBookmarkDialog.resetName();
                    this.locationBookmarkDialog.show(stage);
                    break;
                }
                case SHOW_BOOKMARK_INFO_ACTION: {
                    if (this.bookmarkInfoDialog == null) {
                        this.bookmarkInfoDialog = new BookmarkInfoDialog(stage, this.skin);
                    }
                    BookmarksManager.BookmarkNode bookmark = (BookmarksManager.BookmarkNode)data[0];
                    this.bookmarkInfoDialog.updateView(bookmark);
                    this.bookmarkInfoDialog.show(stage);
                    break;
                }
                case UI_THEME_RELOAD_INFO: {
                    if (this.keyframesWindow != null) {
                        this.keyframesWindow.dispose();
                        this.keyframesWindow = null;
                    }
                    this.skin = (Skin)data[0];
                    break;
                }
                case MODE_POPUP_CMD: {
                    if (!Settings.settings.runtime.displayGui || !Settings.settings.program.ui.modeChangeInfo) break;
                    ModePopupInfo mpi = (ModePopupInfo)data[0];
                    String name = (String)data[1];
                    if (mpi != null) {
                        Float seconds = (Float)data[2];
                        float pad10 = 16.0f;
                        float pad5 = 8.0f;
                        float pad3 = 4.8f;
                        if (this.modeChangeInfoPopup != null) {
                            this.modeChangeInfoPopup.remove();
                        }
                        this.modeChangeInfoPopup = new Table(this.skin);
                        this.modeChangeInfoPopup.setName("mct-" + name);
                        this.modeChangeInfoPopup.setBackground("table-bg");
                        this.modeChangeInfoPopup.pad(pad10);
                        OwnLabel ttl = new OwnLabel((CharSequence)mpi.title, this.skin, "hud-header");
                        this.modeChangeInfoPopup.add((Actor)ttl).left().padBottom(pad10).row();
                        OwnLabel dsc = new OwnLabel((CharSequence)mpi.header, this.skin);
                        this.modeChangeInfoPopup.add((Actor)dsc).left().padBottom(pad5 * 3.0f).row();
                        Table keysTable = new Table(this.skin);
                        for (Pair m : mpi.mappings) {
                            HorizontalGroup keysGroup = new HorizontalGroup();
                            keysGroup.space(pad3);
                            String[] keys = (String[])m.getFirst();
                            String action = (String)m.getSecond();
                            if (keys == null || keys.length <= 0 || action == null || action.isEmpty()) continue;
                            for (int i = 0; i < keys.length; ++i) {
                                TextButton key = new TextButton(keys[i], this.skin, "key");
                                key.pad(0.0f, pad3, 0.0f, pad3);
                                key.pad(pad5);
                                keysGroup.addActor((Actor)key);
                                if (i >= keys.length - 1) continue;
                                keysGroup.addActor((Actor)new OwnLabel((CharSequence)"+", this.skin));
                            }
                            keysTable.add((Actor)keysGroup).right().padBottom(pad5).padRight(pad10 * 2.0f);
                            keysTable.add((Actor)new OwnLabel((CharSequence)action, this.skin)).left().padBottom(pad5).row();
                        }
                        this.modeChangeInfoPopup.add((Actor)keysTable).center().row();
                        if (mpi.warn != null && !mpi.warn.isEmpty()) {
                            this.modeChangeInfoPopup.add((Actor)new OwnLabel((CharSequence)mpi.warn, this.skin, "mono-pink")).left().padTop(pad10).padBottom(pad5).row();
                        }
                        OwnTextButton closeButton = new OwnTextButton(I18n.msg("gui.ok") + " [esc]", this.skin);
                        closeButton.pad(pad3, pad10, pad3, pad10);
                        closeButton.addListener(event1 -> {
                            if (event1 instanceof ChangeListener.ChangeEvent) {
                                this.removeModeChangePopup();
                                return true;
                            }
                            return false;
                        });
                        this.modeChangeInfoPopup.add((Actor)closeButton).right().padTop(pad10 * 2.0f);
                        this.modeChangeInfoPopup.pack();
                        Container mct = new Container((Actor)this.modeChangeInfoPopup);
                        mct.setFillParent(true);
                        mct.top();
                        mct.pad(pad10 * 2.0f, 0.0f, 0.0f, 0.0f);
                        stage.addActor((Actor)mct);
                        this.cancelRemovePopupTask();
                        this.removePopup = new Timer.Task(){

                            public void run() {
                                if (GuiRegistry.this.modeChangeInfoPopup != null && GuiRegistry.this.modeChangeInfoPopup.hasParent()) {
                                    GuiRegistry.this.modeChangeInfoPopup.remove();
                                }
                            }
                        };
                        Timer.schedule((Timer.Task)this.removePopup, (float)seconds.floatValue());
                        break;
                    }
                    if (this.modeChangeInfoPopup == null || !this.modeChangeInfoPopup.hasParent() || !this.modeChangeInfoPopup.getName().equals("mct-" + name)) break;
                    this.modeChangeInfoPopup.remove();
                    this.modeChangeInfoPopup = null;
                    break;
                }
                case DISPLAY_GUI_CMD: {
                    boolean displayGui = (Boolean)data[0];
                    this.inputMultiplexer.removeProcessor((InputProcessor)this.current.getGuiStage());
                    if (!displayGui) break;
                    this.inputMultiplexer.addProcessor(0, (InputProcessor)this.current.getGuiStage());
                    break;
                }
                case SHOW_RESTART_ACTION: {
                    final String text = data.length > 0 ? (String)data[0] : I18n.msg("gui.restart.default");
                    GenericDialog restart = new GenericDialog(this, I18n.msg("gui.restart.title"), this.skin, stage){

                        @Override
                        protected void build() {
                            this.content.clear();
                            this.content.add((Actor)new OwnLabel((CharSequence)text, this.skin)).left().padBottom(pad18 * 2.0f).row();
                        }

                        @Override
                        protected boolean accept() {
                            GaiaSky.postRunnable(() -> {
                                Gdx.app.exit();
                                Path workingDir = Path.of(System.getProperty("user.dir"), new String[0]);
                                Path[] scripts = SysUtils.isWindows() ? new Path[]{workingDir.resolve("gaiasky.exe"), workingDir.resolve("gaiasky.bat"), workingDir.resolve("gradlew.bat")} : new Path[]{workingDir.resolve("gaiasky"), workingDir.resolve("gradlew")};
                                for (Path file : scripts) {
                                    if (!Files.exists(file, new LinkOption[0]) || !Files.isRegularFile(file, new LinkOption[0]) || !Files.isExecutable(file)) continue;
                                    try {
                                        if (file.getFileName().toString().contains("gaiasky")) {
                                            ArrayList<String> command = new ArrayList<String>();
                                            command.add(file.toString());
                                            ProcessBuilder builder = new ProcessBuilder(command);
                                            builder.start();
                                            break;
                                        }
                                        if (!file.getFileName().toString().contains("gradlew")) break;
                                        ArrayList<String> command = new ArrayList<String>();
                                        command.add(file.toString());
                                        command.add("core:run");
                                        ProcessBuilder builder = new ProcessBuilder(command);
                                        builder.start();
                                        break;
                                    }
                                    catch (IOException e) {
                                        logger.error(e, "Error running Gaia Sky");
                                    }
                                }
                            });
                            return true;
                        }

                        @Override
                        protected void cancel() {
                        }

                        @Override
                        public void dispose() {
                        }
                    };
                    restart.setAcceptText(I18n.msg("gui.yes"));
                    restart.setCancelText(I18n.msg("gui.no"));
                    restart.buildSuper();
                    restart.show(stage);
                    break;
                }
                case CLOSE_ALL_GUI_WINDOWS_CMD: {
                    Array actors = stage.getActors();
                    for (Actor actor : actors) {
                        if (!(actor instanceof GenericDialog)) continue;
                        this.closeWindow((GenericDialog)actor);
                    }
                    break;
                }
                case UI_RELOAD_CMD: {
                    this.reloadUI((GlobalResources)data[0]);
                    break;
                }
            }
        }
    }

    private TextureWindow getTextureWindow(Object[] data, Stage stage) {
        TextureWindow textureWindow;
        Object object;
        String title = (String)data[0];
        float scale = 1.0f;
        if (data.length > 2) {
            scale = ((Float)data[2]).floatValue();
        }
        boolean flipX = false;
        boolean flipY = false;
        if (data.length > 3) {
            flipX = (Boolean)data[3];
        }
        if (data.length > 4) {
            flipY = (Boolean)data[4];
        }
        if ((object = data[1]) instanceof FrameBuffer) {
            FrameBuffer frameBuffer = (FrameBuffer)object;
            textureWindow = new TextureWindow(title, this.skin, stage, frameBuffer, scale);
        } else {
            Texture texture = (Texture)data[1];
            textureWindow = new TextureWindow(title, this.skin, stage, texture, scale);
        }
        textureWindow.setFlip(flipX, flipY);
        return textureWindow;
    }

    private void closeWindow(GenericDialog dialog) {
        if (dialog != null && dialog.isVisible() && dialog.hasParent()) {
            dialog.closeCancel();
        }
    }

    private Array<Actor> getElementsOfType(Class<? extends Actor> clazz) {
        Array result = new Array();
        if (this.current != null) {
            Stage ui = this.current.getGuiStage();
            Array actors = ui.getActors();
            for (Actor actor : actors) {
                if (!clazz.isAssignableFrom(actor.getClass())) continue;
                result.add((Object)actor);
            }
        }
        return result;
    }

    public boolean removeGamepadGui() {
        for (int i = 0; i < this.guis.size; ++i) {
            IGui gui = (IGui)this.guis.get(i);
            if (!(gui instanceof GamepadGui)) continue;
            GamepadGui gamepadGui = (GamepadGui)gui;
            return gamepadGui.removeGamepadGui();
        }
        return false;
    }

    private void cancelRemovePopupTask() {
        if (this.removePopup != null && this.removePopup.isScheduled()) {
            this.removePopup.cancel();
        }
    }

    public boolean removeModeChangePopup() {
        boolean removed = false;
        if (this.modeChangeInfoPopup != null) {
            removed = this.modeChangeInfoPopup.remove();
            this.cancelRemovePopupTask();
        }
        return removed;
    }

    private void reloadUI(GlobalResources globalResources) {
        GaiaSky.postRunnable(() -> {
            globalResources.updateSkin();
            GenericDialog.updatePads();
            GaiaSky.instance.reinitialiseGUI1();
            EventManager.publish(Event.SPACECRAFT_LOADED, this, this.scene.getEntity("Spacecraft"));
            GaiaSky.instance.reinitialiseGUI2();
            EventManager.publish(Event.TIME_CHANGE_INFO, this, GaiaSky.instance.time.getTime());
            if (GaiaSky.instance.cameraManager.mode == CameraManager.CameraMode.FOCUS_MODE) {
                FocusView focus = (FocusView)GaiaSky.instance.cameraManager.getFocus();
                EventManager.publish(Event.FOCUS_CHANGE_CMD, this, focus.getEntity());
            }
            EventManager.publish(Event.UI_THEME_RELOAD_INFO, this, globalResources.getSkin());
            EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.ui.reload"));
        });
    }
}

