/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.utils.Array;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.main.FullGui;
import gaiasky.gui.main.GSKeys;
import gaiasky.render.postprocess.effects.CubmeapProjectionEffect;
import gaiasky.scene.camera.CameraManager;
import gaiasky.util.Logger;
import gaiasky.util.MasterManager;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.SlaveManager;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.parse.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class KeyBindings {
    public static final int CTRL_L = 129;
    public static final int SHIFT_L = 59;
    public static final int ALT_L = 57;
    public static final int[] SPECIAL = new int[]{129, 59, 57};
    private static final Logger.Log logger = Logger.getLogger(KeyBindings.class);
    public static KeyBindings instance;
    private final Map<String, ProgramAction> actions = new HashMap<String, ProgramAction>();
    private final Map<TreeSet<Integer>, ProgramAction> mappings = new HashMap<TreeSet<Integer>, ProgramAction>();
    private final Map<ProgramAction, Array<TreeSet<Integer>>> mappingsInv = new TreeMap<ProgramAction, Array<TreeSet<Integer>>>();

    private KeyBindings() {
        this.initDefault();
    }

    public static void initialize() {
        KeyBindings.initialize(false);
    }

    public static void initialize(boolean force) {
        if (instance == null || force) {
            instance = new KeyBindings();
        }
    }

    public Map<TreeSet<Integer>, ProgramAction> getMappings() {
        return this.mappings;
    }

    public Map<ProgramAction, Array<TreeSet<Integer>>> getSortedMappingsInv() {
        return this.mappingsInv;
    }

    private void addMapping(ProgramAction action, int ... keyCodes) {
        TreeSet<Integer> keys = new TreeSet<Integer>();
        for (int key : keyCodes) {
            keys.add(key);
        }
        this.mappings.put(keys, action);
        if (this.mappingsInv.containsKey(action)) {
            this.mappingsInv.get(action).add(keys);
        } else {
            Array a = new Array();
            a.add(keys);
            this.mappingsInv.put(action, (Array<TreeSet<Integer>>)a);
        }
    }

    private void addAction(ProgramAction action) {
        this.actions.put(action.actionId, action);
    }

    public ProgramAction findAction(String name) {
        Set<ProgramAction> actions = this.mappingsInv.keySet();
        for (ProgramAction action : actions) {
            if (!action.actionId.equals(name)) continue;
            return action;
        }
        return null;
    }

    public TreeSet<Integer> getKeys(String actionId) {
        ProgramAction action = this.findAction(actionId);
        if (action != null) {
            Set<Map.Entry<TreeSet<Integer>, ProgramAction>> entries = this.mappings.entrySet();
            for (Map.Entry<TreeSet<Integer>, ProgramAction> entry : entries) {
                if (!entry.getValue().equals(action)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public List<TreeSet<Integer>> getAllKeys(String actionId) {
        ArrayList<TreeSet<Integer>> result = new ArrayList<TreeSet<Integer>>();
        ProgramAction action = this.findAction(actionId);
        if (action != null) {
            Set<Map.Entry<TreeSet<Integer>, ProgramAction>> entries = this.mappings.entrySet();
            for (Map.Entry<TreeSet<Integer>, ProgramAction> entry : entries) {
                if (!entry.getValue().equals(action)) continue;
                result.add(entry.getKey());
            }
            return result;
        }
        return null;
    }

    public String getStringKeys(String actionId) {
        String[] r = this.getStringKeys(actionId, "+", false);
        if (r != null && r.length > 0) {
            return r[0];
        }
        return null;
    }

    public String[] getStringKeys(String actionId, boolean allSets) {
        return this.getStringKeys(actionId, "+", allSets);
    }

    public String[] getStringKeys(String actionId, String join, boolean allSets) {
        if (allSets) {
            List<TreeSet<Integer>> keySets = this.getAllKeys(actionId);
            if (keySets != null && !keySets.isEmpty()) {
                String[] result = new String[keySets.size()];
                int i = 0;
                for (TreeSet<Integer> keys : keySets) {
                    result[i] = this.getStringKeys(keys, join);
                    ++i;
                }
                return result;
            }
            return null;
        }
        TreeSet<Integer> keys = this.getKeys(actionId);
        String s = this.getStringKeys(keys, join);
        if (s != null) {
            return new String[]{s};
        }
        return null;
    }

    private String getStringKeys(TreeSet<Integer> keys, String join) {
        if (keys != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<Integer> it = keys.descendingIterator();
            while (it.hasNext()) {
                sb.append(GSKeys.toString(it.next()));
                if (!it.hasNext()) continue;
                sb.append(join);
            }
            return sb.toString();
        }
        return null;
    }

    public String[] getStringArrayKeys(String actionId) {
        TreeSet<Integer> keys = this.getKeys(actionId);
        if (keys != null) {
            String[] result = new String[keys.size()];
            Iterator<Integer> it = keys.descendingIterator();
            int i = 0;
            while (it.hasNext()) {
                result[i++] = GSKeys.toString(it.next());
            }
            return result;
        }
        return null;
    }

    private void initDefault() {
        this.initActions();
        this.initMappings();
    }

    private void initActions() {
        BooleanRunnable fullGuiCondition = () -> GaiaSky.instance.getGuiRegistry().current instanceof FullGui;
        BooleanRunnable noGameCondition = () -> !GaiaSky.instance.getCameraManager().getMode().isGame();
        BooleanRunnable noCleanMode = () -> Settings.settings.runtime.displayGui || GaiaSky.instance.getCliArgs().externalView;
        BooleanRunnable noPanorama = () -> !Settings.settings.program.modeCubemap.active || !Settings.settings.program.modeCubemap.projection.isPanorama();
        BooleanRunnable noPlanetarium = () -> !Settings.settings.program.modeCubemap.active || !Settings.settings.program.modeCubemap.projection.isPlanetarium();
        BooleanRunnable noOrthoSphere = () -> !Settings.settings.program.modeCubemap.active || !Settings.settings.program.modeCubemap.projection.isOrthosphere();
        BooleanRunnable noSlaveProj = () -> !SlaveManager.projectionActive();
        BooleanRunnable masterWithSlaves = MasterManager::hasSlaves;
        Runnable runnableAbout = () -> EventManager.publish(Event.SHOW_ABOUT_ACTION, this, new Object[0]);
        this.addAction(new ProgramAction("action.help", runnableAbout, noCleanMode));
        this.addAction(new ProgramAction("action.help", runnableAbout, noCleanMode));
        Runnable runnableQuit = () -> EventManager.publish(Event.SHOW_QUIT_ACTION, this, new Object[0]);
        this.addAction(new ProgramAction("action.exit", runnableQuit, noCleanMode));
        this.addAction(new ProgramAction("action.preferences", () -> EventManager.publish(Event.SHOW_PREFERENCES_ACTION, this, new Object[0]), noCleanMode));
        this.addAction(new ProgramAction("action.toggle/gui.minimap.title", () -> EventManager.publish(Event.MINIMAP_TOGGLE_CMD, this, new Object[0]), noCleanMode));
        this.addAction(new ProgramAction("action.toggle/gui.console.title", () -> EventManager.publish(Event.CONSOLE_CMD, this, new Object[0]), noCleanMode));
        this.addAction(new ProgramAction("action.console", () -> EventManager.publish(Event.CONSOLE_CMD, this, true), noCleanMode));
        this.addAction(new ProgramAction("action.loadcatalog", () -> EventManager.publish(Event.SHOW_LOAD_CATALOG_ACTION, this, new Object[0]), noCleanMode));
        this.addAction(new ProgramAction("action.playcamera", () -> EventManager.publish(Event.SHOW_PLAYCAMERA_CMD, this, new Object[0]), noCleanMode));
        this.addAction(new ProgramAction("action.log", () -> EventManager.publish(Event.SHOW_LOG_CMD, this, new Object[0]), noCleanMode));
        this.addAction(new ProgramAction("action.toggle/element.orbits", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.orbits"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.planets", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.planets"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.moons", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.moons"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.stars", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.stars"), noGameCondition));
        this.addAction(new ProgramAction("action.toggle/element.satellites", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.satellites"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.asteroids", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.asteroids"), noGameCondition));
        this.addAction(new ProgramAction("action.toggle/element.labels", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.labels"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.constellations", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.constellations"), noGameCondition));
        this.addAction(new ProgramAction("action.toggle/element.boundaries", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.boundaries"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.equatorial", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.equatorial"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.ecliptic", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.ecliptic"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.galactic", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.galactic"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.recursivegrid", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.recursivegrid"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.meshes", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.meshes"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.clusters", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.clusters"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.keyframes", () -> EventManager.publish(Event.TOGGLE_VISIBILITY_CMD, this, "element.keyframes"), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.dividetime", () -> EventManager.publish(Event.TIME_WARP_DECREASE_CMD, this, new Object[0]), 500L, new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.doubletime", () -> EventManager.publish(Event.TIME_WARP_INCREASE_CMD, this, new Object[0]), 500L, new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.time.warp.reset", () -> EventManager.publish(Event.TIME_WARP_CMD, this, 1.0), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.pauseresume", () -> {
            if (!GaiaSky.instance.cameraManager.mode.isGame()) {
                EventManager.publish(Event.TIME_STATE_CMD, this, !Settings.settings.runtime.timeOn);
            }
        }, new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.incfov", () -> EventManager.publish(Event.FOV_CHANGED_CMD, this, Float.valueOf(Settings.settings.scene.camera.fov + 1.0f)), noSlaveProj));
        this.addAction(new ProgramAction("action.decfov", () -> EventManager.publish(Event.FOV_CHANGED_CMD, this, Float.valueOf(Settings.settings.scene.camera.fov - 1.0f)), noSlaveProj));
        this.addAction(new ProgramAction("action.togglefs", () -> {
            Settings.settings.graphics.fullScreen.active = !Settings.settings.graphics.fullScreen.active;
            EventManager.publish(Event.SCREEN_MODE_CMD, this, new Object[0]);
        }, new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.screenshot", () -> EventManager.publish(Event.SCREENSHOT_CMD, this, Settings.settings.screenshot.resolution[0], Settings.settings.screenshot.resolution[1], Settings.settings.screenshot.location), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.screenshot.cubemap", () -> EventManager.publish(Event.SCREENSHOT_CUBEMAP_CMD, this, Settings.settings.screenshot.location), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.frameoutput", () -> EventManager.publish(Event.FRAME_OUTPUT_CMD, this, !Settings.settings.frame.active), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.controls", () -> EventManager.publish(Event.GUI_FOLD_CMD, this, new Object[0]), fullGuiCondition, noCleanMode));
        this.addAction(new ProgramAction("action.toggle/element.planetarium", () -> {
            boolean enable = !Settings.settings.program.modeCubemap.active || !Settings.settings.program.modeCubemap.isPlanetariumOn();
            EventManager.publish(Event.CUBEMAP_CMD, this, new Object[]{enable, CubmeapProjectionEffect.CubemapProjection.AZIMUTHAL_EQUIDISTANT});
        }, noPanorama, noOrthoSphere));
        this.addAction(new ProgramAction("action.toggle/element.planetarium.projection", () -> {
            if (Settings.settings.program.modeCubemap.isPlanetariumOn()) {
                int newProjectionIndex = Settings.settings.program.modeCubemap.projection.getNextPlanetariumProjection().ordinal();
                EventManager.publish(Event.PLANETARIUM_PROJECTION_CMD, this, new Object[]{CubmeapProjectionEffect.CubemapProjection.values()[newProjectionIndex]});
            }
        }, noPanorama, noOrthoSphere));
        this.addAction(new ProgramAction("action.toggle/element.360", () -> {
            boolean enable = !Settings.settings.program.modeCubemap.active || !Settings.settings.program.modeCubemap.isPanoramaOn();
            EventManager.publish(Event.CUBEMAP_CMD, this, new Object[]{enable, CubmeapProjectionEffect.CubemapProjection.EQUIRECTANGULAR});
        }, noPlanetarium, noOrthoSphere));
        this.addAction(new ProgramAction("action.toggle/element.projection", () -> {
            if (Settings.settings.program.modeCubemap.isPanoramaOn()) {
                int newProjectionIndex = Settings.settings.program.modeCubemap.projection.getNextPanoramaProjection().ordinal();
                EventManager.publish(Event.CUBEMAP_PROJECTION_CMD, this, new Object[]{CubmeapProjectionEffect.CubemapProjection.values()[newProjectionIndex]});
            }
        }, noPlanetarium, noOrthoSphere));
        this.addAction(new ProgramAction("action.toggle/element.orthosphere", () -> {
            boolean enable = !Settings.settings.program.modeCubemap.active || !Settings.settings.program.modeCubemap.isOrthosphereOn();
            EventManager.publish(Event.CUBEMAP_CMD, this, new Object[]{enable, CubmeapProjectionEffect.CubemapProjection.ORTHOSPHERE});
        }, noPlanetarium, noPanorama));
        this.addAction(new ProgramAction("action.toggle/element.orthosphere.profile", () -> {
            if (Settings.settings.program.modeCubemap.isOrthosphereOn()) {
                int newProfileIndex = Settings.settings.program.modeCubemap.projection.getNextOrthosphereProfile().ordinal();
                EventManager.publish(Event.CUBEMAP_PROJECTION_CMD, this, new Object[]{CubmeapProjectionEffect.CubemapProjection.values()[newProfileIndex]});
            }
        }, new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.starpointsize.inc", () -> EventManager.publish(Event.STAR_POINT_SIZE_INCREASE_CMD, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.starpointsize.dec", () -> EventManager.publish(Event.STAR_POINT_SIZE_DECREASE_CMD, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.starpointsize.reset", () -> EventManager.publish(Event.STAR_POINT_SIZE_RESET_CMD, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.keyframe", () -> EventManager.publish(Event.KEYFRAME_ADD, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.debugmode", () -> EventManager.publish(Event.SHOW_DEBUG_CMD, this, new Object[0]), noCleanMode));
        Runnable runnableSearch = () -> EventManager.publish(Event.SHOW_SEARCH_ACTION, this, new Object[0]);
        this.addAction(new ProgramAction("action.search", runnableSearch, fullGuiCondition, noCleanMode));
        this.addAction(new ProgramAction("action.toggle/element.octreeparticlefade", () -> EventManager.publish(Event.OCTREE_PARTICLE_FADE_CMD, this, !Settings.settings.scene.octree.fade), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.stereomode", () -> EventManager.publish(Event.STEREOSCOPIC_CMD, this, !Settings.settings.program.modeStereo.active), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.switchstereoprofile", () -> {
            int newidx = Settings.settings.program.modeStereo.profile.ordinal();
            newidx = (newidx + 1) % Settings.StereoProfile.values().length;
            EventManager.publish(Event.STEREO_PROFILE_CMD, this, newidx);
        }, new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/element.cleanmode", () -> EventManager.publish(Event.DISPLAY_GUI_CMD, this, !Settings.settings.runtime.displayGui, I18n.msg("notif.cleanmode")), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.gotoobject", () -> EventManager.publish(Event.GO_TO_OBJECT_CMD, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.resettime", () -> EventManager.publish(Event.TIME_CHANGE_CMD, this, Instant.now()), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.home", () -> EventManager.publish(Event.HOME_CMD, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.expandcollapse.pane/gui.time", () -> EventManager.publish(Event.TOGGLE_EXPANDCOLLAPSE_PANE_CMD, this, "TimeComponent"), noCleanMode));
        this.addAction(new ProgramAction("action.expandcollapse.pane/gui.camera", () -> EventManager.publish(Event.TOGGLE_EXPANDCOLLAPSE_PANE_CMD, this, "CameraComponent"), noCleanMode));
        this.addAction(new ProgramAction("action.expandcollapse.pane/gui.visibility", () -> EventManager.publish(Event.TOGGLE_EXPANDCOLLAPSE_PANE_CMD, this, "VisibilityComponent"), noCleanMode));
        this.addAction(new ProgramAction("action.expandcollapse.pane/gui.lighting", () -> EventManager.publish(Event.TOGGLE_EXPANDCOLLAPSE_PANE_CMD, this, "VisualSettingsComponent"), noCleanMode));
        this.addAction(new ProgramAction("action.expandcollapse.pane/gui.dataset.title", () -> EventManager.publish(Event.TOGGLE_EXPANDCOLLAPSE_PANE_CMD, this, "DatasetsComponent"), noCleanMode));
        this.addAction(new ProgramAction("action.expandcollapse.pane/gui.bookmarks", () -> EventManager.publish(Event.TOGGLE_EXPANDCOLLAPSE_PANE_CMD, this, "BookmarksComponent"), noCleanMode));
        this.addAction(new ProgramAction("action.toggle/gui.mousecapture", () -> EventManager.publish(Event.MOUSE_CAPTURE_TOGGLE, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.ui.reload", () -> EventManager.publish(Event.UI_RELOAD_CMD, this, GaiaSky.instance.getGlobalResources()), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.shaders.reload", () -> EventManager.publish(Event.SHADER_RELOAD_CMD, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.slave.configure", () -> EventManager.publish(Event.SHOW_SLAVE_CONFIG_ACTION, this, new Object[0]), masterWithSlaves));
        for (CameraManager.CameraMode mode : CameraManager.CameraMode.values()) {
            this.addAction(new ProgramAction("camera.full/camera." + mode.toString(), () -> EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{mode}), new BooleanRunnable[0]));
        }
        this.addAction(new ProgramAction("action.toggle/camera.mode", () -> {
            CameraManager.CameraMode oldMode = GaiaSky.instance.getCameraManager().getMode();
            CameraManager.CameraMode newMode = CameraManager.CameraMode.values()[(oldMode.ordinal() + 1) % CameraManager.CameraMode.values().length];
            EventManager.publish(Event.CAMERA_MODE_CMD, this, new Object[]{newMode});
        }, new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.toggle/camera.cinematic", () -> EventManager.publish(Event.CAMERA_CINEMATIC_CMD, this, !Settings.settings.scene.camera.cinematic), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.camera.speedup", () -> {}, new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.controller.gui.in", () -> EventManager.publish(Event.SHOW_CONTROLLER_GUI_ACTION, this, new Object[0]), new BooleanRunnable[0]));
        this.addAction(new ProgramAction("action.upscale", () -> {
            Settings.UpscaleFilter filter = Settings.settings.postprocess.upscaleFilter;
            Settings.UpscaleFilter newFilter = Settings.UpscaleFilter.values()[(filter.ordinal() + 1) % Settings.UpscaleFilter.values().length];
            EventManager.publish(Event.UPSCALE_FILTER_CMD, this, new Object[]{newFilter});
            logger.info("Upscaling filter: " + String.valueOf((Object)newFilter));
        }, new BooleanRunnable[0]));
    }

    private void initMappings() {
        String mappingsFileName = "keyboard.mappings";
        Path customMappings = SysUtils.getDefaultMappingsDir().resolve("keyboard.mappings");
        Path defaultMappings = Paths.get(Settings.ASSETS_LOC, SysUtils.getMappingsDirName(), "keyboard.mappings");
        if (!Files.exists(customMappings, new LinkOption[0])) {
            this.overwriteMappingsFile(defaultMappings, customMappings, false);
        } else {
            Optional<String> customVersionStr = TextUtils.readFirstLine(customMappings);
            Optional<String> defaultVersionStr = TextUtils.readFirstLine(defaultMappings);
            if (customVersionStr.isEmpty() || !customVersionStr.get().startsWith("#v")) {
                this.overwriteMappingsFile(defaultMappings, customMappings, true);
            } else if (defaultVersionStr.isPresent()) {
                int customVersion = Parser.parseInt(customVersionStr.get().substring(2));
                int defaultVersion = Parser.parseInt(defaultVersionStr.get().substring(2));
                if (defaultVersion > customVersion) {
                    this.overwriteMappingsFile(defaultMappings, customMappings, true);
                }
            }
        }
        logger.info(I18n.msg("notif.kbd.mappings.file.use", customMappings));
        try {
            Array<Pair<String, String>> mappings = this.readMappingsFile(customMappings);
            for (Pair mapping : mappings) {
                String key = (String)mapping.getFirst();
                ProgramAction action = this.actions.get(key);
                if (action != null) {
                    String[] keyMappings = ((String)mapping.getSecond()).trim().split("\\s+");
                    int[] keyCodes = new int[keyMappings.length];
                    for (int i = 0; i < keyMappings.length; ++i) {
                        keyCodes[i] = GSKeys.valueOf(keyMappings[i]);
                    }
                    this.addMapping(action, keyCodes);
                    continue;
                }
                logger.warn(I18n.msg("notif.kbd.mappings.action.notfound", key));
            }
        }
        catch (Exception e) {
            logger.error(e, I18n.msg("notif.kbd.mappings.error", customMappings));
        }
    }

    private void overwriteMappingsFile(Path src, Path dst, boolean backup) {
        assert (src != null && src.toFile().exists() && src.toFile().isFile() && src.toFile().canRead()) : I18n.msg("error.file.exists.readable", src != null ? src.getFileName().toString() : "null");
        assert (dst != null) : I18n.msg("notif.null.not", "dest");
        if (backup && dst.toFile().exists() && dst.toFile().canRead()) {
            Date date = Calendar.getInstance().getTime();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-hhmmss");
            String strDate = dateFormat.format(date);
            String backupName = dst.getFileName().toString() + "." + strDate;
            Path backupFile = dst.getParent().resolve(backupName);
            try {
                Files.copy(dst, backupFile, StandardCopyOption.REPLACE_EXISTING);
                logger.info(I18n.msg("notif.file.backup", backupFile));
            }
            catch (IOException e) {
                logger.error(e);
            }
        }
        try {
            Files.copy(src, dst, StandardCopyOption.REPLACE_EXISTING);
            logger.info(I18n.msg("notif.file.update", dst.toString()));
            if (backup) {
                EventManager.publishWaitUntilConsumer(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.file.overriden.backup", dst.toString()), Float.valueOf(-1.0f));
            } else {
                EventManager.publishWaitUntilConsumer(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.file.overriden", dst.toString()), Float.valueOf(-1.0f));
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    private Array<Pair<String, String>> readMappingsFile(Path file) throws IOException {
        String line;
        Array result = new Array();
        InputStream is = Files.newInputStream(file, new OpenOption[0]);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] strPair = line.split("=");
            result.add(new Pair<String, String>(strPair[0].trim(), strPair[1].trim()));
        }
        reader.close();
        return result;
    }

    public static class ProgramAction
    implements Runnable,
    Comparable<ProgramAction> {
        public final long maxKeyDownTimeMs;
        final String actionId;
        public final String actionName;
        private final Runnable action;
        private final BooleanRunnable[] conditions;

        ProgramAction(String actionId, Runnable action, long maxKeyDownTimeMs, BooleanRunnable ... conditions) {
            String actionName;
            this.actionId = actionId;
            try {
                if (actionId.contains("/")) {
                    String[] actions = actionId.split("/");
                    actionName = I18n.msg(actions[0], I18n.msg(actions[1]));
                } else {
                    actionName = I18n.msg(actionId);
                }
            }
            catch (MissingResourceException e) {
                actionName = actionId;
            }
            this.actionName = actionName;
            this.action = action;
            this.conditions = conditions;
            this.maxKeyDownTimeMs = maxKeyDownTimeMs;
        }

        ProgramAction(String actionId, Runnable action, BooleanRunnable ... conditions) {
            this(actionId, action, 10000L, conditions);
        }

        @Override
        public void run() {
            if (this.evaluateConditions()) {
                this.action.run();
            }
        }

        private boolean evaluateConditions() {
            boolean result = true;
            if (this.conditions != null) {
                for (BooleanRunnable br : this.conditions) {
                    result = result && br.run();
                }
            }
            return result;
        }

        @Override
        public int compareTo(ProgramAction other) {
            return this.actionName.toLowerCase(Locale.ROOT).compareTo(other.actionName.toLowerCase(Locale.ROOT));
        }
    }

    public static interface BooleanRunnable {
        public boolean run();
    }
}

