/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.utils.TimeUtils;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.main.KeyBindings;
import gaiasky.input.InputUtils;
import gaiasky.input.KeyRegister;
import gaiasky.util.Settings;
import java.util.Objects;
import java.util.TreeSet;

public class KeyboardInputController
extends InputAdapter
implements IObserver {
    private final Input input;
    public KeyBindings mappings;
    public TreeSet<Integer> pressedKeys;
    private final KeyRegister register;

    public KeyboardInputController(Input input) {
        this.input = input;
        this.register = new KeyRegister();
        this.pressedKeys = new TreeSet();
        KeyBindings.initialize();
        this.mappings = KeyBindings.instance;
        EventManager.instance.subscribe((IObserver)this, Event.CLEAN_PRESSED_KEYS);
    }

    public boolean keyDown(int keyCode) {
        keyCode = InputUtils.physicalToLogicalKeyCode(keyCode);
        this.cleanSpecial();
        if (Settings.settings.runtime.inputEnabled) {
            this.pressedKeys.add(keyCode);
            this.register.registerKeyDownTime(keyCode, TimeUtils.millis());
        }
        return false;
    }

    public boolean keyUp(int keyCode) {
        keyCode = InputUtils.physicalToLogicalKeyCode(keyCode);
        EventManager.publish(Event.INPUT_EVENT, this, keyCode);
        this.cleanSpecial();
        long now = System.currentTimeMillis();
        if (Settings.settings.runtime.inputEnabled) {
            KeyBindings.ProgramAction action = this.mappings.getMappings().get(this.pressedKeys);
            if (action != null && now - this.register.lastKeyDownTime(this.pressedKeys) < action.maxKeyDownTimeMs) {
                action.run();
            }
        } else if (keyCode == 111) {
            EventManager.publish(Event.SHOW_QUIT_ACTION, this, new Object[0]);
        }
        this.pressedKeys.remove(keyCode);
        return false;
    }

    private void cleanSpecial() {
        for (int special : KeyBindings.SPECIAL) {
            if (this.input.isKeyPressed(special)) continue;
            this.pressedKeys.remove(special);
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (Objects.requireNonNull(event) == Event.CLEAN_PRESSED_KEYS && this.pressedKeys != null) {
            this.pressedKeys.clear();
        }
    }
}

