/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.NotificationsInterface;
import gaiasky.gui.main.AbstractGui;
import gaiasky.gui.main.VersionLineTable;
import gaiasky.gui.vr.FixedScreenViewport;
import gaiasky.util.LoadingTextGenerator;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.TipsGenerator;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.StdRandom;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import java.util.Objects;

public class LoadingGui
extends AbstractGui {
    private static final long tipTime = 3500L;
    public NotificationsInterface notificationsInterface;
    protected Table center;
    protected Table topLeft;
    protected Table bottomMiddle;
    protected Table screenMode;
    private TipsGenerator tipGenerator;
    private LoadingTextGenerator loadingTextGenerator;
    private OwnLabel spin;
    private HorizontalGroup tip;
    private long lastFunnyTime;
    private long lastTipTime;
    private long funnyTextTime = 1400L;

    public LoadingGui(Skin skin, Graphics graphics, Float unitsPerPixel, Boolean vr) {
        super(graphics, unitsPerPixel);
        this.vr = vr;
        this.skin = skin;
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        Object vp;
        this.interfaces = new Array();
        float pad30 = 48.0f;
        float pad10 = 16.0f;
        Settings settings = Settings.settings;
        if (this.vr) {
            vp = new FixedScreenViewport(this.getBackBufferWidth(), this.getBackBufferHeight());
        } else {
            vp = new ScreenViewport();
            vp.setUnitsPerPixel(this.unitsPerPixel);
        }
        this.stage = new Stage((Viewport)vp, (Batch)sb);
        if (this.vr) {
            vp.update(settings.graphics.backBufferResolution[0], settings.graphics.backBufferResolution[1], true);
        } else {
            vp.update(GaiaSky.instance.graphics.getWidth(), GaiaSky.instance.graphics.getHeight(), true);
        }
        this.center = new Table(this.skin);
        if (!this.vr) {
            Texture tex = new Texture(OwnTextureLoader.Factory.loadFromFile(Gdx.files.internal("img/splash/splash.jpg"), false));
            SpriteDrawable bg = new SpriteDrawable(new Sprite(tex));
            this.center.setBackground((Drawable)bg);
        }
        this.center.setFillParent(true);
        this.center.center();
        Table centerContent = new Table(this.skin);
        centerContent.center();
        centerContent.setBackground("bg-pane");
        centerContent.pad(pad30);
        centerContent.padLeft(pad30 * 5.0f);
        centerContent.padRight(pad30 * 5.0f);
        Table titleGroup = new Table(this.skin);
        FileHandle gsIcon = Gdx.files.internal("icon/gs_icon_256.png");
        Texture iconTex = new Texture(gsIcon);
        iconTex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image logo = new Image(iconTex);
        logo.setScale(1.05f);
        logo.setOrigin(1);
        OwnLabel gaiaSky = new OwnLabel((CharSequence)Settings.getApplicationTitle(Settings.settings.runtime.openXr), this.skin, "main-title");
        gaiaSky.setFontScale(1.5f);
        OwnLabel version = new OwnLabel((CharSequence)Settings.settings.version.version, this.skin, "main-title");
        version.setColor(this.skin.getColor("blue"));
        Table title = new Table(this.skin);
        title.add((Actor)gaiaSky).bottom().left().padBottom(pad10).row();
        title.add((Actor)version).bottom().left().padRight(pad10);
        titleGroup.add((Actor)logo).center().padRight(pad30 * 2.0f);
        titleGroup.add((Actor)new Separator(this.skin, "default")).fillY().padRight(pad30);
        titleGroup.add((Actor)title);
        this.loadingTextGenerator = new LoadingTextGenerator();
        this.lastFunnyTime = 0L;
        this.spin = new OwnLabel((CharSequence)"0", this.skin, "main-title-s");
        this.spin.setColor(this.skin.getColor("theme"));
        centerContent.add((Actor)titleGroup).width(1300.0f).center().padBottom(pad30 * 2.0f).row();
        centerContent.add((Actor)this.spin).padBottom(pad30).row();
        if (this.vr) {
            this.bottomMiddle = new VersionLineTable(this.skin, true);
            this.bottomMiddle.center().bottom();
        } else {
            this.tipGenerator = new TipsGenerator(this.skin);
            this.tip = new HorizontalGroup();
            this.tip.space(pad10);
            this.tip.pad(10.0f, 30.0f, 10.0f, 30.0f);
            Container tipContainer = new Container((Actor)this.tip);
            tipContainer.setBackground(this.skin.getDrawable("table-bg"));
            this.bottomMiddle = new Table(this.skin);
            this.bottomMiddle.setFillParent(true);
            this.bottomMiddle.center().bottom();
            this.bottomMiddle.padBottom(pad30);
            this.bottomMiddle.add((Actor)tipContainer).fillX().expandX().height(90.0f);
        }
        this.topLeft = new VersionLineTable(this.skin);
        if (!this.vr) {
            this.screenMode = new Table(this.skin);
            this.screenMode.setFillParent(true);
            this.screenMode.top().right();
            this.screenMode.pad(pad10);
            OwnTextIconButton screenModeButton = new OwnTextIconButton("", this.skin, "screen-mode");
            screenModeButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.fullscreen"), this.skin, 10));
            screenModeButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    settings.graphics.fullScreen.active = !settings.graphics.fullScreen.active;
                    EventManager.publish(Event.SCREEN_MODE_CMD, (Object)screenModeButton, new Object[0]);
                    return true;
                }
                return false;
            });
            this.screenMode.add((Actor)screenModeButton);
        }
        this.notificationsInterface = new NotificationsInterface(this.skin, this.lock, false, false, false);
        this.notificationsInterface.setIgnoreDisplaySetting(true);
        centerContent.add((Actor)this.notificationsInterface);
        this.center.add((Actor)centerContent).center().size(1500.0f, 750.0f);
        this.interfaces.add((Object)this.notificationsInterface);
        this.rebuildGui();
        EventManager.instance.subscribe((IObserver)this, Event.UI_SCALE_RECOMPUTE_CMD);
        EventManager.publish(Event.UI_SCALE_RECOMPUTE_CMD, this, new Object[0]);
    }

    @Override
    public void update(double dt) {
        super.update(dt);
        long currTime = System.currentTimeMillis();
        if (currTime - this.lastFunnyTime > this.funnyTextTime) {
            this.randomFunnyText();
            this.lastFunnyTime = currTime;
            this.funnyTextTime = StdRandom.uniform(1500, 3000);
        }
        if (!this.vr && currTime - this.lastTipTime > 3500L) {
            this.tipGenerator.newTip((WidgetGroup)this.tip);
            this.lastTipTime = currTime;
        }
    }

    private void randomFunnyText() {
        if (Settings.settings.runtime.openXr) {
            this.spin.setText(I18n.msg("gui.loading"));
        } else {
            try {
                this.spin.setText(TextUtils.capitalise(this.loadingTextGenerator.next()));
            }
            catch (Exception e) {
                this.spin.setText(I18n.msg("gui.loading"));
            }
        }
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
    }

    @Override
    public void rebuildGui() {
        if (this.stage != null) {
            this.stage.clear();
            this.stage.addActor((Actor)this.center);
            this.stage.addActor((Actor)this.bottomMiddle);
            if (!this.vr) {
                this.stage.addActor((Actor)this.screenMode);
                this.stage.addActor((Actor)this.topLeft);
            }
        }
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (Objects.requireNonNull(event) == Event.UI_SCALE_RECOMPUTE_CMD) {
            int height = data != null && data.length > 0 ? ((Integer)data[0]).intValue() : Gdx.graphics.getHeight();
            GaiaSky.instance.applyUIScale(height, this);
        }
    }
}

