/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import gaiasky.util.i18n.I18n;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

public record MessageBean(String msg, Instant date) {
    private static final String TAG_SEPARATOR = " - ";
    private static final DateTimeFormatter df = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(I18n.locale).withZone(ZoneOffset.UTC);

    public MessageBean(String msg) {
        this(msg, Instant.now());
    }

    public boolean finished(long timeout) {
        return Instant.now().toEpochMilli() - this.date.toEpochMilli() > timeout;
    }

    @Override
    public String toString() {
        return this.formatMessage(true);
    }

    public String formatMessage(boolean writeDates) {
        return (String)(writeDates ? df.format(this.date) + TAG_SEPARATOR : "") + this.msg;
    }
}

