/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.ashley.core.Entity;
import com.badlogic.ashley.utils.ImmutableArray;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.gui.beans.DistanceUnitComboBoxBean;
import gaiasky.gui.beans.OrientationComboBoxBean;
import gaiasky.gui.beans.PrimitiveComboBoxBean;
import gaiasky.gui.beans.ShapeComboBoxBean;
import gaiasky.gui.window.AddShapeDialog;
import gaiasky.scene.Mapper;
import gaiasky.scene.Scene;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.Ruler;
import gaiasky.scene.component.Shape;
import gaiasky.scene.view.FocusView;
import gaiasky.util.CatalogInfo;
import gaiasky.util.CatalogManager;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.camera.CameraUtils;
import gaiasky.util.gravwaves.RelativisticEffectsManager;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.scene2d.ContextMenu;
import gaiasky.util.scene2d.MenuItem;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnImage;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public class SceneContextMenu
extends ContextMenu {
    private final Skin skin;
    private final FocusView candidate;
    private final int screenX;
    private final int screenY;
    private final float pad;
    private final CatalogManager catalogManager;
    private final Scene scene;
    private final AtomicBoolean relativisticEffects = new AtomicBoolean(false);
    private String candidateName;
    private String candidateNameShort;
    private int nItems = 0;

    public SceneContextMenu(Skin skin, String styleName, int screenX, int screenY, FocusView candidate, CatalogManager catalogManager, Scene scene) {
        super(skin, styleName);
        this.skin = skin;
        this.screenX = (int)((float)screenX / Settings.settings.program.ui.scale);
        this.screenY = screenY;
        this.candidate = candidate;
        this.catalogManager = catalogManager;
        this.pad = 8.0f;
        this.scene = scene;
        if (candidate != null && candidate.isValid()) {
            this.candidateName = candidate.getCandidateName();
            this.candidateNameShort = this.candidateName != null ? TextUtils.capString(this.candidateName, 10) : "";
        }
        this.build();
    }

    @Override
    public void addItem(MenuItem item) {
        super.addItem(item);
        ++this.nItems;
    }

    private void build() {
        MenuItem cim;
        Ruler ruler;
        Entity cr;
        Drawable rulerDwb = this.skin.getDrawable("icon-elem-ruler");
        if (this.candidate != null && this.candidate.isValid()) {
            MenuItem select = new MenuItem(I18n.msg("context.select", this.candidateNameShort), this.skin, this.skin.getDrawable("highlight-off"));
            select.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(Event.CAMERA_MODE_CMD, (Object)select, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                    EventManager.publish(Event.FOCUS_CHANGE_CMD, (Object)select, this.candidate);
                }
                return false;
            });
            this.addItem(select);
            MenuItem go = new MenuItem(I18n.msg("context.goto", this.candidateNameShort), this.skin, this.skin.getDrawable("go-to"));
            go.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.candidate.makeFocus();
                    EventManager.publish(Event.NAVIGATE_TO_OBJECT, (Object)go, this.candidate);
                }
                return false;
            });
            this.addItem(go);
            MenuItem moreInfo = new MenuItem(I18n.msg("context.moreinfo", this.candidateNameShort), this.skin, this.skin.getDrawable("iconic-info"));
            moreInfo.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(Event.SHOW_DATA_INFO_CMD, (Object)moreInfo, this.candidate);
                }
                return false;
            });
            this.addItem(moreInfo);
            this.addSeparator();
            MenuItem track = new MenuItem(I18n.msg("context.track", this.candidateNameShort), this.skin, this.skin.getDrawable("highlight-on"));
            track.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(Event.CAMERA_TRACKING_OBJECT_CMD, (Object)track, this.candidate.getEntity(), this.candidateName);
                }
                return false;
            });
            this.addItem(track);
            MenuItem noTrack = new MenuItem(I18n.msg("context.notrack", this.candidateNameShort), this.skin, this.skin.getDrawable("iconic-delete"));
            noTrack.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(Event.CAMERA_TRACKING_OBJECT_CMD, (Object)noTrack, null, null);
                }
                return false;
            });
            this.addItem(noTrack);
            this.addSeparator();
            Object addShape = new MenuItem(I18n.msg("context.shape.new", this.candidateNameShort), this.skin, this.skin.getDrawable("icon-elem-grids"));
            addShape.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    AddShapeDialog dialog = new AddShapeDialog(I18n.msg("context.shape.new", this.candidateNameShort), this.candidate, this.candidateName, this.skin, this.getStage());
                    dialog.setAcceptListener(() -> {
                        double size = ((DistanceUnitComboBoxBean)dialog.units.getSelected()).unit.toKm(dialog.size.getDoubleValue(1.0)) * 2.0;
                        float[] color = dialog.color.getPickedColor();
                        String shape = ((ShapeComboBoxBean)dialog.shape.getSelected()).shape.toString();
                        String primitive = ((PrimitiveComboBoxBean)dialog.primitive.getSelected()).primitive.toString();
                        String orientation = ((OrientationComboBoxBean)dialog.orientation.getSelected()).orientation.toString();
                        boolean showLabel = dialog.showLabel.isChecked();
                        boolean trackObj = dialog.track.isChecked();
                        GaiaSky.instance.scripting().addShapeAroundObject(dialog.name.getText().trim(), shape, primitive, orientation, size, this.candidateName, color[0], color[1], color[2], color[3], showLabel, trackObj);
                    });
                    dialog.show(this.getStage());
                    return true;
                }
                return false;
            });
            this.addItem((MenuItem)((Object)addShape));
            MenuItem removeShapesObj = new MenuItem(I18n.msg("context.shape.remove", this.candidateNameShort), this.skin, this.skin.getDrawable("iconic-delete"));
            removeShapesObj.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    GaiaSky.postRunnable(() -> {
                        ImmutableArray shapes = this.scene.engine.getEntitiesFor(this.scene.getFamilies().shapes);
                        for (Entity entity : shapes) {
                            Shape shape = (Shape)Mapper.shape.get(entity);
                            if (shape.track != null && shape.track.getEntity() == this.candidate.getEntity()) {
                                EventManager.publish(Event.SCENE_REMOVE_OBJECT_CMD, (Object)removeShapesObj, entity, false);
                                continue;
                            }
                            if (shape.trackName == null || !shape.trackName.equalsIgnoreCase(this.candidateName)) continue;
                            EventManager.publish(Event.SCENE_REMOVE_OBJECT_CMD, (Object)removeShapesObj, entity, false);
                        }
                    });
                }
                return false;
            });
            this.addItem(removeShapesObj);
            MenuItem removeShapesAll = new MenuItem(I18n.msg("context.shape.remove.all"), this.skin, this.skin.getDrawable("iconic-delete"));
            removeShapesAll.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    GaiaSky.postRunnable(() -> {
                        ImmutableArray shapes = this.scene.engine.getEntitiesFor(this.scene.getFamilies().shapes);
                        for (Entity entity : shapes) {
                            Shape shape = (Shape)Mapper.shape.get(entity);
                            if (shape.track == null && shape.trackName == null) continue;
                            EventManager.publish(Event.SCENE_REMOVE_OBJECT_CMD, (Object)removeShapesAll, entity, false);
                        }
                    });
                }
                return false;
            });
            this.addItem(removeShapesAll);
            if (Mapper.atmosphere.has(this.candidate.getEntity())) {
                this.addSeparator();
                MenuItem landOn = new MenuItem(I18n.msg("context.landon", this.candidateNameShort), this.skin, this.skin.getDrawable("land-on"));
                landOn.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        EventManager.publish(Event.LAND_ON_OBJECT, (Object)landOn, this.candidate);
                        return true;
                    }
                    return false;
                });
                this.addItem(landOn);
                double[] lonlat = new double[2];
                FocusView view = this.candidate;
                boolean ok = CameraUtils.getLonLat(view, view.getEntity(), GaiaSky.instance.getICamera(), Gdx.input.getX(), Gdx.input.getY(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3D(), new Vector3D(), new Matrix4(), lonlat);
                if (ok) {
                    Double pointerLon = lonlat[0];
                    Double pointerLat = lonlat[1];
                    MenuItem landOnPointer = new MenuItem(I18n.msg("context.landatpointer", this.candidateNameShort), this.skin, this.skin.getDrawable("land-on"));
                    landOnPointer.addListener(event -> {
                        if (event instanceof ChangeListener.ChangeEvent) {
                            EventManager.publish(Event.LAND_AT_LOCATION_OF_OBJECT, (Object)landOnPointer, this.candidate, pointerLon, pointerLat);
                            return true;
                        }
                        return false;
                    });
                    this.addItem(landOnPointer);
                }
                MenuItem landOnCoord = new MenuItem(I18n.msg("context.landatcoord", this.candidateNameShort), this.skin, this.skin.getDrawable("land-at"));
                landOnCoord.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        EventManager.publish(Event.SHOW_LAND_AT_LOCATION_CMD, (Object)landOnCoord, this.candidate);
                        return true;
                    }
                    return false;
                });
                this.addItem(landOnCoord);
                this.addSeparator();
                MenuItem proceduralSurface = new MenuItem(I18n.msg("context.proceduralmenu", this.candidateNameShort), this.skin, this.skin.getDrawable("iconic-fork"));
                proceduralSurface.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        EventManager.publish(Event.SHOW_PROCEDURAL_GEN_CMD, (Object)proceduralSurface, this.candidate);
                        return true;
                    }
                    return false;
                });
                this.addItem(proceduralSurface);
            }
            this.addSeparator();
            Entity cr2 = this.scene.getEntity("Cosmicruler");
            if (cr2 != null) {
                Ruler ruler2 = (Ruler)Mapper.ruler.get(cr2);
                MenuItem rulerAttach0 = null;
                MenuItem rulerAttach1 = null;
                if (!ruler2.hasObject0() && !ruler2.hasObject1()) {
                    ra = rulerAttach0 = new MenuItem(I18n.msg("context.ruler.attach", "0", this.candidateNameShort), this.skin, rulerDwb);
                    rulerAttach0.addListener(ev -> {
                        if (ev instanceof ChangeListener.ChangeEvent) {
                            EventManager.publish(Event.RULER_ATTACH_0, (Object)ra, this.candidateName);
                            return true;
                        }
                        return false;
                    });
                } else if (ruler2.hasObject0() && !ruler2.hasObject1()) {
                    ra = rulerAttach1 = new MenuItem(I18n.msg("context.ruler.attach", "1", this.candidateNameShort), this.skin, rulerDwb);
                    rulerAttach1.addListener(ev -> {
                        if (ev instanceof ChangeListener.ChangeEvent) {
                            EventManager.publish(Event.RULER_ATTACH_1, (Object)ra, this.candidateName);
                            return true;
                        }
                        return false;
                    });
                } else {
                    MenuItem ra0 = rulerAttach0 = new MenuItem(I18n.msg("context.ruler.attach", "0", this.candidateNameShort), this.skin, rulerDwb);
                    rulerAttach0.addListener(ev -> {
                        if (ev instanceof ChangeListener.ChangeEvent) {
                            GaiaSky.postRunnable(() -> EventManager.publish(Event.RULER_ATTACH_0, (Object)ra0, this.candidateName));
                            return true;
                        }
                        return false;
                    });
                    MenuItem ra1 = rulerAttach1 = new MenuItem(I18n.msg("context.ruler.attach", "1", this.candidateNameShort), this.skin, rulerDwb);
                    rulerAttach1.addListener(ev -> {
                        if (ev instanceof ChangeListener.ChangeEvent) {
                            GaiaSky.postRunnable(() -> EventManager.publish(Event.RULER_ATTACH_1, (Object)ra1, this.candidateName));
                            return true;
                        }
                        return false;
                    });
                }
                if (rulerAttach0 != null) {
                    this.addItem(rulerAttach0);
                }
                if (rulerAttach1 != null) {
                    this.addItem(rulerAttach1);
                }
            }
        }
        if ((cr = this.scene.getEntity("Cosmicruler")) != null && ((ruler = (Ruler)Mapper.ruler.get(cr)).rulerOk() || ruler.hasAttached())) {
            MenuItem clearRuler = new MenuItem(I18n.msg("context.ruler.clear"), this.skin, rulerDwb);
            clearRuler.addListener(evt -> {
                if (evt instanceof ChangeListener.ChangeEvent) {
                    GaiaSky.postRunnable(() -> EventManager.publish(Event.RULER_CLEAR, (Object)clearRuler, new Object[0]));
                    return true;
                }
                return false;
            });
            this.addItem(clearRuler);
        }
        MenuItem dsLoad = new MenuItem(I18n.msg("context.dataset.load"), this.skin, this.skin.getDrawable("open-icon"));
        dsLoad.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_LOAD_CATALOG_ACTION, (Object)dsLoad, new Object[0]);
                return true;
            }
            return false;
        });
        this.addItem(dsLoad);
        Collection<CatalogInfo> cis = this.catalogManager.getCatalogInfos();
        if (cis != null && !cis.isEmpty()) {
            MenuItem dsHighlight = new MenuItem(I18n.msg("context.dataset.highlight"), this.skin, this.skin.getDrawable("highlight-on"));
            ContextMenu dsHighlightSubmenu = new ContextMenu(this.skin, "default");
            for (CatalogInfo ci : cis) {
                if (!ci.isVisible()) continue;
                cim = new MenuItem(ci.name, this.skin, "default");
                cim.align(16);
                OwnCheckBox cb = new OwnCheckBox(null, this.skin, this.pad);
                cb.setChecked(ci.highlighted);
                cim.add((Actor)cb).right().expand();
                cim.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        EventManager.publish(Event.CATALOG_HIGHLIGHT, (Object)cim, ci, !ci.highlighted);
                        return true;
                    }
                    return false;
                });
                dsHighlightSubmenu.addItem(cim);
            }
            dsHighlight.setSubMenu(dsHighlightSubmenu);
            this.addItem(dsHighlight);
        }
        if (cis != null && !cis.isEmpty()) {
            MenuItem dsVisibility = new MenuItem(I18n.msg("context.dataset.visibility"), this.skin, this.skin.getDrawable("eye-icon"));
            ContextMenu dsVisibilitySubmenu = new ContextMenu(this.skin, "default");
            for (CatalogInfo ci : cis) {
                cim = new MenuItem(ci.name, this.skin, "default");
                cim.align(16);
                Drawable icon = ci.isVisible(true) ? this.skin.getDrawable("eye-icon") : this.skin.getDrawable("eye-closed-icon");
                OwnImage img = new OwnImage(icon);
                cim.add((Actor)img).right().padRight(this.pad).expand();
                cim.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        EventManager.publish(Event.CATALOG_VISIBLE, (Object)cim, ci.name, !ci.isVisible(true));
                        return true;
                    }
                    return false;
                });
                dsVisibilitySubmenu.addItem(cim);
            }
            dsVisibility.setSubMenu(dsVisibilitySubmenu);
            this.addItem(dsVisibility);
        }
        this.addSeparator();
        if (this.candidate != null && this.candidate.isValid()) {
            MenuItem bookmarkObject = new MenuItem(I18n.msg("context.bookmark.object", this.candidateNameShort), this.skin, this.skin.getDrawable("iconic-star"));
            bookmarkObject.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(Event.BOOKMARKS_ADD, (Object)this, this.candidateName, false);
                }
                return false;
            });
            this.addItem(bookmarkObject);
        }
        MenuItem bookmarkPosition = new MenuItem(I18n.msg("context.bookmark.pos"), this.skin, this.skin.getDrawable("iconic-star"));
        bookmarkPosition.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_ADD_POSITION_BOOKMARK_ACTION, (Object)this, new Object[0]);
            }
            return false;
        });
        this.addItem(bookmarkPosition);
        if (this.relativisticEffects.get()) {
            MenuItem gravWaveStart = new MenuItem(I18n.msg("context.startgravwave"), this.skin, "default");
            gravWaveStart.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    EventManager.publish(Event.GRAV_WAVE_START, (Object)gravWaveStart, this.screenX, this.screenY);
                    return true;
                }
                return false;
            });
            this.addItem(gravWaveStart);
            if (RelativisticEffectsManager.getInstance().gravWavesOn()) {
                MenuItem gravWaveStop = new MenuItem(I18n.msg("context.stopgravwave"), this.skin, "default");
                gravWaveStop.addListener(event -> {
                    if (event instanceof ChangeListener.ChangeEvent) {
                        EventManager.publish(Event.GRAV_WAVE_STOP, (Object)gravWaveStop, new Object[0]);
                        return true;
                    }
                    return false;
                });
                this.addItem(gravWaveStop);
            }
        }
        if (this.nItems > 0) {
            this.addSeparator();
        }
        MenuItem preferences = new MenuItem(I18n.msg("gui.preferences"), this.skin, this.skin.getDrawable("prefs-icon"));
        preferences.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_PREFERENCES_ACTION, (Object)preferences, new Object[0]);
                return true;
            }
            return false;
        });
        this.addItem(preferences);
        MenuItem quit = new MenuItem(I18n.msg("context.quit"), this.skin, this.skin.getDrawable("quit-icon"));
        quit.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SHOW_QUIT_ACTION, (Object)quit, new Object[0]);
                return true;
            }
            return false;
        });
        this.addItem(quit);
    }
}

