/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.ashley.core.Entity;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.decals.Decal;
import com.badlogic.gdx.graphics.g3d.decals.DecalBatch;
import com.badlogic.gdx.graphics.g3d.decals.GroupStrategy;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Slider;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.ExtendViewport;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.main.AbstractGui;
import gaiasky.scene.camera.CameraManager;
import gaiasky.scene.component.MotorEngine;
import gaiasky.scene.record.MachineDefinition;
import gaiasky.scene.view.SpacecraftView;
import gaiasky.util.Bits;
import gaiasky.util.Constants;
import gaiasky.util.GlobalResources;
import gaiasky.util.Pair;
import gaiasky.util.Settings;
import gaiasky.util.gdx.IntModelBatch;
import gaiasky.util.gdx.IntModelBuilder;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.g3d.decals.CameraGroupStrategy;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.DepthTestAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;
import gaiasky.util.scene2d.OwnCheckBox;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnSelectBox;
import gaiasky.util.scene2d.OwnSlider;
import gaiasky.util.scene2d.OwnTextTooltip;
import java.text.DecimalFormat;
import net.jafama.FastMath;

public class SpacecraftGui
extends AbstractGui {
    private final DecimalFormat nf;
    private final DecimalFormat sf;
    private final Vector3 aux3f1;
    private final Vector3 aux3f2;
    private Table main;
    private OwnImageButton stabilise;
    private OwnImageButton stop;
    private OwnImageButton exit;
    private OwnImageButton enginePlus;
    private OwnImageButton engineMinus;
    private Slider enginePower;
    private Slider thrustv;
    private Slider thrusty;
    private Slider thrustp;
    private Slider thrustr;
    private Slider thrustvm;
    private Slider thrustym;
    private Slider thrustpm;
    private Slider thrustrm;
    private OwnLabel mainvel;
    private OwnLabel yawvel;
    private OwnLabel pitchvel;
    private OwnLabel rollvel;
    private OwnLabel closestname;
    private OwnLabel closestdist;
    private OwnLabel thrustfactor;
    private CheckBox velToDir;
    private SelectBox<MachineDefinition> machineSelector;
    private Entity sc;
    private final SpacecraftView view;
    private PerspectiveCamera aiCam;
    private IntModelBatch mb;
    private DecalBatch db;
    private SpriteBatch sb;
    private IntModelInstance aiModelInstance;
    private Texture aiPointerTexture;
    private Decal aiVelDec;
    private Decal aiAntivelDec;
    private Environment env;
    private Matrix4 aiTransform;
    private Viewport aiViewport;
    private Quaternion qf;
    private Vector3D vel;
    private float indicatorw;
    private float indicatorh;
    private float indicatorx;
    private float indicatory;
    private boolean thrustEvents = true;

    public SpacecraftGui(Skin skin, Graphics graphics, Float unitsPerPixel) {
        super(graphics, unitsPerPixel);
        this.skin = skin;
        this.aux3f1 = new Vector3();
        this.aux3f2 = new Vector3();
        this.view = new SpacecraftView();
        this.nf = new DecimalFormat("##0.##");
        this.sf = new DecimalFormat("#0.###E0");
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        this.sb = sb;
        ScreenViewport vp = new ScreenViewport();
        vp.setUnitsPerPixel(this.unitsPerPixel);
        this.stage = new Stage((Viewport)vp, (Batch)sb);
        this.indicatorw = 480.0f;
        this.indicatorh = 480.0f;
        this.indicatorx = -32.0f;
        this.indicatory = -20.0f;
        this.aiCam = new PerspectiveCamera(30.0f, this.indicatorw * Settings.settings.program.ui.scale, this.indicatorh * Settings.settings.program.ui.scale);
        this.aiCam.near = (float)(100000.0 * Constants.KM_TO_U);
        this.aiCam.far = (float)(1.0E8 * Constants.KM_TO_U);
        this.aiCam.up.set(0.0f, 1.0f, 0.0f);
        this.aiCam.direction.set(0.0f, 0.0f, 1.0f);
        this.aiCam.position.set(0.0f, 0.0f, 0.0f);
        DirectionalLight dlight = new DirectionalLight();
        dlight.color.set(1.0f, 1.0f, 1.0f, 1.0f);
        dlight.setDirection(-1.0f, 0.05f, 0.5f);
        this.env = new Environment();
        this.env.set((Attribute)new ColorAttribute(ColorAttribute.AmbientLight, 1.0f, 1.0f, 1.0f, 1.0f), (Attribute)new ColorAttribute(ColorAttribute.Specular, 0.5f, 0.5f, 0.5f, 1.0f));
        this.env.add(dlight);
        this.db = new DecalBatch(4, (GroupStrategy)new CameraGroupStrategy((Camera)this.aiCam));
        this.mb = new IntModelBatch();
        EventManager.instance.subscribe((IObserver)this, Event.SPACECRAFT_LOADED);
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
        GlobalResources globalResources = GaiaSky.instance.getGlobalResources();
        Texture aiTexture = globalResources.getTexture("attitude-indicator");
        this.aiPointerTexture = globalResources.getTexture("ai-pointer");
        Texture aiVelTex = globalResources.getTexture("ai-vel");
        Texture aiAntivelTex = globalResources.getTexture("ai-antivel");
        this.aiVelDec = Decal.newDecal((TextureRegion)new TextureRegion(aiVelTex));
        this.aiAntivelDec = Decal.newDecal((TextureRegion)new TextureRegion(aiAntivelTex));
        Material mat = new Material(new TextureAttribute(TextureAttribute.Diffuse, aiTexture), new ColorAttribute(ColorAttribute.Specular, 0.3f, 0.3f, 0.3f, 1.0f), new DepthTestAttribute(513, this.aiCam.near, this.aiCam.far, true));
        IntModel aiModel = new IntModelBuilder().createSphere(1.6f, 30, 30, false, mat, Bits.indices(1, 8, 128, 256, 16));
        this.aiTransform = new Matrix4();
        this.aiModelInstance = new IntModelInstance(aiModel, this.aiTransform);
        this.aiViewport = new ExtendViewport(this.indicatorw * Settings.settings.program.ui.scale, this.indicatorh * Settings.settings.program.ui.scale, (Camera)this.aiCam);
        EventManager.instance.subscribe((IObserver)this, Event.SPACECRAFT_STABILISE_CMD, Event.SPACECRAFT_STOP_CMD, Event.SPACECRAFT_INFO, Event.SPACECRAFT_NEAREST_INFO, Event.SPACECRAFT_THRUST_INFO);
        EventManager.instance.unsubscribe((IObserver)this, Event.SPACECRAFT_LOADED);
    }

    private void buildGui() {
        Container buttonContainer = new Container();
        HorizontalGroup buttonRow = new HorizontalGroup();
        buttonRow.space(4.8f);
        buttonRow.setFillParent(true);
        buttonRow.align(12);
        this.stabilise = new OwnImageButton(this.skin, "sc-stabilise");
        this.stabilise.setProgrammaticChangeEvents(false);
        this.stabilise.setName("stabilise");
        if (this.sc != null) {
            this.stabilise.setChecked(this.view.isStabilising());
        }
        this.stabilise.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SPACECRAFT_STABILISE_CMD, (Object)this.stabilise, this.stabilise.isChecked());
                return true;
            }
            return false;
        });
        this.stabilise.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.sc.stabilise"), this.skin));
        this.stop = new OwnImageButton(this.skin, "sc-stop");
        this.stop.setProgrammaticChangeEvents(false);
        this.stop.setName("stop spacecraft");
        if (this.sc != null) {
            this.stop.setChecked(this.view.isStopping());
        }
        this.stop.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SPACECRAFT_STOP_CMD, (Object)this.stop, this.stop.isChecked());
                return true;
            }
            return false;
        });
        this.stop.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.sc.stop"), this.skin));
        this.exit = new OwnImageButton(this.skin, "sc-exit");
        this.exit.setProgrammaticChangeEvents(false);
        this.exit.setName("exit spacecraft");
        this.exit.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.CAMERA_MODE_CMD, (Object)this.exit, new Object[]{CameraManager.CameraMode.FOCUS_MODE});
                return true;
            }
            return false;
        });
        this.exit.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.sc.exit"), this.skin));
        buttonRow.addActor((Actor)this.stabilise);
        buttonRow.addActor((Actor)this.stop);
        buttonRow.addActor((Actor)this.exit);
        buttonContainer.setActor((Actor)buttonRow);
        buttonContainer.pack();
        HorizontalGroup engineGroup = new HorizontalGroup();
        engineGroup.space(0.8f);
        engineGroup.align(12);
        float enginePowerH = 380.0f;
        Table engineControls = new Table(this.skin);
        engineControls.pad(0.0f);
        this.enginePlus = new OwnImageButton(this.skin, "sc-engine-power-up");
        this.enginePlus.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.sc.powerup"), this.skin));
        this.enginePlus.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SPACECRAFT_THRUST_INCREASE_CMD, (Object)this.enginePlus, new Object[0]);
                return true;
            }
            return false;
        });
        this.engineMinus = new OwnImageButton(this.skin, "sc-engine-power-down");
        this.enginePlus.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.tooltip.sc.powerdown"), this.skin));
        this.engineMinus.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SPACECRAFT_THRUST_DECREASE_CMD, (Object)this.engineMinus, new Object[0]);
                return true;
            }
            return false;
        });
        Group engineLabelRotated = new Group();
        OwnLabel engineLabel = new OwnLabel((CharSequence)I18n.msg("gui.sc.enginepower"), this.skin);
        engineLabelRotated.addActor((Actor)engineLabel);
        float engineLabelH = enginePowerH - this.enginePlus.getHeight() - this.engineMinus.getHeight() - 2.0f;
        engineLabelRotated.addAction((Action)Actions.rotateBy((float)-90.0f));
        engineLabelRotated.addAction((Action)Actions.moveBy((float)-5.0f, (float)((engineLabelH - this.enginePlus.getHeight() - engineLabel.getWidth()) / 2.0f + engineLabel.getWidth())));
        engineLabelRotated.setHeight(engineLabelH);
        engineControls.add((Actor)this.enginePlus);
        engineControls.row();
        engineControls.add((Actor)engineLabelRotated);
        engineControls.row();
        engineControls.add((Actor)this.engineMinus);
        this.enginePower = new OwnSlider(0.0f, (float)(MotorEngine.thrustFactor.length - 1), 1.0f, true, this.skin, "sc-engine");
        this.enginePower.setName("engine power slider");
        this.enginePower.setValue(0.0f);
        this.enginePower.setHeight(enginePowerH);
        this.enginePower.addListener(event -> {
            if (this.thrustEvents && event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.SPACECRAFT_THRUST_SET_CMD, this.enginePower, FastMath.round((float)this.enginePower.getValue()));
                return true;
            }
            return false;
        });
        engineGroup.addActor((Actor)this.enginePower);
        engineGroup.addActor((Actor)engineControls);
        engineGroup.pack();
        Table controlsGroup = new Table(this.skin);
        controlsGroup.align(10);
        this.machineSelector = new OwnSelectBox<MachineDefinition>(this.skin);
        this.machineSelector.setItems((Object[])this.view.getMachines());
        this.machineSelector.setSelected((Object)this.view.getMachines()[this.view.getCurrentMachine()]);
        this.machineSelector.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                int machineIndex = this.machineSelector.getSelectedIndex();
                EventManager.publish(Event.SPACECRAFT_MACHINE_SELECTION_CMD, this.machineSelector, machineIndex);
                return true;
            }
            return false;
        });
        this.velToDir = new OwnCheckBox(I18n.msg("gui.sc.veltodir"), this.skin, 16.0f);
        this.velToDir.setName("sc veltodir");
        this.velToDir.setChecked(Settings.settings.spacecraft.velocityDirection);
        this.velToDir.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                Settings.settings.spacecraft.velocityDirection = this.velToDir.isChecked();
            }
            return false;
        });
        controlsGroup.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.sc.spaceship"), this.skin, "sc-header")).left().padRight(16.0f).padBottom(8.0f);
        controlsGroup.add(this.machineSelector).left().padBottom(8.0f).row();
        controlsGroup.add((Actor)this.velToDir).left().colspan(2);
        controlsGroup.pack();
        float groupspacing = 10.0f;
        this.thrustfactor = new OwnLabel((CharSequence)"", this.skin);
        Container thrustContainer = new Container((Actor)this.thrustfactor);
        float labelWidth = 110.0f;
        float valueWidth = 150.0f;
        this.mainvel = new OwnLabel((CharSequence)"", this.skin);
        this.mainvel.setWidth(valueWidth);
        HorizontalGroup mvg = new HorizontalGroup();
        mvg.space(groupspacing);
        OwnLabel speed = new OwnLabel((CharSequence)(I18n.msg("gui.sc.velocity") + ":"), this.skin, "sc-header");
        speed.setWidth(labelWidth);
        mvg.addActor((Actor)speed);
        mvg.addActor((Actor)this.mainvel);
        this.yawvel = new OwnLabel((CharSequence)"", this.skin);
        this.yawvel.setWidth(valueWidth);
        HorizontalGroup yvg = new HorizontalGroup();
        yvg.space(groupspacing);
        OwnLabel yaw = new OwnLabel((CharSequence)(I18n.msg("gui.sc.yaw") + ":"), this.skin, "sc-header");
        yaw.setWidth(labelWidth);
        yvg.addActor((Actor)yaw);
        yvg.addActor((Actor)this.yawvel);
        this.pitchvel = new OwnLabel((CharSequence)"", this.skin);
        this.pitchvel.setWidth(valueWidth);
        HorizontalGroup pvg = new HorizontalGroup();
        pvg.space(groupspacing);
        OwnLabel pitch = new OwnLabel((CharSequence)(I18n.msg("gui.sc.pitch") + ":"), this.skin, "sc-header");
        pitch.setWidth(labelWidth);
        pvg.addActor((Actor)pitch);
        pvg.addActor((Actor)this.pitchvel);
        this.rollvel = new OwnLabel((CharSequence)"", this.skin);
        this.rollvel.setWidth(valueWidth);
        HorizontalGroup rvg = new HorizontalGroup();
        rvg.space(groupspacing);
        OwnLabel roll = new OwnLabel((CharSequence)(I18n.msg("gui.sc.roll") + ":"), this.skin, "sc-header");
        roll.setWidth(labelWidth);
        rvg.addActor((Actor)roll);
        rvg.addActor((Actor)this.rollvel);
        Table motionGroup = new Table(this.skin);
        motionGroup.align(10);
        motionGroup.add((Actor)mvg).left().row();
        motionGroup.add((Actor)yvg).left().row();
        motionGroup.add((Actor)pvg).left().row();
        motionGroup.add((Actor)rvg).left();
        motionGroup.pack();
        Table nearestGroup = new Table(this.skin);
        nearestGroup.align(10);
        this.closestname = new OwnLabel((CharSequence)"", this.skin);
        this.closestdist = new OwnLabel((CharSequence)"", this.skin);
        HorizontalGroup cng = new HorizontalGroup();
        cng.align(8);
        cng.space(groupspacing);
        cng.addActor((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.sc.nearest") + ":"), this.skin, "sc-header"));
        cng.addActor((Actor)this.closestname);
        HorizontalGroup cdg = new HorizontalGroup();
        cdg.align(8);
        cdg.space(groupspacing);
        cdg.addActor((Actor)new OwnLabel((CharSequence)(I18n.msg("gui.sc.distance") + ":"), this.skin, "sc-header"));
        cdg.addActor((Actor)this.closestdist);
        nearestGroup.add((Actor)cng).left().row();
        nearestGroup.add((Actor)cdg).left();
        nearestGroup.pack();
        float thrustHeight = 96.0f;
        float thrustWidth = 16.0f;
        VerticalGroup thrustGroup = new VerticalGroup();
        thrustGroup.space(1.6f);
        HorizontalGroup thrustPlus = new HorizontalGroup().space(1.0f);
        HorizontalGroup thrustMinus = new HorizontalGroup().space(1.0f);
        this.thrustv = new OwnSlider(0.0f, 1.0f, 0.05f, true, this.skin, "sc-thrust");
        this.thrustv.setHeight(thrustHeight);
        this.thrustv.setWidth(thrustWidth);
        this.thrustv.setDisabled(true);
        this.thrustvm = new OwnSlider(0.0f, 1.0f, 0.05f, true, this.skin, "sc-thrust-minus");
        this.thrustvm.setHeight(thrustHeight);
        this.thrustvm.setWidth(thrustWidth);
        this.thrustvm.setDisabled(true);
        this.thrusty = new OwnSlider(0.0f, 1.0f, 0.05f, true, this.skin, "sc-thrust");
        this.thrusty.setHeight(thrustHeight);
        this.thrusty.setWidth(thrustWidth);
        this.thrusty.setDisabled(true);
        this.thrustym = new OwnSlider(0.0f, 1.0f, 0.05f, true, this.skin, "sc-thrust-minus");
        this.thrustym.setHeight(thrustHeight);
        this.thrustym.setWidth(thrustWidth);
        this.thrustym.setDisabled(true);
        this.thrustp = new OwnSlider(0.0f, 1.0f, 0.05f, true, this.skin, "sc-thrust");
        this.thrustp.setHeight(thrustHeight);
        this.thrustp.setWidth(thrustWidth);
        this.thrustp.setDisabled(true);
        this.thrustpm = new OwnSlider(0.0f, 1.0f, 0.05f, true, this.skin, "sc-thrust-minus");
        this.thrustpm.setHeight(thrustHeight);
        this.thrustpm.setWidth(thrustWidth);
        this.thrustpm.setDisabled(true);
        this.thrustr = new OwnSlider(0.0f, 1.0f, 0.05f, true, this.skin, "sc-thrust");
        this.thrustr.setHeight(thrustHeight);
        this.thrustr.setWidth(thrustWidth);
        this.thrustr.setDisabled(true);
        this.thrustrm = new OwnSlider(0.0f, 1.0f, 0.05f, true, this.skin, "sc-thrust-minus");
        this.thrustrm.setHeight(thrustHeight);
        this.thrustrm.setWidth(thrustWidth);
        this.thrustrm.setDisabled(true);
        thrustPlus.addActor((Actor)this.thrustv);
        thrustMinus.addActor((Actor)this.thrustvm);
        thrustPlus.addActor((Actor)this.thrusty);
        thrustMinus.addActor((Actor)this.thrustym);
        thrustPlus.addActor((Actor)this.thrustp);
        thrustMinus.addActor((Actor)this.thrustpm);
        thrustPlus.addActor((Actor)this.thrustr);
        thrustMinus.addActor((Actor)this.thrustrm);
        thrustGroup.addActor((Actor)thrustPlus);
        thrustGroup.addActor((Actor)thrustMinus);
        thrustGroup.pack();
        Table motionThrustGroup = new Table(this.skin);
        motionThrustGroup.add((Actor)motionGroup).left().padBottom(50.0f).row();
        motionThrustGroup.add((Actor)thrustGroup).right();
        Table buttonNearestGroup = new Table(this.skin);
        buttonNearestGroup.add((Actor)buttonContainer).left().padRight(15.0f);
        buttonNearestGroup.add((Actor)nearestGroup).left();
        this.main = new Table(this.skin);
        this.main.setBackground("table-bg");
        this.main.setWidth(410.0f);
        this.main.setHeight(560.0f);
        this.main.setFillParent(false);
        this.main.bottom().left();
        this.main.pad(0.0f, 20.0f, 20.0f, 0.0f);
        float pad = 10.0f;
        this.main.add((Actor)controlsGroup).left().colspan(2).padBottom(pad).row();
        this.main.add((Actor)thrustContainer).left().colspan(2).row();
        this.main.add((Actor)engineGroup).left().padBottom(pad).padRight(pad * 8.0f);
        this.main.add((Actor)motionThrustGroup).left().top().padBottom(pad).row();
        this.main.add((Actor)buttonNearestGroup).left().colspan(2);
        this.rebuildGui();
    }

    @Override
    protected void rebuildGui() {
        if (this.stage != null && this.main != null) {
            this.stage.clear();
            this.stage.addActor((Actor)this.main);
            this.stage.addListener(new EventListener(){

                public boolean handle(com.badlogic.gdx.scenes.scene2d.Event event) {
                    if (event instanceof InputEvent) {
                        InputEvent ie = (InputEvent)event;
                        if (ie.getType() == InputEvent.Type.mouseMoved) {
                            Actor scrollPanelAncestor = this.getScrollPanelAncestor(ie.getTarget());
                            SpacecraftGui.this.stage.setScrollFocus(scrollPanelAncestor);
                        } else if (ie.getType() == InputEvent.Type.touchDown && ie.getTarget() instanceof TextField) {
                            SpacecraftGui.this.stage.setKeyboardFocus(ie.getTarget());
                        }
                    }
                    return false;
                }

                private Actor getScrollPanelAncestor(Actor actor) {
                    if (actor == null) {
                        return null;
                    }
                    if (actor instanceof ScrollPane) {
                        return actor;
                    }
                    return this.getScrollPanelAncestor((Actor)actor.getParent());
                }
            });
        }
    }

    @Override
    public void render(int rw, int rh) {
        this.stage.draw();
        this.aiViewport.setCamera((Camera)this.aiCam);
        this.aiViewport.setWorldSize(this.indicatorw / this.unitsPerPixel, this.indicatorh / this.unitsPerPixel);
        this.aiViewport.setScreenBounds((int)(this.indicatorx / this.unitsPerPixel), (int)(this.indicatory / this.unitsPerPixel), (int)(this.indicatorw / this.unitsPerPixel), (int)(this.indicatorh / this.unitsPerPixel));
        this.aiViewport.apply();
        this.mb.begin((Camera)this.aiCam);
        this.aiTransform.idt();
        this.aiTransform.translate(0.0f, 0.0f, 6.4f);
        this.aiTransform.rotate(this.qf);
        this.aiTransform.rotate(0.0f, 1.0f, 0.0f, 90.0f);
        this.mb.render((IntRenderableProvider)this.aiModelInstance, this.env);
        this.mb.end();
        if (!this.vel.isZero()) {
            this.aux3f1.set(this.vel.valuesF()).nor().scl(0.864f);
            this.aux3f1.mul(this.qf);
            this.aux3f1.add(0.0f, 0.0f, 6.3f);
            this.aiVelDec.setPosition(this.aux3f1);
            this.aiVelDec.setScale(0.0078f);
            this.aiVelDec.lookAt(this.aiCam.position, this.aiCam.up);
            this.aux3f2.set(this.vel.valuesF()).nor().scl(-0.864f);
            this.aux3f2.mul(this.qf);
            this.aux3f2.add(0.0f, 0.0f, 6.3f);
            this.aiAntivelDec.setPosition(this.aux3f2);
            this.aiAntivelDec.setScale(0.0048f);
            this.aiAntivelDec.lookAt(this.aiCam.position, this.aiCam.up);
            Gdx.gl.glEnable(3042);
            Gdx.gl.glEnable(2929);
            Gdx.gl.glDepthFunc(516);
            Gdx.gl.glDepthMask(true);
            this.db.add(this.aiVelDec);
            this.db.add(this.aiAntivelDec);
            this.db.flush();
        }
        this.aiViewport.setWorldSize((float)rw, (float)rh);
        this.aiViewport.setScreenBounds(0, 0, rw, rh);
        this.aiViewport.apply();
        this.sb.begin();
        this.sb.draw(this.aiPointerTexture, this.indicatorx + this.indicatorw / 2.0f - 16.0f, this.indicatory + this.indicatorh / 2.0f - 16.0f);
        this.sb.end();
    }

    @Override
    public void resizeImmediate(int width, int height) {
        this.stage.getViewport().update(width, height, true);
        this.rebuildGui();
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case SPACECRAFT_LOADED: {
                this.sc = (Entity)data[0];
                this.view.setEntity(this.sc);
                this.qf = this.view.getRotationQuaternion();
                this.vel = this.view.vel();
                this.buildGui();
                break;
            }
            case SPACECRAFT_STABILISE_CMD: {
                Boolean state = (Boolean)data[0];
                this.stabilise.setChecked(state);
                break;
            }
            case SPACECRAFT_STOP_CMD: {
                Boolean state = (Boolean)data[0];
                this.stop.setChecked(state);
                break;
            }
            case SPACECRAFT_INFO: {
                double y = -((Double)data[0]).doubleValue();
                double p = -((Double)data[1]).doubleValue();
                double r = (Double)data[2];
                double v = (Double)data[3];
                double thf = (Double)data[4];
                double epow = (Double)data[5];
                double ypow = (Double)data[6];
                double ppow = (Double)data[7];
                double rpow = (Double)data[8];
                this.yawvel.setText(this.nf.format(y) + "\u00b0");
                this.pitchvel.setText(this.nf.format(p) + "\u00b0");
                this.rollvel.setText(this.nf.format(r) + "\u00b0");
                Pair<Double, String> velstr = GlobalResources.doubleToVelocityString(v, Settings.settings.program.ui.distanceUnits);
                this.mainvel.setText(this.sf.format(velstr.getFirst()) + " " + velstr.getSecond());
                this.thrustfactor.setText("x" + (thf > 1000.0 ? this.sf.format(thf) : this.nf.format(thf)));
                this.setPowerValuesSlider(this.thrustv, this.thrustvm, epow);
                this.setPowerValuesSlider(this.thrusty, this.thrustym, ypow);
                this.setPowerValuesSlider(this.thrustp, this.thrustpm, ppow);
                this.setPowerValuesSlider(this.thrustr, this.thrustrm, rpow);
                break;
            }
            case SPACECRAFT_NEAREST_INFO: {
                if (data[0] != null) {
                    this.closestname.setText((String)data[0]);
                    Pair<Double, String> closestDistance = GlobalResources.doubleToDistanceString((Double)data[1], Settings.settings.program.ui.distanceUnits);
                    this.closestdist.setText(this.sf.format(closestDistance.getFirst()) + " " + closestDistance.getSecond());
                    break;
                }
                this.closestname.setText("");
                this.closestdist.setText("");
                break;
            }
            case SPACECRAFT_THRUST_INFO: {
                this.thrustEvents = false;
                this.enginePower.setValue((float)((Integer)data[0]).intValue());
                this.thrustEvents = true;
                break;
            }
        }
    }

    private void setPowerValuesSlider(Slider plus, Slider minus, double value) {
        plus.setValue((float)value);
        minus.setValue(1.0f + (float)value);
    }
}

