/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.iface.CustomInterface;
import gaiasky.gui.iface.NotificationsInterface;
import gaiasky.gui.main.AbstractGui;
import gaiasky.gui.main.KeyBindings;
import gaiasky.render.ComponentTypes;
import gaiasky.util.Settings;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnImageButton;
import gaiasky.util.scene2d.OwnTextHotkeyTooltip;
import java.text.DecimalFormat;

public class StereoGui
extends AbstractGui {
    private final Skin skin;
    protected NotificationsInterface notificationsOne;
    protected NotificationsInterface notificationsTwo;
    protected Container<Button> buttonContainer;
    protected Button back;
    protected CustomInterface customInterface;
    protected DecimalFormat nf;

    public StereoGui(Skin skin, Graphics graphics, Float unitsPerPixel) {
        super(graphics, unitsPerPixel);
        this.skin = skin;
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        ScreenViewport vp = new ScreenViewport();
        vp.setUnitsPerPixel(this.unitsPerPixel);
        this.stage = new Stage((Viewport)vp, (Batch)sb);
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
        this.interfaces = new Array();
        this.buildGui();
        EventManager.instance.subscribe((IObserver)this, Event.STEREO_PROFILE_CMD);
    }

    private void buildGui() {
        for (ComponentTypes.ComponentType ct : ComponentTypes.ComponentType.values()) {
            ct.getName();
        }
        this.nf = new DecimalFormat("##0.###");
        this.notificationsOne = new NotificationsInterface(this.skin, true, true, false, false);
        this.notificationsOne.setFillParent(true);
        this.notificationsOne.left().bottom();
        this.notificationsOne.pad(0.0f, 5.0f, 5.0f, 0.0f);
        this.interfaces.add((Object)this.notificationsOne);
        this.notificationsTwo = new NotificationsInterface(this.skin, true, true, false, false);
        this.notificationsTwo.setFillParent(true);
        this.notificationsTwo.bottom();
        this.notificationsTwo.setX((float)Gdx.graphics.getWidth() / 2.0f);
        this.notificationsTwo.pad(0.0f, 5.0f, 5.0f, 0.0f);
        this.interfaces.add((Object)this.notificationsTwo);
        float bw = 48.0f;
        float bh = 48.0f;
        KeyBindings kb = KeyBindings.instance;
        this.buttonContainer = new Container();
        this.back = new OwnImageButton(this.skin, "sc-exit");
        this.back.setSize(bw, bh);
        this.back.setName("exit stereo mode");
        this.back.addListener((EventListener)new OwnTextHotkeyTooltip(I18n.msg("gui.stereo.notice.back"), kb.getStringKeys("action.toggle/element.stereomode", true), this.skin));
        this.back.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                EventManager.publish(Event.STEREOSCOPIC_CMD, this, !Settings.settings.program.modeStereo.active);
            }
            return false;
        });
        this.buttonContainer.setActor((Actor)this.back);
        this.buttonContainer.setFillParent(true);
        this.buttonContainer.bottom().right().pad(0.0f, 0.0f, 5.0f, 5.0f);
        this.customInterface = new CustomInterface(this.stage, this.skin, this.lock);
        this.interfaces.add((Object)this.customInterface);
        this.rebuildGui();
    }

    @Override
    protected void rebuildGui() {
        if (this.stage != null) {
            this.stage.clear();
            if (this.notificationsOne != null) {
                this.stage.addActor((Actor)this.notificationsOne);
            }
            if (this.notificationsTwo != null) {
                this.stage.addActor((Actor)this.notificationsTwo);
            }
            if (this.buttonContainer != null) {
                this.stage.addActor(this.buttonContainer);
            }
        }
    }

    @Override
    public boolean cancelTouchFocus() {
        if (this.stage.getScrollFocus() != null) {
            this.stage.setScrollFocus(null);
            this.stage.setKeyboardFocus(null);
            return true;
        }
        return false;
    }

    @Override
    public void update(double dt) {
        this.notificationsTwo.setX(this.notificationsTwo.getMessagesWidth() / 2.0f);
        this.stage.act((float)dt);
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        if (event == Event.STEREO_PROFILE_CMD) {
            Settings.StereoProfile profile = Settings.StereoProfile.values()[(Integer)data[0]];
            this.notificationsTwo.setVisible(!profile.isAnaglyph());
        }
    }
}

