/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import gaiasky.util.Settings;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextTooltip;

public class VersionLineTable
extends Table {
    public VersionLineTable(Skin skin) {
        this(skin, false);
    }

    public VersionLineTable(Skin skin, boolean vr) {
        super(skin);
        float pad16 = 16.0f;
        float pad32 = 32.0f;
        this.setFillParent(true);
        this.top().left();
        this.pad(pad16);
        Table content = new Table(skin);
        content.setBackground("table-bg");
        content.pad(2.0f, pad16, 2.0f, pad16);
        content.top().left();
        Settings settings = Settings.settings;
        String style = vr ? "hud" : "hud-med";
        OwnLabel gsVersion = new OwnLabel((CharSequence)settings.version.version, skin, style);
        gsVersion.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.help.version", Settings.APPLICATION_NAME), skin));
        content.add((Actor)gsVersion).bottom().left().padRight(pad16);
        OwnLabel gsBuild = new OwnLabel((CharSequence)I18n.msg("gui.buildandtime", settings.version.build, settings.version.getBuildTimePretty()), skin, style);
        gsBuild.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.help.buildandtime"), skin));
        gsBuild.setColor(ColorUtils.oLighterGrayC);
        content.add((Actor)gsBuild).bottom().left().padRight(pad32 * 2.0f);
        OwnLabel device = new OwnLabel((CharSequence)Gdx.gl.glGetString(7937), skin, style);
        device.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.help.graphicsdevice"), skin));
        device.setColor(ColorUtils.oLighterGrayC);
        content.add((Actor)device).bottom().left().padRight(pad32);
        OwnLabel glVersion = new OwnLabel((CharSequence)I18n.msg("notif.glversion", Gdx.gl.glGetString(7938)), skin, style);
        glVersion.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.help.openglversion"), skin));
        glVersion.setColor(ColorUtils.oLighterGrayC);
        content.add((Actor)glVersion).bottom().left().padRight(pad32);
        OwnLabel glslVersion = new OwnLabel((CharSequence)I18n.msg("notif.glslversion", Gdx.gl.glGetString(35724)), skin, style);
        glslVersion.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.help.glslversion"), skin));
        glslVersion.setColor(ColorUtils.oLighterGrayC);
        content.add((Actor)glslVersion).bottom().left().padRight(settings.runtime.openXr || settings.program.net.master.active || settings.program.net.slave.active || settings.program.safeMode || settings.program.offlineMode ? pad32 : 0.0f);
        if (!vr && settings.runtime.openXr) {
            OwnLabel vrLabel = new OwnLabel((CharSequence)TextUtils.surroundBrackets(I18n.msg("gui.vr.mode")), skin, style);
            vrLabel.setColor(ColorUtils.gPinkC);
            vrLabel.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.vr.mode.tooltip"), skin));
            content.add((Actor)vrLabel).bottom().left().padRight(pad32);
        }
        if (settings.program.net.master.active) {
            OwnLabel master = new OwnLabel((CharSequence)TextUtils.surroundBrackets(I18n.msg("gui.master.instance")), skin, style);
            master.setColor(ColorUtils.gBlueC);
            master.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.master.instance.tooltip"), skin));
            content.add((Actor)master).bottom().left().padRight(pad32);
        }
        if (settings.program.net.slave.active) {
            OwnLabel slave = new OwnLabel((CharSequence)TextUtils.surroundBrackets(I18n.msg("gui.slave.instance")), skin, style);
            slave.setColor(ColorUtils.gYellowC);
            slave.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.slave.instance.tooltip"), skin));
            content.add((Actor)slave).colspan(2).bottom().right().padBottom(pad16).row();
        }
        if (settings.program.safeMode) {
            OwnLabel safeMode = new OwnLabel((CharSequence)TextUtils.surroundBrackets(I18n.msg("gui.debug.safemode")), skin, style);
            safeMode.setColor(ColorUtils.gRedC);
            safeMode.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.debug.safemode.tooltip"), skin));
            content.add((Actor)safeMode).bottom().left().padRight(pad32);
        }
        if (settings.program.offlineMode) {
            OwnLabel offlineMode = new OwnLabel((CharSequence)TextUtils.surroundBrackets(I18n.msg("gui.system.offlinemode")), skin, style);
            offlineMode.setColor(ColorUtils.gRedC);
            offlineMode.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.system.offlinemode.tooltip"), skin));
            content.add((Actor)offlineMode).bottom().left().padRight(pad32);
        }
        this.add((Actor)content);
    }
}

