/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.main;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.SpriteDrawable;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.viewport.ScreenViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import gaiasky.GaiaSky;
import gaiasky.event.Event;
import gaiasky.event.EventManager;
import gaiasky.event.IObserver;
import gaiasky.gui.datasets.DatasetManagerWindow;
import gaiasky.gui.iface.PopupNotificationsInterface;
import gaiasky.gui.main.AbstractGui;
import gaiasky.gui.main.VersionLineTable;
import gaiasky.gui.window.AboutWindow;
import gaiasky.gui.window.BatchDownloadWindow;
import gaiasky.gui.window.DataLocationCheckWindow;
import gaiasky.gui.window.GenericDialog;
import gaiasky.gui.window.PreferencesWindow;
import gaiasky.input.AbstractGamepadListener;
import gaiasky.input.GuiKbdListener;
import gaiasky.util.DownloadHelper;
import gaiasky.util.GlobalResources;
import gaiasky.util.GuiUtils;
import gaiasky.util.Logger;
import gaiasky.util.Settings;
import gaiasky.util.SysUtils;
import gaiasky.util.TextUtils;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.datadesc.DataDescriptor;
import gaiasky.util.datadesc.DataDescriptorUtils;
import gaiasky.util.datadesc.DatasetDesc;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.i18n.I18n;
import gaiasky.util.scene2d.OwnImage;
import gaiasky.util.scene2d.OwnLabel;
import gaiasky.util.scene2d.OwnTextIconButton;
import gaiasky.util.scene2d.OwnTextTooltip;
import gaiasky.util.scene2d.Separator;
import gaiasky.vr.openxr.XrLoadStatus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class WelcomeGui
extends AbstractGui {
    private static final Logger.Log logger = Logger.getLogger(WelcomeGui.class);
    private static final AtomicReference<DataDescriptor> localDatasets = new AtomicReference();
    private final XrLoadStatus vrStatus;
    private final boolean skipWelcome;
    private final WelcomeGuiGamepadListener gamepadListener;
    protected DatasetManagerWindow datasetManager;
    private AboutWindow aboutWindow;
    private PreferencesWindow preferencesWindow;
    private FileHandle dataDescriptor;
    private boolean downloadError = false;
    private Texture bgTex;
    private DataDescriptor serverDatasets;
    private Array<Button> buttonList;
    private int currentSelected = 0;
    private PopupNotificationsInterface popupInterface;
    private WelcomeGuiKbdListener kbdListener;
    private Table datasetsContainer;
    private boolean preventRecommended = false;

    public WelcomeGui(Skin skin, Graphics graphics, Float unitsPerPixel, boolean skipWelcome, XrLoadStatus vrStatus) {
        super(graphics, unitsPerPixel);
        this.skin = skin;
        this.skipWelcome = skipWelcome;
        this.vrStatus = vrStatus;
        this.gamepadListener = new WelcomeGuiGamepadListener(Settings.settings.controls.gamepad.mappingsFile);
    }

    @Override
    public void initialize(AssetManager assetManager, SpriteBatch sb) {
        ScreenViewport vp = new ScreenViewport();
        vp.setUnitsPerPixel(this.unitsPerPixel);
        this.stage = new Stage((Viewport)vp, (Batch)sb);
        InputMultiplexer inputMultiplexer = GaiaSky.instance.inputMultiplexer;
        if (inputMultiplexer != null) {
            inputMultiplexer.addProcessor((InputProcessor)this.stage);
        }
        this.kbdListener = new WelcomeGuiKbdListener(this.stage);
        this.popupInterface = new PopupNotificationsInterface(this.skin);
        this.popupInterface.top().right();
        this.popupInterface.setFillParent(true);
        if (DataDescriptorUtils.dataLocationOldVersionDatasetsCheck()) {
            DataLocationCheckWindow fsCheck = new DataLocationCheckWindow(I18n.msg("gui.dscheck.title"), this.skin, this.stage);
            fsCheck.setAcceptListener(() -> {
                GaiaSky.instance.getExecutorService().execute(DataDescriptorUtils::cleanDataLocationOldDatasets);
                this.continueWelcomeGui();
            });
            fsCheck.setCancelListener(this::continueWelcomeGui);
            fsCheck.show(this.stage);
        } else {
            this.continueWelcomeGui();
        }
    }

    private void continueWelcomeGui() {
        if (this.vrStatus.vrInitFailed()) {
            if (this.vrStatus.equals((Object)XrLoadStatus.ERROR_NO_CONTEXT)) {
                GaiaSky.postRunnable(() -> GuiUtils.addNoVRConnectionExit(this.skin, this.stage));
            } else if (this.vrStatus.equals((Object)XrLoadStatus.ERROR_RENDERMODEL)) {
                GaiaSky.postRunnable(() -> GuiUtils.addNoVRDataExit(this.skin, this.stage));
            }
        } else if (Settings.settings.program.net.slave.active || GaiaSky.instance.isHeadless()) {
            this.startLoading();
        } else {
            this.clearGui();
            if (Controllers.getControllers().size > 0) {
                Timer.Task notification = new Timer.Task(this){

                    public void run() {
                        EventManager.publish(Event.POST_POPUP_NOTIFICATION, (Object)this, I18n.msg("gui.welcome.gamepad.notification", Controllers.getControllers().size), Float.valueOf(10.0f));
                    }
                };
                Timer.schedule((Timer.Task)notification, (float)2.0f);
            }
            this.buildWaitingUI();
            this.dataDescriptor = Gdx.files.absolute(String.valueOf(SysUtils.getDataTempDir(Settings.settings.data.location)) + "/gaiasky-data.json.gz");
            DownloadHelper.downloadFile(Settings.settings.program.url.dataDescriptor, this.dataDescriptor, Settings.settings.program.offlineMode, null, null, digest -> GaiaSky.postRunnable(() -> {
                if (this.skipWelcome && this.baseDataPresent()) {
                    this.startLoading();
                } else {
                    this.buildWelcomeUI();
                }
            }), () -> {
                this.downloadError = true;
                if (Settings.settings.program.offlineMode) {
                    logger.error(I18n.msg("gui.welcome.error.offlinemode"));
                } else {
                    logger.error(I18n.msg("gui.welcome.error.nointernet"));
                }
                if (this.baseDataPresent()) {
                    GaiaSky.postRunnable(() -> GuiUtils.addNoConnectionWindow(this.skin, this.stage, this::buildWelcomeUI));
                } else {
                    logger.error(I18n.msg("gui.welcome.error.nobasedata"));
                    GaiaSky.postRunnable(() -> GuiUtils.addNoConnectionExit(this.skin, this.stage));
                }
            }, null);
            this.stage.addListener(event -> {
                InputEvent ie;
                if (event instanceof InputEvent && (ie = (InputEvent)event).getType() == InputEvent.Type.keyUp) {
                    if (ie.getKeyCode() == 111) {
                        Gdx.app.exit();
                    } else if (ie.getKeyCode() == 66) {
                        if (this.baseDataPresent()) {
                            this.startLoading();
                        } else {
                            this.addDatasetManagerWindow(this.serverDatasets);
                        }
                    }
                }
                return false;
            });
        }
    }

    private void buildWaitingUI() {
        if (!Settings.settings.program.offlineMode) {
            this.updateUnitsPerPixel(1.6f);
            Table centerContainer = new Table(this.skin);
            centerContainer.setFillParent(true);
            centerContainer.bottom().right();
            if (this.bgTex == null) {
                this.bgTex = new Texture(OwnTextureLoader.Factory.loadFromFile(Gdx.files.internal("img/splash/splash.jpg"), false));
            }
            SpriteDrawable bg = new SpriteDrawable(new Sprite(this.bgTex));
            centerContainer.setBackground((Drawable)bg);
            Table table = new Table(this.skin);
            OwnLabel gaiaSky = new OwnLabel((CharSequence)Settings.getApplicationTitle(Settings.settings.runtime.openXr), this.skin, "main-title");
            table.add((Actor)gaiaSky).row();
            OwnLabel msg = new OwnLabel((CharSequence)I18n.msg("gui.welcome.datasets.updates"), this.skin);
            table.add((Actor)msg);
            centerContainer.add((Actor)table).bottom().right().padBottom(30.0f).padRight(30.0f);
            this.stage.addActor((Actor)centerContainer);
        }
    }

    private void buildWelcomeUI() {
        DatasetDesc baseData;
        boolean regularStart;
        this.stage.clear();
        this.addOwnListeners();
        this.buttonList = new Array();
        this.serverDatasets = !this.downloadError ? DataDescriptorUtils.instance().buildServerDatasets(this.dataDescriptor) : null;
        WelcomeGui.reloadLocalDatasets();
        Table centerContainer = new Table(this.skin);
        centerContainer.setFillParent(true);
        centerContainer.center();
        if (this.bgTex == null) {
            this.bgTex = new Texture(OwnTextureLoader.Factory.loadFromFile(Gdx.files.internal("img/splash/splash.jpg"), false));
        }
        SpriteDrawable bg = new SpriteDrawable(new Sprite(this.bgTex));
        centerContainer.setBackground((Drawable)bg);
        float pad16 = 16.0f;
        float pad18 = 18.0f;
        final float pad28 = 28.0f;
        float pad32 = 32.0f;
        float buttonWidth = 460.0f;
        float buttonHeight = 110.0f;
        Table center = new Table(this.skin);
        center.center();
        center.setBackground("bg-pane");
        center.pad(pad32);
        center.padLeft(pad32 * 5.0f);
        center.padRight(pad32 * 5.0f);
        Set<String> removed = this.removeNonExistent();
        if (!removed.isEmpty()) {
            logger.warn(I18n.msg("gui.welcome.warn.nonexistent", removed.size()));
            logger.warn(TextUtils.setToStr(removed));
        }
        int numCatalogsAvailable = this.numCatalogsAvailable();
        int numGaiaDRCatalogsEnabled = this.numGaiaDRCatalogsEnabled();
        int numStarCatalogsEnabled = this.numStarCatalogsEnabled();
        int numTotalCatalogsEnabled = this.numTotalDatasetsEnabled();
        boolean baseDataPresent = this.baseDataPresent();
        Table titleGroup = new Table(this.skin);
        FileHandle gsIcon = Gdx.files.internal("icon/gs_icon_256.png");
        Texture iconTex = new Texture(gsIcon);
        iconTex.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        Image logo = new Image(iconTex);
        logo.setScale(1.05f);
        logo.setOrigin(1);
        OwnLabel gaiaSky = new OwnLabel((CharSequence)Settings.getApplicationTitle(Settings.settings.runtime.openXr), this.skin, "main-title");
        gaiaSky.setFontScale(1.5f);
        OwnLabel version = new OwnLabel((CharSequence)Settings.settings.version.version, this.skin, "main-title");
        version.setColor(this.skin.getColor("theme"));
        Table title = new Table(this.skin);
        title.add((Actor)gaiaSky).bottom().left().padBottom(pad16).row();
        title.add((Actor)version).bottom().left().padRight(pad16);
        titleGroup.add((Actor)logo).center().padRight(pad32 * 3.0f);
        titleGroup.add((Actor)new Separator(this.skin, "default")).fillY().padRight(pad32);
        titleGroup.add((Actor)title);
        String textStyle = "main-title-s";
        center.add((Actor)titleGroup).center().padLeft(pad32 * 2.0f).padBottom(pad18 * 6.0f).colspan(2).row();
        int numLocalDatasets = WelcomeGui.localDatasets.get().datasets.size() + (baseDataPresent ? 1 : 0);
        boolean bl = regularStart = numLocalDatasets > 0 || this.preventRecommended;
        if (regularStart) {
            OwnTextIconButton startButton = new OwnTextIconButton(I18n.msg("gui.welcome.start", Settings.APPLICATION_NAME), this.skin, "start");
            startButton.setSpace(pad18);
            startButton.setPad(pad16);
            startButton.setContentAlign(1);
            startButton.align(1);
            startButton.setHeight(buttonHeight);
            startButton.pack();
            startButton.setWidth(Math.max(startButton.getWidth(), buttonWidth));
            startButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.startLoading();
                }
                return true;
            });
            this.buttonList.add((Object)startButton);
            Table startGroup = new Table(this.skin);
            OwnLabel startLabel = new OwnLabel((CharSequence)I18n.msg("gui.welcome.start.desc", Settings.APPLICATION_NAME), this.skin, textStyle);
            startGroup.add((Actor)startLabel).top().left().padBottom(pad16).row();
            if (!baseDataPresent) {
                startButton.setDisabled(true);
                OwnLabel noBaseData = new OwnLabel((CharSequence)I18n.msg("gui.welcome.start.nobasedata"), this.skin, textStyle);
                noBaseData.setColor(ColorUtils.gRedC);
                startGroup.add((Actor)noBaseData).bottom().left();
            } else if (numCatalogsAvailable > 0 && numTotalCatalogsEnabled == 0) {
                OwnLabel noCatsSelected = new OwnLabel((CharSequence)I18n.msg("gui.welcome.start.nocatalogs"), this.skin, textStyle);
                noCatsSelected.setColor(ColorUtils.gRedC);
                startGroup.add((Actor)noCatsSelected).bottom().left();
            } else if (numGaiaDRCatalogsEnabled > 1 || numStarCatalogsEnabled == 0) {
                OwnLabel tooManyDR = new OwnLabel((CharSequence)I18n.msg("gui.welcome.start.check"), this.skin, textStyle);
                tooManyDR.setColor(ColorUtils.gRedC);
                startGroup.add((Actor)tooManyDR).bottom().left();
            } else {
                OwnLabel ready = new OwnLabel((CharSequence)I18n.msg("gui.welcome.start.ready"), this.skin, textStyle);
                ready.setColor(ColorUtils.gGreenC);
                startGroup.add((Actor)ready).bottom().left();
            }
            OwnTextIconButton datasetManagerButton = new OwnTextIconButton(I18n.msg("gui.welcome.dsmanager"), this.skin, "cloud-download");
            datasetManagerButton.setSpace(pad18);
            datasetManagerButton.setPad(pad16);
            datasetManagerButton.setContentAlign(1);
            datasetManagerButton.align(1);
            datasetManagerButton.setHeight(buttonHeight);
            datasetManagerButton.pack();
            datasetManagerButton.setWidth(Math.max(datasetManagerButton.getWidth(), buttonWidth));
            datasetManagerButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.addDatasetManagerWindow(this.serverDatasets);
                }
                return true;
            });
            this.buttonList.add((Object)datasetManagerButton);
            Table datasetManagerInfo = new Table(this.skin);
            OwnLabel downloadLabel = new OwnLabel((CharSequence)I18n.msg("gui.welcome.dsmanager.desc"), this.skin, textStyle);
            datasetManagerInfo.add((Actor)downloadLabel).top().left().padBottom(pad16);
            if (this.serverDatasets != null && this.serverDatasets.updatesAvailable) {
                datasetManagerInfo.row();
                OwnLabel updates = new OwnLabel((CharSequence)I18n.msg("gui.welcome.dsmanager.updates", this.serverDatasets.numUpdates), this.skin, textStyle);
                updates.setColor(ColorUtils.gYellowC);
                datasetManagerInfo.add((Actor)updates).bottom().left();
            } else if (!baseDataPresent) {
                datasetManagerInfo.row();
                OwnLabel getBasedata = new OwnLabel((CharSequence)I18n.msg("gui.welcome.dsmanager.info"), this.skin, textStyle);
                getBasedata.setColor(ColorUtils.gGreenC);
                datasetManagerInfo.add((Actor)getBasedata).bottom().left();
            } else {
                OwnLabel numCatalogsEnabled = new OwnLabel((CharSequence)I18n.msg("gui.welcome.enabled", numTotalCatalogsEnabled, numCatalogsAvailable), this.skin, textStyle);
                numCatalogsEnabled.setColor(ColorUtils.gBlueC);
                datasetManagerInfo.row().padBottom(pad16);
                datasetManagerInfo.add((Actor)numCatalogsEnabled).left().padBottom(pad18);
            }
            Table selectionInfo = new Table(this.skin);
            if (numCatalogsAvailable == 0) {
                OwnLabel noCatalogs = new OwnLabel((CharSequence)I18n.msg("gui.welcome.catalogsel.nocatalogs"), this.skin, textStyle);
                noCatalogs.setColor(ColorUtils.aOrangeC);
                selectionInfo.add((Actor)noCatalogs);
            } else if (numGaiaDRCatalogsEnabled > 1) {
                OwnLabel tooManyDR = new OwnLabel((CharSequence)I18n.msg("gui.welcome.catalogsel.manydrcatalogs"), this.skin, textStyle);
                tooManyDR.setColor(ColorUtils.gRedC);
                selectionInfo.add((Actor)tooManyDR);
            } else if (numStarCatalogsEnabled > 1) {
                OwnLabel warn2Star = new OwnLabel((CharSequence)I18n.msg("gui.welcome.catalogsel.manystarcatalogs"), this.skin, textStyle);
                warn2Star.setColor(ColorUtils.aOrangeC);
                selectionInfo.add((Actor)warn2Star);
            } else if (numStarCatalogsEnabled == 0) {
                OwnLabel noStarCatalogs = new OwnLabel((CharSequence)I18n.msg("gui.welcome.catalogsel.nostarcatalogs"), this.skin, textStyle);
                noStarCatalogs.setColor(ColorUtils.aOrangeC);
                selectionInfo.add((Actor)noStarCatalogs);
            }
            center.add((Actor)startButton).right().top().padBottom(pad18 * 10.0f).padRight(pad28 * 2.0f);
            center.add((Actor)startGroup).top().left().padBottom(pad18 * 10.0f).row();
            center.add((Actor)datasetManagerButton).right().top().padBottom(pad32).padRight(pad28 * 2.0f);
            center.add((Actor)datasetManagerInfo).left().top().padBottom(pad32).row();
            center.add((Actor)selectionInfo).colspan(2).center().top().padBottom(pad32 * 4.0f).row();
            if (numLocalDatasets == 0 && this.preventRecommended) {
                OwnTextIconButton backButton = new OwnTextIconButton(I18n.msg("gui.back"), this.skin, "back");
                backButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.back.prev"), this.skin, 10));
                backButton.setHeight(buttonHeight * 0.6f);
                backButton.setWidth(buttonWidth * 0.5f);
                backButton.addListener((EventListener)new ClickListener(){

                    public void clicked(InputEvent event, float x, float y) {
                        WelcomeGui.this.preventRecommended = false;
                        WelcomeGui.this.reloadView();
                    }
                });
                backButton.pack();
                center.add((Actor)backButton).colspan(2).left().bottom().padBottom(pad32);
            }
        } else {
            OwnTextIconButton recommendedDatasetsButton = new OwnTextIconButton(I18n.msg("gui.welcome.recommended"), this.skin, "start");
            recommendedDatasetsButton.setSpace(pad18);
            recommendedDatasetsButton.setPad(pad16);
            recommendedDatasetsButton.setContentAlign(1);
            recommendedDatasetsButton.align(1);
            recommendedDatasetsButton.setHeight(buttonHeight);
            recommendedDatasetsButton.pack();
            recommendedDatasetsButton.setWidth(Math.max(recommendedDatasetsButton.getWidth(), buttonWidth));
            recommendedDatasetsButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    Set<String> recommendedDatasets = this.serverDatasets.recommended != null && this.serverDatasets.recommended.length > 0 ? Set.of(this.serverDatasets.recommended) : Settings.settings.program.recommendedDatasets;
                    List<DatasetDesc> recommended = this.serverDatasets.datasets.stream().filter(ds -> recommendedDatasets.contains(ds.key)).sorted(Comparator.comparing(datasetDesc -> datasetDesc.name)).toList();
                    String bdwTitle = I18n.msg("gui.batch.recommended.title");
                    String bdwInfo = I18n.msg("gui.batch.recommended.info");
                    BatchDownloadWindow bdw = new BatchDownloadWindow(bdwTitle, bdwInfo, this.skin, this.stage, recommended);
                    bdw.setSuccessRunnable(() -> {
                        bdw.closeCancel();
                        bdw.dispose();
                        this.startLoading();
                    });
                    bdw.setErrorRunnable(() -> {
                        EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("gui.batch.error.global"));
                        bdw.closeCancel();
                        bdw.dispose();
                        this.reloadView();
                    });
                    bdw.show(this.stage);
                    bdw.downloadDatasets();
                }
                return true;
            });
            this.buttonList.add((Object)recommendedDatasetsButton);
            OwnTextIconButton customizeButton = new OwnTextIconButton(I18n.msg("gui.welcome.custom"), this.skin, "cloud-download");
            customizeButton.setSpace(pad18);
            customizeButton.setPad(pad16);
            customizeButton.setContentAlign(1);
            customizeButton.align(1);
            customizeButton.setHeight(buttonHeight);
            customizeButton.pack();
            customizeButton.setWidth(Math.max(recommendedDatasetsButton.getWidth(), buttonWidth));
            customizeButton.addListener(event -> {
                if (event instanceof ChangeListener.ChangeEvent) {
                    this.preventRecommended = true;
                    this.reloadView();
                }
                return true;
            });
            this.buttonList.add((Object)customizeButton);
            center.add((Actor)recommendedDatasetsButton).center().top().padBottom(pad18 * 3.0f).row();
            center.add((Actor)customizeButton).center().top().padBottom(pad32 * 5.0f).row();
        }
        centerContainer.add((Actor)center).center();
        this.datasetsContainer = new Table(this.skin);
        this.datasetsContainer.setFillParent(true);
        Table datasets = new Table(this.skin);
        datasets.setBackground("bg-pane");
        datasets.right().pad(pad32);
        Collection<DatasetDesc> enabledDatasets = this.getEnabledDatasets();
        int count = enabledDatasets != null ? enabledDatasets.size() : 0;
        datasets.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.welcome.datasets.enabled", count), this.skin, "header")).left().padBottom(pad28).row();
        if (enabledDatasets != null && !enabledDatasets.isEmpty()) {
            enabledDatasets.forEach(ds -> {
                OwnImage typeIcon = new OwnImage(this.skin.getDrawable(DatasetManagerWindow.getIcon(ds.type)));
                typeIcon.setSize(30.0f, 30.0f);
                HorizontalGroup g = this.hg(new Actor[]{typeIcon, new OwnLabel((CharSequence)TextUtils.capString(ds.name, 32), this.skin)});
                datasets.add((Actor)g).left().padBottom(pad16).row();
            });
        } else {
            OwnLabel noDatasets = new OwnLabel((CharSequence)I18n.msg("gui.welcome.datasets.enabled.no"), this.skin);
            datasets.add((Actor)noDatasets).left();
        }
        this.datasetsContainer.add((Actor)datasets).right().expandX().padRight(pad32);
        VersionLineTable topLeft = new VersionLineTable(this.skin);
        Table screenMode = new Table(this.skin);
        screenMode.setFillParent(true);
        screenMode.top().right();
        screenMode.pad(pad16);
        OwnTextIconButton screenModeButton = new OwnTextIconButton("", this.skin, "screen-mode");
        screenModeButton.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.fullscreen"), this.skin, 10));
        screenModeButton.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                Settings.settings.graphics.fullScreen.active = !Settings.settings.graphics.fullScreen.active;
                EventManager.publish(Event.SCREEN_MODE_CMD, (Object)screenModeButton, new Object[0]);
                return true;
            }
            return false;
        });
        screenMode.add((Actor)screenModeButton);
        OwnTextIconButton about = new OwnTextIconButton("", this.skin, "help");
        about.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.help.about"), this.skin, 10));
        about.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.aboutWindow == null) {
                    this.aboutWindow = new AboutWindow(this.stage, this.skin);
                }
                if (!this.aboutWindow.isVisible() || !this.aboutWindow.hasParent()) {
                    this.aboutWindow.show(this.stage);
                }
                return true;
            }
            return false;
        });
        about.pack();
        OwnTextIconButton preferences = new OwnTextIconButton("", this.skin, "preferences");
        preferences.addListener((EventListener)new OwnTextTooltip(I18n.msg("gui.preferences"), this.skin, 10));
        preferences.addListener(event -> {
            if (event instanceof ChangeListener.ChangeEvent) {
                if (this.preferencesWindow == null) {
                    this.preferencesWindow = new PreferencesWindow(this.stage, this.skin, GaiaSky.instance.getGlobalResources(), true);
                }
                if (!this.preferencesWindow.isVisible() || !this.preferencesWindow.hasParent()) {
                    this.preferencesWindow.show(this.stage);
                }
                return true;
            }
            return false;
        });
        preferences.pack();
        OwnTextIconButton exit = new OwnTextIconButton("", this.skin, "quit");
        exit.addListener((EventListener)new OwnTextTooltip(I18n.msg("context.quit"), this.skin, 10));
        exit.addListener((EventListener)new ClickListener(this){

            public void clicked(InputEvent event, float x, float y) {
                GaiaSky.postRunnable(() -> ((Application)Gdx.app).exit());
            }
        });
        exit.pack();
        this.buttonList.add((Object)preferences);
        this.buttonList.add((Object)about);
        this.buttonList.add((Object)screenModeButton);
        this.buttonList.add((Object)exit);
        HorizontalGroup bottomRight = new HorizontalGroup();
        bottomRight.space(pad18);
        bottomRight.addActor((Actor)preferences);
        bottomRight.addActor((Actor)about);
        bottomRight.addActor((Actor)exit);
        bottomRight.setFillParent(true);
        bottomRight.bottom().right().pad(pad28);
        this.stage.addActor((Actor)centerContainer);
        this.stage.addActor((Actor)this.datasetsContainer);
        this.stage.addActor((Actor)topLeft);
        this.stage.addActor((Actor)screenMode);
        this.stage.addActor((Actor)bottomRight);
        this.stage.addActor((Actor)this.popupInterface);
        if (baseDataPresent && this.serverDatasets != null && this.serverDatasets.updatesAvailable && (baseData = this.serverDatasets.findDatasetByKey("default-data")) != null && baseData.myVersion < baseData.serverVersion) {
            GenericDialog baseDataNotice = new GenericDialog(this, I18n.msg("gui.basedata.title"), this.skin, this.stage){

                @Override
                protected void build() {
                    this.content.clear();
                    this.content.pad(pad34, pad28 * 2.0f, pad34, pad28 * 2.0f);
                    this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.basedata.default", baseData.name, I18n.msg("gui.welcome.dsmanager")), this.skin, "huge")).left().colspan(3).padBottom(pad34 * 2.0f).row();
                    this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.basedata.version", baseData.myVersion), this.skin, "header-large")).center().padRight(pad34);
                    this.content.add((Actor)new OwnLabel((CharSequence)"->", this.skin, "main-title-s")).center().padRight(pad34);
                    this.content.add((Actor)new OwnLabel((CharSequence)I18n.msg("gui.basedata.version", baseData.serverVersion), this.skin, "header-large")).center().padRight(pad34);
                }

                @Override
                protected boolean accept() {
                    return true;
                }

                @Override
                protected void cancel() {
                }

                @Override
                public void dispose() {
                }
            };
            baseDataNotice.setAcceptText(I18n.msg("gui.ok"));
            baseDataNotice.buildSuper();
            baseDataNotice.show(this.stage);
        }
        this.updateFocused();
        EventManager.instance.subscribe((IObserver)this, Event.UI_RELOAD_CMD, Event.UI_SCALE_RECOMPUTE_CMD);
        EventManager.publish(Event.UI_SCALE_RECOMPUTE_CMD, this, new Object[0]);
    }

    private void ensureBaseDataEnabled(DataDescriptor dd) {
        if (dd != null) {
            DatasetDesc base = null;
            for (DatasetDesc dataset : dd.datasets) {
                if (!dataset.baseData) continue;
                base = dataset;
                break;
            }
            if (base != null && !Settings.settings.data.dataFiles.contains(base.checkStr)) {
                Settings.settings.data.dataFiles.addFirst(base.checkStr);
            }
        }
    }

    public void startLoading() {
        EventManager.instance.removeAllSubscriptions((IObserver)this);
        this.removeOwnListeners();
        this.ensureBaseDataEnabled(this.serverDatasets);
        if (this.popupInterface != null) {
            this.popupInterface.remove();
            this.popupInterface.dispose();
        }
        if (this.bgTex != null) {
            this.bgTex.dispose();
        }
        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
        EventManager.publish(Event.LOAD_DATA_CMD, this, new Object[0]);
    }

    private void reloadView() {
        this.clearGui();
        Gdx.graphics.setSystemCursor(Cursor.SystemCursor.Arrow);
        this.buildWelcomeUI();
    }

    private static void reloadLocalDatasets() {
        localDatasets.set(DataDescriptorUtils.instance().buildLocalDatasets(null));
    }

    private int numTotalDatasetsEnabled() {
        return localDatasets.get() != null ? (int)WelcomeGui.localDatasets.get().datasets.stream().filter(ds -> Settings.settings.data.dataFiles.contains(ds.checkStr)).count() : 0;
    }

    private Collection<DatasetDesc> getEnabledDatasets() {
        return localDatasets.get() != null ? (Collection)WelcomeGui.localDatasets.get().datasets.stream().filter(ds -> Settings.settings.data.dataFiles.contains(ds.checkStr)).sorted(Comparator.comparing(a -> a.type)).collect(Collectors.toList()) : null;
    }

    private int numCatalogsAvailable() {
        return localDatasets.get() != null ? WelcomeGui.localDatasets.get().datasets.size() : 0;
    }

    private int numGaiaDRCatalogsEnabled() {
        int matches = 0;
        for (String f : Settings.settings.data.dataFiles) {
            String path = Settings.settings.data.dataFile(f);
            if (!this.isGaiaDRCatalogFile(path)) continue;
            ++matches;
        }
        return matches;
    }

    private boolean isGaiaDRCatalogFile(String name) {
        return name.matches("^\\S*catalog-[e]?dr\\d+(int\\d+)?-\\S+(\\.json)$");
    }

    private int numStarCatalogsEnabled() {
        int matches = 0;
        if (this.serverDatasets == null && localDatasets.get() == null) {
            return 0;
        }
        for (String f : Settings.settings.data.dataFiles) {
            Path path = Settings.settings.data.dataPath(f);
            String filenameExt = path.getFileName().toString();
            try {
                DatasetDesc dataset = null;
                if (this.serverDatasets != null) {
                    dataset = this.serverDatasets.findDatasetByDescriptor(path);
                }
                if (dataset == null && localDatasets.get() != null) {
                    dataset = localDatasets.get().findDatasetByDescriptor(path);
                }
                if ((dataset == null || !dataset.isStarDataset()) && !this.isGaiaDRCatalogFile(filenameExt)) continue;
                ++matches;
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        return matches;
    }

    private Set<String> removeNonExistent() {
        HashSet<String> toRemove = new HashSet<String>();
        FileHandleResolver dataResolver = fileName -> Settings.settings.data.dataFileHandle(fileName);
        for (String f : Settings.settings.data.dataFiles) {
            FileHandle fh = dataResolver.resolve(f);
            if (fh.exists()) continue;
            toRemove.add(f);
        }
        for (String out : toRemove) {
            Settings.settings.data.dataFiles.remove(out);
        }
        return toRemove;
    }

    public boolean baseDataPresent() {
        Array defaultDatasetFiles = new Array();
        this.fillDefaultDatasetFiles((Array<Path>)defaultDatasetFiles);
        for (Path p : defaultDatasetFiles) {
            if (Files.exists(p, new LinkOption[0]) && Files.isReadable(p)) continue;
            logger.info("Data files not found: " + String.valueOf(p));
            return false;
        }
        return true;
    }

    private void fillDefaultDatasetFiles(Array<Path> newFiles) {
        Path location = Paths.get(Settings.settings.data.location, new String[0]).normalize();
        newFiles.add((Object)location.resolve("default-data"));
        newFiles.add((Object)location.resolve("default-data").resolve("dataset.json"));
    }

    @Override
    public void doneLoading(AssetManager assetManager) {
    }

    private void addDatasetManagerWindow(DataDescriptor dd) {
        if (this.datasetManager == null) {
            this.datasetManager = new DatasetManagerWindow(this.stage, this.skin, dd);
            this.datasetManager.setAcceptListener(() -> {
                if (this.datasetManager != null) {
                    Timer.schedule((Timer.Task)new Timer.Task(){

                        public void run() {
                            WelcomeGui.this.reloadView();
                        }
                    }, (float)0.5f);
                }
            });
        } else {
            this.datasetManager.refresh();
        }
        this.datasetManager.show(this.stage);
    }

    public void clearGui() {
        if (this.stage != null) {
            this.stage.clear();
        }
        if (this.datasetManager != null) {
            this.datasetManager.remove();
            this.datasetManager = null;
        }
        if (this.preferencesWindow != null) {
            this.preferencesWindow.remove();
            this.preferencesWindow = null;
        }
        EventManager.instance.removeAllSubscriptions((IObserver)this);
    }

    @Override
    public void update(double dt) {
        super.update(dt);
        if (this.kbdListener != null && this.kbdListener.isActive()) {
            this.kbdListener.update();
        }
        if (this.gamepadListener != null && this.gamepadListener.isActive()) {
            this.gamepadListener.update();
        }
    }

    @Override
    protected void rebuildGui() {
    }

    protected HorizontalGroup hg(Actor ... actors) {
        HorizontalGroup hg = new HorizontalGroup();
        hg.space(10.0f);
        for (Actor a : actors) {
            hg.addActor(a);
        }
        return hg;
    }

    @Override
    public void notify(Event event, Object source, Object ... data) {
        switch (event) {
            case UI_RELOAD_CMD: {
                GaiaSky.postRunnable(() -> {
                    GlobalResources globalResources = GaiaSky.instance.getGlobalResources();
                    globalResources.updateSkin();
                    GenericDialog.updatePads();
                    EventManager.publish(Event.UI_THEME_RELOAD_INFO, this, globalResources.getSkin());
                    EventManager.publish(Event.POST_POPUP_NOTIFICATION, this, I18n.msg("notif.ui.reload"));
                    this.skin = globalResources.getSkin();
                    this.reloadView();
                });
                break;
            }
            case UI_SCALE_RECOMPUTE_CMD: {
                int height = data != null && data.length > 0 ? ((Integer)data[0]).intValue() : Gdx.graphics.getHeight();
                GaiaSky.instance.applyUIScale(height, this);
            }
        }
    }

    private void addOwnListeners() {
        if (this.kbdListener != null) {
            InputMultiplexer multiplexer = GaiaSky.instance.inputMultiplexer;
            if (multiplexer != null) {
                multiplexer.addProcessor(0, (InputProcessor)this.kbdListener);
            }
            this.kbdListener.activate();
        }
        if (this.gamepadListener != null) {
            Settings.settings.controls.gamepad.addControllerListener(this.gamepadListener);
            this.gamepadListener.activate();
        }
    }

    private void removeOwnListeners() {
        if (this.kbdListener != null) {
            InputMultiplexer multiplexer = GaiaSky.instance.inputMultiplexer;
            if (multiplexer != null) {
                multiplexer.removeProcessor((InputProcessor)this.kbdListener);
            }
            this.kbdListener.deactivate();
        }
        if (this.gamepadListener != null) {
            Settings.settings.controls.gamepad.removeControllerListener(this.gamepadListener);
            this.gamepadListener.deactivate();
        }
    }

    public boolean updateFocused() {
        if (this.buttonList != null && this.buttonList.size != 0) {
            Button actor = (Button)this.buttonList.get(this.currentSelected);
            this.stage.setKeyboardFocus((Actor)actor);
            return true;
        }
        return false;
    }

    private boolean up() {
        this.currentSelected = this.currentSelected == 0 ? this.buttonList.size - 1 : (this.currentSelected - 1) % this.buttonList.size;
        return this.updateFocused();
    }

    private boolean down() {
        this.currentSelected = (this.currentSelected + 1) % this.buttonList.size;
        return this.updateFocused();
    }

    public void fireChange() {
        if (this.buttonList != null) {
            Button b = (Button)this.buttonList.get(this.currentSelected);
            ChangeListener.ChangeEvent event = (ChangeListener.ChangeEvent)Pools.obtain(ChangeListener.ChangeEvent::new);
            event.setTarget((Actor)b);
            b.fire((com.badlogic.gdx.scenes.scene2d.Event)event);
            Pools.free((Object)event);
        }
    }

    public static AtomicReference<DataDescriptor> getLocalDatasets() {
        return localDatasets;
    }

    @Override
    public void resize(int width, int height) {
        if (this.preferencesWindow != null) {
            this.preferencesWindow.resize(width, height);
        }
        if (this.datasetsContainer != null) {
            this.datasetsContainer.setVisible(!((double)((float)width / (float)height) < 1.6));
        }
        super.resize(width, height);
    }

    private class WelcomeGuiGamepadListener
    extends AbstractGamepadListener {
        public WelcomeGuiGamepadListener(String mappingsFile) {
            super(mappingsFile);
        }

        @Override
        public void connected(Controller controller) {
        }

        @Override
        public void disconnected(Controller controller) {
        }

        @Override
        public boolean pollAxes() {
            if (this.lastControllerUsed != null) {
                float value = (float)this.applyZeroPoint(this.lastControllerUsed.getAxis(this.mappings.getAxisLstickV()));
                if (value > 0.0f) {
                    WelcomeGui.this.down();
                    return true;
                }
                if (value < 0.0f) {
                    WelcomeGui.this.up();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean pollButtons() {
            if (this.isKeyPressed(this.mappings.getButtonDpadUp())) {
                WelcomeGui.this.up();
                return true;
            }
            if (this.isKeyPressed(this.mappings.getButtonDpadDown())) {
                WelcomeGui.this.down();
                return true;
            }
            return false;
        }

        @Override
        public boolean buttonDown(Controller controller, int buttonCode) {
            long now = TimeUtils.millis();
            if (buttonCode == this.mappings.getButtonStart()) {
                WelcomeGui.this.startLoading();
                this.lastButtonPollTime = now;
            } else if (buttonCode == this.mappings.getButtonA()) {
                WelcomeGui.this.fireChange();
                this.lastButtonPollTime = now;
            } else if (buttonCode == this.mappings.getButtonDpadUp()) {
                WelcomeGui.this.up();
                this.lastButtonPollTime = now;
            } else if (buttonCode == this.mappings.getButtonDpadDown()) {
                WelcomeGui.this.down();
                this.lastButtonPollTime = now;
            }
            this.lastControllerUsed = controller;
            return true;
        }

        @Override
        public boolean buttonUp(Controller controller, int buttonCode) {
            this.lastControllerUsed = controller;
            return true;
        }

        @Override
        public boolean axisMoved(Controller controller, int axisCode, float value) {
            long now = TimeUtils.millis();
            if (now - this.lastAxisEvtTime > this.axisEventDelay && axisCode == this.mappings.getAxisLstickV()) {
                if ((value = (float)this.applyZeroPoint(value)) > 0.0f) {
                    WelcomeGui.this.down();
                    this.lastAxisEvtTime = now;
                } else if (value < 0.0f) {
                    WelcomeGui.this.up();
                    this.lastAxisEvtTime = now;
                }
            }
            this.lastControllerUsed = controller;
            return true;
        }
    }

    private class WelcomeGuiKbdListener
    extends GuiKbdListener {
        protected WelcomeGuiKbdListener(Stage stage) {
            super(stage);
        }

        @Override
        public boolean close() {
            GaiaSky.postRunnable(() -> ((Application)Gdx.app).exit());
            return true;
        }

        @Override
        public boolean accept() {
            WelcomeGui.this.startLoading();
            return true;
        }

        @Override
        public boolean select() {
            return false;
        }

        @Override
        public boolean tabLeft() {
            return false;
        }

        @Override
        public boolean tabRight() {
            return false;
        }

        @Override
        public boolean moveUp() {
            return WelcomeGui.this.up();
        }

        @Override
        public boolean moveDown() {
            return WelcomeGui.this.down();
        }
    }
}

