/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import gaiasky.GaiaSky;
import gaiasky.gui.api.IMinimapScale;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector2D;
import gaiasky.util.math.Vector3D;
import gaiasky.util.math.Vector3Q;

public abstract class AbstractMinimapScale
implements IMinimapScale {
    protected OrthographicCamera ortho;
    protected SpriteBatch sb;
    protected ShapeRenderer sr;
    protected BitmapFont font;
    protected int side;
    protected int sideshort;
    protected int side2;
    protected int sideshort2;
    protected double extentUp;
    protected double extentDown;
    protected double to;
    protected double from;
    protected Vector3D aux3d1 = new Vector3D();
    protected Vector3D aux3d2 = new Vector3D();
    protected Vector3Q aux3b1 = new Vector3Q();
    protected Vector3Q aux3b2 = new Vector3Q();
    protected Vector2D aux2d1 = new Vector2D();
    protected Vector2D aux2d2 = new Vector2D();
    protected Matrix4D trans;
    protected Color sunc;
    protected Color camc;
    protected Color textbc;
    protected Color textrc;
    protected Color textgc;
    protected Color textyc;
    protected Color textcc;
    protected Color textmc;
    protected float[] camp;
    protected float[] camd;
    protected float suns;
    protected ICamera cam;

    protected AbstractMinimapScale() {
    }

    protected void initialize(OrthographicCamera ortho, SpriteBatch sb, ShapeRenderer sr, BitmapFont font, int side, int sideshort, double to, double from, double extentUp, double extentDown) {
        this.cam = GaiaSky.instance.cameraManager;
        this.ortho = ortho;
        this.sb = sb;
        this.sr = sr;
        this.font = font;
        this.side = side;
        this.side2 = side / 2;
        this.sideshort = sideshort;
        this.sideshort2 = sideshort / 2;
        this.to = to;
        this.from = from;
        this.extentUp = extentUp;
        this.extentDown = extentDown;
        this.suns = 5.0f;
        this.camc = ColorUtils.gRedC;
        this.camp = new float[4];
        this.camd = new float[4];
        float h = 1.0f;
        float l = 0.7f;
        this.textbc = new Color(l, l, h, h);
        this.textrc = new Color(h, l, l, h);
        this.textgc = new Color(l, h, l, h);
        this.textyc = new Color(h, h, l, h);
        this.textcc = new Color(l, h, h, h);
        this.textmc = new Color(h, l, h, h);
        this.sunc = new Color(1.0f, 1.0f, 0.0f, 1.0f);
        sb.enableBlending();
        sb.setBlendFunction(770, 771);
    }

    @Override
    public void update() {
        this.position(this.cam.getPos().tov3d(this.aux3d1), this.camp);
        this.direction(this.cam.getDirection(), this.camd);
        this.updateLocal();
    }

    protected abstract void updateLocal();

    public float[] position(Vector3D pos, float[] out) {
        Vector3D p = this.aux3d1.set(pos).mul(this.trans);
        Vector2D pos2d = this.aux2d1;
        pos2d.set(p.z, p.y).scl(this.from);
        float cx = this.u2Px(pos2d.x, this.side2);
        float cy = this.u2Px(pos2d.y, this.sideshort2);
        out[0] = cx;
        out[1] = cy;
        pos2d.set(-p.x, p.z).scl(this.from);
        cx = this.u2Px(pos2d.x, this.side2);
        cy = this.u2Px(pos2d.y, this.side2);
        out[2] = cx;
        out[3] = cy;
        return out;
    }

    public float[] direction(Vector3D dir, float[] out) {
        this.aux3d2.set(dir).mul(this.trans);
        this.aux2d2.set(this.aux3d2.z, this.aux3d2.y).nor().scl(this.px(15.0f));
        out[0] = (float)this.aux2d2.x;
        out[1] = (float)this.aux2d2.y;
        this.aux2d2.set(-this.aux3d2.x, this.aux3d2.z).nor().scl(this.px(15.0f));
        out[2] = (float)this.aux2d2.x;
        out[3] = (float)this.aux2d2.y;
        return out;
    }

    @Override
    public boolean isActive(Vector3D campos, double distSun) {
        return distSun <= this.extentUp * this.to && distSun > this.extentDown * this.to;
    }

    protected float px(float px) {
        return px;
    }

    protected int u2Px(double units, float side) {
        return (int)(units / this.extentUp * (double)side + (double)side);
    }

    protected void renderCameraSide() {
        this.renderCameraSide(0.2f);
    }

    protected void renderCameraSide(float viewportAlpha) {
        float cx = this.camp[0];
        float cy = this.camp[1];
        float dx = this.camd[0];
        float dy = this.camd[1];
        this.sr.setColor(1.0f, 1.0f, 1.0f, viewportAlpha);
        Vector2D endx = this.aux2d1.set(dx, dy).scl(40.0);
        endx.rotate((double)(-this.cam.getCamera().fieldOfView) / 2.0);
        float c1x = (float)endx.x + cx;
        float c1y = (float)endx.y + cy;
        endx.set(dx, dy).scl(40.0);
        endx.rotate((double)this.cam.getCamera().fieldOfView / 2.0);
        this.sr.triangle(cx, cy, c1x, c1y, (float)endx.x + cx, (float)endx.y + cy);
        endx = this.aux2d1.set(dx, dy);
        endx.rotate((double)(-this.cam.getCamera().fieldOfView) / 2.0);
        c1x = (float)endx.x + cx;
        c1y = (float)endx.y + cy;
        endx.set(dx, dy);
        endx.rotate((double)this.cam.getCamera().fieldOfView / 2.0);
        this.sr.setColor(this.camc);
        this.sr.triangle(cx, cy, c1x, c1y, (float)endx.x + cx, (float)endx.y + cy);
        this.sr.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.sr.circle(cx, cy, 8.0f);
        this.sr.setColor(this.camc);
        this.sr.circle(cx, cy, 6.0f);
    }

    protected void renderCameraTop() {
        this.renderCameraTop(0.2f);
    }

    protected void renderCameraTop(float viewportAlpha) {
        float cx = this.camp[2];
        float cy = this.camp[3];
        float dx = this.camd[2];
        float dy = this.camd[3];
        this.sr.setColor(1.0f, 1.0f, 1.0f, viewportAlpha);
        Vector2D endx = this.aux2d1.set(dx, dy).scl(40.0);
        endx.rotate((double)(-this.cam.getCamera().fieldOfView) / 2.0);
        float c1x = (float)endx.x + cx;
        float c1y = (float)endx.y + cy;
        endx.set(dx, dy).scl(40.0);
        endx.rotate((double)this.cam.getCamera().fieldOfView / 2.0);
        this.sr.triangle(cx, cy, c1x, c1y, (float)endx.x + cx, (float)endx.y + cy);
        endx = this.aux2d1.set(dx, dy);
        endx.rotate((double)(-this.cam.getCamera().fieldOfView) / 2.0);
        c1x = (float)endx.x + cx;
        c1y = (float)endx.y + cy;
        endx.set(dx, dy);
        endx.rotate((double)this.cam.getCamera().fieldOfView / 2.0);
        this.sr.setColor(this.camc);
        this.sr.triangle(cx, cy, c1x, c1y, (float)endx.x + cx, (float)endx.y + cy);
        this.sr.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.sr.circle(cx, cy, 8.0f);
        this.sr.setColor(this.camc);
        this.sr.circle(cx, cy, 6.0f);
    }

    @Override
    public void dispose() {
    }
}

