/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import gaiasky.gui.minimap.AbstractMinimapScale;
import gaiasky.util.Constants;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Matrix4D;

public class HeliosphereMinimapScale
extends AbstractMinimapScale {
    private final Color helc = new Color(0.4f, 0.8f, 0.5f, 1.0f);
    private final Color helpc = new Color(1.0f, 1.0f, 0.4f, 1.0f);
    private final Color intc = new Color(0.8f, 0.2f, 1.0f, 1.0f);

    @Override
    public void updateLocal() {
    }

    @Override
    public void initialize(OrthographicCamera ortho, SpriteBatch sb, ShapeRenderer sr, BitmapFont font, int side, int sideshort) {
        super.initialize(ortho, sb, sr, font, side, sideshort, Constants.AU_TO_U, Constants.U_TO_AU, 1000.0, 50.0);
        this.trans = new Matrix4D();
    }

    @Override
    public void renderSideProjection(FrameBuffer fb) {
        Gdx.gl.glEnable(3042);
        this.ortho.setToOrtho(true, (float)this.side, (float)this.sideshort);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.intc);
        this.sr.getColor().a = 0.4f;
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)(1000.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.helpc);
        this.sr.getColor().a = 0.9f;
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)(110.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.helc);
        this.sr.getColor().a = 0.9f;
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)(90.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.sideshort2, this.px(this.suns));
        this.renderCameraSide(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.helc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.heliosphere"), (float)this.side2 + this.px(8.0f), (float)this.u2Px(100.0, this.sideshort2) + this.px(8.0f));
        this.font.setColor(this.helpc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.heliopause"), this.px(80.0f), this.px(40.0f));
        this.font.setColor(this.intc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.interstellar"), this.px(10.0f), this.px(90.0f));
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(8.0f), (float)this.u2Px(10.0, this.sideshort2) - this.px(2.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public void renderTopProjection(FrameBuffer fb) {
        Gdx.gl.glEnable(3042);
        this.ortho.setToOrtho(true, (float)this.side, (float)this.side);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.intc);
        this.sr.getColor().a = 0.4f;
        this.sr.circle((float)this.side2, (float)this.side2, (float)(1000.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.helpc);
        this.sr.getColor().a = 0.9f;
        this.sr.circle((float)this.side2, (float)this.side2, (float)(110.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.helc);
        this.sr.getColor().a = 0.9f;
        this.sr.circle((float)this.side2, (float)this.side2, (float)(90.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.side2, this.px(this.suns));
        this.renderCameraTop(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.textbc);
        this.font.draw((Batch)this.sb, (CharSequence)("100 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(200.0, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("1000 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(1003.0, this.side2));
        this.font.setColor(this.helc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.heliosphere"), (float)this.side2 + this.px(15.0f), (float)this.u2Px(0.0, this.side2) + this.px(8.0f));
        this.font.setColor(this.helpc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.heliopause"), (float)this.side2 - this.px(80.0f), (float)this.side2 - this.px(40.0f));
        this.font.setColor(this.intc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.interstellar"), this.px(60.0f), this.px(30.0f));
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(5.0f), (float)this.side2 - this.px(5.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public String getName() {
        return I18n.msg("gui.minimap.heliosphere");
    }
}

