/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import gaiasky.gui.minimap.AbstractMinimapScale;
import gaiasky.util.Constants;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;

public class HighZMinimapScale
extends AbstractMinimapScale {
    @Override
    public void updateLocal() {
    }

    @Override
    public void initialize(OrthographicCamera ortho, SpriteBatch sb, ShapeRenderer sr, BitmapFont font, int side, int sideshort) {
        super.initialize(ortho, sb, sr, font, side, sideshort, Constants.PC_TO_U, Constants.U_TO_PC, 2.0E9, 2.5E7);
        this.trans = Coordinates.eqToGal();
    }

    private Vector3D get(double raDeg, double decDeg, double distMpc) {
        return Coordinates.sphericalToCartesian(Math.PI / 180 * raDeg, Math.PI / 180 * decDeg, distMpc * Constants.MPC_TO_U, new Vector3D());
    }

    @Override
    public void renderSideProjection(FrameBuffer fb) {
        this.ortho.setToOrtho(true, (float)this.side, (float)this.sideshort);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(0.5f, 0.3f, 0.0f, 0.8f);
        this.sr.triangle((float)this.side2, (float)this.sideshort2, (float)(this.side2 / 4), (float)this.sideshort, (float)this.side2 + (float)this.side2 * 0.7f, (float)this.sideshort);
        this.sr.setColor(0.2f, 0.5f, 0.0f, 1.0f);
        this.sr.triangle((float)this.side2, (float)this.sideshort2, (float)(this.side2 / 2), (float)this.sideshort2 * 1.7f, (float)this.side2 + (float)this.side2 * 0.5f, (float)this.sideshort2 * 1.7f);
        this.sr.setColor(0.5f, 0.3f, 0.0f, 0.8f);
        this.sr.triangle((float)this.side2, (float)this.sideshort2, (float)(this.side2 / 2), 0.0f, (float)this.side2 + (float)this.side2 * 1.3f, 0.0f);
        this.sr.setColor(0.2f, 0.5f, 0.0f, 1.0f);
        this.sr.triangle((float)this.side2, (float)this.sideshort2, (float)this.side2 * 0.65f, (float)this.sideshort2 * 0.3f, (float)this.side2 * 1.5f, (float)this.sideshort2 * 0.6f);
        this.sr.end();
        Gdx.gl.glLineWidth(2.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(this.textbc);
        this.sr.line(0.0f, (float)this.sideshort2, (float)this.side, (float)this.sideshort2);
        this.sr.line((float)this.side2, 0.0f, (float)this.side2, (float)this.side);
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)this.side2 / 2.0f);
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.sideshort2, this.px(this.suns));
        this.renderCameraSide(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.localgroup"), (float)this.side2 + this.px(7.0f), (float)this.sideshort2 - this.px(4.0f));
        this.font.setColor(this.textyc);
        this.font.draw((Batch)this.sb, (CharSequence)"SDSS", (float)this.side2 - this.px(20.0f), (float)this.sideshort - this.px(22.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public void renderTopProjection(FrameBuffer fb) {
        this.ortho.setToOrtho(true, (float)this.side, (float)this.side);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        Gdx.gl.glLineWidth(2.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(this.textbc);
        this.sr.line(0.0f, (float)this.side2, (float)this.side, (float)this.side2);
        this.sr.line((float)this.side2, 0.0f, (float)this.side2, (float)this.side);
        this.sr.circle((float)this.side2, (float)this.side2, (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.side2, (float)this.side2 / 2.0f);
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.side2, this.px(this.suns));
        this.renderCameraTop(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.localgroup"), (float)this.side2 + this.px(10.0f), (float)this.side2 + this.px(20.0f));
        this.font.setColor(this.textmc);
        this.font.draw((Batch)this.sb, (CharSequence)("0" + I18n.msg("gui.unit.deg")), (float)this.side2 - this.px(15.0f), (float)this.side - this.px(5.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("270" + I18n.msg("gui.unit.deg")), (float)this.side - this.px(30.0f), (float)this.side2 + this.px(15.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("180" + I18n.msg("gui.unit.deg")), (float)this.side2 + this.px(3.0f), this.px(15.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("90" + I18n.msg("gui.unit.deg")), this.px(5.0f), (float)this.side2 + this.px(15.0f));
        this.font.setColor(this.textgc);
        this.font.draw((Batch)this.sb, (CharSequence)("1000" + I18n.msg("gui.unit.mpc")), (float)this.side2 + this.px(15.0f), (float)this.side2 + (float)this.side2 / 2.0f + this.px(10.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("2000" + I18n.msg("gui.unit.mpc")), (float)this.side2 + this.px(25.0f), (float)this.side - this.px(15.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public String getName() {
        return I18n.msg("gui.minimap.highz");
    }
}

