/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import gaiasky.GaiaSky;
import gaiasky.gui.minimap.AbstractMinimapScale;
import gaiasky.scene.view.FocusView;
import gaiasky.util.Constants;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;

public class InnerSolarSystemMinimapScale
extends AbstractMinimapScale {
    private final float[] merp = new float[4];
    private final float[] venp = new float[4];
    private final float[] earp = new float[4];
    private final float[] marp = new float[4];
    private final Color merc = new Color(0.4f, 0.5f, 0.4f, 1.0f);
    private final Color venc = new Color(1.0f, 0.6f, 0.1f, 1.0f);
    private final Color marc;
    private final Color earc = new Color(0.4f, 0.4f, 1.0f, 1.0f);
    private final FocusView mer;
    private final FocusView ven;
    private final FocusView ear;
    private final FocusView mar;

    public InnerSolarSystemMinimapScale() {
        this.marc = new Color(0.8f, 0.2f, 0.2f, 1.0f);
        this.mer = new FocusView();
        this.ven = new FocusView();
        this.ear = new FocusView();
        this.mar = new FocusView();
    }

    @Override
    public void updateLocal() {
        if (this.mer.isEmpty()) {
            this.mer.setEntity(GaiaSky.instance.scene.index().getEntity("Mercury"));
        }
        if (this.ven.isEmpty()) {
            this.ven.setEntity(GaiaSky.instance.scene.index().getEntity("Venus"));
        }
        if (this.ear.isEmpty()) {
            this.ear.setEntity(GaiaSky.instance.scene.index().getEntity("Earth"));
        }
        if (this.mar.isEmpty()) {
            this.mar.setEntity(GaiaSky.instance.scene.index().getEntity("Mars"));
        }
        if (!this.mer.isEmpty()) {
            this.position(this.mer.getAbsolutePosition(this.aux3b1).tov3d(this.aux3d1), this.merp);
        }
        if (!this.ven.isEmpty()) {
            this.position(this.ven.getAbsolutePosition(this.aux3b1).tov3d(this.aux3d1), this.venp);
        }
        if (!this.ear.isEmpty()) {
            this.position(this.ear.getAbsolutePosition(this.aux3b1).tov3d(this.aux3d1), this.earp);
        }
        if (!this.mar.isEmpty()) {
            this.position(this.mar.getAbsolutePosition(this.aux3b1).tov3d(this.aux3d1), this.marp);
        }
    }

    @Override
    public void initialize(OrthographicCamera ortho, SpriteBatch sb, ShapeRenderer sr, BitmapFont font, int side, int sideshort) {
        super.initialize(ortho, sb, sr, font, side, sideshort, Constants.AU_TO_U, Constants.U_TO_AU, 2.2, -1.0);
        this.trans = Coordinates.eqToEcl();
    }

    @Override
    public void renderSideProjection(FrameBuffer fb) {
        Gdx.gl.glEnable(3042);
        this.ortho.setToOrtho(true, (float)this.side, (float)this.sideshort);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        float ycenter = this.u2Px(0.0, this.sideshort2);
        this.sr.setColor(this.marc);
        this.sr.rectLine((float)this.u2Px(-1.6, this.side2), ycenter, (float)this.u2Px(1.6, this.side2), ycenter, 2.0f);
        this.sr.setColor(this.earc);
        this.sr.rectLine((float)this.u2Px(-1.0, this.side2), ycenter, (float)this.u2Px(1.0, this.side2), ycenter, 2.0f);
        this.sr.setColor(this.venc);
        this.sr.rectLine((float)this.u2Px(-0.71, this.side2), ycenter, (float)this.u2Px(0.71, this.side2), ycenter, 2.0f);
        this.sr.setColor(this.merc);
        this.sr.rectLine((float)this.u2Px(-0.45, this.side2), ycenter, (float)this.u2Px(0.45, this.side2), ycenter, 2.0f);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.u2Px(0.0, this.side2), ycenter, this.px(this.suns));
        this.sr.setColor(this.merc);
        this.sr.circle(this.merp[0], this.merp[1], this.px(3.0f));
        this.sr.setColor(this.venc);
        this.sr.circle(this.venp[0], this.venp[1], this.px(3.0f));
        this.sr.setColor(this.earc);
        this.sr.circle(this.earp[0], this.earp[1], this.px(3.0f));
        this.sr.setColor(this.marc);
        this.sr.circle(this.marp[0], this.marp[1], this.px(3.0f));
        this.renderCameraSide(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.merc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("mercury"), this.merp[0] - this.px(20.0f), this.merp[1] + this.px(25.0f));
        this.font.setColor(this.venc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("venus"), this.venp[0] - this.px(20.0f), this.venp[1] - this.px(25.0f));
        this.font.setColor(this.earc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("earth"), this.earp[0] - this.px(20.0f), this.earp[1] + this.px(40.0f));
        this.font.setColor(this.marc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("mars"), this.marp[0] - this.px(20.0f), this.marp[1] - this.px(10.0f));
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(8.0f), (float)this.u2Px(10.0, this.sideshort2) - this.px(2.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public void renderTopProjection(FrameBuffer fb) {
        Gdx.gl.glEnable(3042);
        this.ortho.setToOrtho(true, (float)this.side, (float)this.side);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glBlendFunc(770, 771);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.marc);
        this.sr.getColor().mul(0.2f, 0.2f, 0.2f, 1.0f);
        this.sr.circle((float)this.side2 + this.px(4.0f), (float)this.side2 - this.px(4.0f), (float)(1.54 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.earc);
        this.sr.getColor().mul(0.2f, 0.2f, 0.2f, 1.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(1.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.venc);
        this.sr.getColor().mul(0.2f, 0.2f, 0.2f, 1.0f);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(0.71 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.merc);
        this.sr.getColor().mul(0.2f, 0.2f, 0.2f, 1.0f);
        this.sr.circle((float)this.side2 - this.px(3.0f), (float)this.side2, (float)(0.4 / this.extentUp) * (float)this.side2);
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        Gdx.gl.glLineWidth(2.0f);
        this.sr.setColor(this.merc);
        this.sr.circle((float)this.side2 - this.px(3.0f), (float)this.side2, (float)(0.4 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.venc);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(0.71 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.earc);
        this.sr.circle((float)this.side2, (float)this.side2, (float)(1.0 / this.extentUp) * (float)this.side2);
        this.sr.setColor(this.marc);
        this.sr.circle((float)this.side2 + this.px(4.0f), (float)this.side2 - this.px(4.0f), (float)(1.54 / this.extentUp) * (float)this.side2);
        this.sr.end();
        Gdx.gl.glLineWidth(1.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.side2, this.px(this.suns));
        this.sr.setColor(this.merc);
        this.sr.circle(this.merp[2], this.merp[3], this.px(3.0f));
        this.sr.setColor(this.venc);
        this.sr.circle(this.venp[2], this.venp[3], this.px(3.0f));
        this.sr.setColor(this.earc);
        this.sr.circle(this.earp[2], this.earp[3], this.px(3.0f));
        this.sr.setColor(this.marc);
        this.sr.circle(this.marp[2], this.marp[3], this.px(3.0f));
        this.renderCameraTop(0.1f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.textbc);
        this.font.draw((Batch)this.sb, (CharSequence)("0.45 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(0.65, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("0.71 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(0.9099999999999999, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("1 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(1.2, this.side2));
        this.font.draw((Batch)this.sb, (CharSequence)("1.6 " + I18n.msg("gui.unit.au")), (float)this.side2, (float)this.u2Px(1.7000000000000002, this.side2));
        this.font.setColor(this.merc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("mercury"), this.merp[2] - this.px(20.0f), this.merp[3] - this.px(8.0f));
        this.font.setColor(this.venc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("venus"), this.venp[2] - this.px(20.0f), this.venp[3] - this.px(8.0f));
        this.font.setColor(this.earc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("earth"), this.earp[2] - this.px(20.0f), this.earp[3] - this.px(8.0f));
        this.font.setColor(this.marc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("mars"), this.marp[2] - this.px(20.0f), this.marp[3] - this.px(8.0f));
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.obj("sun"), (float)this.side2 + this.px(5.0f), (float)this.side2 - this.px(5.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public String getName() {
        return I18n.msg("gui.minimap.innerss");
    }
}

