/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.gui.minimap;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import gaiasky.gui.minimap.AbstractMinimapScale;
import gaiasky.util.Constants;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.coord.Coordinates;
import gaiasky.util.i18n.I18n;
import gaiasky.util.math.Vector3D;

public class LocalGroup1MinimapScale
extends AbstractMinimapScale {
    private int ngals;
    private Vector3D[] positions;
    private float[][] galp;
    private String[] names;
    private Color galc;
    private float gals;

    @Override
    public void updateLocal() {
        for (int i = 0; i < this.positions.length; ++i) {
            this.position(this.positions[i], this.galp[i]);
        }
    }

    @Override
    public void initialize(OrthographicCamera ortho, SpriteBatch sb, ShapeRenderer sr, BitmapFont font, int side, int sideshort) {
        super.initialize(ortho, sb, sr, font, side, sideshort, Constants.PC_TO_U, Constants.U_TO_PC, 5000000.0, 16000.0);
        this.trans = Coordinates.eqToGal();
        this.ngals = 8;
        this.galp = new float[this.ngals][];
        this.positions = new Vector3D[this.ngals];
        this.names = new String[this.ngals];
        int i = 0;
        this.addGalaxy(i++, "Andromeda", 10.69, 41.27, 0.778);
        this.addGalaxy(i++, "Triangulum", 1.565, 30.65, 3.0);
        this.addGalaxy(i++, "SMC", 13.158, -72.8002, 0.06);
        this.addGalaxy(i++, "LeoA", 149.85, 30.74, 0.81);
        this.addGalaxy(i++, "Bode's", 148.88, 69.06, 3.63);
        this.addGalaxy(i++, "Sc22", 5.96, -24.705, 4.21);
        this.addGalaxy(i++, "KK258", 340.18, -30.79, 2.0);
        this.addGalaxy(i++, "KK196", 200.44, -45.06, 3.98);
        this.galc = ColorUtils.gBlueC;
        this.gals = 3.0f;
    }

    private void addGalaxy(int i, String name, double raDeg, double decDeg, double distMpc) {
        this.galp[i] = new float[4];
        this.positions[i] = this.get(raDeg, decDeg, distMpc);
        this.names[i] = name;
    }

    private Vector3D get(double raDeg, double decDeg, double distMpc) {
        return Coordinates.sphericalToCartesian(Math.PI / 180 * raDeg, Math.PI / 180 * decDeg, distMpc * Constants.MPC_TO_U, new Vector3D());
    }

    @Override
    public void renderSideProjection(FrameBuffer fb) {
        this.ortho.setToOrtho(true, (float)this.side, (float)this.sideshort);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        Gdx.gl.glLineWidth(2.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(this.textbc);
        this.sr.line(0.0f, (float)this.sideshort2, (float)this.side, (float)this.sideshort2);
        this.sr.line((float)this.side2, 0.0f, (float)this.side2, (float)this.side);
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.sideshort2, (float)this.side2 / 2.0f);
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.sideshort2, this.px(this.suns));
        this.sr.setColor(this.galc);
        for (float[] g : this.galp) {
            this.sr.circle(g[0], g[1], this.px(this.gals));
        }
        this.renderCameraSide(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(this.sunc);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.milkyway"), (float)this.side2 + this.px(7.0f), (float)this.sideshort2 - this.px(2.0f));
        this.font.setColor(this.galc);
        for (int i = 0; i < this.ngals; ++i) {
            this.font.draw((Batch)this.sb, (CharSequence)this.names[i], this.galp[i][0] + this.px(5.0f), this.galp[i][1] - this.px(10.0f));
        }
        this.sb.end();
        fb.end();
    }

    @Override
    public void renderTopProjection(FrameBuffer fb) {
        this.ortho.setToOrtho(true, (float)this.side, (float)this.side);
        this.sr.setProjectionMatrix(this.ortho.combined);
        this.sb.setProjectionMatrix(this.ortho.combined);
        fb.begin();
        Gdx.gl.glClear(0x4100 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        Gdx.gl.glLineWidth(2.0f);
        this.sr.begin(ShapeRenderer.ShapeType.Line);
        this.sr.setColor(this.textbc);
        this.sr.line(0.0f, (float)this.side2, (float)this.side, (float)this.side2);
        this.sr.line((float)this.side2, 0.0f, (float)this.side2, (float)this.side);
        this.sr.circle((float)this.side2, (float)this.side2, (float)this.side2);
        this.sr.circle((float)this.side2, (float)this.side2, (float)this.side2 / 2.0f);
        for (float[] g : this.galp) {
            this.sr.line(g[2], g[3], g[2], g[3] - this.px(24.0f));
        }
        this.sr.end();
        this.sr.begin(ShapeRenderer.ShapeType.Filled);
        this.sr.setColor(this.sunc);
        this.sr.circle((float)this.side2, (float)this.side2, this.px(this.suns));
        this.sr.setColor(this.galc);
        for (float[] g : this.galp) {
            this.sr.circle(g[2], g[3], this.px(this.gals));
        }
        this.renderCameraTop(0.4f);
        this.sr.end();
        this.sb.begin();
        this.font.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        this.font.draw((Batch)this.sb, (CharSequence)I18n.msg("gui.minimap.milkyway"), (float)this.side2 + this.px(10.0f), (float)this.side2 + this.px(10.0f));
        this.font.setColor(this.galc);
        for (int i = 0; i < this.ngals; ++i) {
            this.font.draw((Batch)this.sb, (CharSequence)this.names[i], this.galp[i][2] + this.px(5.0f), this.galp[i][3] - this.px(15.0f));
        }
        this.font.setColor(this.textmc);
        this.font.draw((Batch)this.sb, (CharSequence)("0" + I18n.msg("gui.unit.deg")), (float)this.side2 - this.px(15.0f), (float)this.side - this.px(5.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("270" + I18n.msg("gui.unit.deg")), (float)this.side - this.px(30.0f), (float)this.side2 + this.px(15.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("180" + I18n.msg("gui.unit.deg")), (float)this.side2 + this.px(3.0f), this.px(15.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("90" + I18n.msg("gui.unit.deg")), this.px(5.0f), (float)this.side2 + this.px(15.0f));
        this.font.setColor(this.textgc);
        this.font.draw((Batch)this.sb, (CharSequence)("2.5" + I18n.msg("gui.unit.mpc")), (float)this.side2 + this.px(15.0f), (float)this.side2 + (float)this.side2 / 2.0f + this.px(10.0f));
        this.font.draw((Batch)this.sb, (CharSequence)("5" + I18n.msg("gui.unit.mpc")), (float)this.side2 + this.px(25.0f), (float)this.side - this.px(15.0f));
        this.sb.end();
        fb.end();
    }

    @Override
    public String getName() {
        return I18n.msg("gui.minimap.localgroup") + " (1)";
    }
}

